/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb.config;

import java.util.logging.Logger;
import org.rocksdb.DBOptions;
import org.rocksdb.WriteOptions;

public class XAPDBOptions
extends DBOptions {
    private static final Logger logger = Logger.getLogger(XAPDBOptions.class.getName());
    private boolean _useFsyncIsSet = false;
    private boolean disableWal;
    private boolean sync;
    private WriteOptions writeOptions;

    public XAPDBOptions() {
        this.setCreateIfMissing(true);
        this.setMaxBackgroundCompactions(8);
        this.setMaxBackgroundFlushes(2);
        this.setMaxOpenFiles(-1);
        this.writeOptions = new WriteOptions();
    }

    public XAPDBOptions setUseFsync(boolean useFsync) {
        this._useFsyncIsSet = true;
        super.setUseFsync(useFsync);
        return this;
    }

    public boolean useFsyncIsSet() {
        return this._useFsyncIsSet;
    }

    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public void setDisableWal(boolean disableWal) {
        this.writeOptions.setDisableWAL(disableWal);
        this.disableWal = disableWal;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.writeOptions.setSync(sync);
        this.sync = sync;
    }

    private Integer parse(String prop, int defaultValue) {
        String propValue = System.getProperty(prop);
        if (propValue == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(propValue);
        }
        catch (NumberFormatException e) {
            logger.warning("Failed to parse " + prop + "=" + propValue + ", will use the default value: " + defaultValue);
            return defaultValue;
        }
    }
}

