/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb.utils;

import com.gigaspaces.attribute_store.PropertiesFileAttributeStore;
import com.gigaspaces.attribute_store.PropertiesHandler;
import com.gigaspaces.blobstore.rocksdb.utils.FreeDevice;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.gigaspaces.server.blobstore.BlobStoreException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceController
implements Serializable {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.cache");
    private static String devSpaceFilePath = "path-per-space.properties";
    private static File deviceDirectory;
    private boolean isCentralDevice;
    private PropertiesFileAttributeStore propertiesFileAttributeStore;
    private int numberOfPartitions;
    private int numberOfBackups;

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    public int getNumberOfBackups() {
        return this.numberOfBackups;
    }

    public void setNumberOfBackups(int numberOfBackups) {
        this.numberOfBackups = numberOfBackups;
    }

    public DeviceController() {
    }

    public DeviceController(String blobStoreDevicesMappingDir, boolean isCentralDevice) {
        this();
        File devicesBlobstore = new File(blobStoreDevicesMappingDir);
        deviceDirectory = new File(devicesBlobstore, "paths");
        this.propertiesFileAttributeStore = new PropertiesFileAttributeStore(new File(deviceDirectory, devSpaceFilePath).getAbsolutePath());
        this.isCentralDevice = isCentralDevice;
    }

    public String getFullDevicesFileName() {
        return deviceDirectory + File.separator + devSpaceFilePath;
    }

    public boolean remove(String spaceName) {
        try {
            return this.propertiesFileAttributeStore.remove(spaceName) != null;
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    public FreeDevice insertIfAbsent(final String spaceName, final List<String> devices) {
        try {
            return (FreeDevice)this.propertiesFileAttributeStore.withProperties((PropertiesHandler)new PropertiesHandler<FreeDevice>(){

                public FreeDevice handle(Properties properties) {
                    String device = properties.getProperty(spaceName);
                    if (device != null) {
                        return new FreeDevice(DeviceController.this.stripDeviceName(device), true);
                    }
                    device = DeviceController.this.getFreeDevice(properties, devices, spaceName, DeviceController.this.isCentralDevice, DeviceController.this.numberOfPartitions, DeviceController.this.numberOfBackups);
                    if (device != null) {
                        String consistentDevice = device + "@" + StorageConsistencyModes.Unknown + "^" + new Date(System.currentTimeMillis());
                        properties.setProperty(spaceName, consistentDevice);
                        return new FreeDevice(device, false);
                    }
                    String msg = "[ ";
                    for (String space : properties.stringPropertyNames()) {
                        msg = msg + space + " -> " + properties.getProperty(space) + " ; ";
                    }
                    msg = msg + " ]";
                    throw new RuntimeException("No available path found for space [ " + spaceName + " ].\n This is space / path mapping " + msg + ".\n if you don't want to perform recovery from taken paths please delete them from " + DeviceController.this.getFullDevicesFileName());
                }
            });
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    public void setSpaceStorageConsistencyMode(final String spaceName, final StorageConsistencyModes storageConsistencyModes) {
        try {
            this.propertiesFileAttributeStore.withProperties((PropertiesHandler)new PropertiesHandler<Void>(){

                public Void handle(Properties properties) {
                    String fullDevName = properties.getProperty(spaceName);
                    String dev = DeviceController.this.stripDeviceName(fullDevName) + "@" + storageConsistencyModes.name() + "^" + new Date(System.currentTimeMillis());
                    properties.setProperty(spaceName, dev);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    public String getSpaceDevice(String spaceName) {
        try {
            return this.propertiesFileAttributeStore.get(spaceName);
        }
        catch (Exception e) {
            throw new BlobStoreException((Throwable)e);
        }
    }

    private String getFreeDevice(Properties devicePerSpaceProperties, List<String> devices, String spaceName, boolean isCentralDevice, int numberOfPartitions, int numberOfBackups) {
        if (isCentralDevice) {
            Map<String, Integer> indexes = this.getSpaceIndexes(spaceName);
            return this.getMemberIndex(indexes.get("primary"), indexes.get("backup"), numberOfPartitions, numberOfBackups, devices);
        }
        ArrayList<String> occupiedDevices = new ArrayList<String>();
        String[] parts = devices.get(0).split(",");
        ArrayList<String> devicesClone = new ArrayList<String>(Arrays.asList(parts));
        for (Object key : devicePerSpaceProperties.keySet()) {
            occupiedDevices.add(this.stripDeviceName(devicePerSpaceProperties.getProperty((String)key)));
        }
        devicesClone.removeAll(occupiedDevices);
        if (devicesClone.size() > 0) {
            return (String)devicesClone.get(0);
        }
        return null;
    }

    private String getMemberIndex(int primaryIndex, int backupIndex, int totalPartitions, int totalBackups, List<String> devices) {
        int devicesNumber = 0;
        if (devices.size() == 1) {
            try {
                String[] parts = devices.get(0).split(",");
                devicesNumber = parts.length;
                if (backupIndex == 0) {
                    return parts[primaryIndex - 1];
                }
                return parts[totalBackups * (primaryIndex - 1) + backupIndex + totalPartitions - 1];
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new BlobStoreException("Number of paths [ " + devicesNumber + " ] is less then the number of cluster instances [ " + totalPartitions * (totalBackups + 1) + " ]", (Throwable)aioobe);
            }
        }
        String[] primaries = devices.get(0).split(",");
        String[] backups = devices.get(1).split(",");
        if (backupIndex == 0) {
            try {
                return primaries[primaryIndex - 1];
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new BlobStoreException("Number of paths for primaries [ " + primaries.length + " ] is less then the number of cluster primaries instances [ " + totalPartitions + " ].", (Throwable)aioobe);
            }
        }
        try {
            return backups[primaryIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new BlobStoreException("Number of paths for backups [ " + backups.length + " ] is less then the number of cluster backups instances [ " + totalBackups * totalPartitions + " ].", (Throwable)aioobe);
        }
    }

    private Map<String, Integer> getSpaceIndexes(String spaceName) {
        HashMap<String, Integer> spaceIndexes = new HashMap<String, Integer>();
        Pattern pb = Pattern.compile("\\w+_container(\\d+)+_(\\d)");
        Pattern p = Pattern.compile("\\w+_container(\\d+)");
        Matcher mpb = pb.matcher(spaceName);
        Matcher mp = p.matcher(spaceName);
        if (mpb.find()) {
            spaceIndexes.put("primary", Integer.valueOf(mpb.group(1)));
            spaceIndexes.put("backup", Integer.valueOf(mpb.group(2)));
        } else if (mp.find()) {
            spaceIndexes.put("primary", Integer.valueOf(mp.group(1)));
            spaceIndexes.put("backup", 0);
        } else {
            spaceIndexes.put("primary", 1);
            spaceIndexes.put("backup", 0);
        }
        return spaceIndexes;
    }

    public List<String> getDevicesArray(String devicesArray) {
        Matcher m;
        String re1;
        ArrayList<String> devices = new ArrayList<String>();
        if (!devicesArray.startsWith("[") || !devicesArray.endsWith("]")) {
            throw new BlobStoreException("paths list should start and end with brackets. \nexample: paths=[/mnt/db1,/mnt/db2]");
        }
        if (devicesArray.contains("],[")) {
            re1 = "(\\[.*?\\])";
            String re2 = ".*?";
            String re3 = "(\\[.*?\\])";
            Pattern p = Pattern.compile(re1 + re2 + re3, 34);
            m = p.matcher(devicesArray);
        } else {
            re1 = "(\\[.*?\\])";
            Pattern p = Pattern.compile(re1, 34);
            m = p.matcher(devicesArray);
        }
        if (m.find()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                String dev = m.group(i);
                dev = dev.substring(dev.indexOf("[") + 1, dev.indexOf("]"));
                devices.add(dev.trim());
            }
        }
        return devices;
    }

    private String stripDeviceName(String deviceName) {
        return deviceName.substring(0, deviceName.indexOf("@"));
    }
}

