/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.blobstore.rocksdb.utils;

import com.gigaspaces.server.blobstore.BlobStoreException;
import java.io.File;
import java.util.Map;

public class Utils {
    public static void runCommand(String command, File workingDir) {
        Utils.runCommand(command, workingDir, null);
    }

    public static void runCommand(String command, File workingDir, Map<String, String> additionalProcessVariables) {
        String cmdLine = command;
        String[] parts = cmdLine.split(" ");
        ProcessBuilder pb = new ProcessBuilder(parts);
        if (workingDir != null) {
            if (!workingDir.exists() || !workingDir.isDirectory()) {
                throw new BlobStoreException(workingDir + " should be a path of a directory, please check if it exists");
            }
            pb.directory(workingDir);
        }
        if (additionalProcessVariables != null) {
            Map<String, String> env = pb.environment();
            for (Map.Entry<String, String> additionalVar : additionalProcessVariables.entrySet()) {
                env.put(additionalVar.getKey(), additionalVar.getValue());
            }
        }
        try {
            Process process = pb.start();
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                throw new Exception("Failed to run command: " + command + " at directory: " + workingDir + " error code: " + errorCode);
            }
        }
        catch (Exception e) {
            throw new BlobStoreException("Failed to run command: " + command + " at directory: " + workingDir, (Throwable)e);
        }
    }
}

