/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli;

import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.jvm.JavaUtils;
import com.gigaspaces.start.GsCommandFactory;
import com.gigaspaces.start.JavaCommandBuilder;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.util.Collection;

public class GsPremiumCommandFactory
extends GsCommandFactory {
    public static void main(String[] args) {
        GsPremiumCommandFactory.execute((String[])args, (GsCommandFactory)new GsPremiumCommandFactory());
    }

    protected JavaCommandBuilder generate(String id) {
        switch (id.toLowerCase()) {
            case "old-cli": {
                return this.oldCli();
            }
            case "service-grid": {
                return this.serviceGridImpl(null);
            }
            case "webui": {
                return this.webui();
            }
            case "gs-ui": {
                return this.gsUi();
            }
            case "benchmark-cli": {
                return this.benchmarkCli();
            }
            case "benchmark-ui": {
                return this.benchmarkUi();
            }
            case "pu-instance": {
                return this.puInstance();
            }
            case "lookup-browser": {
                return this.lookupBrowser();
            }
            case "scala-repl": {
                return this.scalaRepl();
            }
            case "cli-premium": {
                return this.cliPremium();
            }
            case "cli-insightedge-premium": {
                return this.cliInsightEdgePremium();
            }
            case "apache-lb": {
                return this.apacheLB();
            }
        }
        return super.generate(id);
    }

    public static String serviceGrid(Collection<String> componentOptions) {
        return new GsPremiumCommandFactory().serviceGridImpl(componentOptions).toCommandLine();
    }

    private JavaCommandBuilder serviceGridImpl(Collection<String> componentOptions) {
        this.command.mainClass("com.gigaspaces.start.SystemBoot");
        this.preClasspath();
        this.command.classpathFromEnv("XAP_HOME");
        this.appendSigarClassPath();
        this.addOshiAndLoggerToClasspath();
        this.command.classpathFromPath(new String[]{this.locations().getLibRequired(), "xap-common.jar"});
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "service-grid", "xap-service-grid-boot.jar"});
        this.postClasspath();
        this.appendXapOptions();
        if (componentOptions != null) {
            this.command.options(componentOptions);
        } else {
            this.command.optionsFromEnv("XAP_COMPONENT_OPTIONS");
        }
        this.command.systemPropertyFromEnv("agentId", "AGENT_ID");
        this.command.systemPropertyFromEnv("gsaServiceID", "GSA_SERVICE_ID");
        this.command.systemPropertyFromEnv("enableDynamicLocators", "ENABLE_DYNAMIC_LOCATORS");
        this.command.systemProperty("java.library.path", GsPremiumCommandFactory.getSystemEnv((String)"XAP_LIBRARY_PATH").orElseGet(() -> {
            String libPlatformNative = BootIOUtils.quoteIfContainsSpace((String)new File(this.locations().getLibPlatform(), "native").getPath());
            return GsPremiumCommandFactory.getSystemEnv((String)"XAP_LIBRARY_PATH_EXT").map(s -> libPlatformNative + File.pathSeparatorChar + s).orElse(libPlatformNative);
        }));
        return this.command;
    }

    private JavaCommandBuilder oldCli() {
        this.command.mainClass("com.gigaspaces.admin.cli.GS");
        this.preClasspath();
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "cli-old", "*"});
        this.appendGsClasspath();
        this.appendSpringClassPath();
        this.appendMemoryXtendCP();
        this.addOshiAndLoggerToClasspath();
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "service-grid", "*"});
        if (JavaUtils.greaterOrEquals((int)9)) {
            this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "javax", "*"});
        }
        this.postClasspath();
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_CLI_OPTIONS");
        this.command.arg("config/services/services.config");
        return this.command;
    }

    private JavaCommandBuilder webui() {
        this.command.mainClass("org.openspaces.launcher.Launcher");
        this.preClasspath();
        this.appendGsClasspath();
        this.appendSpringClassPath();
        this.addOshiAndLoggerToClasspath();
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "jetty", "*"}).classpathFromPath(new String[]{this.locations().getLibOptional(), "jetty", "xap-jetty", "*"}).classpathFromPath(new String[]{this.locations().getLibOptional(), "interop", "*"}).classpathFromPath(new String[]{this.locations().getLibPlatform(), "commons", "*"}).classpathFromPath(new String[]{this.locations().getLibPlatform(), "service-grid", "*"});
        this.appendMemoryXtendCP();
        this.postClasspath();
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_WEBUI_OPTIONS");
        return this.command;
    }

    private JavaCommandBuilder gsUi() {
        if (JavaUtils.isWindows()) {
            this.command.javaExecutable("start \"GigaSpaces Management Center\" \"" + this.command.getDefaultJavaWindowsExecutable() + "\"");
        }
        this.command.mainClass("com.gigaspaces.admin.ui.MainUI");
        this.preClasspath();
        this.appendUiCP();
        this.appendSpringClassPath();
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "interop", "*"});
        this.appendMemoryXtendCP();
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "commons", "*"});
        this.postClasspath();
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_GUI_OPTIONS").systemProperty("com.gs.env.report", "false").systemProperty("com.gs.jini.useDefinedGroupOnly", "false").systemProperty("com.gs.browser.containername", "mySpace_container").systemProperty("com.gs.embeddedQP.enabled", "true").systemProperty("java.protocol.handler.pkgs", "net.jini.url");
        if (JavaUtils.isOsx()) {
            this.appendOsxSystemProperties("GigaSpacesBrowser");
        }
        return this.command;
    }

    private JavaCommandBuilder benchmarkCli() {
        this.command.mainClass("com.j_spaces.examples.benchmark.BenchmarkTest");
        this.command.classpathFromPath(new String[]{SystemInfo.singleton().getXapHome(), "tools", "benchmark", "classes"});
        this.command.classpathFromPath(new String[]{this.locations().getLibRequired(), "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "benchmark", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "poi", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "jms", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "metrics", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "map", "xap-map.jar"});
        this.appendXapOptions();
        this.command.optionsFromEnv("JAVA_BENCHMARK_OPTIONS");
        return this.command;
    }

    private JavaCommandBuilder benchmarkUi() {
        this.command.mainClass("com.j_spaces.tools.spacebrowser.benchmark.standalone.BenchmarkMain");
        this.preClasspath();
        this.appendUiCP();
        this.appendSpringClassPath();
        this.postClasspath();
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_GUI_OPTIONS");
        this.command.systemProperty("com.gs.env.report", "false");
        if (JavaUtils.isOsx()) {
            this.appendOsxSystemProperties("Benchmark");
        }
        return this.command;
    }

    private JavaCommandBuilder puInstance() {
        this.command.mainClass("org.openspaces.pu.container.standalone.StandaloneProcessingUnitContainer");
        this.preClasspath();
        this.appendGsClasspath();
        this.appendSpringClassPath();
        this.postClasspath();
        this.appendXapOptions();
        return this.command;
    }

    private JavaCommandBuilder lookupBrowser() {
        this.command.mainClass("com.gigaspaces.admin.ui.lookupbrowser.Browser");
        this.appendUiCP();
        this.appendXapOptions();
        return this.command;
    }

    private JavaCommandBuilder scalaRepl() {
        this.command.mainClass("org.openspaces.scala.repl.GigaSpacesScalaRepl");
        this.appendGsClasspath();
        this.appendSpringClassPath();
        this.appendSigarClassPath();
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "scala", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "scala", "lib", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "service-grid", "*"});
        this.appendXapOptions();
        this.command.arg("-usejavacp");
        this.command.arg("-Yrepl-sync");
        return this.command;
    }

    private JavaCommandBuilder cliPremium() {
        this.command.mainClass("com.gigaspaces.cli.commands.XapPremiumMainCommand");
        this.command.classpathFromPath(new String[]{SystemInfo.singleton().getXapHome(), "tools", "cli", "*"});
        this.command.classpathFromPath(new String[]{SystemInfo.singleton().locations().getLibPlatform(), "blueprints", "*"});
        this.appendGsClasspath();
        this.appendSigarClassPath();
        this.addOshiAndLoggerToClasspath();
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_CLI_OPTIONS");
        return this.command;
    }

    private JavaCommandBuilder cliInsightEdgePremium() {
        this.command.mainClass("com.insightedge.cli.commands.I9EPremiumMainCommand");
        this.command.classpathFromPath(new String[]{SystemInfo.singleton().getXapHome(), "tools", "cli", "*"});
        this.command.classpathFromPath(new String[]{SystemInfo.singleton().locations().getLibPlatform(), "blueprints", "*"});
        this.command.classpathFromEnv("INSIGHTEDGE_CLASSPATH");
        this.appendSigarClassPath();
        this.addOshiAndLoggerToClasspath();
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_CLI_OPTIONS");
        return this.command;
    }

    private JavaCommandBuilder apacheLB() {
        this.command.mainClass("org.openspaces.pu.container.jee.lb.apache.ApacheLoadBalancerAgent");
        this.preClasspath();
        this.appendGsClasspath();
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "service-grid", "*"});
        this.addOshiAndLoggerToClasspath();
        this.appendSpringClassPath();
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "jdbc", "*"});
        this.command.classpathFromPath(new String[]{SystemInfo.singleton().getXapHome(), "tools", "apache", "lib", "*"});
        this.postClasspath();
        this.appendXapOptions();
        this.command.systemProperty("lb.vmDir", SystemInfo.singleton().getXapHome() + "/tools/apache");
        return this.command;
    }

    private void appendMemoryXtendCP() {
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "memoryxtend", "rocksdb", "*"});
        this.command.classpathFromPath(new String[]{this.locations().getLibOptional(), "memoryxtend", "off-heap", "*"});
    }

    private void appendUiCP() {
        this.command.classpathFromPath(new String[]{this.locations().getLibPlatform(), "ui", "*"}).classpathFromPath(new String[]{this.locations().getLibPlatform(), "poi", "*"}).classpathFromPath(new String[]{this.locations().getLibPlatform(), "benchmark", "*"}).classpathFromPath(new String[]{this.locations().getLibOptional(), "jms", "*"}).classpathFromPath(new String[]{this.locations().getLibOptional(), "map", "*"}).classpathFromPath(new String[]{this.locations().getLibPlatform(), "service-grid", "*"});
        this.addOshiAndLoggerToClasspath();
        this.appendGsClasspath();
    }

    private void appendOsxSystemProperties(String dockName) {
        this.command.systemProperty("com.gs.ui.laf.classname", "apple.laf.AquaLookAndFeel").systemProperty("com.apple.macos.useScreenMenuBar", "true").option("-Xdock:name=" + dockName).systemProperty("com.apple.mrj.application.growbox.intrudes", "false").systemProperty("com.apple.mrj.application.live-resize", "true");
    }
}

