/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.license;

import java.util.EnumSet;

public enum LicenseType {
    PREMIUM(1),
    ENTERPRISE(2);

    private final int level;

    private LicenseType(int level) {
        this.level = level;
    }

    public boolean includes(LicenseType licenseType) {
        return this.level >= licenseType.level;
    }

    public static LicenseType fromString(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("License type not specified");
        }
        if (PREMIUM.toString().equals(value)) {
            return PREMIUM;
        }
        if (ENTERPRISE.toString().equals(value)) {
            return ENTERPRISE;
        }
        throw new IllegalArgumentException("Type should be one of " + EnumSet.allOf(LicenseType.class) + ". Found: " + value);
    }
}

