/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.license;

import com.gigaspaces.internal.license.Encoder;
import com.gigaspaces.internal.license.LicenseInfo;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.license.LicenseException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseValidation {
    private static Logger LOGGER;
    public static final int MAX_DAYS_AMOUNT = 90;
    private static final String WILL_EXPIRE_KEY = "message.will.expire";
    private static final String EXPIRED_KEY = "message.expired";
    private static final String NOT_VALID_LICENSE_KEY = "message.not.valid.license";
    private static final String NOT_VALID_USER_ID = "url.not.valid.userid";
    private static final String DAY_KEY = "message.day";
    private static final String DAYS_KEY = "message.days";
    private static final String PREMIUM_NAME_KEY = "message.premium.name";
    private static final String ENTERPRISE_NAME_KEY = "message.enterprise.name";
    private static final String CLICK_HERE_KEY = "message.click.here";
    private static final String URL_XAP_EXPIRED = "url.xap.expired";
    private static final String URL_XAP_WILL_EXPIRE = "url.xap.will.expire";
    private static final String URL_NOT_VALID_LICENSE = "url.not.valid.license";
    private static final String SOURCE_UI = "source.ui";
    private static final String SOURCE_WEBUI = "source.webui";
    public static final String INVALID_LICENSE = "Invalid License";
    private static final String LICENSE_NOT_FOUND = "_LICENSE_NOT_FOUND_";
    private static ResourceBundle _bundle;

    public static LicenseInfo handleLicense(ManagementToolType managementType, Encoder encoder) {
        String userId;
        LicenseType licenseType;
        String licenseMessage;
        block6: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("START handleLicense(), managementType=" + (Object)((Object)managementType));
            }
            licenseMessage = null;
            licenseType = null;
            userId = null;
            try {
                LicenseManager licenseManager = LicenseManager.getInstance();
                if (licenseManager.getLicenseKey() == null) {
                    licenseMessage = LicenseValidation.createNotValidLicenseMessage(managementType);
                } else {
                    licenseType = licenseManager.getLicenseType();
                    userId = licenseManager.getUser();
                    licenseMessage = LicenseValidation.createLicenseMessage(managementType, licenseManager, userId, licenseType);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                if (!(e instanceof LicenseException) || e.toString().indexOf(INVALID_LICENSE) == -1) break block6;
                licenseMessage = LicenseValidation.createNotValidLicenseMessage(managementType);
            }
        }
        String licenseTypeDesc = licenseType != null ? licenseType.name() : "none";
        return new LicenseInfo(licenseMessage, userId, licenseTypeDesc);
    }

    private static String createLicenseMessage(ManagementToolType managementType, LicenseManager licenseManager, String userId, LicenseType licenseType) {
        Date expiration = licenseManager.getExpirationDate();
        if (expiration != null) {
            long timeDif = expiration.getTime() - System.currentTimeMillis();
            if (timeDif < 0L) {
                return LicenseValidation.createLicenseExpiredMessage(licenseType, userId, managementType);
            }
            long day = 86400000L;
            int daysNum = 90;
            long expirationDelay = 7776000000L;
            if (timeDif < 7776000000L) {
                int daysLeft = (int)(timeDif / 86400000L) + 1;
                LOGGER.fine("days left:" + daysLeft);
                return LicenseValidation.createLicenseWillExpireMessage(licenseType, daysLeft, userId, managementType);
            }
        }
        return null;
    }

    private static String createLicenseWillExpireMessage(LicenseType licenseType, int daysLeft, String userId, ManagementToolType managementType) {
        Object[] messageArguments = new Object[]{LicenseValidation.getLicenseTypeName(licenseType), daysLeft, daysLeft == 1 ? _bundle.getString(DAY_KEY) : _bundle.getString(DAYS_KEY), LicenseValidation.getUrl(false, licenseType), LicenseValidation.getClickHereMessage()};
        MessageFormat formatter = new MessageFormat(_bundle.getString(WILL_EXPIRE_KEY));
        return formatter.format(messageArguments);
    }

    private static String createLicenseExpiredMessage(LicenseType licenseType, String userId, ManagementToolType managementType) {
        Object[] messageArguments = new Object[]{LicenseValidation.getLicenseTypeName(licenseType), LicenseValidation.getUrl(false, licenseType), LicenseValidation.getClickHereMessage()};
        MessageFormat formatter = new MessageFormat(_bundle.getString(EXPIRED_KEY));
        return formatter.format(messageArguments);
    }

    private static String createNotValidLicenseMessage(ManagementToolType managementType) {
        String notValidUserId = _bundle.getString(NOT_VALID_USER_ID);
        Object[] messageArguments = new Object[]{_bundle.getString(URL_NOT_VALID_LICENSE), LicenseValidation.getClickHereMessage()};
        MessageFormat formatter = new MessageFormat(_bundle.getString(NOT_VALID_LICENSE_KEY));
        return formatter.format(messageArguments);
    }

    private static String getSourceName(ManagementToolType managementType) {
        String resultSource;
        switch (managementType) {
            case UI: {
                resultSource = _bundle.getString(SOURCE_UI);
                break;
            }
            case WEBUI: {
                resultSource = _bundle.getString(SOURCE_WEBUI);
                break;
            }
            default: {
                resultSource = "none";
            }
        }
        return resultSource;
    }

    public static String getClickHereMessage() {
        return _bundle.getString(CLICK_HERE_KEY);
    }

    public static String getUrl(boolean isExpired, LicenseType licenseType) {
        return isExpired ? _bundle.getString(URL_XAP_EXPIRED) : _bundle.getString(URL_XAP_WILL_EXPIRE);
    }

    private static String getLicenseTypeName(LicenseType licenseType) {
        switch (licenseType) {
            case PREMIUM: {
                return _bundle.getString(PREMIUM_NAME_KEY);
            }
            case ENTERPRISE: {
                return _bundle.getString(ENTERPRISE_NAME_KEY);
            }
        }
        return "unknown license - " + licenseType.toString();
    }

    public static String handlePlatformHelpUrlWithParameter(ManagementToolType managementType) {
        try {
            LicenseManager licenseManager = LicenseManager.getInstance();
            String licenseKey = licenseManager.getLicenseKey();
            if (licenseKey == null) {
                return LicenseValidation.createNotValidLicenseMessage(managementType);
            }
            if (licenseKey.equals(LICENSE_NOT_FOUND)) {
                return PlatformVersion.getProductHelpUrl();
            }
            return PlatformVersion.getProductHelpUrl();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            if (e instanceof LicenseException && e.toString().indexOf(INVALID_LICENSE) != -1) {
                return LicenseValidation.createNotValidLicenseMessage(managementType);
            }
            return null;
        }
    }

    static {
        block2: {
            LOGGER = Logger.getLogger("com.gigaspaces.common.resourceloader");
            try {
                _bundle = ResourceBundle.getBundle("com.gigaspaces.internal.license.licenseWarningMessages");
            }
            catch (MissingResourceException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    public static enum ManagementToolType {
        UI,
        WEBUI;

    }
}

