/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.discovery;

import com.gigaspaces.admin.discovery.RecordingDiscoveryListener;
import com.gigaspaces.admin.discovery.ReggieStat;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.internal.utils.concurrent.GSTimer;
import com.gigaspaces.start.SystemInfo;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupGroups;

public class GroupSelector
extends JPanel {
    private final GroupModel model;
    private static final String GROUP_DISABLE = "<html>Group discovery is enabled, select <br><i>\"Stop\"</i> to stop group discovery</html>";
    private static final String GROUP_ENABLE = "<html>Group discovery is disabled, select <br><i>\"Start\"</i> to start group discovery</html>";
    private JButton applyButton;
    private JButton closeButton;
    private JTable groupTable;
    private JButton groupsControlButton;
    private JLabel groupsStatusLabel;
    private JLabel tableHeaderLabel;
    private JScrollPane tableScrollPane;
    private JButton okButton;
    private JButton refreshButton;
    private JButton selectorButton;
    private Dimension buttonSize = new Dimension(80, 22);
    private MainUI _mainUI;
    private String[] curSelectedGroups;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private Timer spaceRemovingWaitingTimer = null;
    private static final int WAITING_DURATION = 5000;

    public GroupSelector(MainUI mainUI, final DiscoveryManagement dMgr, final LookupDiscovery lookupDiscovery, RecordingDiscoveryListener rdl, final JDialog dialog) {
        this._mainUI = mainUI;
        this.initComponents();
        if (rdl == null) {
            throw new NullPointerException("rdl is null");
        }
        this.toggleGroupStatus(lookupDiscovery.getGroups() == LookupGroups.none());
        this.groupsControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                if (b.getText().equals("Start")) {
                    GroupSelector.this._mainUI.startDiscovery();
                    GroupSelector.this.toggleGroupStatus(false);
                    GroupSelector.this.fillGroups();
                } else {
                    GroupSelector.this._mainUI.stopDiscovery();
                    GroupSelector.this.toggleGroupStatus(true);
                    GroupSelector.this.model.clear();
                }
            }
        });
        this.groupTable.getSelectionModel().setSelectionMode(0);
        this.groupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = GroupSelector.this.groupTable.getSelectedRow();
                GroupModel model = (GroupModel)GroupSelector.this.groupTable.getModel();
                Boolean b = (Boolean)model.getValueAt(row, 0);
                GroupItem gi = (GroupItem)model.getItem(row);
                gi.include = b == false;
                model.setValueAt(gi, row);
            }
        });
        this.model = new GroupModel();
        this.groupTable.setModel(this.model);
        this.groupTable.setAutoResizeMode(3);
        TableColumn col = this.groupTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(60);
        col.setMaxWidth(60);
        this.fillGroups();
        this.selectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                boolean select = b.getText().startsWith("Select");
                GroupItem[] items = GroupSelector.this.model.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].include = select;
                }
                b.setText(select ? "De-Select All" : "Select All");
                GroupSelector.this.model.fireTableDataChanged();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GroupSelector.this.fillGroups();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GroupSelector.this.setGroups(dMgr, lookupDiscovery);
                dialog.dispose();
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GroupSelector.this.setGroups(dMgr, lookupDiscovery);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
    }

    public void addLookupGroups(String[] lookupGroups) {
        this.model.addLookupGroups(lookupGroups);
    }

    void fillGroups() {
        this.model.clear();
        this.addLookupGroups(System.getProperty("com.gs.jini_lus.groups").split(","));
        DiscoveryManagement dMgr = this._mainUI.getDiscoveryManager();
        RecordingDiscoveryListener rdl = this._mainUI.getRecordingDiscoveryListener();
        LookupDiscovery lookupDiscovery = this._mainUI.getLookupDiscovery();
        String[] configured = ((DiscoveryGroupManagement)dMgr).getGroups();
        this.curSelectedGroups = configured;
        String[] systemDisco = lookupDiscovery.getGroups();
        boolean allGroups = false;
        if (configured == LookupGroups.all()) {
            allGroups = true;
        }
        if (systemDisco != LookupGroups.none()) {
            ReggieStat[] rStats = rdl.getReggieStats(0);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < rStats.length; ++i) {
                String[] groups = rStats[i].getGroups();
                for (int j = 0; j < groups.length; ++j) {
                    String group = groups[j];
                    if (group.equals(LookupGroups.all())) {
                        group = "ALL_GROUPS";
                    }
                    if (list.contains(group)) continue;
                    list.add(group);
                }
            }
            for (String group : list) {
                GroupItem gi = new GroupItem(group);
                if (!allGroups) {
                    boolean include = false;
                    for (int i = 0; i < configured.length; ++i) {
                        if (!group.equals(configured[i])) continue;
                        include = true;
                        break;
                    }
                    gi.include = include;
                }
                if (this.model.hasItem(gi)) continue;
                this.model.addItem(gi);
            }
            boolean allSelected = true;
            GroupItem[] gis = this.model.getItems();
            for (int i = 0; i < gis.length; ++i) {
                if (gis[i].include) continue;
                allSelected = false;
                break;
            }
            if (allSelected) {
                this.selectorButton.setText("De-Select All");
            }
        }
    }

    void toggleGroupStatus(boolean enable) {
        if (enable) {
            this.groupsStatusLabel.setText(GROUP_ENABLE);
            this.groupsControlButton.setText("Start");
            this.groupsControlButton.setToolTipText("Enable group discovery");
        } else {
            this.groupsStatusLabel.setText(GROUP_DISABLE);
            this.groupsControlButton.setText("Stop");
            this.groupsControlButton.setToolTipText("Disable (halt) group discovery");
        }
    }

    private boolean isAnyJiniGroupDeselected(GroupModel groupModel, String[] prevSelectedJniGroups, String[] newJiniGroups) {
        int i;
        if (prevSelectedJniGroups == LookupGroups.all()) {
            int rowCount = groupModel.getRowCount();
            return rowCount != newJiniGroups.length;
        }
        HashSet<String> newGroupsSet = new HashSet<String>(newJiniGroups.length);
        for (i = 0; i < newJiniGroups.length; ++i) {
            newGroupsSet.add(newJiniGroups[i]);
        }
        for (i = 0; i < prevSelectedJniGroups.length; ++i) {
            if (newGroupsSet.contains(prevSelectedJniGroups[i])) continue;
            return true;
        }
        return false;
    }

    void setGroups(final DiscoveryManagement dMgr, LookupDiscovery lookupDiscovery) {
        final Runnable doSetGroup = new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        String[] selectedGroups = GroupSelector.this.model.getSelectedGroups();
                        boolean isAnyJiniGroupDeselected = GroupSelector.this.isAnyJiniGroupDeselected(GroupSelector.this.model, GroupSelector.this.curSelectedGroups, selectedGroups);
                        if (isAnyJiniGroupDeselected) {
                            GroupSelector.this.allowSpaceRemoving();
                        }
                        GroupSelector.this._mainUI.setJiniGroups(selectedGroups);
                        SystemInfo.singleton().lookup().setGroups(selectedGroups);
                        ((DiscoveryGroupManagement)dMgr).setGroups(selectedGroups);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        };
        new Thread(){

            @Override
            public void run() {
                block2: {
                    try {
                        SwingUtilities.invokeAndWait(doSetGroup);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        }.start();
    }

    protected void allowSpaceRemoving() {
        this._mainUI.setAllowSpaceRemoving(true);
        if (this.spaceRemovingWaitingTimer != null) {
            this.spaceRemovingWaitingTimer.cancel();
        }
        this.spaceRemovingWaitingTimer = new GSTimer("spaceRemovingWaitingTimer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    GroupSelector.this._mainUI.setAllowSpaceRemoving(false);
                }
                finally {
                    GroupSelector.this.spaceRemovingWaitingTimer.cancel();
                }
            }
        };
        long curTime = System.currentTimeMillis();
        this.spaceRemovingWaitingTimer.schedule(timerTask, new Date(curTime + 5000L));
    }

    private void initComponents() {
        this.groupTable = new JTable();
        this.selectorButton = new JButton("Select All");
        this.okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        this.closeButton = new JButton("Close");
        this.groupsStatusLabel = new JLabel("jLabel1");
        this.groupsControlButton = new JButton();
        this.tableHeaderLabel = new JLabel("Advertised Groups Available:");
        this.refreshButton = new JButton("Refresh");
        Dimension bigButtonsSize = new Dimension(93, 22);
        this.selectorButton.setPreferredSize(bigButtonsSize);
        this.refreshButton.setPreferredSize(bigButtonsSize);
        this.applyButton.setPreferredSize(this.buttonSize);
        this.closeButton.setPreferredSize(this.buttonSize);
        this.groupsControlButton.setPreferredSize(this.buttonSize);
        this.okButton.setPreferredSize(this.buttonSize);
        this.refreshButton.setToolTipText("Refresh list of groups");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Box topDiscoveryBox = new Box(0);
        this.tableScrollPane = new JScrollPane(this.groupTable);
        topDiscoveryBox.add(this.groupsStatusLabel);
        topDiscoveryBox.add(this.groupsControlButton);
        Box tableBox = this.createTableBox();
        Box tableHeaderBox = this.createTableHeaderBox();
        Box bottomButtonsBox = this.createBottomButtonsBox();
        Box tableButtonsBox = this.createTableButtonsBox();
        this.add(Box.createVerticalStrut(15));
        this.add(topDiscoveryBox);
        this.add(Box.createVerticalStrut(15));
        this.add(tableHeaderBox);
        this.add(Box.createVerticalStrut(5));
        this.add(tableBox);
        this.add(Box.createVerticalStrut(5));
        this.add(tableButtonsBox);
        this.add(Box.createVerticalStrut(10));
        this.add(bottomButtonsBox);
        this.add(Box.createVerticalStrut(10));
    }

    private Box createTableHeaderBox() {
        Box horizBox = new Box(0);
        horizBox.add(this.tableHeaderLabel);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    private Box createTableBox() {
        Box horizBox = new Box(0);
        horizBox.add(this.tableScrollPane);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    private Box createBottomButtonsBox() {
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalGlue());
        horizBox.add(this.okButton);
        horizBox.add(Box.createHorizontalStrut(5));
        horizBox.add(this.applyButton);
        horizBox.add(Box.createHorizontalStrut(5));
        horizBox.add(this.closeButton);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    private Box createTableButtonsBox() {
        Box horizBox = new Box(0);
        horizBox.add(this.selectorButton);
        horizBox.add(Box.createHorizontalStrut(5));
        horizBox.add(this.refreshButton);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    public void removeLookupGroups(String[] groups) {
        this.model.removeLookupGroups(groups);
    }

    static class GroupItem {
        private final String name;
        boolean include = true;

        GroupItem(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return this.name.equals(((GroupItem)o).name);
        }
    }

    static class GroupModel
    extends AbstractTableModel {
        Vector<GroupItem> tableData = new Vector();
        final String[] columnNames = new String[]{"Include", "Group"};

        GroupModel() {
        }

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                GroupItem gi = this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return gi.include;
                    }
                    case 1: {
                        return gi.name;
                    }
                }
                return null;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                return null;
            }
        }

        public void addLookupGroups(String[] lookupGroups) {
            for (String newLookupGroup : lookupGroups) {
                int rowNum = this.tableData.size();
                boolean suchLookupGroupNameExists = false;
                for (int rowIndex = 0; rowIndex < rowNum; ++rowIndex) {
                    GroupItem groupItem = this.tableData.get(rowIndex);
                    if (!groupItem.name.equals(newLookupGroup)) continue;
                    suchLookupGroupNameExists = true;
                    break;
                }
                if (suchLookupGroupNameExists) continue;
                this.addItem(new GroupItem(newLookupGroup));
            }
        }

        public String[] getSelectedGroups() {
            ArrayList<String> list = new ArrayList<String>();
            GroupItem[] gis = this.getItems();
            for (int i = 0; i < gis.length; ++i) {
                if (!gis[i].include) continue;
                list.add(gis[i].name);
            }
            return list.toArray(new String[list.size()]);
        }

        GroupItem[] getItems() {
            return this.tableData.toArray(new GroupItem[this.tableData.size()]);
        }

        boolean hasItem(GroupItem item) {
            return this.tableData.contains(item);
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.add(rowNum, (GroupItem)item);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(Object item) {
            int rowIndex = this.tableData.indexOf(item);
            if (rowIndex >= 0) {
                this.tableData.remove(item);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
        }

        public void removeItemAt(int row) {
            if (row >= 0) {
                this.tableData.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        public Object getItem(int row) {
            return this.tableData.get(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt((GroupItem)item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        void clear() {
            this.tableData.clear();
            this.fireTableDataChanged();
        }

        public void removeLookupGroups(String[] lookupGroups) {
            for (String removedLookupGroup : lookupGroups) {
                int rowNum = this.tableData.size();
                for (int rowIndex = rowNum - 1; rowIndex >= 0; --rowIndex) {
                    GroupItem groupItem = this.tableData.get(rowIndex);
                    if (!groupItem.name.equals(removedLookupGroup)) continue;
                    this.removeItemAt(rowIndex);
                }
            }
        }
    }
}

