/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.discovery;

import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.start.SystemInfo;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.Constants;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import org.jini.rio.boot.BootUtil;

public class LocatorDialog
extends JPanel {
    private DiscoveryManagement dMgr;
    private JFrame frame;
    private JButton addButton;
    private JButton closeButton;
    private JLabel listHeaderLabel;
    private JScrollPane jScrollPane1;
    private JTextField locatorField;
    private JList locatorList;
    private JButton removeButton;

    public LocatorDialog(JFrame frame, DiscoveryManagement dMgr, final JDialog dialog) {
        if (dMgr == null) {
            throw new NullPointerException("dMgr is null");
        }
        this.dMgr = dMgr;
        this.frame = frame;
        this.initComponents();
        this.removeButton.setEnabled(false);
        DefaultListModel model = new DefaultListModel();
        this.locatorList.setModel(model);
        this.locatorList.addListSelectionListener(new LocatorListSelectionListener());
        this.fillLocatorList();
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LocatorDialog.this.addLocator();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object[] selected = LocatorDialog.this.locatorList.getSelectedValues();
                if (selected.length == 0) {
                    return;
                }
                for (int i = 0; i < selected.length; ++i) {
                    try {
                        String s = (String)selected[i];
                        if (!s.startsWith("jini://")) {
                            s = "jini://" + s;
                        }
                        LocatorDialog.this.removeLocator(new LookupLocator(s));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                LocatorDialog.this.fillLocatorList();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
    }

    private void addLocator() {
        if (this.addLocator(this.locatorField.getText())) {
            this.locatorField.setText("");
        }
        this.fillLocatorList();
    }

    private void fillLocatorList() {
        DefaultListModel model = (DefaultListModel)this.locatorList.getModel();
        model.clear();
        LookupLocator[] locators = this.getLocators();
        for (int i = 0; i < locators.length; ++i) {
            model.add(i, this.stripProtocol(locators[i]));
        }
        String locatorsStr = BootUtil.toLookupLocatorURLs((LookupLocator[])locators, (boolean)true);
        SystemInfo.singleton().lookup().setLocators(locatorsStr);
    }

    private String stripProtocol(LookupLocator locator) {
        return locator.getHost() + ":" + locator.getPort();
    }

    private LookupLocator[] getLocators() {
        if (this.dMgr instanceof DiscoveryLocatorManagement) {
            return ((DiscoveryLocatorManagement)this.dMgr).getLocators();
        }
        return new LookupLocator[0];
    }

    private void removeLocator(LookupLocator locator) {
        if (this.dMgr instanceof DiscoveryLocatorManagement) {
            ((DiscoveryLocatorManagement)this.dMgr).removeLocators(new LookupLocator[]{locator});
        }
    }

    private boolean addLocator(String input) {
        boolean added;
        block12: {
            added = true;
            if (input != null) {
                input = input.trim();
                int port = 0;
                int portIndex = input.indexOf(":");
                if (portIndex == -1) {
                    port = Constants.getDiscoveryPort();
                }
                if (input.startsWith("http://") || input.startsWith("jini://")) {
                    String s = input.substring(0, 5);
                    JOptionPane.showMessageDialog(this.frame, "Remove the [" + s + "] and resubmit", "Locator Format Error", 0);
                    return false;
                }
                try {
                    String host;
                    String string = host = portIndex == -1 ? input : input.substring(0, portIndex);
                    if (portIndex != -1) {
                        boolean portError = false;
                        String errorReason = null;
                        String p = input.substring(portIndex + 1, input.length());
                        try {
                            port = new Integer(p);
                        }
                        catch (Throwable t) {
                            portError = true;
                            errorReason = "Not a valid number";
                        }
                        if (port <= 0 || port >= 65536) {
                            portError = true;
                            errorReason = "port number out of range";
                        }
                        if (portError) {
                            JOptionPane.showMessageDialog(this.frame, "The provided port is invalid : " + errorReason, "Locator Port Error", 0);
                            return false;
                        }
                    }
                    if (this.dMgr instanceof DiscoveryLocatorManagement) {
                        ((DiscoveryLocatorManagement)this.dMgr).addLocators(new LookupLocator[]{new LookupLocator(host, port)});
                        break block12;
                    }
                    added = false;
                }
                catch (Exception e) {
                    added = false;
                    UIHelper.showError((Throwable)e, "Exception trying to add Locator");
                }
            } else {
                JOptionPane.showMessageDialog(this.frame, "You must provide a value to add", "Locator Input Error", 0);
                added = false;
            }
        }
        return added;
    }

    public static JDialog getDialog(JFrame frame, DiscoveryManagement dMgr) {
        EscapeDialog dialog = new EscapeDialog(frame, "Locator Management", true);
        LocatorDialog gs = new LocatorDialog(frame, dMgr, dialog);
        dialog.getContentPane().add(gs);
        int width = 320;
        int height = 300;
        dialog.pack();
        dialog.setSize(width, height);
        dialog.setLocationRelativeTo(frame);
        return dialog;
    }

    private void initComponents() {
        this.closeButton = new JButton("Close");
        this.listHeaderLabel = new JLabel("Enter host[:port] address");
        this.locatorField = new JTextField();
        this.locatorList = new JList();
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        int componentHeight = 23;
        Dimension buttonSize = new Dimension(70, 23);
        this.locatorField.setMaximumSize(new Dimension(1000, 23));
        this.locatorField.setPreferredSize(new Dimension(1000, 23));
        this.locatorField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LocatorDialog.this.addLocator();
                }
            }
        });
        this.addButton.setPreferredSize(buttonSize);
        this.addButton.setMaximumSize(buttonSize);
        this.addButton.setMinimumSize(buttonSize);
        this.removeButton.setPreferredSize(buttonSize);
        this.removeButton.setMaximumSize(buttonSize);
        this.removeButton.setMinimumSize(buttonSize);
        this.closeButton.setPreferredSize(buttonSize);
        this.closeButton.setMaximumSize(buttonSize);
        this.closeButton.setMinimumSize(buttonSize);
        this.jScrollPane1 = new JScrollPane(this.locatorList);
        this.jScrollPane1.setPreferredSize(new Dimension(1000, 220));
        this.jScrollPane1.setMaximumSize(new Dimension(1000, 220));
        Box label1Box = new Box(0);
        label1Box.add(Box.createHorizontalStrut(5));
        label1Box.add(this.listHeaderLabel);
        label1Box.add(Box.createHorizontalGlue());
        Box editorBox = new Box(0);
        editorBox.add(Box.createHorizontalStrut(5));
        editorBox.add(this.locatorField);
        editorBox.add(Box.createHorizontalStrut(5));
        editorBox.add(this.addButton);
        editorBox.add(Box.createHorizontalStrut(5));
        Box locatorsListBox = new Box(1);
        Box scrollBox = new Box(0);
        scrollBox.add(Box.createHorizontalStrut(5));
        scrollBox.add(this.jScrollPane1);
        scrollBox.add(Box.createHorizontalStrut(10));
        scrollBox.add(this.removeButton);
        scrollBox.add(Box.createHorizontalStrut(3));
        Box closeButtonBox = new Box(0);
        closeButtonBox.add(Box.createHorizontalGlue());
        closeButtonBox.add(this.closeButton);
        closeButtonBox.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        locatorsListBox.add(scrollBox);
        locatorsListBox.add(Box.createVerticalStrut(5));
        locatorsListBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), BorderFactory.createTitledBorder("Managed set of locators")));
        this.add(Box.createVerticalStrut(5));
        this.add(label1Box);
        this.add(Box.createVerticalStrut(5));
        this.add(editorBox);
        this.add(Box.createVerticalStrut(5));
        this.add(locatorsListBox);
        this.add(Box.createVerticalStrut(10));
        this.add(closeButtonBox);
        this.add(Box.createVerticalStrut(5));
    }

    class LocatorListSelectionListener
    implements ListSelectionListener {
        LocatorListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                JList list = (JList)evt.getSource();
                Object[] selected = list.getSelectedValues();
                if (selected.length > 0) {
                    LocatorDialog.this.removeButton.setEnabled(true);
                } else {
                    LocatorDialog.this.removeButton.setEnabled(false);
                }
            }
        }
    }
}

