/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.discovery;

import com.gigaspaces.admin.discovery.RecordingDiscoveryListener;
import com.gigaspaces.admin.discovery.ReggieStat;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class ReggieStatPanel
extends JPanel {
    long startTime;

    public ReggieStatPanel(long startTime, RecordingDiscoveryListener rdl, final JDialog dialog) {
        this.startTime = startTime;
        this.setLayout(new BorderLayout(8, 8));
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JLabel l1 = new JLabel("Discovery Statistics");
        JTable discoveredTable = new JTable();
        StatModel model1 = new StatModel(true);
        discoveredTable.setModel(model1);
        ReggieStat[] rStats = rdl.getReggieStats(0);
        for (int i = 0; i < rStats.length; ++i) {
            model1.addItem(rStats[i]);
        }
        JLabel l2 = new JLabel("Discarded Statistics");
        JTable discardedTable = new JTable();
        StatModel model2 = new StatModel(false);
        discardedTable.setModel(model2);
        rStats = rdl.getReggieStats(1);
        for (int i = 0; i < rStats.length; ++i) {
            model2.addItem(rStats[i]);
        }
        this.setColumns(discoveredTable);
        this.setColumns(discardedTable);
        JScrollPane sp1 = new JScrollPane(discoveredTable);
        JScrollPane sp2 = new JScrollPane(discardedTable);
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        Box label1Box = new Box(0);
        Box label2Box = new Box(0);
        label1Box.add(l1);
        label1Box.add(Box.createHorizontalGlue());
        label2Box.add(l2);
        label2Box.add(Box.createHorizontalGlue());
        p1.add(label1Box);
        p1.add(Box.createVerticalStrut(8));
        p1.add(sp1);
        p1.add(Box.createVerticalStrut(8));
        p1.add(label2Box);
        p1.add(Box.createVerticalStrut(8));
        p1.add(sp2);
        JPanel p2 = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
        p2.add(close);
        this.add((Component)p1, "Center");
        this.add((Component)p2, "South");
    }

    private void setColumns(JTable table) {
        TableColumnModel cm = table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(1).setPreferredWidth(200);
    }

    public static JDialog getDialog(JFrame frame, long startTime, RecordingDiscoveryListener rdl) {
        EscapeDialog dialog = new EscapeDialog(frame, "Lookup Service Discovery Times", true);
        ReggieStatPanel rsp = new ReggieStatPanel(startTime, rdl, dialog);
        dialog.getContentPane().add(rsp);
        int width = 435;
        int height = 345;
        dialog.pack();
        dialog.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int widthLoc = screenSize.width / 2 - width / 2;
        int heightLoc = screenSize.height / 2 - height / 2;
        dialog.setLocation(widthLoc, heightLoc);
        return dialog;
    }

    static String fromArray(String[] array, String delim) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        if (delim == null) {
            throw new NullPointerException("delim is null");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(delim);
            }
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    class StatModel
    extends AbstractTableModel {
        Vector tableData = new Vector();
        boolean forDiscovery;
        final String[] columnNames = new String[]{"Locator", "Groups", "Time (millis)"};

        public StatModel(boolean forDiscovery) {
            this.forDiscovery = forDiscovery;
            if (!forDiscovery) {
                this.columnNames[2] = "Discarded";
            }
        }

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                ReggieStat rStat = (ReggieStat)this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return rStat.getMachine() + ":" + rStat.getPort();
                    }
                    case 1: {
                        return ReggieStatPanel.fromArray(rStat.getGroups(), ",");
                    }
                    case 2: {
                        String value = null;
                        if (this.forDiscovery) {
                            long baseTime = rStat.getBaseTime() == 0L ? ReggieStatPanel.this.startTime : rStat.getBaseTime();
                            long t = (rStat.getEventTime() - baseTime) / 1000L;
                            value = Long.toString(t);
                        } else {
                            value = new Date(rStat.getEventTime()).toString();
                        }
                        return value;
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.removeElementAt(row);
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }
}

