/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.discovery;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.admin.ui.views.utils.BasicSortableTableModel;
import com.gigaspaces.admin.ui.views.utils.BasicTable;
import com.gigaspaces.admin.ui.views.utils.BasicWrapper;
import com.gigaspaces.admin.ui.views.utils.CheckBoxHeader;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.jini.core.lookup.ServiceItem;

public class ZonesManagementDialog
extends EscapeDialog
implements ActionListener {
    private final MainUI _mainUI;
    private final Dimension buttonSize = new Dimension(80, 22);
    private JTable _zonesTable;
    private JLabel tableHeaderLabel;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _refreshButton;
    private final int LEFT_RIGHT_MARGIN = 3;
    private ZonesTableModel _zonesTableModel;
    private Set<String> _selectedZonesSet;
    private ZonesCheckBoxHeader _zonesCheckBoxHeader;
    protected final ZoneWrapper NO_ZONES_WRAPPER = new ZoneWrapper("<No Zone>", true, true);

    public ZonesManagementDialog(MainUI mainUI) {
        super(mainUI, "Zones Selection", true);
        this._mainUI = mainUI;
        this.init();
        this.setSize(300, 500);
        this.setLocationRelativeTo(mainUI);
    }

    private void init() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        Box tableHeaderBox = this.createTableHeaderBox();
        Box tableBox = this.createTableBox();
        Box refreshButtonBox = this.createRefreshButtonBox();
        Box buttonsBox = this.createBottomButtonsBox();
        contentPane.add(Box.createVerticalStrut(3));
        contentPane.add(tableHeaderBox);
        contentPane.add(Box.createVerticalStrut(3));
        contentPane.add(tableBox);
        contentPane.add(Box.createVerticalStrut(2));
        contentPane.add(refreshButtonBox);
        contentPane.add(Box.createVerticalStrut(6));
        contentPane.add(new JSeparator());
        contentPane.add(Box.createVerticalStrut(4));
        contentPane.add(buttonsBox);
        contentPane.add(Box.createVerticalStrut(3));
    }

    private Box createTableBox() {
        this._zonesTableModel = new ZonesTableModel();
        this._zonesTable = new BasicTable(this._zonesTableModel);
        this.setTableProperties(this._zonesTable);
        JScrollPane tableScrollPane = new JScrollPane(this._zonesTable);
        Box horizBox = new Box(0);
        horizBox.add(tableScrollPane);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    private void setTableProperties(JTable table) {
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn includeTableColumn = tableColumnModel.getColumn(0);
        TableColumn zoneTableColumn = tableColumnModel.getColumn(1);
        this._zonesCheckBoxHeader = new ZonesCheckBoxHeader(table);
        includeTableColumn.setHeaderRenderer(this._zonesCheckBoxHeader);
        includeTableColumn.setPreferredWidth(25);
        zoneTableColumn.setPreferredWidth(267);
    }

    private Box createTableHeaderBox() {
        this.tableHeaderLabel = new JLabel("<HTML>Choose the zones you would like to filter on. Only components which belong to the selected zones will be displayed</HTML>");
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalStrut(3));
        horizBox.add(this.tableHeaderLabel);
        horizBox.add(Box.createHorizontalStrut(3));
        return horizBox;
    }

    private Box createRefreshButtonBox() {
        this._refreshButton = new JButton("Refresh");
        this._refreshButton.setPreferredSize(this.buttonSize);
        this._refreshButton.setMinimumSize(this.buttonSize);
        this._refreshButton.addActionListener(this);
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalStrut(3));
        horizBox.add(this._refreshButton);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    private Box createBottomButtonsBox() {
        this._okButton = new JButton("OK");
        this._cancelButton = new JButton("Cancel");
        this._okButton.setPreferredSize(this.buttonSize);
        this._cancelButton.setPreferredSize(this.buttonSize);
        this._okButton.setMinimumSize(this.buttonSize);
        this._cancelButton.setMinimumSize(this.buttonSize);
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        Box horizBox = new Box(0);
        horizBox.add(Box.createHorizontalGlue());
        horizBox.add(this._okButton);
        horizBox.add(Box.createHorizontalStrut(10));
        horizBox.add(this._cancelButton);
        horizBox.add(Box.createHorizontalGlue());
        return horizBox;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setZones();
        }
        super.setVisible(visible);
    }

    public void setZones() {
        this._zonesTableModel.clear();
        HashSet<String> allZonesSet = new HashSet<String>(Repository.getInstance().getAllZones());
        allZonesSet.remove(this.NO_ZONES_WRAPPER.getZone());
        Iterator iterator = allZonesSet.iterator();
        ArrayList<BasicWrapper> wrappersList = new ArrayList<BasicWrapper>(allZonesSet.size());
        wrappersList.add(this.NO_ZONES_WRAPPER);
        while (iterator.hasNext()) {
            String zone = (String)iterator.next();
            ZoneWrapper zoneWrapper = new ZoneWrapper(zone, this._mainUI.isDisplayZone(zone));
            wrappersList.add(zoneWrapper);
        }
        this._zonesTableModel.setWrappersList(wrappersList, true);
        if (wrappersList.size() == 0) {
            this._zonesCheckBoxHeader.setSelected(false);
        } else {
            boolean isSelectHeaderCheckBox = true;
            for (BasicWrapper basicWrapper : wrappersList) {
                if (((ZoneWrapper)basicWrapper).isInclude()) continue;
                isSelectHeaderCheckBox = false;
                break;
            }
            this._zonesCheckBoxHeader.setSelected(isSelectHeaderCheckBox);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._okButton)) {
            List<BasicWrapper> allZoneWrappersList = this._zonesTableModel.getWrappersList();
            this._selectedZonesSet = new HashSet<String>();
            HashSet<String> unselectedZonesSet = new HashSet<String>();
            for (BasicWrapper wrapper : allZoneWrappersList) {
                ZoneWrapper zoneWrapper = (ZoneWrapper)wrapper;
                if (zoneWrapper.isInclude()) {
                    this._selectedZonesSet.add(zoneWrapper.getZone());
                    continue;
                }
                unselectedZonesSet.add(zoneWrapper.getZone());
            }
            String[] selectedZonesArray = this._selectedZonesSet.toArray(new String[this._selectedZonesSet.size()]);
            Set<String> prevDisplayedZonesSet = this._mainUI.getDisplayedZones();
            String[] prevDisplayedZonesArray = prevDisplayedZonesSet.toArray(new String[prevDisplayedZonesSet.size()]);
            Set<String> removedZones = this.getRemovedZones(prevDisplayedZonesArray, this._selectedZonesSet);
            Set<String> addedZones = this.getAddedZones(prevDisplayedZonesSet, selectedZonesArray);
            this._mainUI.setDisplayedZones(this._selectedZonesSet);
            this._mainUI.setDisplayServicesWithNoZone(this._selectedZonesSet.contains(this.NO_ZONES_WRAPPER.getZone()));
            for (String removedZone : removedZones) {
                List<ServiceItem> removedServiceItemsList = Repository.getInstance().getServicesItems(removedZone);
                for (ServiceItem removedServiceItem : removedServiceItemsList) {
                    if (Repository.getInstance().isServiceAssociatedWithAnotherZones(removedServiceItem, this._selectedZonesSet)) continue;
                    this._mainUI.serviceRemoved(removedServiceItem, false, true);
                }
            }
            for (String addedZone : addedZones) {
                List<ServiceItem> addedServiceItemsList = Repository.getInstance().getServicesItems(addedZone);
                for (ServiceItem addedServiceItem : addedServiceItemsList) {
                    this._mainUI.serviceAdded(addedServiceItem);
                }
            }
            this.dispose();
        } else if (source.equals(this._cancelButton)) {
            this._selectedZonesSet = null;
            this.dispose();
        } else if (source.equals(this._refreshButton)) {
            this.setZones();
        }
    }

    private Set<String> getRemovedZones(String[] prevSelectedZones, Set<String> curSelectedZones) {
        HashSet<String> removedZonesSet = new HashSet<String>();
        for (String prevSelectedZone : prevSelectedZones) {
            if (curSelectedZones.contains(prevSelectedZone)) continue;
            removedZonesSet.add(prevSelectedZone);
        }
        return removedZonesSet;
    }

    private Set<String> getAddedZones(Set<String> prevSelectedZones, String[] curSelectedZones) {
        HashSet<String> newZonesSet = new HashSet<String>();
        for (String curSelectedZone : curSelectedZones) {
            if (prevSelectedZones.contains(curSelectedZone)) continue;
            newZonesSet.add(curSelectedZone);
        }
        return newZonesSet;
    }

    public Set<String> getSelectedZones() {
        return this._selectedZonesSet;
    }

    private class ZonesTableModel
    extends BasicSortableTableModel {
        private static final String CN_INCLUDE = "\u00a0";
        private static final String CN_ZONE = "Zone";
        public static final int CI_INCLUDE_ID = 0;
        public static final int CI_ZONE_ID = 1;

        private ZonesTableModel() {
        }

        @Override
        protected void initColumnNames() {
            this.columnNames = new String[2];
            this.columnNames[0] = CN_INCLUDE;
            this.columnNames[1] = CN_ZONE;
        }

        @Override
        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public Object getCellValue(BasicWrapper basicWrapper, int column) {
            ZoneWrapper zoneWrapper = (ZoneWrapper)basicWrapper;
            switch (column) {
                case 0: {
                    return zoneWrapper.isInclude();
                }
                case 1: {
                    return zoneWrapper.getZone();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                ZoneWrapper zoneWrapper = (ZoneWrapper)this.getWrapperAt(row);
                boolean isInclude = (Boolean)aValue;
                zoneWrapper.setInclude(isInclude);
                if (!isInclude) {
                    ZonesManagementDialog.this._zonesCheckBoxHeader.setSelected(false);
                } else {
                    List<BasicWrapper> zonesWrappersList = this.getWrappersList();
                    boolean isSelectHeaderCB = true;
                    for (BasicWrapper basicWrapper : zonesWrappersList) {
                        if (((ZoneWrapper)basicWrapper).isInclude()) continue;
                        isSelectHeaderCB = false;
                        break;
                    }
                    ZonesManagementDialog.this._zonesCheckBoxHeader.setSelected(isSelectHeaderCB);
                }
                this.fireTableRowsUpdated(row, row);
            }
        }

        @Override
        protected int compareWrappers(BasicWrapper wrapper1, BasicWrapper wrapper2, int colIndex, boolean ascending) {
            ZoneWrapper zoneWrapper1 = (ZoneWrapper)wrapper1;
            ZoneWrapper zoneWrapper2 = (ZoneWrapper)wrapper2;
            switch (colIndex) {
                case 1: {
                    String zone1 = zoneWrapper1.getZone();
                    String zone2 = zoneWrapper2.getZone();
                    if (ascending) {
                        return zone1.compareToIgnoreCase(zone2);
                    }
                    return zone2.compareToIgnoreCase(zone1);
                }
            }
            return 0;
        }

        public void setSelectedAllZones(boolean selected) {
            List<BasicWrapper> wrappersList = this.getWrappersList();
            for (BasicWrapper basicWrapper : wrappersList) {
                ZoneWrapper zoneWrapper = (ZoneWrapper)basicWrapper;
                zoneWrapper.setInclude(selected);
            }
            this.fireTableDataChanged();
        }
    }

    public class ZoneWrapper
    extends BasicWrapper {
        private final String zone;
        private boolean include;
        private final boolean isConstant;

        public ZoneWrapper(String zone, boolean include, boolean isConstant) {
            this.zone = zone;
            this.include = include;
            this.isConstant = isConstant;
        }

        private ZoneWrapper(String zone, boolean include) {
            this(zone, include, false);
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public String getZone() {
            return this.zone;
        }

        public boolean isInclude() {
            return this.include;
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        @Override
        public boolean compareRuntimeDetails(BasicWrapper wrapper) {
            return false;
        }

        private ZonesManagementDialog getOuterType() {
            return ZonesManagementDialog.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.include ? 1231 : 1237);
            result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ZoneWrapper other = (ZoneWrapper)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.include != other.include) {
                return false;
            }
            return !(this.zone == null ? other.zone != null : !this.zone.equals(other.zone));
        }
    }

    private class ZonesCheckBoxHeader
    extends CheckBoxHeader {
        public ZonesCheckBoxHeader(JTable table) {
            super(table, 0);
        }

        @Override
        protected void handleSelection(boolean isSelected) {
            ZonesManagementDialog.this._zonesTableModel.setSelectedAllZones(isSelected);
        }
    }
}

