/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.security;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.ILoginListener;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.service.ServiceItemUtils;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.IJSpace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class SecurityServicesRepository {
    private static SecurityServicesRepository _securityServicesRepository;
    private CredentialsProvider _curCredentialsProvider;
    private final Map<ServiceID, Authentication> _securityAuthenticationsMap = Collections.synchronizedMap(new HashMap());
    private final List<AuthenticationListener> _listenersList = new ArrayList<AuthenticationListener>(20);
    private final List<ILoginListener> _loginListenersList = new ArrayList<ILoginListener>(2);
    private static Logger LOGGER;

    public void addAuthenticationListener(AuthenticationListener authenticationListener) {
        this._listenersList.add(authenticationListener);
    }

    public void addLoginListener(ILoginListener loginListener) {
        this._loginListenersList.add(loginListener);
    }

    private void fireLoginPerformed(String userName) {
        int listSize = this._loginListenersList.size();
        for (int index = 0; index < listSize; ++index) {
            ILoginListener loginListener = this._loginListenersList.get(index);
            loginListener.loginPerformed(userName);
        }
    }

    private void fireLogoutPerformed() {
        int listSize = this._loginListenersList.size();
        for (int index = 0; index < listSize; ++index) {
            ILoginListener loginListener = this._loginListenersList.get(index);
            loginListener.logoutPerformed();
        }
    }

    private void fireAuthenticationSucceeded(final ServiceItem serviceItem, final boolean isLoginSucceed, final Authentication authentication, final String failureMessage) {
        Thread updateThread = new Thread(){

            @Override
            public void run() {
                int listSize = SecurityServicesRepository.this._listenersList.size();
                for (int index = 0; index < listSize; ++index) {
                    try {
                        AuthenticationListener authenticationListener = (AuthenticationListener)SecurityServicesRepository.this._listenersList.get(index);
                        authenticationListener.serviceAuthenticated(serviceItem, isLoginSucceed, authentication, failureMessage);
                        continue;
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        };
        updateThread.start();
    }

    public Authentication getSecurityAuthentication(ServiceID serviceID) {
        return this._securityAuthenticationsMap.get(serviceID);
    }

    public void login(CredentialsProvider credentialsProvider) throws Exception {
        this._curCredentialsProvider = credentialsProvider;
        this.fireLoginPerformed(this._curCredentialsProvider.getUserDetails().getUsername());
        this.handleLogin();
    }

    public boolean isUserLoggedIn() {
        return this._curCredentialsProvider != null;
    }

    public String getLoggedUserName() {
        return this._curCredentialsProvider == null ? "" : this._curCredentialsProvider.getUserDetails().getUsername();
    }

    public String getLoggedUserPassword() {
        return this._curCredentialsProvider == null ? "" : this._curCredentialsProvider.getUserDetails().getPassword();
    }

    public boolean login(ServiceItem serviceItem, CredentialsProvider credentialsProvider) {
        try {
            this.performLogin(serviceItem, credentialsProvider, false);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            return false;
        }
        return true;
    }

    private void handleLogin() {
        ServiceItem[] serviceItems;
        Repository.ProvisionMonitorHolder[] provisionMonitorsArray;
        for (Repository.ProvisionMonitorHolder provisionMonitorHolder : provisionMonitorsArray = Repository.getInstance().getProvisionMonitorHolders()) {
            ServiceItem serviceItem = provisionMonitorHolder.getServiceItem();
            this.performBackgroundLogin(serviceItem);
        }
        for (ServiceItem serviceItem : serviceItems = Repository.getInstance().getServiceItems()) {
            SecuredService service = ServiceItemUtils.getSecuredServiceIfRelevant((ServiceItem)serviceItem);
            if (service == null || service instanceof GSM) continue;
            this.performBackgroundLogin(serviceItem);
        }
    }

    private void performBackgroundLogin(final ServiceItem serviceItem) {
        AdminUIThreadPool.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        SecurityServicesRepository.this.performLogin(serviceItem, SecurityServicesRepository.this._curCredentialsProvider, false);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLogin(ServiceItem serviceItem, CredentialsProvider credentialsProvider, boolean forceLogin) throws Exception {
        SecuredService securedService = ServiceItemUtils.getSecuredService((ServiceItem)serviceItem);
        ServiceID securedServiceID = serviceItem.serviceID;
        Map<ServiceID, Authentication> map = this._securityAuthenticationsMap;
        synchronized (map) {
            if (securedService.isServiceSecured() && (forceLogin || !this._securityAuthenticationsMap.containsKey(securedServiceID))) {
                try {
                    SecurityContext securityContext = securedService.login(credentialsProvider);
                    if (!this._securityAuthenticationsMap.containsKey(securedServiceID)) {
                        this._securityAuthenticationsMap.put(securedServiceID, securityContext.getAuthentication());
                        this.fireAuthenticationSucceeded(serviceItem, true, securityContext.getAuthentication(), "");
                    }
                }
                catch (Exception e) {
                    this.fireAuthenticationSucceeded(serviceItem, false, null, e.getMessage());
                    throw e;
                }
            }
        }
    }

    public void logout() {
        this._curCredentialsProvider = null;
        this.clearAuthenricationsMap();
        this.fireLogoutPerformed();
    }

    public void clearAuthenricationsMap() {
        this._securityAuthenticationsMap.clear();
    }

    public static synchronized SecurityServicesRepository getInstance() {
        if (_securityServicesRepository == null) {
            _securityServicesRepository = new SecurityServicesRepository();
        }
        return _securityServicesRepository;
    }

    private SecurityServicesRepository() {
    }

    public void authenticateUsingExistngAuthentication(ServiceItem serviceItem, boolean forceLogin) {
        block3: {
            if (this._curCredentialsProvider != null && (forceLogin || !this._securityAuthenticationsMap.containsKey(serviceItem.serviceID))) {
                try {
                    this.performLogin(serviceItem, this._curCredentialsProvider, forceLogin);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    public void authenticateUsingExistngAuthentication(IJSpace space) {
        block4: {
            if (this._curCredentialsProvider != null) {
                try {
                    SecuredService securedService = (SecuredService)space;
                    if (securedService.isServiceSecured()) {
                        securedService.login(this._curCredentialsProvider);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    public void handleAddedSecuredService(ServiceItem item) {
        SecuredService securedService = ServiceItemUtils.getSecuredServiceIfRelevant((ServiceItem)item);
        if (securedService != null) {
            try {
                if (securedService.isServiceSecured()) {
                    this.authenticateUsingExistngAuthentication(item, false);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static {
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    }
}

