/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.security.ui;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.security.ui.CustomLoginPropertiesPanel;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.j_spaces.tools.spacebrowser.utils.TableChangedListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.jini.core.lookup.ServiceItem;

public class CustomLoginDialog
extends EscapeDialog
implements ActionListener,
TableChangedListener {
    private JButton _okButton;
    private JButton _cancelButton;
    private JTextField _userDetailsProviderClassTextField;
    private CustomLoginPropertiesPanel _customLoginPropertiesPanel;
    private Component _parentComponent;
    private ServiceItem _serviceItem;
    private boolean isOkPressed = false;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private final int COMPONENT_HEIGHT = 22;
    private static String TITLE = "Custom Login";
    private CredentialsProvider _credentialsProvider;

    public CustomLoginDialog(JFrame parentFrame) {
        this(parentFrame, null);
    }

    public CustomLoginDialog(JFrame parentFrame, ServiceItem serviceItem) {
        super(parentFrame, TITLE, true);
        this._serviceItem = serviceItem;
        this._parentComponent = parentFrame;
        this._customLoginPropertiesPanel = new CustomLoginPropertiesPanel(this, MainUI.getUserLoginProperties());
        this._customLoginPropertiesPanel.addTableChangeListener(this);
        this.init();
    }

    public CustomLoginDialog(JDialog parentDialog) {
        this(parentDialog, null);
    }

    public CustomLoginDialog(JDialog parentFrame, ServiceItem serviceItem) {
        super(parentFrame, TITLE, true);
        this._parentComponent = parentFrame;
        this._serviceItem = serviceItem;
        this._customLoginPropertiesPanel = new CustomLoginPropertiesPanel(this, MainUI.getUserLoginProperties());
        this._customLoginPropertiesPanel.addTableChangeListener(this);
        this.init();
    }

    private void init() {
        Box buttonsBox = this.createButtonsBox();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(this.createTextFieldBox());
        contentPane.add(Box.createVerticalStrut(4));
        contentPane.add(this._customLoginPropertiesPanel);
        contentPane.add(Box.createVerticalStrut(7));
        contentPane.add(new JSeparator(0));
        contentPane.add(Box.createVerticalStrut(5));
        contentPane.add(buttonsBox);
        contentPane.add(Box.createVerticalStrut(5));
        this.handleOkButtonState(this._customLoginPropertiesPanel.getLoginProperties().size());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CustomLoginDialog.this.performCancel();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                CustomLoginDialog.this.performCancel();
            }
        });
        this.setSize(550, 350);
        this.setResizable(true);
        this.setLocationRelativeTo(this._parentComponent);
    }

    private Box createTextFieldBox() {
        Box hBox = new Box(0);
        JLabel label = new JLabel("User details provider class:");
        this._userDetailsProviderClassTextField = new JTextField();
        hBox.add(hBox.add(Box.createHorizontalStrut(2)));
        hBox.add(label);
        hBox.add(hBox.add(Box.createHorizontalStrut(2)));
        hBox.add(this._userDetailsProviderClassTextField);
        hBox.add(Box.createHorizontalGlue());
        this._userDetailsProviderClassTextField.setText(MainUI.getUserDetailsProviderClass());
        return hBox;
    }

    private void handleOkButtonState(int numOfIndexes) {
        this._okButton.setEnabled(numOfIndexes > 0);
    }

    private Box createButtonsBox() {
        this._okButton = new JButton("OK");
        this._cancelButton = new JButton("Cancel");
        Dimension buttonSize = new Dimension(75, 22);
        this._okButton.setPreferredSize(buttonSize);
        this._okButton.setMinimumSize(buttonSize);
        this._cancelButton.setPreferredSize(buttonSize);
        this._cancelButton.setMinimumSize(buttonSize);
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        Box hBox = new Box(0);
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this._okButton);
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(this._cancelButton);
        hBox.add(Box.createHorizontalGlue());
        return hBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this._okButton)) {
            this.okButtonPressed();
        } else if (e.getSource().equals(this._cancelButton)) {
            this.performCancel();
        }
    }

    private void performCancel() {
        this.isOkPressed = false;
        this.setVisible(false);
    }

    public boolean isOKPressed() {
        return this.isOkPressed;
    }

    private void okButtonPressed() {
        if (this.performLogin()) {
            this.isOkPressed = true;
            this.setVisible(false);
        }
    }

    private boolean isDataValid(String className, Properties properties) {
        if (className.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Unable to continue.\nPlease provide user details provider class.", "Login", 2);
            return false;
        }
        try {
            this._credentialsProvider = CredentialsProviderHelper.fromClassName((String)className, (Properties)properties);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            JOptionPane.showMessageDialog(this, "<HTML>Failed to initialize <FONT color=\"blue\">" + className + "</FONT> class due to<BR><FONT color=\"red\">" + e.toString() + "</FONT></HTML>", "Login", 2);
            return false;
        }
        return this._customLoginPropertiesPanel.isDataValid();
    }

    private boolean performLogin() {
        List<CustomLoginPropertiesPanel.LoginPropertyWrapper> loginProperties = this._customLoginPropertiesPanel.getLoginProperties();
        Properties resultLoginProperties = new Properties();
        for (CustomLoginPropertiesPanel.LoginPropertyWrapper loginPropertyWrapper : loginProperties) {
            String propertyKey = loginPropertyWrapper.getPropertyKey();
            String propertyValue = loginPropertyWrapper.getPropertyValue();
            resultLoginProperties.setProperty(propertyKey, propertyValue);
        }
        if (!this.isDataValid(this._userDetailsProviderClassTextField.getText(), resultLoginProperties)) {
            return false;
        }
        try {
            SecurityServicesRepository.getInstance().login(this._credentialsProvider);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            JOptionPane.showMessageDialog(this, "<HTML>Failed to login due to <FONT color=\"red\">" + e.toString() + "</FONT></HTML>", "Login", 2);
        }
        if (this._serviceItem != null) {
            SecurityServicesRepository.getInstance().login(this._serviceItem, this._credentialsProvider);
        }
        return true;
    }

    @Override
    public void rowsNumChanged(int rowsCount) {
        this._okButton.setEnabled(rowsCount > 0);
    }
}

