/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.security.ui;

import com.gigaspaces.security.Authority;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.TableChangedListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;

public class CustomLoginPropertiesPanel
extends Box
implements ActionListener {
    private JTable _loginPropertiesTable;
    private LoginPropertiesTableModel _loginPropertiesTableModel;
    private JButton _addPropertyButton;
    private JButton _deletePropertyButton;
    private final JDialog _parentDialog;
    private List<TableChangedListener> _tableChangeListenersList = new ArrayList<TableChangedListener>();
    private final Dimension buttonSize = new Dimension(24, 24);

    public CustomLoginPropertiesPanel(JDialog parentDialog, Properties initialProperties) {
        super(1);
        this._parentDialog = parentDialog;
        this.init();
        if (initialProperties == null) {
            initialProperties = new Properties();
        }
        if (initialProperties.isEmpty()) {
            initialProperties.setProperty("username", "");
            initialProperties.setProperty("password", "");
        }
        this.loadInitialData(initialProperties);
    }

    public void addTableChangeListener(TableChangedListener tableChangedListener) {
        this._tableChangeListenersList.add(tableChangedListener);
    }

    private void init() {
        this.add(Box.createVerticalStrut(6));
        Box loginPropertiesTableBox = this.createLoginPropertiesTableBox();
        this.add(loginPropertiesTableBox);
        this.add(Box.createVerticalStrut(3));
    }

    private Box createLoginPropertiesTableBox() {
        Box loginPropertiesTableBox = new Box(0);
        this._loginPropertiesTableModel = new LoginPropertiesTableModel();
        this._loginPropertiesTable = new JTable(this._loginPropertiesTableModel);
        this._loginPropertiesTable.setRowHeight(17);
        CustomLoginPropertiesPanel.setTableProperties(this._loginPropertiesTable);
        this._loginPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CustomLoginPropertiesPanel.this.handleDeleteButtonState();
            }
        });
        this._loginPropertiesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    CustomLoginPropertiesPanel.this.deleteSelectedRows();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._loginPropertiesTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        loginPropertiesTableBox.add(scrollPane);
        this._addPropertyButton = this.createAddRemoveButton(IconsRepository.getInstance().getIcon(200), "+", "Add space operation rule");
        this._deletePropertyButton = this.createAddRemoveButton(IconsRepository.getInstance().getIcon(201), "-", "Remove selected space operation rule(s)");
        this._addPropertyButton.addActionListener(this);
        this._deletePropertyButton.addActionListener(this);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._addPropertyButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._deletePropertyButton);
        buttonsBox.add(Box.createHorizontalGlue());
        Box vertBox = new Box(1);
        vertBox.add(loginPropertiesTableBox);
        vertBox.add(Box.createVerticalStrut(4));
        vertBox.add(buttonsBox);
        return vertBox;
    }

    private JButton createAddRemoveButton(ImageIcon icon, String text, String tooltip) {
        JButton button = new JButton(text);
        button.setPreferredSize(this.buttonSize);
        button.setMinimumSize(this.buttonSize);
        button.setToolTipText(tooltip);
        return button;
    }

    private static void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 3);
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(4);
        table.setAutoscrolls(true);
    }

    private void handleDeleteButtonState() {
        this._deletePropertyButton.setEnabled(this._loginPropertiesTable.getSelectedRows().length > 0);
    }

    private void loadInitialData(Properties initialProperties) {
        Set<Map.Entry<Object, Object>> entrySet = initialProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            this._loginPropertiesTableModel.addLoginProperty(new LoginPropertyWrapper(propertyName, propertyValue));
        }
    }

    public void clear() {
        this._deletePropertyButton.setEnabled(false);
        this._loginPropertiesTableModel.clear();
        this._loginPropertiesTable.setEditingColumn(-1);
        this._loginPropertiesTable.setEditingRow(-1);
        TableCellEditor cellEditor = this._loginPropertiesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
    }

    public List<LoginPropertyWrapper> getLoginProperties() {
        return this._loginPropertiesTableModel.getLoginProperties();
    }

    public boolean isDataValid() {
        if (!this.stopCellEditong()) {
            return false;
        }
        List<LoginPropertyWrapper> loginProperties = this._loginPropertiesTableModel.getLoginProperties();
        boolean isUserNameMissing = false;
        boolean isPasswordMissing = false;
        for (LoginPropertyWrapper loginPropertyWrapper : loginProperties) {
            if (loginPropertyWrapper.getPropertyKey().equals("username") && loginPropertyWrapper.getPropertyValue().trim().length() == 0) {
                isUserNameMissing = true;
            }
            if (!loginPropertyWrapper.getPropertyKey().equals("password") || loginPropertyWrapper.getPropertyValue().trim().length() != 0) continue;
            isPasswordMissing = true;
        }
        if (isUserNameMissing && isPasswordMissing) {
            JOptionPane.showMessageDialog(this._parentDialog, "Unable to continue. Please provide both user name and password.", "Login", 2);
            return false;
        }
        if (isUserNameMissing) {
            JOptionPane.showMessageDialog(this._parentDialog, "Unable to continue. Please provide user name.", "Login", 2);
            return false;
        }
        if (isPasswordMissing) {
            JOptionPane.showMessageDialog(this._parentDialog, "Unable to continue. Please provide password.", "Login", 2);
            return false;
        }
        return true;
    }

    private boolean stopCellEditong() {
        TableCellEditor cellEditor = this._loginPropertiesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._addPropertyButton)) {
            if (this.stopCellEditong()) {
                LoginPropertyWrapper loginPropertyWrapper = new LoginPropertyWrapper("", "");
                this._loginPropertiesTableModel.addLoginProperty(loginPropertyWrapper);
            }
        } else if (source.equals(this._deletePropertyButton)) {
            this.deleteSelectedRows();
        }
    }

    private void deleteSelectedRows() {
        if (!this.stopCellEditong()) {
            return;
        }
        int[] selRows = this._loginPropertiesTable.getSelectedRows();
        this._loginPropertiesTableModel.removeClassIndexAt(selRows);
        if (this._loginPropertiesTable.getRowCount() > 0) {
            int minRow = selRows[0];
            int selRow = minRow == 0 ? 0 : minRow - 1;
            this._loginPropertiesTable.setRowSelectionInterval(selRow, selRow);
        }
    }

    public class LoginPropertyWrapper {
        private String _propertyKey;
        private String _propertyValue;

        public LoginPropertyWrapper(String propertyKey, String propertyValue) {
            this._propertyKey = propertyKey;
            this._propertyValue = propertyValue;
        }

        public void setPropertyKey(String propertyKey) {
            this._propertyKey = propertyKey;
        }

        public void setValue(String propertyValue) {
            this._propertyValue = propertyValue;
        }

        public String getPropertyKey() {
            return this._propertyKey;
        }

        public String getPropertyValue() {
            return this._propertyValue;
        }
    }

    private class LoginPropertiesTableModel
    extends DefaultTableModel {
        private final String CN_INDEX_PROPERTY_KEY = "Property";
        private final String CN_INDEX_PROPERTY_VALUE = "Value";
        public static final int CI_INDEX_PROPERTY_KEY = 0;
        public static final int CI_INDEX_PROPERTY_VALUE = 1;
        protected String[] columnNames;
        private final List<LoginPropertyWrapper> _curLoginPropertiesList = new ArrayList<LoginPropertyWrapper>();

        public LoginPropertiesTableModel() {
            this.initColumnNames();
        }

        public void addLoginProperty(LoginPropertyWrapper loginProperty) {
            this._curLoginPropertiesList.add(loginProperty);
            int newListSize = this._curLoginPropertiesList.size();
            this.fireTableRowsInserted(newListSize - 1, newListSize - 1);
        }

        protected void initColumnNames() {
            this.columnNames = new String[2];
            this.columnNames[0] = "Property";
            this.columnNames[1] = "Value";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row >= this._curLoginPropertiesList.size()) {
                return;
            }
            LoginPropertyWrapper loginPropertyWrapper = this._curLoginPropertiesList.get(row);
            switch (column) {
                case 0: {
                    String propertyKey = (String)aValue;
                    loginPropertyWrapper.setPropertyKey(propertyKey);
                    break;
                }
                case 1: {
                    String value = (String)aValue;
                    loginPropertyWrapper.setValue(value);
                }
            }
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            this.fireTableRowsChanged();
        }

        @Override
        public void fireTableRowsInserted(int firstRow, int lastRow) {
            super.fireTableRowsInserted(firstRow, lastRow);
            this.fireTableRowsChanged();
        }

        @Override
        public void fireTableRowsDeleted(int firstRow, int lastRow) {
            super.fireTableRowsDeleted(firstRow, lastRow);
            this.fireTableRowsChanged();
        }

        private void fireTableRowsChanged() {
            int rowCount = this.getRowCount();
            for (TableChangedListener tableChangedListener : CustomLoginPropertiesPanel.this._tableChangeListenersList) {
                tableChangedListener.rowsNumChanged(rowCount);
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void removeClassIndexAt(int ... rows) {
            for (int index = rows.length - 1; index >= 0; --index) {
                this._curLoginPropertiesList.remove(rows[index]);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int column) {
            LoginPropertyWrapper loginPropertyWrapper;
            if (row >= 0 && row < this._curLoginPropertiesList.size() && (loginPropertyWrapper = this._curLoginPropertiesList.get(row)) != null) {
                return this.getCellValue(loginPropertyWrapper, column);
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            if (obj != null) {
                return obj.getClass();
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._curLoginPropertiesList == null ? 0 : this._curLoginPropertiesList.size();
        }

        private Object getCellValue(LoginPropertyWrapper loginPropertyWrapper, int column) {
            switch (column) {
                case 0: {
                    return loginPropertyWrapper.getPropertyKey();
                }
                case 1: {
                    return loginPropertyWrapper.getPropertyValue();
                }
            }
            return "";
        }

        public LoginPropertyWrapper getLoginPropertyWrapperAt(int row) {
            if (row >= 0 && row < this._curLoginPropertiesList.size()) {
                return this._curLoginPropertiesList.get(row);
            }
            return null;
        }

        public List<LoginPropertyWrapper> getLoginProperties() {
            return this._curLoginPropertiesList;
        }

        public void setLoginProperties(List<LoginPropertyWrapper> loginPropertiesList) {
            int curListSize = this._curLoginPropertiesList.size();
            this._curLoginPropertiesList.addAll(loginPropertiesList);
            int listSize = loginPropertiesList.size();
            if (listSize > 0) {
                this.fireTableRowsInserted(curListSize, curListSize + listSize - 1);
            }
        }

        private Object getAuthoritiesRepresentation(Authority[] authoritiesArray) {
            String result = "";
            for (Authority authority : authoritiesArray) {
                if (result.length() != 0) {
                    result = result + ", ";
                }
                result = result + authority.getAuthority();
            }
            return result;
        }

        public void clear() {
            int curRowCount = this._curLoginPropertiesList.size();
            if (curRowCount > 0) {
                this.fireTableRowsDeleted(0, curRowCount - 1);
            }
            this._curLoginPropertiesList.clear();
        }
    }
}

