/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.security.ui;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.j_spaces.kernel.JSpaceUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.jini.core.lookup.ServiceItem;

public class LoginDialog
extends EscapeDialog
implements ActionListener {
    private JTextField _loginNameField;
    private JPasswordField _passwordFiled;
    private JButton _okButton;
    private JButton _cancelButton;
    private Dimension _componentSize = new Dimension(450, 23);
    private Dimension _labelSize = new Dimension(76, 22);
    private MyKeyListsner _keyListener = new MyKeyListsner();
    private String _loginName = "";
    private String _password;
    private ServiceItem _serviceItem;
    private Component _parentComponent;
    private boolean isOkPressed = false;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static String TITLE = "Login";

    public LoginDialog(JFrame parentFrame) {
        this(parentFrame, null);
    }

    public LoginDialog(JFrame parentFrame, ServiceItem serviceItem) {
        super(parentFrame, TITLE, true);
        this._parentComponent = parentFrame;
        this._serviceItem = serviceItem;
        this.init();
    }

    public LoginDialog(JDialog parentDialog) {
        this(parentDialog, null);
    }

    public LoginDialog(JDialog parentDialog, ServiceItem serviceItem) {
        super(parentDialog, TITLE, true);
        this._serviceItem = serviceItem;
        this._parentComponent = parentDialog;
        this.init();
    }

    private void init() {
        this._loginNameField = new JTextField();
        this._passwordFiled = new JPasswordField();
        Container contentContainer = this.getContentPane();
        Box loginNameBox = this.createLoginNameBox();
        Box passwordBox = this.createPasswordBox();
        Box buttonsBox = this.createButtonsBox();
        Box centerBox = new Box(1);
        centerBox.add(loginNameBox);
        centerBox.add(passwordBox);
        centerBox.add(new JSeparator(0));
        centerBox.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        buttonsBox.setBorder(BorderFactory.createEmptyBorder(0, 3, 5, 3));
        contentContainer.add((Component)centerBox, "Center");
        contentContainer.add((Component)buttonsBox, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LoginDialog.this.performCancel();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                LoginDialog.this.performCancel();
            }
        });
        this.pack();
        this.setResizable(false);
        this.setSize(295, 160);
        this.setLocationRelativeTo(this._parentComponent);
    }

    private Box createLoginNameBox() {
        JLabel loginNameLabel = new JLabel("User Name:");
        this._loginNameField = new JTextField();
        Box horizontalBox = new Box(0);
        loginNameLabel.setPreferredSize(this._labelSize);
        loginNameLabel.setMinimumSize(this._labelSize);
        this._loginNameField.setPreferredSize(this._componentSize);
        this._loginNameField.setMaximumSize(this._componentSize);
        this._loginNameField.addKeyListener(this._keyListener);
        horizontalBox.add(loginNameLabel);
        horizontalBox.add(Box.createHorizontalStrut(20));
        horizontalBox.add(this._loginNameField);
        return horizontalBox;
    }

    private Box createPasswordBox() {
        JLabel passwordLabel = new JLabel("Password:");
        passwordLabel.setPreferredSize(this._labelSize);
        passwordLabel.setMinimumSize(this._labelSize);
        this._passwordFiled = new JPasswordField();
        this._passwordFiled.setPreferredSize(this._componentSize);
        this._passwordFiled.setMaximumSize(this._componentSize);
        this._passwordFiled.addKeyListener(this._keyListener);
        Box horizontalBox = new Box(0);
        horizontalBox.add(passwordLabel);
        horizontalBox.add(Box.createHorizontalStrut(20));
        horizontalBox.add(this._passwordFiled);
        return horizontalBox;
    }

    private Box createButtonsBox() {
        Box horizontalBox = new Box(0);
        this._okButton = new JButton("OK");
        this._cancelButton = new JButton("Cancel");
        this._okButton.setMnemonic('O');
        this._cancelButton.setMnemonic('C');
        Dimension buttonSize = new Dimension(60, 22);
        this._okButton.setPreferredSize(buttonSize);
        this._cancelButton.setPreferredSize(buttonSize);
        this._okButton.setMinimumSize(buttonSize);
        this._cancelButton.setMinimumSize(buttonSize);
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(this._okButton);
        horizontalBox.add(Box.createHorizontalStrut(15));
        horizontalBox.add(this._cancelButton);
        horizontalBox.add(Box.createHorizontalGlue());
        return horizontalBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this.performOk();
        } else if (e.getSource() == this._cancelButton) {
            this.performCancel();
        }
    }

    private void performCancel() {
        this.isOkPressed = false;
        this.setVisible(false);
    }

    public boolean isOKPressed() {
        return this.isOkPressed;
    }

    private void performOk() {
        if (this.isDataValid()) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.performLogin()) {
                    this.isOkPressed = true;
                    this.setVisible(false);
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private boolean performLogin() {
        DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider(this._loginName, this._password);
        try {
            SecurityServicesRepository.getInstance().login((CredentialsProvider)credentialsProvider);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            JOptionPane.showMessageDialog(this, "<HTML>Failed to login due to <FONT color=\"red\">" + e.toString() + "</FONT></HTML>", "Login", 2);
            return false;
        }
        if (this._serviceItem != null) {
            SecurityServicesRepository.getInstance().login(this._serviceItem, (CredentialsProvider)credentialsProvider);
        }
        return true;
    }

    private boolean isDataValid() {
        this._loginName = this._loginNameField.getText();
        this._password = String.valueOf(this._passwordFiled.getPassword());
        if (JSpaceUtilities.isEmpty((String)this._loginName, (boolean)true) || JSpaceUtilities.isEmpty((String)this._password, (boolean)true)) {
            String messagePrefix = "Unable to continue. ";
            String message = null;
            message = JSpaceUtilities.isEmpty((String)this._loginName, (boolean)true) && JSpaceUtilities.isEmpty((String)this._password, (boolean)true) ? "Unable to continue. Please provide both user name and password." : (JSpaceUtilities.isEmpty((String)this._loginName, (boolean)true) ? "Unable to continue. Please provide user name." : "Unable to continue. Please provide password.");
            JOptionPane.showMessageDialog(this, message, "Login", 1);
            return false;
        }
        return true;
    }

    public String getLoginName() {
        return this._loginName;
    }

    public String getPassword() {
        return this._password;
    }

    private class MyKeyListsner
    extends KeyAdapter {
        private MyKeyListsner() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                LoginDialog.this.performOk();
            }
        }
    }
}

