/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui;

import com.gigaspaces.admin.ui.util.UIHelper;
import java.awt.Component;
import java.awt.Container;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class LogoWindow
extends JWindow {
    private static final long serialVersionUID = -4539922132271131519L;
    private LoadingProgressBar progressBar;
    private JLabel _label;
    private static Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public LogoWindow(JFrame parentFrame) {
        ImageIcon splashImageIcon;
        block4: {
            super(parentFrame);
            this.progressBar = new LoadingProgressBar();
            String iconName = "com/gigaspaces/admin/ui/images/service_large.png";
            splashImageIcon = UIHelper.getImageIcon(iconName);
            String customSplashImagePath = System.getProperty("com.gs.splash-image.path");
            if (customSplashImagePath != null) {
                try {
                    ImageIcon splashIconLocal = new ImageIcon(customSplashImagePath);
                    if (splashImageIcon != null) {
                        splashImageIcon = splashIconLocal;
                    }
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, t.toString(), t);
                }
            }
        }
        this._label = new JLabel(splashImageIcon);
        this.progressBar.setBorder(null);
        this.progressBar.setIgnoreRepaint(false);
        this._label.setIgnoreRepaint(false);
        this.progressBar.setDoubleBuffered(true);
        this._label.setDoubleBuffered(true);
        Container _contentPanel = this.getContentPane();
        _contentPanel.add((Component)this._label, "Center");
        _contentPanel.add((Component)this.progressBar, "South");
        this.pack();
    }

    public LoadingProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.progressBar.startProgress();
        } else {
            this.progressBar.stopProgress();
        }
        super.setVisible(visible);
    }

    public class LoadingProgressBar
    extends JProgressBar {
        private static final int PROGRESS_BAR_MAX_VALUE = 370;
        public static final int BIG_PROGRESS = 120;
        public static final int LITTLE_PROGRESS = 50;
        private Timer timer;
        private int curProgressVal;
        private TimerTask timerTask;

        public LoadingProgressBar() {
            super(0, 370);
            this.curProgressVal = 0;
            this.setDoubleBuffered(true);
            this.timerTask = new ProgressTimerTask();
            this.timer = new Timer();
        }

        public void incrementProgressBar(int incrementation) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("-----------Incrementation" + incrementation + "cur=" + this.curProgressVal);
            }
            if (this.curProgressVal < incrementation) {
                if (incrementation == 370 && this.curProgressVal < 340) {
                    incrementation -= 25;
                }
                this.setValue(incrementation);
                this.curProgressVal = incrementation;
            }
        }

        public void startProgress() {
            this.timer.scheduleAtFixedRate(this.timerTask, 0L, 50L);
        }

        public void stopProgress() {
            this.timerTask.cancel();
            this.timer.cancel();
        }

        private void checkProgressState() {
            if (LogoWindow.this.progressBar.getValue() >= 370) {
                this.stopProgress();
            }
        }

        private class ProgressTimerTask
        extends TimerTask {
            private ProgressTimerTask() {
            }

            @Override
            public void run() {
                LogoWindow.this.progressBar.setValue(LoadingProgressBar.this.curProgressVal++);
                LogoWindow.this._label.paintImmediately(LogoWindow.this._label.getBounds());
                LogoWindow.this.progressBar.paintImmediately(0, 0, LogoWindow.this.progressBar.getWidth(), LogoWindow.this.progressBar.getHeight());
                LoadingProgressBar.this.checkProgressState();
            }
        }
    }
}

