/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui;

import com.gigaspaces.admin.discovery.GroupSelector;
import com.gigaspaces.admin.discovery.LocatorDialog;
import com.gigaspaces.admin.discovery.RecordingDiscoveryListener;
import com.gigaspaces.admin.discovery.ReggieStatPanel;
import com.gigaspaces.admin.discovery.ZonesManagementDialog;
import com.gigaspaces.admin.security.ILoginListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.IServiceGridUIComponent;
import com.gigaspaces.admin.ui.LogoWindow;
import com.gigaspaces.admin.ui.OrderedThreadPool;
import com.gigaspaces.admin.ui.SingleThreadExecutor;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.UI;
import com.gigaspaces.admin.ui.grid.deploy.utils.Colors;
import com.gigaspaces.admin.ui.grid.gsc.GSCMonitorPanel;
import com.gigaspaces.admin.ui.grid.gsc.ServicesInstancesInfoPanel;
import com.gigaspaces.admin.ui.grid.utils.DeploymentActionsManager;
import com.gigaspaces.admin.ui.security.ManageSecurityFrame;
import com.gigaspaces.admin.ui.security.SecurityManagementLoginDialog;
import com.gigaspaces.admin.ui.security.monitor.LoginMonitorDialog;
import com.gigaspaces.admin.ui.util.AboutBox;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.admin.ui.util.MacUIHelper;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.admin.ui.views.hosts.HostsViewPanel;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.license.Encoder;
import com.gigaspaces.internal.license.LicenseInfo;
import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.license.LicenseType;
import com.gigaspaces.internal.license.LicenseValidation;
import com.gigaspaces.internal.utils.SecurityUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.spacebrowser.AddressBarDialog;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.sun.jini.config.Config;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.tree.MutableTreeNode;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.util.Direction;
import net.jini.admin.Administrable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupGroups;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import org.apache.commons.codec.binary.Base64;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.core.FaultDetectionHandler;
import org.jini.rio.core.FaultDetectionListener;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.jsb.ServiceBeanAdmin;
import org.jini.rio.cybernode.Cybernode;
import org.jini.rio.resources.client.FaultDetectionHandlerFactory;

public class MainUI
extends JFrame
implements ServiceDiscoveryListener,
FaultDetectionListener,
ILoginListener {
    private static Logger LOGGER;
    String hostInfo;
    RecordingDiscoveryListener recordingListener;
    LookupDiscovery lookupDiscovery;
    static ServiceDiscoveryManager sdm;
    LookupCache lCache;
    DiscoveryManagement dMgr;
    GWDiscoveryListener gwdListener;
    private static final OrderedThreadPool<ServiceID> orderedThreadPool;
    private final SingleThreadExecutor<MutableTreeNode> singleThreadExecutor;
    private final Hashtable<ServiceItem, FaultDetectionHandler> fdhTable;
    private UI _uiComponent;
    private HostsViewPanel _hostsView;
    private final Map<String, Boolean> _zonesMap;
    private boolean _isDisplayServicesWithNoZone;
    private final JComponent[] serviceListeners;
    ImageIcon removeEnterIcon;
    ImageIcon removeIcon;
    private final JPanel base;
    private JMenuItem refreshViewMenuItem;
    private JMenuItem loginMenuItem;
    private JMenuItem customLoginMenuItem;
    private JMenuItem logoutMenuItem;
    private final Set<ServiceID> _displayedServices;
    Timer taskTimer;
    private static long DEFAULT_LOOKUP_CHECK_DELAY;
    private static long MIN_LOOKUP_CHECK_DELAY;
    private long lookupCheckInterval;
    private boolean isRetrieveRuntimeForPersistentLRUSpace;
    private boolean isSaveLocatorsToPropertiesFile;
    private JCheckBoxMenuItem displayPerstMatrixMenuItem;
    private JCheckBoxMenuItem saveLocatorsMenuItem;
    private final Container contentPane;
    private SpaceBrowser.SpaceBrowserMainContainer _spaceBrowserPanel;
    private ClusterViewDlg _clusterViewDialog;
    private final GSCMonitorPanel gscMonitorPanel;
    private final ServicesInstancesInfoPanel servicesInstancesInfoBox;
    private static final String LOCATORS_DELIMETER = ";";
    private int currentProgressIcrementValue;
    private String[] _jiniGroups;
    private String[] _searchedJiniGroups;
    private LookupLocator[] _lookupLocators;
    private final Timer spaceModeTimer;
    private static final int SET_SPACE_MODE_DELAY = 5000;
    public static final int TAB_INDEX_HOSTS = 0;
    public static final int TAB_INDEX_DEPLOYMENTS = 1;
    public static final int TAB_INDEX_SPACE_BROWSER = 2;
    private AboutBox aboutDialog;
    private final long startTime;
    MainUI frame;
    private static Properties configuredSysProps;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu launchMenu;
    private JMenu viewMenu;
    private JMenu settingsMenu;
    private JMenu securityMenu;
    private JMenu helpMenu;
    private TabWindow topTabWindow;
    private final RootWindow rootDockingWindow;
    private final DockingWindow[] topTabWindowsArray;
    private int mainSplitPaneDivLoc;
    private JToolBar toolBar;
    private JButton helpButton;
    private final JLabel statusLabel;
    private final JPanel statusContainer;
    private JButton resetWindows;
    private JButton jiniGroupsFilter;
    private JButton zonesFilter;
    private JButton refreshViewButton;
    private JButton _launchEDGDeploymentButton;
    private JButton _launchSBADeploymentButton;
    private JMenuItem _launchEDGDeploymentMenuItem;
    private JMenuItem _launchSBADeploymentMenuItem;
    private final LogoWindow.LoadingProgressBar _progressBar;
    private static Image logoImage;
    private static final String FRAME_PROP_WIDTH = "ui.width";
    private static final String FRAME_PROP_HEIGHT = "ui.height";
    private static final String FRAME_PROP_X_POS = "ui.xPos";
    private static final String FRAME_PROP_Y_POS = "ui.yPos";
    private static final String FRAME_PROP_SPLIT_LOCATION = "ui.mainSplitPane";
    private static final String LOCATORS = "LOCATORS";
    public static final String BUILD_NUM = "BUILD_NUM";
    public static final String SAVE_LOCATORS = "SAVE_LOCATORS";
    private boolean _isAllowSpaceRemoving;
    private DockingWindow spaceBrowserDockingWindow;
    private DockingWindow hostsDockingWindow;
    private Timer refreshEnablingTimer;
    private Timer startDiscoveryTimer;
    private static final int REFRESH_ENABLING_WAITING_DURATION = 7000;
    private static final int START_DISCOVERY_WAITING_DURATION = 2500;
    private static MainUI mainUI;
    private static JFrame hiddenFrame;
    private static LogoWindow logoWindow;
    private static Configuration _config;
    private ServiceTemplate _template;
    private GroupSelector _groupSelector;
    private final JLabel _loggedUserInfoLabel;
    private final JButton _securityMonitorButton;
    private final JToolBar _securMonitorToolBar;
    private ZonesManagementDialog _zonesSelectorDialog;
    private static String _userDetailsProviderClass;
    private static Properties _userLoginProperties;
    private String _helpUrl;
    private Box _verticalMessagesBox;

    public MainUI(Configuration config, LogoWindow.LoadingProgressBar progressBar) {
        block9: {
            this.fdhTable = new Hashtable();
            this._isDisplayServicesWithNoZone = true;
            this._displayedServices = new HashSet<ServiceID>();
            this.lookupCheckInterval = DEFAULT_LOOKUP_CHECK_DELAY;
            this.currentProgressIcrementValue = 0;
            this.spaceModeTimer = new Timer();
            this.mainSplitPaneDivLoc = 510;
            this.refreshEnablingTimer = null;
            this.startDiscoveryTimer = null;
            this.singleThreadExecutor = new SingleThreadExecutor();
            this._zonesMap = new HashMap<String, Boolean>();
            this.startTime = System.currentTimeMillis();
            this.frame = this;
            this.contentPane = this.getContentPane();
            this._progressBar = progressBar;
            this.statusLabel = new JLabel();
            this.statusContainer = new JPanel(new BorderLayout());
            this.statusContainer.add((Component)this.statusLabel, "Center");
            this.contentPane.add((Component)this.statusContainer, "South");
            this.statusContainer.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            try {
                Repository.getInstance().setProperties(UIHelper.loadProperties());
            }
            catch (IOException e1) {
                System.err.println("Using default window placement settings");
            }
            InetAddress addr = SystemInfo.singleton().network().getHost();
            String hAddr = addr.getHostAddress();
            String hName = addr.getHostName();
            this.hostInfo = hAddr.equals(hName) ? hAddr : hName + "@" + hAddr;
            this.setTitle("GigaSpaces Management Center");
            this.base = new JPanel(new BorderLayout(4, 4));
            this.base.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.removeIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/remove.gif");
            this.removeEnterIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/remove_enter.gif");
            if (logoImage == null) {
                logoImage = UIHelper.getImageIcon("image/browser/jspacesIcon.png").getImage();
            }
            this.setIconImage(logoImage);
            this.gscMonitorPanel = new GSCMonitorPanel(this, config);
            RootWindowProperties rootWindowProperties = new RootWindowProperties();
            ShapedGradientDockingTheme currentDockingTheme = new ShapedGradientDockingTheme();
            DockingWindowProperties dockingWindowProperties = rootWindowProperties.getDockingWindowProperties();
            dockingWindowProperties.setCloseEnabled(true);
            dockingWindowProperties.setDockEnabled(true);
            dockingWindowProperties.setDragEnabled(true);
            dockingWindowProperties.setMaximizeEnabled(true);
            dockingWindowProperties.setMinimizeEnabled(true);
            dockingWindowProperties.setRestoreEnabled(true);
            dockingWindowProperties.setUndockEnabled(true);
            dockingWindowProperties.setUndockOnDropEnabled(true);
            rootWindowProperties.addSuperObject(currentDockingTheme.getRootWindowProperties());
            this.currentProgressIcrementValue = 50;
            this._progressBar.incrementProgressBar(50);
            JComponent[] uiComponents = this.createMainUIComponents(config);
            int componentsNum = uiComponents.length;
            this.topTabWindowsArray = new DockingWindow[componentsNum];
            for (int i = 0; i < componentsNum; ++i) {
                JComponent component = uiComponents[i];
                String toolTip = ((IServiceGridUIComponent)((Object)component)).getComponentToolTip();
                String name = ((IServiceGridUIComponent)((Object)component)).getComponentName();
                View dockingWindow = null;
                dockingWindow = new View(name, null, (Component)component);
                if (i == 2) {
                    this.spaceBrowserDockingWindow = dockingWindow;
                } else if (i == 0) {
                    this.hostsDockingWindow = dockingWindow;
                }
                dockingWindow.setToolTipText(toolTip);
                this.topTabWindowsArray[i] = dockingWindow;
            }
            this.serviceListeners = uiComponents;
            this.servicesInstancesInfoBox = new ServicesInstancesInfoPanel(this.gscMonitorPanel.getGSCPanel(), this._hostsView);
            this._loggedUserInfoLabel = new JLabel();
            this._securityMonitorButton = new JButton(IconsRepository.getInstance().getIcon(18));
            this._securMonitorToolBar = new JToolBar();
            this._securMonitorToolBar.setFloatable(false);
            this._securMonitorToolBar.setRollover(true);
            this._securMonitorToolBar.setBorderPainted(false);
            this._securMonitorToolBar.add(this._securityMonitorButton);
            Box infoSouthBox = new Box(0);
            infoSouthBox.add(this.servicesInstancesInfoBox);
            infoSouthBox.add(Box.createHorizontalGlue());
            infoSouthBox.add(this._loggedUserInfoLabel);
            infoSouthBox.add(Box.createHorizontalStrut(2));
            infoSouthBox.add(this._securMonitorToolBar);
            infoSouthBox.add(Box.createHorizontalStrut(3));
            this._securMonitorToolBar.setVisible(false);
            this._securityMonitorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoginMonitorDialog.getInstance(MainUI.this).setVisible(true);
                }
            });
            this.setJMenuBar(this.createMenu());
            this.topTabWindow = new TabWindow(this.topTabWindowsArray);
            this.rootDockingWindow = new RootWindow(null);
            this.rootDockingWindow.addListener((DockingWindowListener)new DockingWindowListenerImpl());
            this.rootDockingWindow.getRootWindowProperties().addSuperObject(rootWindowProperties);
            this.base.add((Component)this.createToolBar(), "North");
            this.base.add((Component)this.rootDockingWindow, "Center");
            this.base.add((Component)infoSouthBox, "South");
            this.rootDockingWindow.setWindow((DockingWindow)this.topTabWindow);
            this.setWindowsDefaultSettings();
            this.contentPane.add((Component)this.base, "Center");
            this.taskTimer = new Timer(true);
            try {
                this.lookupCheckInterval = Config.getLongEntry((Configuration)config, (String)"com.gigaspaces.admin.ui", (String)"lookupCheckInterval", (long)DEFAULT_LOOKUP_CHECK_DELAY, (long)MIN_LOOKUP_CHECK_DELAY, (long)Long.MAX_VALUE);
            }
            catch (ConfigurationException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.setDefaultCloseOperation(0);
        SecurityServicesRepository.getInstance().addLoginListener(this);
        LoginMonitorDialog.getInstance(this);
    }

    private void setLoggedinUserName(String userName) {
        this._loggedUserInfoLabel.setText("Logged in as: " + userName);
        this._securMonitorToolBar.setVisible(true);
    }

    private void clearLoggedinUserName() {
        this._loggedUserInfoLabel.setText("");
        this._securMonitorToolBar.setVisible(false);
    }

    public void removePUInstances(List<ServiceID> removedPUInstanceIds, String operStringName) {
        this._uiComponent.removePUInstances(removedPUInstanceIds, operStringName);
    }

    public boolean isRetrieveRuntimeForPersistentLRUSpace() {
        return this.isRetrieveRuntimeForPersistentLRUSpace;
    }

    private JToolBar createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setBorderPainted(false);
        this._launchSBADeploymentButton = new JButton("");
        this._launchSBADeploymentButton.setToolTipText("Deploy Application");
        this._launchSBADeploymentButton.setIcon(UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/launch_sba.gif"));
        this._launchEDGDeploymentButton = new JButton("");
        this._launchEDGDeploymentButton.setToolTipText("Deploy In-Memory-Data-Grid");
        this._launchEDGDeploymentButton.setIcon(UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/launch_edg.gif"));
        this._launchSBADeploymentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.selectDeploymentsTab();
                DeploymentActionsManager.getInstance(MainUI.this).performDeploy((short)1);
            }
        });
        this._launchEDGDeploymentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.selectDeploymentsTab();
                DeploymentActionsManager.getInstance(MainUI.this).performDeploy((short)2);
            }
        });
        this.toolBar.add(this._launchSBADeploymentButton);
        this.toolBar.add(this._launchEDGDeploymentButton);
        this.refreshViewButton = new JButton();
        ImageIcon refreshViewIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/refresh_icon.gif");
        this.refreshViewButton.setIcon(refreshViewIcon);
        this.refreshViewButton.setToolTipText("Refresh");
        this.toolBar.add(this.refreshViewButton);
        this.refreshViewButton.addActionListener(new RefreshViewAction());
        this.jiniGroupsFilter = new JButton();
        ImageIcon groupDiscoveryIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/groups_discovery.gif");
        this.jiniGroupsFilter.setIcon(groupDiscoveryIcon);
        this.jiniGroupsFilter.setToolTipText("Group Management...");
        this.toolBar.add(this.jiniGroupsFilter);
        this.jiniGroupsFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.showGroupManagementDialog();
            }
        });
        this.zonesFilter = new JButton();
        ImageIcon zonesIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/zones.png");
        this.zonesFilter.setIcon(zonesIcon);
        this.zonesFilter.setToolTipText("Zones Management...");
        this.toolBar.add(this.zonesFilter);
        this.zonesFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.showZonesManagementDialog();
            }
        });
        this.resetWindows = new JButton();
        ImageIcon resetWindowsIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/reset_view.gif");
        this.resetWindows.setIcon(resetWindowsIcon);
        this.resetWindows.setToolTipText("Reset Layout");
        this.toolBar.add(this.resetWindows);
        this.resetWindows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.resetWindows();
            }
        });
        ImageIcon helpIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/help.gif");
        this.helpButton = new JButton(helpIcon);
        this.toolBar.add(this.helpButton);
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.showOnlineHelp();
            }
        });
        LicenseInfo licenseInfo = LicenseValidation.handleLicense((LicenseValidation.ManagementToolType)LicenseValidation.ManagementToolType.UI, (Encoder)new Encoder(){

            protected byte[] encode(byte[] data) {
                return Base64.encodeBase64((byte[])data);
            }
        });
        String licenseMessage = null;
        if (licenseInfo != null) {
            licenseMessage = licenseInfo.getLicenseMessage();
        }
        LicenseIndicationBox licenseIndicationBox = new LicenseIndicationBox(licenseMessage);
        licenseIndicationBox.setAlignmentX(0.0f);
        this._verticalMessagesBox = new Box(1);
        this._verticalMessagesBox.add(licenseIndicationBox);
        this.toolBar.add(this._verticalMessagesBox);
        return this.toolBar;
    }

    public void selectDeploymentsTab() {
        if (this.topTabWindow.getSelectedWindow() == null || !this.topTabWindow.getSelectedWindow().equals(this.hostsDockingWindow)) {
            this.topTabWindow.setSelectedTab(1);
        }
    }

    public void selectSpaceBrowserTab() {
        if (this.topTabWindow.getSelectedWindow() == null || !this.topTabWindow.getSelectedWindow().equals(this.spaceBrowserDockingWindow)) {
            this.topTabWindow.setSelectedTab(2);
        }
    }

    private void showOnlineHelp() {
        if (this._helpUrl == null) {
            this._helpUrl = LicenseValidation.handlePlatformHelpUrlWithParameter((LicenseValidation.ManagementToolType)LicenseValidation.ManagementToolType.UI);
            if (this._helpUrl == null) {
                this._helpUrl = PlatformVersion.getProductHelpUrl();
            }
        }
        JSpaceUIUtils.showInBrowser(this, this._helpUrl, LOGGER);
    }

    private JComponent[] createMainUIComponents(Configuration config) {
        JComponent[] resultUIComponentsArray = new JComponent[3];
        this._clusterViewDialog = new ClusterViewDlg(this, null);
        this._uiComponent = new UI(this, this._clusterViewDialog, config);
        this._progressBar.incrementProgressBar(this.currentProgressIcrementValue += 120);
        this._spaceBrowserPanel = SpaceBrowser.getMainPanel(this, this._clusterViewDialog);
        this._progressBar.incrementProgressBar(this.currentProgressIcrementValue += 170);
        this._hostsView = new HostsViewPanel(this, this.gscMonitorPanel);
        resultUIComponentsArray[0] = this._hostsView;
        resultUIComponentsArray[1] = this._uiComponent;
        resultUIComponentsArray[2] = this._spaceBrowserPanel;
        return resultUIComponentsArray;
    }

    public static OrderedThreadPool<ServiceID> getOrderedThreadPool() {
        return orderedThreadPool;
    }

    private void setWindowsDefaultSettings() {
        this.topTabWindow.getTabWindowProperties().getTabbedPanelProperties().setTabAreaOrientation(Direction.UP);
        this.topTabWindow.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setDirection(Direction.RIGHT);
        this.topTabWindow.setSelectedTab(0);
    }

    private void refreshView() {
        this.refreshViewMenuItem.setEnabled(false);
        this.refreshViewButton.setEnabled(false);
        this.setAllowSpaceRemoving(true);
        final String[] rmiServicesURLs = SpaceBrowser.getInstance().removeRMIContainers();
        this.stopDiscovery();
        this.refreshEnablingTimer = new Timer();
        final TimerTask refreshEnablingTimerTask = new TimerTask(){

            @Override
            public void run() {
                LOGGER.finer("-------------------------stopAllowSpaceRemovingTimerTask--------");
                MainUI.this.refreshViewMenuItem.setEnabled(true);
                MainUI.this.refreshViewButton.setEnabled(true);
                MainUI.this.refreshEnablingTimer.cancel();
            }
        };
        this.startDiscoveryTimer = new Timer();
        TimerTask startDiscoveryTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    block6: {
                        LOGGER.finer("-------------------------WAIT startDiscovery-------- ");
                        try {
                            while (SpaceBrowser.getInstance().isServicesDisplayed() || MainUI.this._uiComponent.isServicesDisplayed() && MainUI.this._hostsView.isServicesDisplayed()) {
                                Thread.sleep(500L);
                            }
                            SecurityServicesRepository.getInstance().clearAuthenricationsMap();
                            LoginMonitorDialog.getInstance(MainUI.this).clear();
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block6;
                            LOGGER.log(Level.FINE, e.toString(), e);
                        }
                    }
                    Repository.clearSpaceConfigs();
                    LOGGER.finer("------------------------- startDiscovery-------- ");
                    MainUI.this.setAllowSpaceRemoving(false);
                    MainUI.this.startDiscovery();
                    SpaceBrowser.getInstance().findRMIServices(rmiServicesURLs);
                }
                finally {
                    MainUI.this.startDiscoveryTimer.cancel();
                    MainUI.this.refreshEnablingTimer.schedule(refreshEnablingTimerTask, 7000L);
                }
            }
        };
        this.startDiscoveryTimer.schedule(startDiscoveryTimerTask, 2500L);
        LOGGER.finer("--------REFRESH VIEW END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWindows() {
        try {
            int selWindowIndex;
            this.setCursor(Cursor.getPredefinedCursor(3));
            DockingWindow selDockingWindow = this.topTabWindow.getSelectedWindow();
            this.topTabWindow = new TabWindow(this.topTabWindowsArray);
            this.rootDockingWindow.setWindow((DockingWindow)this.topTabWindow);
            this.setWindowsDefaultSettings();
            if (selDockingWindow != null && (selWindowIndex = this.topTabWindow.getChildWindowIndex(selDockingWindow)) >= 0) {
                this.topTabWindow.setSelectedTab(selWindowIndex);
            }
            for (int index = 0; index < this.topTabWindowsArray.length; ++index) {
                DockingWindow dockingWindow = this.topTabWindowsArray[index];
                IServiceGridUIComponent gridUIComponent = this.getGridUIComponent(dockingWindow);
                if (gridUIComponent == null) continue;
                gridUIComponent.resetInternalWindows();
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private IServiceGridUIComponent getGridUIComponent(DockingWindow dockingWindow) {
        View selView;
        Component selComponent;
        TabWindow tabWindow;
        int childCount;
        int i;
        if (dockingWindow instanceof SplitWindow) {
            SplitWindow splitWindow = (SplitWindow)dockingWindow;
            DockingWindow leftDockingWindow = splitWindow.getLeftWindow();
            DockingWindow rightDockingWindow = splitWindow.getRightWindow();
            IServiceGridUIComponent gridUIComponent = this.getGridUIComponent(leftDockingWindow);
            if (gridUIComponent != null) {
                return gridUIComponent;
            }
            return this.getGridUIComponent(rightDockingWindow);
        }
        if (dockingWindow instanceof TabWindow && (i = 0) < (childCount = (tabWindow = (TabWindow)dockingWindow).getChildWindowCount())) {
            return this.getGridUIComponent(tabWindow.getChildWindow(i));
        }
        if (dockingWindow instanceof View && (selComponent = (selView = (View)dockingWindow).getComponent()) instanceof IServiceGridUIComponent) {
            return (IServiceGridUIComponent)((Object)selComponent);
        }
        return null;
    }

    private JMenuBar createMenu() {
        this.menuBar = new JMenuBar();
        this.menuBar.setLayout(new BoxLayout(this.menuBar, 0));
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        if (!MacUIHelper.isMacOS()) {
            JMenuItem exitMenuItem = this.fileMenu.add(new JMenuItem("Exit"));
            exitMenuItem.setMnemonic('x');
            exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainUI.this.closeWindow();
                }
            });
        }
        this.createLaunchMenuItems();
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.settingsMenu = new JMenu("Settings");
        this.settingsMenu.setMnemonic('S');
        this.securityMenu = new JMenu("Security");
        this.securityMenu.setMnemonic('e');
        JMenu discoveryMenu = new JMenu("Discovery");
        discoveryMenu.setMnemonic('D');
        JMenuItem groups = new JMenuItem("Group Management...");
        groups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.showGroupManagementDialog();
            }
        });
        discoveryMenu.add(groups);
        JMenuItem locators = new JMenuItem("Locator Management...");
        locators.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(MainUI.this.dMgr instanceof DiscoveryLocatorManagement)) {
                    JOptionPane.showMessageDialog(MainUI.this.frame, "Locator Discovery", "<html>Discovery Management not an <br>instance of DiscoveryLocatorManagement", 0);
                    return;
                }
                JDialog dialog = LocatorDialog.getDialog(MainUI.this.frame, MainUI.this.dMgr);
                dialog.setVisible(true);
            }
        });
        discoveryMenu.add(locators);
        JMenuItem zonesMenuItem = new JMenuItem("Zones Management...");
        zonesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.showZonesManagementDialog();
            }
        });
        JMenuItem locateSpaceJMenuItem = new JMenuItem("Locate Space...");
        locateSpaceJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressBarDialog.getInstance(MainUI.this.frame).setVisible(true);
            }
        });
        JMenuItem resetMenuItem = new JMenuItem("Reset Layout");
        resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.resetWindows();
            }
        });
        this.refreshViewMenuItem = new JMenuItem("Refresh       F5");
        this.refreshViewMenuItem.addActionListener(new RefreshViewAction());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401 && e.getKeyCode() == 116 && MainUI.this.refreshViewMenuItem.isEnabled() && MainUI.this.isFocused()) {
                    MainUI.this.refreshView();
                }
                return false;
            }
        });
        String saveLocatorsProperty = Repository.getInstance().getProperties().getProperty(SAVE_LOCATORS);
        this.isSaveLocatorsToPropertiesFile = saveLocatorsProperty == null ? true : Boolean.parseBoolean(saveLocatorsProperty);
        this.saveLocatorsMenuItem = new JCheckBoxMenuItem("Save Locators Details", this.isSaveLocatorsToPropertiesFile);
        this.saveLocatorsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainUI.this.isSaveLocatorsToPropertiesFile = MainUI.this.saveLocatorsMenuItem.isSelected();
            }
        });
        this.settingsMenu.add(discoveryMenu);
        this.settingsMenu.add(zonesMenuItem);
        this.settingsMenu.add(locateSpaceJMenuItem);
        this.settingsMenu.add(resetMenuItem);
        this.settingsMenu.add(this.saveLocatorsMenuItem);
        this.displayPerstMatrixMenuItem = new JCheckBoxMenuItem("Display Persistent LRU Space Metrics", this.isRetrieveRuntimeForPersistentLRUSpace);
        this.displayPerstMatrixMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainUI.this.isRetrieveRuntimeForPersistentLRUSpace = MainUI.this.displayPerstMatrixMenuItem.isSelected();
            }
        });
        this.viewMenu.add(this.refreshViewMenuItem);
        this.viewMenu.add(this.displayPerstMatrixMenuItem);
        JMenuItem stats = new JMenuItem("Discovery Statistics...");
        stats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = ReggieStatPanel.getDialog(MainUI.this.frame, MainUI.this.startTime, MainUI.this.recordingListener);
                dialog.setVisible(true);
            }
        });
        discoveryMenu.add(stats);
        this.loginMenuItem = this.fileMenu.add(new JMenuItem("Login..."));
        this.customLoginMenuItem = this.fileMenu.add(new JMenuItem("Custom Login..."));
        this.logoutMenuItem = this.fileMenu.add(new JMenuItem("Logout"));
        this.loginMenuItem.setMnemonic('L');
        this.loginMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityUtils.login((Component)MainUI.this, true);
            }
        });
        this.customLoginMenuItem.setMnemonic('C');
        this.customLoginMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityUtils.customLogin((Component)MainUI.this, true);
            }
        });
        if (!SecurityServicesRepository.getInstance().isUserLoggedIn()) {
            this.logoutMenuItem.setEnabled(false);
            this.loginMenuItem.setEnabled(true);
            this.customLoginMenuItem.setEnabled(true);
        } else {
            this.setLoggedinUserName(SecurityServicesRepository.getInstance().getLoggedUserName());
            this.logoutMenuItem.setEnabled(true);
            this.loginMenuItem.setEnabled(false);
            this.customLoginMenuItem.setEnabled(false);
        }
        this.logoutMenuItem.setMnemonic('u');
        this.logoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnValue = JOptionPane.showConfirmDialog(MainUI.this, "Are you sure you want to logout?", "Logout", 0, 1);
                if (returnValue == 0) {
                    MainUI.this.logout();
                }
            }
        });
        JMenuItem manageSecurityMenuItem = new JMenuItem("Manage Security...");
        manageSecurityMenuItem.addActionListener(new ActionListener(){
            private ManageSecurityFrame _manageUsersDialog;
            private SecurityManagementLoginDialog _securityManagementLoginDialog;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this._manageUsersDialog == null) {
                    try {
                        MainUI.this.setCursor(Cursor.getPredefinedCursor(3));
                        ManageSecurityFrame manageSecurityFrame = null;
                        if (this._securityManagementLoginDialog == null) {
                            this._securityManagementLoginDialog = new SecurityManagementLoginDialog(MainUI.this);
                        } else {
                            manageSecurityFrame = this._securityManagementLoginDialog.getManageSecurityFrame();
                        }
                        if (manageSecurityFrame != null) {
                            manageSecurityFrame.setVisible(true);
                            manageSecurityFrame.toFront();
                            manageSecurityFrame.requestFocus();
                        } else {
                            this._securityManagementLoginDialog.setVisible(true);
                        }
                    }
                    finally {
                        MainUI.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        this.securityMenu.add(this.loginMenuItem);
        this.securityMenu.add(this.customLoginMenuItem);
        this.securityMenu.add(this.logoutMenuItem);
        this.securityMenu.addSeparator();
        this.securityMenu.add(manageSecurityMenuItem);
        if (!MacUIHelper.isMacOS()) {
            this.helpMenu = new JMenu("Help");
            this.helpMenu.setMnemonic('H');
            JMenuItem about = this.helpMenu.add(new JMenuItem("About..."));
            about.setMnemonic('A');
            about.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainUI.this.showAbout();
                }
            });
            JMenuItem onlineHelp = this.helpMenu.add(new JMenuItem("Documentation"));
            onlineHelp.setMnemonic('D');
            onlineHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainUI.this.showOnlineHelp();
                }
            });
        } else {
            MacUIHelper.setUIHandler(this);
        }
        if (this.fileMenu != null) {
            this.menuBar.add(this.fileMenu);
        }
        if (this.launchMenu != null) {
            this.menuBar.add(this.launchMenu);
        }
        if (this.viewMenu != null) {
            this.menuBar.add(this.viewMenu);
        }
        if (this.settingsMenu != null) {
            this.menuBar.add(this.settingsMenu);
        }
        if (this.securityMenu != null) {
            this.menuBar.add(this.securityMenu);
        }
        if (this.helpMenu != null) {
            this.menuBar.add(this.helpMenu);
        }
        return this.menuBar;
    }

    private void showZonesManagementDialog() {
        if (this._zonesSelectorDialog == null) {
            this._zonesSelectorDialog = new ZonesManagementDialog(this);
        }
        this._zonesSelectorDialog.setVisible(true);
    }

    public void setDisplayedZones(Set<String> displayZones) {
        Set<String> keySet = this._zonesMap.keySet();
        for (String existingZone : keySet) {
            this._zonesMap.put(existingZone, displayZones.contains(existingZone));
        }
    }

    public void setDisplayServicesWithNoZone(boolean isDisplayServicesWithNoZone) {
        this._isDisplayServicesWithNoZone = isDisplayServicesWithNoZone;
    }

    private boolean isDisplayZone(Set<String> zones) {
        if (zones == null || zones.size() == 0) {
            return this._isDisplayServicesWithNoZone;
        }
        for (String zone : zones) {
            if (!this.isDisplayZone(zone)) continue;
            return true;
        }
        return false;
    }

    public boolean isDisplayZone(String zone) {
        Boolean isSelected = this._zonesMap.get(zone);
        if (isSelected == null) {
            isSelected = new Boolean(true);
            this._zonesMap.put(zone, isSelected);
        }
        return isSelected;
    }

    public Set<String> getDisplayedZones() {
        HashSet<String> displayedZones = new HashSet<String>();
        Set<String> keySet = this._zonesMap.keySet();
        for (String zone : keySet) {
            if (!this._zonesMap.get(zone).booleanValue()) continue;
            displayedZones.add(zone);
        }
        return displayedZones;
    }

    private void showGroupManagementDialog() {
        EscapeDialog dialog = new EscapeDialog(this, "Discovery Group Selection", true);
        this._groupSelector = new GroupSelector(this, this.dMgr, this.lookupDiscovery, this.recordingListener, dialog);
        dialog.getContentPane().add(this._groupSelector);
        int width = 335;
        int height = 440;
        dialog.pack();
        dialog.setSize(width, height);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this._groupSelector = null;
    }

    public void logout() {
        SecurityUtils.logout();
        SpaceBrowser.getInstance().clearBenchmarks();
        this._uiComponent.clearBenchmarks();
        this.refresh();
    }

    private void createLaunchMenuItems() {
        this.launchMenu = new JMenu("Launch");
        this.launchMenu.setMnemonic('L');
        this._launchEDGDeploymentMenuItem = new JMenuItem("Enterprise Data Grid...");
        this._launchSBADeploymentMenuItem = new JMenuItem("SBA Application - Processing Unit...");
        this._launchEDGDeploymentMenuItem.setToolTipText("Deploy In-Memory-Data-Grid");
        this._launchSBADeploymentMenuItem.setToolTipText("Deploy Application");
        this.launchMenu.add(this._launchSBADeploymentMenuItem);
        this.launchMenu.add(this._launchEDGDeploymentMenuItem);
        this._launchEDGDeploymentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.selectDeploymentsTab();
                DeploymentActionsManager.getInstance(MainUI.this).performDeploy((short)2);
            }
        });
        this._launchSBADeploymentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainUI.this.selectDeploymentsTab();
                DeploymentActionsManager.getInstance(MainUI.this).performDeploy((short)1);
            }
        });
    }

    void showFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width - screenSize.width / 3;
        int height = screenSize.height - 40;
        int widthLoc = screenSize.width / 2 - width / 2;
        int heightLoc = 5;
        Properties props = Repository.getInstance().getProperties();
        String propWidth = props.getProperty(FRAME_PROP_WIDTH);
        String propHeight = props.getProperty(FRAME_PROP_HEIGHT);
        String propXpos = props.getProperty(FRAME_PROP_X_POS);
        String propYpos = props.getProperty(FRAME_PROP_Y_POS);
        boolean maximizeWindow = false;
        if (propWidth != null && propHeight != null && propXpos != null && propYpos != null && Integer.parseInt(propWidth) == screenSize.width && Integer.parseInt(propHeight) == screenSize.height && Integer.parseInt(propXpos) == 0 && Integer.parseInt(propYpos) == 0) {
            maximizeWindow = true;
        }
        if (propWidth != null) {
            width = Integer.parseInt(propWidth);
        }
        if (propHeight != null) {
            height = Integer.parseInt(propHeight);
        }
        if (propXpos != null) {
            widthLoc = Integer.parseInt(propXpos);
        }
        if (propYpos != null) {
            heightLoc = Integer.parseInt(propYpos);
        }
        String sVal = props.getProperty(FRAME_PROP_SPLIT_LOCATION);
        try {
            if (sVal != null) {
                this.mainSplitPaneDivLoc = Integer.parseInt(sVal);
            }
        }
        catch (NumberFormatException e) {
            this.mainSplitPaneDivLoc = 510;
        }
        this._uiComponent.setDividerLocation(this.mainSplitPaneDivLoc);
        this.pack();
        if (maximizeWindow || propWidth == null && propHeight == null && propXpos == null && propYpos == null) {
            this.setExtendedState(6);
        } else {
            this.setLocation(widthLoc, heightLoc);
            this.setSize(width, height);
        }
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainUI.this.closeWindow();
            }
        };
        this.addWindowListener(l);
        this.setVisible(true);
    }

    private void closeWindow() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.terminate();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public UI getUIComponent() {
        return this._uiComponent;
    }

    public void terminate() {
        block8: {
            Enumeration<FaultDetectionHandler> en = this.fdhTable.elements();
            while (en.hasMoreElements()) {
                FaultDetectionHandler fdh = en.nextElement();
                fdh.terminate();
            }
            for (int i = 0; i < this.serviceListeners.length; ++i) {
                ((IServiceGridUIComponent)((Object)this.serviceListeners[i])).closeServices();
            }
            Dimension d = this.getSize();
            Point p = this.getLocation();
            this.mainSplitPaneDivLoc = this._uiComponent.getDividerLocation();
            try {
                Properties props = Repository.getInstance().getProperties();
                props.put(BUILD_NUM, PlatformVersion.getInstance().getId());
                props.put(FRAME_PROP_WIDTH, Integer.toString(d.width));
                props.put(FRAME_PROP_HEIGHT, Integer.toString(d.height));
                props.put(FRAME_PROP_X_POS, Integer.toString(p.x));
                props.put(FRAME_PROP_Y_POS, Integer.toString(p.y));
                props.put(FRAME_PROP_SPLIT_LOCATION, Integer.toString(this.mainSplitPaneDivLoc));
                props.put(SAVE_LOCATORS, Boolean.toString(this.isSaveLocatorsToPropertiesFile));
                this.saveLocatorsToProperties(props);
                UIHelper.saveProperties(props);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        if (this.lookupDiscovery != null) {
            this.lookupDiscovery.terminate();
        }
        if (sdm != null) {
            sdm.terminate();
        }
        if (this.dMgr != null) {
            this.dMgr.terminate();
        }
        if (this.taskTimer != null) {
            this.taskTimer.cancel();
        }
        System.exit(0);
    }

    public static ServiceItem lookupServiceItem(ServiceID serviceID) {
        ServiceTemplate serviceTemplate = new ServiceTemplate(serviceID, null, null);
        ServiceItem serviceItem = sdm.lookup(serviceTemplate, null);
        return serviceItem;
    }

    public String getGscOwnerName(ServiceID puInstanceID) {
        return this.gscMonitorPanel.getGSCPanel().getGscOwnerName(puInstanceID);
    }

    public ServiceID getGscOwnerServiceID(ServiceID puInstanceID) {
        return this.gscMonitorPanel.getGSCPanel().getGscOwnerServiceD(puInstanceID);
    }

    public static IJSpace getSpace(ServiceID serviceID) {
        ServiceItem serviceItem;
        IJSpace space = SpaceBrowser.getInstance().getSpace(serviceID);
        if (space == null && (serviceItem = MainUI.lookupServiceItem(serviceID)) != null && serviceItem.service instanceof IJSpace) {
            space = (IJSpace)serviceItem.service;
        }
        return space;
    }

    private void saveLocatorsToProperties(Properties properties) {
        if (this.isSaveLocatorsToPropertiesFile) {
            StringBuilder locatorsStrBuilder = null;
            if (this.dMgr instanceof DiscoveryLocatorManagement) {
                LookupLocator[] lookupLocators = ((DiscoveryLocatorManagement)this.dMgr).getLocators();
                if (lookupLocators.length > 0) {
                    locatorsStrBuilder = new StringBuilder();
                }
                for (int index = 0; index < lookupLocators.length; ++index) {
                    locatorsStrBuilder.append(lookupLocators[index].getHost() + ":" + lookupLocators[index].getPort());
                    if (index + 1 >= lookupLocators.length) continue;
                    locatorsStrBuilder.append(LOCATORS_DELIMETER);
                }
            }
            if (locatorsStrBuilder != null) {
                properties.setProperty(LOCATORS, locatorsStrBuilder.toString());
            } else {
                properties.remove(LOCATORS);
            }
        } else {
            properties.remove(LOCATORS);
        }
    }

    private LookupLocator[] mergeLocators(Properties properties, LookupLocator[] locatorsSysProps) {
        String locators = properties.getProperty(LOCATORS);
        HashSet<Object> locatorsSet = new HashSet<Object>();
        if (locators != null) {
            StringTokenizer strTokenizer = new StringTokenizer(locators, LOCATORS_DELIMETER, false);
            while (strTokenizer.hasMoreTokens()) {
                String locator = strTokenizer.nextToken();
                locatorsSet.add(JSpaceUtilities.createLookupLocator((String)locator));
            }
        }
        for (LookupLocator lookupLocatorSysProp : locatorsSysProps) {
            locatorsSet.add(lookupLocatorSysProp);
        }
        LookupLocator[] lookupLocatorsArray = new LookupLocator[locatorsSet.size()];
        locatorsSet.toArray(lookupLocatorsArray);
        String locatorsStr = BootUtil.toLookupLocatorURLs((LookupLocator[])lookupLocatorsArray, (boolean)true);
        SystemInfo.singleton().lookup().setLocators(locatorsStr);
        return lookupLocatorsArray;
    }

    void showAbout() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutBox(this);
        }
        this.aboutDialog.setVisible(true);
    }

    void startDiscovery(Configuration config) throws Exception {
        this._jiniGroups = SystemInfo.singleton().lookup().groupsArray();
        this._jiniGroups = this.resolveAllJiniGroup();
        String useDefinedOnlyJiniGroup = System.getProperty("com.gs.jini.useDefinedGroupOnly", String.valueOf(false));
        this._searchedJiniGroups = LookupGroups.all();
        if (Boolean.valueOf(useDefinedOnlyJiniGroup).booleanValue()) {
            this._searchedJiniGroups = this._jiniGroups;
        }
        this._jiniGroups = this.resolveAllJiniGroup();
        LookupLocator[] locators = SystemInfo.singleton().lookup().locatorsArray();
        this._lookupLocators = this.mergeLocators(Repository.getInstance().getProperties(), locators);
        this._template = new ServiceTemplate(null, null, null);
        this.initLookupCacheAndDisvcoveryManger();
    }

    private void initLookupCacheAndDisvcoveryManger() throws Exception {
        if (this.lookupDiscovery != null) {
            this.lookupDiscovery.terminate();
        }
        this.lookupDiscovery = new LookupDiscovery(this._searchedJiniGroups, _config);
        if (this.recordingListener == null) {
            this.recordingListener = new RecordingDiscoveryListener();
        }
        this.lookupDiscovery.addDiscoveryListener((DiscoveryListener)this.recordingListener);
        if (this.dMgr != null) {
            this.dMgr.terminate();
        }
        this.dMgr = new LookupDiscoveryManager(this._jiniGroups, this._lookupLocators, null, _config);
        if (sdm != null) {
            sdm.terminate();
        }
        sdm = new ServiceDiscoveryManager(this.dMgr, new LeaseRenewalManager(), _config);
        if (this.lCache != null) {
            this.lCache.terminate();
        }
        this.lCache = sdm.createLookupCache(this._template, null, (ServiceDiscoveryListener)this);
        if (this.gwdListener == null) {
            this.gwdListener = new GWDiscoveryListener();
        }
        this.dMgr.addDiscoveryListener((DiscoveryListener)this.gwdListener);
    }

    public String[] resolveAllJiniGroup() {
        if (this._jiniGroups != null) {
            for (int i = 0; i < this._jiniGroups.length; ++i) {
                if (this._jiniGroups[i] == null || !this._jiniGroups[i].trim().equalsIgnoreCase("all")) continue;
                this._jiniGroups = LookupGroups.all();
                break;
            }
        }
        return this._jiniGroups;
    }

    public void setJiniGroups(String[] jiniGroups) {
        this._jiniGroups = jiniGroups;
    }

    public void startDiscovery() {
        block3: {
            try {
                this.initLookupCacheAndDisvcoveryManger();
                this.lookupDiscovery.setGroups(this._searchedJiniGroups);
                ((DiscoveryGroupManagement)this.dMgr).setGroups(this._jiniGroups);
                if (this.dMgr instanceof DiscoveryLocatorManagement && this._lookupLocators != null) {
                    ((DiscoveryLocatorManagement)this.dMgr).setLocators(this._lookupLocators);
                }
            }
            catch (Exception ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
    }

    public void stopDiscovery() {
        block3: {
            try {
                this.setJiniGroups(((DiscoveryGroupManagement)this.dMgr).getGroups());
                this.lookupDiscovery.setGroups(LookupGroups.none());
                ((DiscoveryGroupManagement)this.dMgr).setGroups(LookupGroups.none());
                if (this.dMgr instanceof DiscoveryLocatorManagement) {
                    this._lookupLocators = ((DiscoveryLocatorManagement)this.dMgr).getLocators();
                    ((DiscoveryLocatorManagement)this.dMgr).setLocators(new LookupLocator[0]);
                }
                this.lCache = null;
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
    }

    public void serviceAdded(ServiceDiscoveryEvent sdEvent) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" --- BEGIN- serviceAdded for " + sdEvent.getPostEventServiceItem() + "  Thread id=" + Thread.currentThread().getId());
        }
        this.serviceAdded(sdEvent.getPostEventServiceItem());
    }

    public void serviceAdded(final ServiceItem item) {
        Runnable serviceAdditionProcess = new Runnable(){

            @Override
            public void run() {
                long startTimeLocal;
                block29: {
                    startTimeLocal = System.currentTimeMillis();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("---SERVICE ADDED:" + item + "  \nLocal Thread id=" + Thread.currentThread().getId());
                    }
                    if (item.service instanceof IJSpace) {
                        final ServiceID spaceID = item.serviceID;
                        final IJSpace spaceProxy = (IJSpace)item.service;
                        short spaceMode = SpaceBrowser.getInstance().getSpaceMode(spaceID);
                        if (spaceMode == 4) {
                            short newSpaceMode;
                            SpaceMode curSpaceModeVal = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceID);
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Space " + spaceProxy + " was removed from LUS and now added, updating..., curSpaceModeVal=" + curSpaceModeVal);
                            }
                            if (curSpaceModeVal == null) {
                                try {
                                    IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
                                    ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
                                    if (containerConfig.isJiniLusEnabled() && Repository.addSpaceConfigToMap(Repository.addSpaceAdminObjectToMap(spaceProxy)).isClustered()) {
                                        PrimaryBackupIndicationListener.getInstance().addSpace(spaceProxy, spaceID);
                                        curSpaceModeVal = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceID);
                                    }
                                }
                                catch (Exception e) {
                                    if (LOGGER.isLoggable(Level.WARNING)) {
                                        LOGGER.log(Level.WARNING, e.toString(), e);
                                    }
                                    UIHelper.showError((Throwable)e, "Getting Space Configuration");
                                }
                            }
                            final short fNewSpaceMode = newSpaceMode = JSpaceUIUtils.getSpaceModeValue(curSpaceModeVal);
                            TimerTask setSpaceModeTimerTask = new TimerTask(){

                                @Override
                                public void run() {
                                    if (LOGGER.isLoggable(Level.WARNING)) {
                                        LOGGER.warning("The existing < " + spaceProxy + " > space was registered again to LUS and will have indication of available space.");
                                    }
                                    SpaceBrowser.getInstance().setSpaceMode(spaceID, fNewSpaceMode);
                                }
                            };
                            MainUI.this.spaceModeTimer.schedule(setSpaceModeTimerTask, 5000L);
                        }
                    }
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("---SERVICE ADDED before add to Registry:" + item.serviceID + "  \nLocal Thread id=" + Thread.currentThread().getId());
                    }
                    Repository.getInstance().addService(item);
                    Set<String> zones = Repository.getInstance().getServiceZones(item.serviceID);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("---SERVICE ADDED before zones:" + item.serviceID + "  \nLocal Thread id=" + Thread.currentThread().getId());
                    }
                    if (!MainUI.this.isDisplayZone(zones)) {
                        return;
                    }
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("---SERVICE ADDED after zones:" + item.serviceID + "  \nLocal Thread id=" + Thread.currentThread().getId() + ", do displayed services contain that:" + MainUI.this._displayedServices.contains(item.serviceID));
                    }
                    if (MainUI.this._displayedServices.contains(item.serviceID)) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("---SERVICE ADDED after zones:" + item.serviceID + ", return! ");
                        }
                        return;
                    }
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("---SERVICE ADDED before calling to serviceNotifyhelper():" + item.serviceID + "  \nLocal Thread id=" + Thread.currentThread().getId());
                    }
                    MainUI.this.serviceNotifyHelper("serviceAdded", item);
                    SecurityServicesRepository.getInstance().handleAddedSecuredService(item);
                    if (item.service instanceof ServiceRegistrar && MainUI.this._groupSelector != null) {
                        ServiceRegistrar serviceRegistrar = (ServiceRegistrar)item.service;
                        try {
                            MainUI.this._groupSelector.addLookupGroups(serviceRegistrar.getGroups());
                        }
                        catch (RemoteException re) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block29;
                            LOGGER.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                }
                if (item.service instanceof GSA || item.service instanceof GSM || item.service instanceof GSC || item.service instanceof ESM || item.service instanceof ServiceRegistrar) {
                    MainUI.this.gscMonitorPanel.addService(item);
                }
                if (item.service instanceof Cybernode || item.service instanceof GSM || item.service instanceof GSA || item.service instanceof ESM) {
                    try {
                        ServiceBeanAdmin serviceBeanAdmin = (ServiceBeanAdmin)((Administrable)item.service).getAdmin();
                        FaultDetectionHandler fdh = FaultDetectionHandlerFactory.getFaultDetectionHandler((ServiceElement)serviceBeanAdmin.getServiceElement(), null);
                        fdh.register((FaultDetectionListener)MainUI.this);
                        MainUI.this.fdhTable.put(item, fdh);
                        fdh.monitor(item.service, (Object)item.serviceID, MainUI.this.lCache);
                    }
                    catch (ConnectException ce) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, ce.toString(), ce);
                        }
                    }
                    catch (Exception e) {
                        UIHelper.showError((Throwable)e, "Getting FaultDetectionHandler for GSC");
                    }
                } else if (!(item.service instanceof IJSpace || item.service instanceof IJSpaceContainer || item.service instanceof ServiceRegistrar)) {
                    MainUI.this.gscMonitorPanel.update((ServiceID)null);
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("---BEFORE ADD to displayedServices:" + item.serviceID);
                }
                MainUI.this._displayedServices.add(item.serviceID);
                long endTime = System.currentTimeMillis();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(" --- Processing of adding service " + item.service + " took " + (endTime - startTimeLocal) + " msec.");
                }
            }
        };
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("--- BEFORE SUBMIT TO THREAD POOL, SERVICE ADDED, service id=" + item.serviceID);
        }
        orderedThreadPool.submit(item.serviceID, serviceAdditionProcess);
    }

    public synchronized void serviceFailure(Object proxy, ServiceID serviceID) {
        this.serviceFailure(proxy, serviceID, true);
    }

    public synchronized void serviceFailure(Object proxy, ServiceID serviceID, boolean fromFDH) {
        Set<ServiceItem> keys = this.fdhTable.keySet();
        ServiceItem remove = null;
        for (ServiceItem item : keys) {
            if (!item.serviceID.equals((Object)serviceID)) continue;
            remove = item;
            break;
        }
        if (remove != null) {
            this.fdhTable.remove(remove);
            if (fromFDH) {
                final ServiceItem finalRemove = remove;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("--- serviceFailure, BEFORE SUBMIT TO THREAD POOL,  service id=" + serviceID + " , proxy=" + proxy);
                }
                orderedThreadPool.submit(finalRemove.serviceID, new Runnable(){

                    @Override
                    public void run() {
                        MainUI.this.gscMonitorPanel.remove(finalRemove);
                        MainUI.this.serviceNotifyHelper("serviceRemoved", finalRemove);
                        Repository.getInstance().removeService(finalRemove);
                    }
                });
            }
        }
    }

    public void serviceRemoved(ServiceDiscoveryEvent sdEvent) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" --- BEGIN- service Removed for " + sdEvent.getPreEventServiceItem() + "  Thread id=" + Thread.currentThread().getId());
        }
        this.serviceRemoved(sdEvent.getPreEventServiceItem(), true, false);
    }

    public void serviceRemoved(final ServiceItem item, final boolean isRemoveFromRepository, final boolean isAllowToRemoveSpaceLocal) {
        Runnable removingProcess = new Runnable(){

            @Override
            public void run() {
                long startTimeLocal = System.currentTimeMillis();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("---SERVICE REMOVED:" + item + "  \nLocal Thread id=" + Thread.currentThread().getId());
                    LOGGER.fine("---_isAllowSpaceRemoving:" + MainUI.this._isAllowSpaceRemoving);
                }
                Object service = item.service;
                if (!MainUI.this._isAllowSpaceRemoving && !isAllowToRemoveSpaceLocal && service instanceof IJSpace) {
                    IJSpace space;
                    boolean isPingFailed;
                    block11: {
                        isPingFailed = false;
                        space = (IJSpace)service;
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("LUS attempts to unregister the < " + item + " > Space service. \n\n Checking space availability using space.ping() before removing from GUI.");
                        }
                        try {
                            space.ping();
                        }
                        catch (Exception e) {
                            isPingFailed = true;
                            if (!LOGGER.isLoggable(Level.FINE)) break block11;
                            LOGGER.log(Level.FINE, "< " + item + " > space service was unregistered from LUS and will be removed since it is also not available via space ping().", e);
                        }
                    }
                    if (!isPingFailed) {
                        SpaceBrowser.getInstance().setSpaceMode(item.serviceID, (short)4);
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("< " + space + " > space was unregistered from LUS but still will not be removed since it is available via space ping().");
                        }
                        return;
                    }
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("< " + space + " > space was unregistered from LUS and will be removed since it is NOT available via space ping(),   service item=" + item);
                    }
                }
                MainUI.this._displayedServices.remove(item.serviceID);
                if (!(item.service instanceof IJSpace) && !(item.service instanceof IJSpaceContainer)) {
                    MainUI.this.gscMonitorPanel.remove(item);
                }
                MainUI.this.serviceNotifyHelper("serviceRemoved", item);
                MainUI.this.serviceFailure(item.service, item.serviceID, false);
                if (isRemoveFromRepository) {
                    Repository.getInstance().removeService(item);
                }
                long endTime = System.currentTimeMillis();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(" --- Processing of removing service " + item.service + " took " + (endTime - startTimeLocal) + " msec.");
                }
            }
        };
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("--- BEFORE SUBMIT TO THREAD POOL, SERVICE REMOVED, service id=" + item.serviceID);
        }
        orderedThreadPool.submit(item.serviceID, removingProcess);
    }

    public void serviceChanged(final ServiceDiscoveryEvent sdEvent) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "-- BEGIN serviceChanged()" + sdEvent.getPostEventServiceItem());
        }
        Runnable serviceChangingProcess = new Runnable(){

            @Override
            public void run() {
                ServiceItem item = sdEvent.getPostEventServiceItem();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("---SERVICE CHANGED:" + item);
                }
                if (item.service instanceof Cybernode) {
                    MainUI.this.gscMonitorPanel.change(item);
                }
                MainUI.this.serviceNotifyHelper("serviceChanged", item);
            }
        };
        orderedThreadPool.submit(sdEvent.getPostEventServiceItem().serviceID, serviceChangingProcess);
    }

    void serviceNotifyHelper(String methodName, ServiceItem item) {
        for (int i = 0; i < this.serviceListeners.length; ++i) {
            try {
                Method method = this.serviceListeners[i].getClass().getMethod(methodName, ServiceItem.class);
                method.invoke((Object)this.serviceListeners[i], item);
                continue;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    private static void setSystemProperties(Configuration config) throws ConfigurationException {
        Properties sysProps = System.getProperties();
        String[] systemProperties = (String[])config.getEntry("com.gigaspaces.start", "systemProperties", String[].class, (Object)new String[0]);
        if (systemProperties.length > 0) {
            if (systemProperties.length % 2 != 0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "systemProperties elements has odd length : " + systemProperties.length);
                }
            } else {
                StringBuilder buff = new StringBuilder();
                for (int i = 0; i < systemProperties.length; i += 2) {
                    String name = systemProperties[i];
                    String value = systemProperties[i + 1];
                    sysProps.setProperty(name, value);
                    configuredSysProps.setProperty(name, value);
                    buff.append("\n");
                    buff.append("    " + name + "=" + value);
                }
                if (MacUIHelper.isMacOS()) {
                    Properties macProps = MacUIHelper.getSystemProperties("GigaSpaces Management Center");
                    Enumeration<Object> en = macProps.keys();
                    while (en.hasMoreElements()) {
                        String name = (String)en.nextElement();
                        String value = macProps.getProperty(name);
                        sysProps.setProperty(name, value);
                        buff.append("\n");
                        buff.append("    " + name + "=" + value);
                    }
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Added System Properties {" + buff.toString() + "\n}");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSpaceNode(String hostName, String containerName, String spaceName) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.topTabWindow.setSelectedTab(2);
            SpaceBrowser.getInstance().selectSpaceNode(hostName, containerName, spaceName);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void selectSpaceNode(ServiceID spaceID) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.topTabWindow.setSelectedTab(2);
            SpaceBrowser.getInstance().selectSpaceOperationNode(spaceID, null);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static void prepareRmiGC() {
        block4: {
            try {
                if (System.getProperty("sun.rmi.dgc.client.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.client.gcInterval", "36000000");
                }
                if (System.getProperty("sun.rmi.dgc.server.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.server.gcInterval", "36000000");
                }
            }
            catch (Exception secExc) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, "Failed to set sun.rmi.dgc.xxx system properties. \n", secExc);
            }
        }
    }

    public static void main(String[] args) {
        LicenseManager.getInstance().validate("GigaSpaces Management Center", LicenseType.PREMIUM);
        ArrayList<String> curArgs = new ArrayList<String>(Arrays.asList(args));
        curArgs.add("services.config");
        args = curArgs.toArray(new String[curArgs.size()]);
        try {
            GSLogConfigLoader.getLoader((String)"ui");
            LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
            args = MainUI.handleSecurityParamaters(args);
            MainUI.setLookAndFeel();
            MainUI.setGnomAppName();
            logoImage = UIHelper.getImageIcon("image/browser/jspacesIcon.png").getImage();
            hiddenFrame = new JFrame();
            hiddenFrame.setIconImage(logoImage);
            logoWindow = new LogoWindow(hiddenFrame);
            final LogoWindow.LoadingProgressBar progressBar = logoWindow.getProgressBar();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension logoSize = logoWindow.getPreferredSize();
            logoWindow.setLocation(screenSize.width / 2 - logoSize.width / 2, screenSize.height / 2 - logoSize.height / 2);
            logoWindow.setVisible(true);
            LOGGER.info("\n==================================================\nGigaSpaces Management Center\nLog created by <" + System.getProperty("user.name") + "> on " + new Date().toString() + "\n==================================================");
            MainUI.prepareRmiGC();
            System.setProperty("com.gs.transport_protocol.lrmi.request_timeout", "5s");
            ToolTipManager.sharedInstance().setDismissDelay(7000);
            SystemConfig sysConfig = SystemConfig.getInstance((String[])args);
            _config = sysConfig.getConfiguration();
            MainUI.setSystemProperties(_config);
            final PrivilegedExceptionAction createViewer = new PrivilegedExceptionAction(){

                public Object run() {
                    return new MainUI(_config, progressBar);
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            LoginContext loginContext = (LoginContext)Config.getNonNullEntry((Configuration)_config, (String)"com.gigaspaces.admin.ui", (String)"loginContext", LoginContext.class);
                            loginContext.login();
                            mainUI = (MainUI)Subject.doAsPrivileged(loginContext.getSubject(), createViewer, null);
                        }
                        catch (NoSuchEntryException e) {
                            mainUI = (MainUI)createViewer.run();
                        }
                        mainUI.startDiscovery(_config);
                        logoWindow.setVisible(false);
                        mainUI.showFrame();
                        hiddenFrame.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        UIHelper.showError(e);
                        System.exit(1);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            UIHelper.showError(e);
            System.exit(1);
        }
    }

    private static void setGnomAppName() {
        block4: {
            String osName = System.getProperty("os.name");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("os name:" + osName);
            }
            if (osName.toLowerCase().equals("linux")) {
                try {
                    Toolkit xToolkit = Toolkit.getDefaultToolkit();
                    Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                    awtAppClassNameField.setAccessible(true);
                    awtAppClassNameField.set(xToolkit, "GigaSpaces Management Center");
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    private static String[] handleSecurityParamaters(String[] args) {
        ArrayList clonedArgsList;
        block24: {
            ArrayList<String> argsList = new ArrayList<String>(args.length);
            for (String arg : args) {
                argsList.add(arg);
            }
            String userName = null;
            String password = null;
            String userDetailsProviderClass = null;
            String userProperties = null;
            int argsListSize = argsList.size();
            clonedArgsList = new ArrayList(argsList);
            for (int index = 0; index < argsListSize; ++index) {
                String foundParamName = null;
                String foundParamValue = null;
                if (((String)argsList.get(index)).equals("-user")) {
                    foundParamName = "-user";
                    if (index < argsList.size() - 1) {
                        foundParamValue = userName = (String)argsList.get(index + 1);
                    }
                } else if (((String)argsList.get(index)).equals("-password")) {
                    foundParamName = "-password";
                    if (index < argsList.size() - 1) {
                        foundParamValue = password = (String)argsList.get(index + 1);
                    }
                } else if (((String)argsList.get(index)).equals("-user-details-provider")) {
                    foundParamName = "-user-details-provider";
                    if (index < argsList.size() - 1) {
                        foundParamValue = userDetailsProviderClass = (String)argsList.get(index + 1);
                    }
                } else if (((String)argsList.get(index)).equals("-user-details-properties")) {
                    foundParamName = "-user-details-properties";
                    if (index < argsList.size() - 1) {
                        foundParamValue = userProperties = (String)argsList.get(index + 1);
                    }
                }
                if (foundParamName != null) {
                    clonedArgsList.remove(foundParamName);
                }
                if (foundParamValue == null) continue;
                clonedArgsList.remove(foundParamValue);
            }
            if (!(userName == null && password == null || userDetailsProviderClass == null && userProperties == null)) {
                System.out.println("\nThe following parameters cannot be handled together: [user], [password], [user-details-provider], [user-details-properties]. Please pass only either [user] and [password] or only [user-details-provider] and optional [user-details-properties]");
                System.exit(0);
            }
            if (userName != null && password == null) {
                System.out.println("\nPlease provide password [password]");
                System.exit(0);
            }
            if (userName == null && password != null) {
                System.out.println("\nPlease provide user name [user]");
                System.exit(0);
            }
            if (userDetailsProviderClass == null && userProperties != null) {
                System.out.println("\nPlease provide user details provider class [user-details-provider]");
                System.exit(0);
            }
            _userLoginProperties = userProperties == null ? new Properties() : JSpaceUtilities.parsePropertiesParam(userProperties);
            _userDetailsProviderClass = userDetailsProviderClass;
            try {
                CredentialsProvider credentialsProvider = null;
                if (userName != null && password != null) {
                    credentialsProvider = new DefaultCredentialsProvider(userName, password);
                } else if (userDetailsProviderClass != null) {
                    credentialsProvider = CredentialsProviderHelper.fromClassName(userDetailsProviderClass, (Properties)_userLoginProperties);
                }
                if (credentialsProvider != null) {
                    SecurityServicesRepository.getInstance().login(credentialsProvider);
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block24;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        String[] newArgsArray = new String[clonedArgsList.size()];
        return clonedArgsList.toArray(newArgsArray);
    }

    public static String getUsername() {
        return _userDetailsProviderClass;
    }

    public static String getPassword() {
        return _userDetailsProviderClass;
    }

    public static String getUserDetailsProviderClass() {
        return _userDetailsProviderClass;
    }

    public static Properties getUserLoginProperties() {
        return _userLoginProperties;
    }

    public static void setLookAndFeel() throws UnsupportedLookAndFeelException {
        String lookAndFeelClassName = System.getProperty("com.gs.ui.laf.classname");
        if (lookAndFeelClassName != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeelClassName);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                LOGGER.log(Level.INFO, "Because an error with setting \"" + lookAndFeelClassName + "\" Look&Feel the \"" + Plastic3DLookAndFeel.class.getName() + "\" Look&Feel class will be used.");
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
        } else {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        UIManager.put("Table.selectionBackground", JSpaceUIUtils.SELECTION_BACKGROUND_COLOR);
        UIManager.put("List.selectionBackground", JSpaceUIUtils.SELECTION_BACKGROUND_COLOR);
        UIManager.put("SplitPane.dividerSize", new Integer(3));
        UIManager.put("Table.font", UIHelper.createTableFont(12));
        UIManager.put("TextField.font", UIHelper.createTextEditor(12));
        UIManager.put("TextArea.font", UIHelper.createTextEditor(12));
        MainUI.changeTaskPaneDefaults();
    }

    private static void changeTaskPaneDefaults() {
        UIManager.put("TaskPaneContainer.background", SystemColor.control);
        UIManager.put("TaskPane.background", Colors.LightGray.color(0.5f));
        UIManager.put("TaskPane.titleBackgroundGradientStart", new Color(164, 192, 221));
    }

    public void setAllowSpaceRemoving(boolean allowSpaceRemoving) {
        this._isAllowSpaceRemoving = allowSpaceRemoving;
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainUI.this.refreshView();
            }
        });
    }

    public DiscoveryManagement getDiscoveryManager() {
        return this.dMgr;
    }

    public RecordingDiscoveryListener getRecordingDiscoveryListener() {
        return this.recordingListener;
    }

    public LookupDiscovery getLookupDiscovery() {
        return this.lookupDiscovery;
    }

    public void loginPerformed(String userName) {
        this.logoutMenuItem.setEnabled(true);
        this.loginMenuItem.setEnabled(false);
        this.customLoginMenuItem.setEnabled(false);
        this.setLoggedinUserName(userName);
    }

    public void logoutPerformed() {
        this.logoutMenuItem.setEnabled(false);
        this.loginMenuItem.setEnabled(true);
        this.customLoginMenuItem.setEnabled(true);
        this.clearLoggedinUserName();
    }

    public SingleThreadExecutor<MutableTreeNode> getTreeSelectionsExecutor() {
        return this.singleThreadExecutor;
    }

    static {
        DEFAULT_LOOKUP_CHECK_DELAY = 5000L;
        MIN_LOOKUP_CHECK_DELAY = 1000L;
        configuredSysProps = new Properties();
        int defaultMaxThreadPoolSize = Math.max(32, Runtime.getRuntime().availableProcessors());
        int maxThreadPoolSize = Integer.parseInt(System.getProperty("com.gs.ui.orderedthreadpool.size", String.valueOf(defaultMaxThreadPoolSize)));
        orderedThreadPool = new OrderedThreadPool(maxThreadPoolSize);
    }

    private class LinkLabel
    extends JLabel {
        private final String _url;
        private final String _msg;

        public LinkLabel(String msg, String url) {
            super("<HTML><A href=\"\">" + msg + "</A></HTML>");
            this._url = url;
            this._msg = msg;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JSpaceUIUtils.showInBrowser(MainUI.this, LinkLabel.this._url, LOGGER);
                }
            });
        }

        public String getMessage() {
            return this._msg;
        }
    }

    public class LicenseIndicationBox
    extends Box {
        private Box _labelsBox;
        private static final String START_HYPERLINK_TAG = "<a";
        private static final String END_HYPERLINK_TAG = "</a>";
        private static final String HREF_ATTRIBUTE = "href=";
        private static final String CLOSE_TAG = ">";
        private static final String BLANK = " ";
        private Dimension _labelSize;

        public LicenseIndicationBox(String licenseMessage) {
            super(0);
            this.setBorder(null);
            if (licenseMessage != null) {
                this._labelsBox = new Box(0);
                int hyperlinkStartIndex = licenseMessage.toLowerCase().indexOf(START_HYPERLINK_TAG);
                if (hyperlinkStartIndex >= 0) {
                    int hyperlinkEndIndex = licenseMessage.toLowerCase().indexOf(END_HYPERLINK_TAG);
                    if (hyperlinkEndIndex >= 0) {
                        String messageBeforeHyperLink = licenseMessage.substring(0, hyperlinkStartIndex);
                        JLabel label1 = new JLabel(messageBeforeHyperLink);
                        this.defineLabelSize(label1);
                        this._labelsBox.add(label1);
                        String messageAfterHyperLink = licenseMessage.substring(hyperlinkEndIndex + END_HYPERLINK_TAG.length());
                        int hrefStartIndex = licenseMessage.toLowerCase().indexOf(HREF_ATTRIBUTE);
                        if (hrefStartIndex > 0) {
                            int closeTagIndex = licenseMessage.toLowerCase().indexOf(CLOSE_TAG, hrefStartIndex);
                            int blankTagIndex = licenseMessage.toLowerCase().indexOf(BLANK, hrefStartIndex);
                            int endUrlIndex = Math.min(closeTagIndex, blankTagIndex);
                            String url = licenseMessage.substring(hrefStartIndex + HREF_ATTRIBUTE.length(), endUrlIndex);
                            String msg = licenseMessage.substring(closeTagIndex + CLOSE_TAG.length(), hyperlinkEndIndex);
                            LinkLabel linkLabel = new LinkLabel(msg, url);
                            this.defineLabelSize(linkLabel);
                            this._labelsBox.add(linkLabel);
                        }
                        JLabel label2 = new JLabel(messageAfterHyperLink);
                        this.defineLabelSize(label2);
                        this._labelsBox.add(label2);
                    }
                } else {
                    JLabel label = new JLabel(licenseMessage);
                    this.defineLabelSize(label);
                    this._labelsBox.add(label);
                }
                this._labelsBox.setAlignmentX(0.0f);
                this.add(Box.createHorizontalGlue());
                this.add(this._labelsBox);
            }
        }

        private void defineLabelSize(JLabel label) {
            FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
            int width = fontMetrics.stringWidth(label instanceof LinkLabel ? ((LinkLabel)label).getMessage() : label.getText());
            int height = fontMetrics.getHeight();
            this._labelSize = new Dimension(width, height);
            label.setPreferredSize(this._labelSize);
            label.setMaximumSize(this._labelSize);
            label.setAlignmentX(0.0f);
        }

        public Dimension getLabelSize() {
            return this._labelSize;
        }
    }

    class RefreshViewAction
    implements ActionListener {
        RefreshViewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainUI.this.refresh();
        }
    }

    class DockingWindowListenerImpl
    implements DockingWindowListener {
        private IServiceGridUIComponent currentSelUIComponent;
        private JMenu[] curAddedMenus;
        private JButton[] curAddedButtons;

        DockingWindowListenerImpl() {
        }

        public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
        }

        public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
        }

        public void windowClosed(DockingWindow window) {
        }

        public void windowClosing(DockingWindow window) throws OperationAbortedException {
        }

        public void windowDocked(DockingWindow window) {
        }

        public void windowDocking(DockingWindow window) throws OperationAbortedException {
        }

        public void windowHidden(DockingWindow window) {
        }

        public void windowMaximized(DockingWindow window) {
        }

        public void windowMaximizing(DockingWindow window) throws OperationAbortedException {
        }

        public void windowMinimized(DockingWindow window) {
        }

        public void windowMinimizing(DockingWindow window) throws OperationAbortedException {
        }

        public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
            if (removedFromWindow instanceof TabWindow) {
                TabWindow tabWindow = (TabWindow)removedFromWindow;
                DockingWindow docWindow = tabWindow.getSelectedWindow();
                if (docWindow instanceof View) {
                    View selView = (View)docWindow;
                    Component selComponent = selView.getComponent();
                    if (selComponent instanceof IServiceGridUIComponent) {
                        IServiceGridUIComponent gridUIComponent = (IServiceGridUIComponent)((Object)selComponent);
                        this.initFrame(gridUIComponent);
                    }
                } else if (docWindow == null) {
                    this.cleanFrame();
                }
            }
        }

        public void windowRestored(DockingWindow window) {
        }

        public void windowRestoring(DockingWindow window) throws OperationAbortedException {
        }

        public void windowShown(DockingWindow window) {
            SplitWindow splitWindow;
            DockingWindow topWindow;
            IServiceGridUIComponent gridUIComponent = null;
            Component selComponent = window.getComponent(0);
            if (selComponent instanceof SimplePanel) {
                gridUIComponent = this.retrieveSGUIComponentFromDockingWindow(window);
                if (gridUIComponent != null) {
                    this.initFrame(gridUIComponent);
                }
            } else if (window instanceof TabWindow) {
                TabWindow shownTab = (TabWindow)window;
                this.initFrame(shownTab);
            } else if (window instanceof SplitWindow && (topWindow = (splitWindow = (SplitWindow)window).getLeftWindow()) instanceof TabWindow) {
                TabWindow shownTab = (TabWindow)topWindow;
                this.initFrame(shownTab);
            }
        }

        public void windowUndocked(DockingWindow window) {
        }

        public void windowUndocking(DockingWindow window) throws OperationAbortedException {
        }

        public IServiceGridUIComponent retrieveSGUIComponentFromDockingWindow(DockingWindow window) {
            IServiceGridUIComponent resultComponent = null;
            Component selComponent = window.getComponent(0);
            if (selComponent instanceof SimplePanel && (selComponent = ((SimplePanel)selComponent).getComponent(0)) instanceof IServiceGridUIComponent) {
                resultComponent = (IServiceGridUIComponent)((Object)selComponent);
            }
            return resultComponent;
        }

        private void initFrame(TabWindow shownTab) {
            IServiceGridUIComponent gridUIComponent;
            DockingWindow dockingWindow = shownTab.getSelectedWindow();
            if (dockingWindow != null && (gridUIComponent = this.retrieveSGUIComponentFromDockingWindow(dockingWindow)) != null) {
                this.initFrame(gridUIComponent);
            }
        }

        private void initFrame(IServiceGridUIComponent serviceGridUIComponent) {
            if (this.currentSelUIComponent == null || !this.currentSelUIComponent.equals(serviceGridUIComponent)) {
                JMenu[] menus = serviceGridUIComponent.getMenus();
                JButton[] buttons = serviceGridUIComponent.getToolBarButtons();
                this.removeLastAddedMenus();
                this.removeLastAddedButtons();
                this.curAddedMenus = menus;
                this.curAddedButtons = buttons;
                if (menus != null) {
                    if (MainUI.this.helpMenu != null) {
                        MainUI.this.menuBar.remove(MainUI.this.helpMenu);
                    }
                    if (MainUI.this.securityMenu != null) {
                        MainUI.this.menuBar.remove(MainUI.this.securityMenu);
                    }
                    if (MainUI.this.settingsMenu != null) {
                        MainUI.this.menuBar.remove(MainUI.this.settingsMenu);
                    }
                    if (MainUI.this.viewMenu != null) {
                        MainUI.this.menuBar.remove(MainUI.this.viewMenu);
                    }
                    for (JMenu jMenu : menus) {
                        MainUI.this.menuBar.add(jMenu);
                    }
                    if (MainUI.this.viewMenu != null) {
                        MainUI.this.menuBar.add(MainUI.this.viewMenu);
                    }
                    if (MainUI.this.settingsMenu != null) {
                        MainUI.this.menuBar.add(MainUI.this.settingsMenu);
                    }
                    if (MainUI.this.securityMenu != null) {
                        MainUI.this.menuBar.add(MainUI.this.securityMenu);
                    }
                    if (MainUI.this.helpMenu != null) {
                        MainUI.this.menuBar.add(MainUI.this.helpMenu);
                    }
                    MainUI.this.menuBar.invalidate();
                    MainUI.this.menuBar.repaint();
                }
                if (buttons != null) {
                    MainUI.this.toolBar.remove(MainUI.this._verticalMessagesBox);
                    MainUI.this.toolBar.remove(MainUI.this.helpButton);
                    MainUI.this.toolBar.remove(MainUI.this.resetWindows);
                    MainUI.this.toolBar.remove(MainUI.this.jiniGroupsFilter);
                    MainUI.this.toolBar.remove(MainUI.this.zonesFilter);
                    MainUI.this.toolBar.remove(MainUI.this.refreshViewButton);
                    for (AbstractButton abstractButton : buttons) {
                        MainUI.this.toolBar.add(abstractButton);
                    }
                    MainUI.this.toolBar.add(MainUI.this.refreshViewButton);
                    MainUI.this.toolBar.add(MainUI.this.jiniGroupsFilter);
                    MainUI.this.toolBar.add(MainUI.this.zonesFilter);
                    MainUI.this.toolBar.add(MainUI.this.resetWindows);
                    MainUI.this.toolBar.add(MainUI.this.helpButton);
                    MainUI.this.toolBar.add(MainUI.this._verticalMessagesBox);
                    MainUI.this.toolBar.invalidate();
                    MainUI.this.toolBar.repaint();
                }
                this.currentSelUIComponent = serviceGridUIComponent;
            }
        }

        private void cleanFrame() {
            this.currentSelUIComponent = null;
            int componentsSize = MainUI.this.contentPane.getComponentCount();
            Component[] componentsForRemove = new Component[componentsSize];
            for (int i = 0; i < componentsSize; ++i) {
                componentsForRemove[i] = MainUI.this.contentPane.getComponent(i);
            }
            for (Component comp : componentsForRemove) {
                if (comp.equals(MainUI.this.base) || comp.equals(MainUI.this.statusContainer)) continue;
                MainUI.this.contentPane.remove(comp);
            }
            if (componentsSize > 0) {
                this.removeLastAddedMenus();
                this.removeLastAddedButtons();
            }
        }

        private void removeLastAddedMenus() {
            if (this.curAddedMenus != null) {
                for (JMenu removedMenu : this.curAddedMenus) {
                    MainUI.this.menuBar.remove(removedMenu);
                }
            }
        }

        private void removeLastAddedButtons() {
            if (this.curAddedButtons != null) {
                for (JButton removedButton : this.curAddedButtons) {
                    MainUI.this.toolBar.remove(removedButton);
                }
            }
        }
    }

    class GWDiscoveryListener
    implements DiscoveryListener {
        GWDiscoveryListener() {
        }

        public void discovered(final DiscoveryEvent dEvent) {
            final long startTimeLocal = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "-- BEGIN discovered() GWDiscoveryListener class");
            }
            Runnable discoveryProcess = new Runnable(){

                @Override
                public void run() {
                    ServiceRegistrar[] reggies = dEvent.getRegistrars();
                    Map groupMap = dEvent.getGroups();
                    for (int i = 0; i < reggies.length; ++i) {
                        try {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                String[] groups = (String[])groupMap.get(reggies[i]);
                                StringBuilder buff = new StringBuilder();
                                for (int j = 0; j < groups.length; ++j) {
                                    if (j > 0) {
                                        buff.append(", ");
                                    }
                                    buff.append(groups[j]);
                                }
                                LOGGER.log(Level.FINER, "Reggie discovered : " + reggies[i].getLocator().getHost() + ", Groups [" + buff.toString() + "]");
                            }
                            long now = System.currentTimeMillis();
                            MainUI.this.taskTimer.scheduleAtFixedRate((TimerTask)new LookupServiceUpdateTask(reggies[i]), new Date(now + MainUI.this.lookupCheckInterval), MainUI.this.lookupCheckInterval);
                            Repository.getInstance().addLookup(reggies[i]);
                            continue;
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.WARNING)) continue;
                            LOGGER.log(Level.WARNING, e.toString(), e);
                        }
                    }
                    long endTime = System.currentTimeMillis();
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(" --- Processing of discovering for event in GWDiscoveryListener class " + dEvent + " took " + (endTime - startTimeLocal) + " msec.");
                    }
                }
            };
            AdminUIThreadPool.getThreadPool().execute(discoveryProcess);
        }

        public void discarded(final DiscoveryEvent dEvent) {
            Runnable discardRegistryAndGSMProcess = new Runnable(){

                @Override
                public void run() {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("---Services dicarded");
                    }
                    Repository repository = Repository.getInstance();
                    ServiceRegistrar[] reggies = dEvent.getRegistrars();
                    for (int i = 0; i < reggies.length; ++i) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "---Reggie discarded:" + reggies[i].getServiceID());
                        }
                        repository.removeLookup(reggies[i]);
                    }
                    Repository.ProvisionMonitorHolder[] pmh = repository.getProvisionMonitorHolders();
                    for (int i = 0; i < pmh.length; ++i) {
                        try {
                            pmh[i].getProvisionMonitor().ping();
                            continue;
                        }
                        catch (RemoteException e) {
                            ServiceItem servItem = pmh[i].getServiceItem();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "---GSM discarded:" + servItem);
                            }
                            repository.removeProvisionMonitor(servItem);
                            MainUI.this.serviceNotifyHelper("serviceRemoved", servItem);
                            MainUI.this.gscMonitorPanel.remove(servItem);
                        }
                    }
                }
            };
            Runnable discardGSCProcess = new Runnable(){

                @Override
                public void run() {
                    List<ServiceItem> gscItemsList = MainUI.this.gscMonitorPanel.getGSCItemsList();
                    for (ServiceItem gscServiceItem : gscItemsList) {
                        try {
                            ((Cybernode)gscServiceItem.service).ping();
                        }
                        catch (RemoteException e) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "---GSC discarded:" + gscServiceItem);
                            }
                            MainUI.this.serviceNotifyHelper("serviceRemoved", gscServiceItem);
                            MainUI.this.gscMonitorPanel.remove(gscServiceItem);
                        }
                    }
                }
            };
            Runnable discardGSAProcess = new Runnable(){

                @Override
                public void run() {
                    Collection<ServiceItem> gsaServiceItemsCollection = Repository.getInstance().getGSAServices();
                    ArrayList<ServiceItem> gsaList = new ArrayList<ServiceItem>(gsaServiceItemsCollection);
                    for (ServiceItem gsaServiceItem : gsaList) {
                        GSA gsaService = (GSA)gsaServiceItem.service;
                        try {
                            gsaService.ping();
                        }
                        catch (RemoteException e) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "---GSA discarded:" + gsaServiceItem);
                            }
                            Repository.getInstance().removeGSA(gsaServiceItem);
                            MainUI.this.serviceNotifyHelper("serviceRemoved", gsaServiceItem);
                            MainUI.this.gscMonitorPanel.remove(gsaServiceItem);
                        }
                    }
                }
            };
            AdminUIThreadPool.getThreadPool().execute(discardRegistryAndGSMProcess);
            AdminUIThreadPool.getThreadPool().execute(discardGSCProcess);
            AdminUIThreadPool.getThreadPool().execute(discardGSAProcess);
        }
    }

    class LookupServiceUpdateTask
    extends TimerTask {
        ServiceRegistrar registrar;

        LookupServiceUpdateTask(ServiceRegistrar registrar) {
            this.registrar = registrar;
        }

        @Override
        public void run() {
            try {
                ((Administrable)this.registrar).getAdmin();
            }
            catch (RemoteException e) {
                try {
                    MainUI.this.dMgr.discard(this.registrar);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.cancel();
            }
        }
    }
}

