/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class ResourceBundleHandler {
    private static ResourceBundle gigaWorldResourceBundle;
    private static ResourceBundleHandler resourceBundleHandler;
    public static final String TERMINOLOGY_GRID_SERVICE_CONTAINER = "terminology.GridServiceContainer";
    public static final String TERMINOLOGY_DEPLOYMENT_DESCRIPTOR = "terminology.DeploymentDescriptor";
    public static final String TERMINOLOGY_GRID_SERVICE_CONTAINERS = "terminology.GridServiceContainers";
    public static final String TERMINOLOGY_GRID_SERVICE_MONITOR = "terminology.GridServiceMonitor";
    public static final String LABEL_GRID_SERVICE_CONTAINERS_IN_USE = "label.GridServiceContainersInUse";
    public static final String LABEL_TOTAL_GRID_SERVICE_CONTAINERS = "label.TotalGridServiceContainers";
    public static final String LABEL_GRID_SERVICE_CONTAINERS_FREE = "label.GridServiceContainersFree";
    public static final String LABEL_DEPLOYMENT_DESCRIPTOR_GRAPH = "label.DeploymentDescriptorGraph";
    public static final String LABEL_NESTED_DEPLOYMENT_DESCRIPTOR = "label.NestedDeploymentDescriptor";
    public static final String TOOLTIP_REFRESH_GRID_SERVICE_CONTAINERS = "tooltip.RefreshGridServiceContainers";
    public static final String TOOLTIP_GRID_SERVICE_CONTAINER_AT = "tooltip.GridServiceContainerAt";
    public static final String TOOLTIP_ZOOM_DEPLOYMENT_DESCRIPTOR_OUT = "tooltip.ZoomDeploymentDescriptorOut";
    public static final String TOOLTIP_ZOOM_DEPLOYMENT_DESCRIPTOR_IN = "tooltip.ZoomDeploymentDescriptorIn";
    public static final String TOOLTIP_REDEPLOY_DEPLOYMENT_DESCRIPTOR = "tooltip.RedeployDeploymentDescriptor";
    public static final String TOOLTIP_UNDEPLOY_DEPLOYMENT_DESCRIPTOR = "tooltip.UndeployDeploymentDescriptor";
    public static final String XML_GRID_SERVICE_CONTAINER_FILTER_CONFIG = "xml.GridServiceContainerFilterConfiguration";
    public static final String MSG_DEPLOYMENT_DESCRIPTOR_MGR = "message.DeploymentDescriptorMgr";
    public static final String MSG_UNKNOWN_DEPLOYMENT_DESCRIPTOR_FOR_SERVICE = "message.UnknownDeploymentDescriptorForService";
    public static final String MSG_UNKNOWN_DEPLOYMENT_DESCRIPTOR = "message.UnknownDeploymentDescriptor";
    public static final String MSG_CREATE_NEW_DEPLOYMENT_DESCRIPTOR_NODE = "message.CreateNewDeploymentDescriptorNode";
    public static final String LABEL_HELP_ABOUT_DIALOG = "dialog.help.labels";
    public static final String IMAGE_HELP_ABOUT_DIALOG = "dialog.help.image";
    public static final String SPACE_SUSPEND_TYPE_QUIESCED = "spaceSuspendTypeQuiesced";
    public static final String SPACE_SUSPEND_TYPE_DEMOTING = "spaceSuspendTypeDemoting";
    public static final String SPACE_SUSPEND_TYPE_DISCONNNECTED = "spaceSuspendTypeDisconnected";

    public static ResourceBundleHandler getInstance() {
        if (resourceBundleHandler == null) {
            resourceBundleHandler = new ResourceBundleHandler();
        }
        return resourceBundleHandler;
    }

    public String[] getResources(String resourceName) {
        String[] resources = null;
        String prop = gigaWorldResourceBundle.getString(resourceName);
        StringTokenizer st = new StringTokenizer(prop, ",");
        resources = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            resources[i] = st.nextToken().trim();
            ++i;
        }
        return resources;
    }

    public String getResource(String resourceName) {
        String[] resources = this.getResources(resourceName);
        if (resources.length > 0) {
            return resources[0];
        }
        return null;
    }

    private ResourceBundleHandler() {
        this.initResourceBundle();
    }

    private void initResourceBundle() {
        try {
            gigaWorldResourceBundle = ResourceBundle.getBundle("grid-admin-ui");
        }
        catch (MissingResourceException e) {
            System.err.println();
            System.err.println("Can't find the grid-admin-ui.properties file that contains all resource names.");
            throw e;
        }
    }
}

