/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.grid.DisplayControl;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.Zoomable;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.tree.JGraphCompactTreeLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.jini.admin.Administrable;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import org.jgraph.JGraph;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.entry.ApplianceInfo;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorAdmin;

public class OpStringGraph
extends JPanel
implements Zoomable {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private JGraph graph;
    private DefaultGraphModel graphModel;
    public static final Color COLOR_PROVISIONER = new Color(255, 153, 0);
    public static final Color COLOR_OPSTRING = Color.BLUE;
    public static final Color COLOR_SERVICE = new Color(0, 117, 58);
    private DefaultGraphCell graphCell;
    private LinkedList cellList;
    private LinkedList rootList;
    public static final int CELL_WIDTH = 100;
    public static final int CELL_HEIGHT = 20;
    static final String NORTH = "North";
    static final String WEST = "West";
    String[] layoutOptions = new String[]{"North", "West"};
    String currentLayout = "West";
    LayoutSelector layoutSelector;
    JComboBox layouts;
    JComboBox layoutMgrs;
    DisplayControl displayControl;
    JSplitPane splitPane;
    boolean initialDisplay = true;
    boolean useShortNames = false;
    private MainUI _mainUI;

    public OpStringGraph(MainUI mainUI) {
        super(new BorderLayout(8, 8));
        this._mainUI = mainUI;
        JPanel topPanel = new JPanel(new BorderLayout(8, 8));
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel legendPanel = this.createLegendPanel();
        this.layouts = new JComboBox<String>(this.layoutOptions);
        this.layouts.setMinimumSize(new Dimension(70, 20));
        this.layoutSelector = new LayoutSelector();
        this.layouts.setSelectedIndex(1);
        this.layouts.addActionListener(this.layoutSelector);
        ImageIcon zoomInIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/zoomin.gif");
        ImageIcon zoomOutIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/zoomout.gif");
        ImageIcon refreshIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/refresh.gif");
        JButton zoomOut = new JButton(zoomOutIcon);
        zoomOut.setToolTipText("Zoom-out the display area");
        zoomOut.setPreferredSize(new Dimension(22, 22));
        zoomOut.setMaximumSize(new Dimension(22, 22));
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpStringGraph.this.zoomOut();
            }
        });
        JButton zoomIn = new JButton(zoomInIcon);
        zoomIn.setToolTipText("Zoom-in the display area");
        zoomIn.setPreferredSize(new Dimension(22, 22));
        zoomIn.setMaximumSize(new Dimension(22, 22));
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpStringGraph.this.zoomIn();
            }
        });
        JButton refresh = new JButton(refreshIcon);
        refresh.setToolTipText("Refresh the graph");
        refresh.setPreferredSize(new Dimension(22, 22));
        refresh.setMaximumSize(new Dimension(22, 22));
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = (JFrame)SwingUtilities.getRoot((Component)OpStringGraph.this.graph);
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                }
                OpStringGraph.this.display(false);
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorderPainted(false);
        toolBar.add(refresh);
        toolBar.add(zoomIn);
        toolBar.add(zoomOut);
        toolBar.setPreferredSize(new Dimension(Integer.MAX_VALUE, 24));
        JCheckBox useShortNamesCB = new JCheckBox(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBox cb = (JCheckBox)evt.getSource();
                OpStringGraph.this.useShortNames = cb.isSelected();
                JFrame frame = (JFrame)SwingUtilities.getRoot((Component)OpStringGraph.this.graph);
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                }
                OpStringGraph.this.graph.invalidate();
                OpStringGraph.this.display(false);
                if (frame != null) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        JPanel panel = this.createGraphOptions(this.layouts, toolBar, useShortNamesCB);
        topPanel.add((Component)panel, NORTH);
        topPanel.add((Component)legendPanel, "Center");
        topPanel.setBorder(BorderFactory.createEtchedBorder());
        FontMetrics fm = this.getFontMetrics(topPanel.getFont());
        String deployDescStr = ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor");
        int legendPanelWidth = fm.stringWidth(deployDescStr) + 24;
        topPanel.setPreferredSize(new Dimension(legendPanelWidth, Integer.MAX_VALUE));
        topPanel.setMinimumSize(new Dimension(5, Integer.MAX_VALUE));
        this.graphModel = new DefaultGraphModel();
        this.graph = new GSGraph((GraphModel)this.graphModel);
        this.graph.setEditable(false);
        this.graph.getGraphLayoutCache().setSelectsAllInsertedCells(false);
        this.graph.setAntiAliased(true);
        this.graph.setCloneable(false);
        this.graph.setMarqueeColor(Color.BLUE);
        this.graph.setBendable(true);
        this.graph.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int x = e.getX();
                    int y = e.getY();
                    Object cell = OpStringGraph.this.graph.getFirstCellForLocation((double)x, (double)y);
                    if (cell != null) {
                        String lab = OpStringGraph.this.graph.convertValueToString(cell);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "#### GSGRAPH SAYS : " + lab);
                        }
                    }
                }
            }
        });
        this.cellList = new LinkedList();
        this.rootList = new LinkedList();
        this.graphCell = this.createRoot(this.getLayoutType());
        this.cellList.add(this.graphCell);
        JScrollPane scrollPane = new JScrollPane((Component)this.graph);
        this.graph.setBackground(Color.WHITE);
        scrollPane.setBackground(this.graph.getBackground());
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        scrollPane.setPreferredSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.splitPane = new JSplitPane(1, true, scrollPane, topPanel);
        this.add((Component)this.splitPane, "Center");
    }

    private JPanel createGraphOptions(JComboBox layoutChoices, JToolBar toolBar, JCheckBox useAbbreviations) {
        JPanel panel = new JPanel();
        JLabel l0 = new JLabel();
        JSeparator jSeparator1 = new JSeparator();
        panel.setLayout(new GridBagLayout());
        l0.setText("Graph Display Options");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)l0, gridBagConstraints);
        layoutChoices.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)layoutChoices, gridBagConstraints);
        useAbbreviations.setText("Use Short Names");
        useAbbreviations.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        useAbbreviations.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)useAbbreviations, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)toolBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        panel.add((Component)jSeparator1, gridBagConstraints);
        return panel;
    }

    private JPanel createLegendPanel() {
        JPanel p = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(150, 500);
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                Font defaultFont = g.getFont();
                FontMetrics fontMetrics = g.getFontMetrics(defaultFont);
                g2.setFont(defaultFont);
                int startX = 2;
                int startY = 8;
                int BLOCK_WIDTH = 14;
                int LINE_HEIGHT = 12;
                int LINE_SPACER = 4;
                int TEXT_SPACER = 4;
                g2.setColor(Color.BLACK);
                String legend = "Legend";
                g2.drawString(legend, 2, LINE_HEIGHT);
                int lLen = fontMetrics.stringWidth(legend);
                g2.drawLine(startX, LINE_HEIGHT + 1, startX + lLen, LINE_HEIGHT + 1);
                g2.setColor(COLOR_PROVISIONER);
                g2.fill3DRect(startX, startY + LINE_HEIGHT + LINE_SPACER, BLOCK_WIDTH, LINE_HEIGHT, true);
                String gridServiceMonitorStr = ResourceBundleHandler.getInstance().getResource("terminology.GridServiceMonitor");
                g2.setColor(Color.BLACK);
                g2.drawString(gridServiceMonitorStr, BLOCK_WIDTH + TEXT_SPACER, LINE_HEIGHT * 2 + LINE_SPACER * 2);
                g2.setColor(COLOR_OPSTRING);
                g2.fill3DRect(startX, startY + LINE_HEIGHT * 2 + LINE_SPACER * 2, BLOCK_WIDTH, LINE_HEIGHT, true);
                String deployDescStr = ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor");
                g2.setColor(Color.BLACK);
                g2.drawString(deployDescStr, BLOCK_WIDTH + 4, LINE_HEIGHT * 3 + LINE_SPACER * 3);
                int column2 = startX;
                g2.setColor(COLOR_SERVICE);
                g2.fill3DRect(startX, startY + LINE_HEIGHT * 3 + LINE_SPACER * 3, BLOCK_WIDTH, LINE_HEIGHT, true);
                g2.setColor(Color.BLACK);
                g2.drawString("Services", column2 + BLOCK_WIDTH + TEXT_SPACER, LINE_HEIGHT * 4 + LINE_SPACER * 4);
            }
        };
        p.setDoubleBuffered(true);
        return p;
    }

    void setDisplayControl(DisplayControl displayControl) {
        this.displayControl = displayControl;
    }

    void display(boolean isPerformedWithinThread) {
        this.layoutSelector.doLayout(isPerformedWithinThread);
    }

    LinkedList getCurrentCells() {
        LinkedList list = new LinkedList();
        list.addAll(this.cellList);
        return list;
    }

    void removeMonitor(ProvisionMonitor monitor) {
        DefaultGraphCell cell = this.lookupCell(monitor, this.rootList);
        if (cell == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Uknown GSM!");
            }
            return;
        }
        this.removeCellAndEdges(cell, true);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "rootList.size()=" + this.rootList.size());
        }
        if (this.rootList.size() == 0) {
            LinkedList list = this.getCurrentCells();
            this.graphModel.remove(list.toArray(new Object[list.size()]));
            this.cellList.clear();
        }
        this.display(true);
    }

    void undeploy(OperationalString opString) {
        boolean undeploy;
        DefaultGraphCell cell = this.lookupCell(opString, this.getCurrentCells());
        if (cell == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Uknown " + ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor") + "[" + opString.getName() + "]cannot remove from graph");
            }
            return;
        }
        boolean bl = undeploy = opString.getStatus() == 0;
        if (undeploy) {
            this.removeCellAndEdges(cell, false);
            this.removeServiceElements(opString.getServices());
        }
        OperationalString[] nested = opString.getNestedOperationalStrings();
        for (int i = 0; i < nested.length; ++i) {
            this.undeploy(nested[i]);
        }
    }

    void removeServiceElements(ServiceElement[] sElems) {
        for (int i = 0; i < sElems.length; ++i) {
            List<DefaultGraphCell> cellsList = this.lookupCells(sElems[i], this.getCurrentCells());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "UNDEPLOY:: FOUND SERVICE(S) [" + sElems[i].getName() + "] ? " + (cellsList.isEmpty() ? "no" : "yes"));
            }
            if (cellsList.isEmpty()) continue;
            this.removeCellAndEdges(cellsList, false);
        }
    }

    @Override
    public void zoomIn() {
        double scale = this.graph.getScale();
        this.graph.setScale(scale + 0.1);
    }

    @Override
    public void zoomOut() {
        double scale = this.graph.getScale();
        this.graph.setScale(scale - 0.1);
    }

    synchronized void removeCellAndEdges(DefaultGraphCell cell, boolean removeFromRoot) {
        block3: {
            List list = DefaultGraphModel.getDescendants((GraphModel)this.graphModel, (Object[])new Object[]{cell});
            Object[] cells = list.toArray(new Object[list.size()]);
            try {
                this.graph.getGraphLayoutCache().remove(cells, true, true);
            }
            catch (ConcurrentModificationException cme) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                LOGGER.log(Level.FINEST, cme.toString(), cme);
            }
        }
        if (removeFromRoot) {
            this.rootList.remove(cell);
        }
        this.cellList.remove(cell);
    }

    synchronized void removeCellAndEdges(List<DefaultGraphCell> cellsList, boolean removeFromRoot) {
        block4: {
            List list = DefaultGraphModel.getDescendants((GraphModel)this.graphModel, (Object[])cellsList.toArray(new DefaultGraphCell[cellsList.size()]));
            Object[] cells = list.toArray(new Object[list.size()]);
            try {
                this.graph.getGraphLayoutCache().remove(cells, true, true);
            }
            catch (ConcurrentModificationException cme) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block4;
                LOGGER.log(Level.FINEST, cme.toString(), cme);
            }
        }
        for (DefaultGraphCell cell : cellsList) {
            if (removeFromRoot) {
                this.rootList.remove(cell);
            }
            this.cellList.remove(cell);
        }
    }

    synchronized void addMonitor(ServiceItem item) throws RemoteException {
        DefaultGraphCell provisionerCell;
        ProvisionMonitor monitor = (ProvisionMonitor)item.service;
        if (this.initialDisplay) {
            this.splitPane.setDividerLocation((int)this.displayControl.getDisplayableSize().getWidth() - 160);
            this.initialDisplay = false;
        }
        if ((provisionerCell = this.lookupCell(monitor, this.rootList)) == null) {
            String name = "*" + ResourceBundleHandler.getInstance().getResources("terminology.GridServiceMonitor").toString();
            ApplianceInfo aInfo = ApplianceInfo.getApplianceInfo((Entry[])item.attributeSets);
            String toolTip = null;
            if (aInfo != null) {
                JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(item.serviceID);
                String pid = jvmDetails == null ? "n/a" : String.valueOf(jvmDetails.getPid());
                toolTip = "Process ID:" + pid + ", " + aInfo.hostName;
            }
            name = "*GSM";
            NamedData data = new NamedData(name, monitor);
            data.setServiceItem(item);
            provisionerCell = this.createCell(data, COLOR_PROVISIONER, toolTip);
            this.rootList.add(provisionerCell);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Added GSM Cell");
            }
        }
    }

    private LinkedList createCellsForOpString(OperationalString opString, DefaultGraphCell parent, boolean isPrimary, LinkedList cells, ConnectionSet connectionSet) {
        LinkedList<Object> newCells = new LinkedList<Object>();
        DefaultGraphCell opStringCell = this.lookupCell(opString, this.cellList);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "--- CREATE CELLS FOR OPSTRING " + opString.getName() + ", cell=" + opStringCell);
        }
        if (opStringCell == null) {
            NamedData opStringData;
            block16: {
                opStringData = null;
                try {
                    opStringData = new NamedData(opString.getName(), opString, opString);
                }
                catch (ConnectException ce) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, ce.toString(), ce);
                    }
                }
                catch (RemoteException re) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block16;
                    LOGGER.log(Level.SEVERE, re.toString(), re);
                }
            }
            if (opStringData != null) {
                opStringCell = this.createCell(opStringData, COLOR_OPSTRING, opString.getName());
                newCells.add(opStringCell);
                cells.add(opStringCell);
            }
        }
        if (opStringCell == null) {
            return newCells;
        }
        DefaultEdge edge = this.createEdge(parent, opStringCell, connectionSet, isPrimary);
        if (edge != null) {
            newCells.add(edge);
            cells.add(edge);
        }
        ServiceElement[] services = opString.getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceElement service = services[i];
            DefaultGraphCell cell = this.lookupCell(service, this.cellList);
            if (cell == null) {
                NamedData namedData;
                block17: {
                    namedData = null;
                    try {
                        namedData = new NamedData(service.getName(), service, opString);
                    }
                    catch (ConnectException ce) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, ce.toString(), ce);
                        }
                    }
                    catch (RemoteException re) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block17;
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                }
                if (namedData != null) {
                    cell = this.createCell(namedData, COLOR_SERVICE, service.getName());
                    newCells.add(cell);
                    cells.add(cell);
                }
            }
            if (!isPrimary || (edge = this.createEdge(opStringCell, cell, connectionSet, isPrimary)) == null) continue;
            newCells.add(edge);
            cells.add(edge);
        }
        return newCells;
    }

    DefaultGraphCell lookupCell(Object cellData, LinkedList cells) {
        if (cellData == null) {
            return null;
        }
        DefaultGraphCell found = null;
        for (int i = 0; i < cells.size(); ++i) {
            DefaultGraphCell graphCell = (DefaultGraphCell)cells.get(i);
            NamedData data = (NamedData)graphCell.getUserObject();
            if (data == null || !data.getData().equals(cellData)) continue;
            found = graphCell;
        }
        return found;
    }

    List<DefaultGraphCell> lookupCells(Object cellData, LinkedList cells) {
        if (cellData == null) {
            return null;
        }
        ArrayList<DefaultGraphCell> resultList = new ArrayList<DefaultGraphCell>(3);
        for (int i = 0; i < cells.size(); ++i) {
            DefaultGraphCell grCell = (DefaultGraphCell)cells.get(i);
            NamedData data = (NamedData)grCell.getUserObject();
            if (data == null || !data.getData().equals(cellData) && (!(cellData instanceof ServiceElement) || !data.isSetHasServiceElement((ServiceElement)cellData))) continue;
            resultList.add(grCell);
        }
        return resultList;
    }

    DefaultGraphCell lookupCellName(String cellName, LinkedList cells) {
        if (cellName == null) {
            return null;
        }
        DefaultGraphCell found = null;
        for (int i = 0; i < cells.size(); ++i) {
            DefaultGraphCell graphCell = (DefaultGraphCell)cells.get(i);
            NamedData data = (NamedData)graphCell.getUserObject();
            if (data == null || !data.getName().equals(cellName)) continue;
            found = graphCell;
        }
        return found;
    }

    private DefaultGraphCell createCell(Object obj, Color color, String toolTip) {
        boolean x = false;
        boolean y = false;
        int w = 100;
        int h = 20;
        TippableCell cell = new TippableCell(obj, toolTip);
        GraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)new Rectangle2D.Double((double)x, (double)y, w, h));
        GraphConstants.setBackground((Map)cell.getAttributes(), (Color)color);
        GraphConstants.setOpaque((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setAutoSize((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setResize((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setEditable((Map)cell.getAttributes(), (boolean)false);
        GraphConstants.setBendable((Map)cell.getAttributes(), (boolean)true);
        GraphConstants.setForeground((Map)cell.getAttributes(), (Color)Color.WHITE);
        GraphConstants.setFont((Map)cell.getAttributes(), (Font)UIManager.getFont("Label.font"));
        GraphConstants.setBorder((Map)cell.getAttributes(), (Border)BorderFactory.createEtchedBorder());
        DefaultPort port = new DefaultPort();
        cell.add((MutableTreeNode)port);
        return cell;
    }

    private DefaultEdge createEdge(DefaultGraphCell source, DefaultGraphCell target, ConnectionSet connectionSet, boolean solid) {
        if (DefaultGraphModel.containsEdgeBetween((GraphModel)this.graphModel, (Object)source, (Object)target)) {
            return null;
        }
        DefaultEdge edge = new DefaultEdge();
        try {
            connectionSet.connect((Object)edge, (Object)source.getChildAt(0), (Object)target.getChildAt(0));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ArrayIndexOutOfBoundsException assembling graph, skipping edge connection");
            }
            return null;
        }
        int arrow = 2;
        GraphConstants.setLineEnd((Map)edge.getAttributes(), (int)arrow);
        GraphConstants.setEditable((Map)edge.getAttributes(), (boolean)false);
        GraphConstants.setEndFill((Map)edge.getAttributes(), (boolean)true);
        GraphConstants.setBendable((Map)edge.getAttributes(), (boolean)true);
        GraphConstants.setMoveable((Map)edge.getAttributes(), (boolean)false);
        GraphConstants.setSelectable((Map)edge.getAttributes(), (boolean)false);
        if (!solid) {
            GraphConstants.setLineColor((Map)edge.getAttributes(), (Color)Color.GRAY);
            GraphConstants.setLineStyle((Map)edge.getAttributes(), (int)12);
        }
        return edge;
    }

    private DefaultEdge createMonitorEdge(DefaultGraphCell source, DefaultGraphCell target, ConnectionSet connectionSet) {
        DefaultEdge edge = new DefaultEdge();
        connectionSet.connect((Object)edge, (Object)source.getChildAt(0), (Object)target.getChildAt(0));
        int arrow = 8;
        GraphConstants.setLineEnd((Map)edge.getAttributes(), (int)arrow);
        GraphConstants.setEndFill((Map)edge.getAttributes(), (boolean)true);
        return edge;
    }

    public void scrollToCell(String name) {
        DefaultGraphCell graphCell = this.lookupCellName(name, this.cellList);
        if (graphCell != null) {
            this.graph.scrollCellToVisible((Object)graphCell);
        }
    }

    void layoutGraph(int orientation) {
        this.assembleGraph();
        JGraphFacade facade = new JGraphFacade(this.graph, new Object[]{this.graphCell});
        JGraphCompactTreeLayout layout = new JGraphCompactTreeLayout();
        layout.setOrientation(orientation);
        layout.run(facade);
        Map nested = facade.createNestedMap(true, true);
        this.graph.getGraphLayoutCache().edit(nested);
    }

    synchronized void assembleGraph() {
        DefaultGraphCell monitorCell;
        int i;
        LinkedList<Object> graphCells = new LinkedList<Object>();
        Object[] roots = this.rootList.toArray(new Object[this.rootList.size()]);
        ConnectionSet connectionSet = new ConnectionSet();
        for (i = 0; i < roots.length; ++i) {
            monitorCell = (DefaultGraphCell)roots[i];
            graphCells.add(monitorCell);
            DefaultEdge fromRoot = new DefaultEdge();
            NamedData data = (NamedData)monitorCell.getUserObject();
            ProvisionMonitor monitor = (ProvisionMonitor)data.getData();
            try {
                monitor.ping();
                try {
                    TreeNode target;
                    TreeNode source;
                    if (this.graphCell.getChildCount() <= 0 || DefaultGraphModel.containsEdgeBetween((GraphModel)this.graphModel, (Object)(source = this.graphCell.getChildAt(0)), (Object)(target = monitorCell.getChildAt(0)))) continue;
                    connectionSet.connect((Object)fromRoot, (Object)source, (Object)target);
                    graphCells.add(fromRoot);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.log(Level.FINER, "ArrayIndexOutOfBoundsException assembling graph, skipping vertex connection to GSM", e);
                }
                continue;
            }
            catch (RemoteException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                this.removeCellAndEdges(monitorCell, true);
                graphCells.remove(monitorCell);
            }
        }
        roots = this.rootList.toArray(new Object[this.rootList.size()]);
        for (i = 0; i < roots.length; ++i) {
            monitorCell = (DefaultGraphCell)roots[i];
            NamedData data = (NamedData)monitorCell.getUserObject();
            try {
                this.addOpstrings(monitorCell, (DeployAdmin)data.getAdminObject(), graphCells, connectionSet);
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                this.removeCellAndEdges(monitorCell, true);
                graphCells.remove(monitorCell);
            }
        }
        this.graphModel.insert(graphCells.toArray(new Object[0]), null, connectionSet, null, null);
    }

    void addOpstrings(DefaultGraphCell provisionerCell, DeployAdmin da, LinkedList cells, ConnectionSet connectionSet) throws RemoteException {
        OperationalStringManager[] opStringMgrs = da.getOperationalStringManagers();
        if (opStringMgrs != null) {
            for (int j = 0; j < opStringMgrs.length; ++j) {
                boolean isManaging = opStringMgrs[j].isManaging();
                if (!isManaging) continue;
                this.cellList.addAll(this.createCellsForOpString(opStringMgrs[j].getOperationalString(), provisionerCell, isManaging, cells, connectionSet));
            }
        }
    }

    int getLayoutType() {
        if (this.currentLayout.equals(WEST)) {
            return 7;
        }
        return 1;
    }

    DefaultGraphCell createRoot(int orientation) {
        DefaultGraphCell rootCell = new DefaultGraphCell();
        GraphConstants.setOpaque((Map)rootCell.getAttributes(), (boolean)true);
        GraphConstants.setAutoSize((Map)rootCell.getAttributes(), (boolean)true);
        GraphConstants.setFont((Map)rootCell.getAttributes(), (Font)UIManager.getFont("Label.font"));
        DefaultPort port = new DefaultPort();
        rootCell.add((MutableTreeNode)port);
        return rootCell;
    }

    void connectProvisioners(DefaultGraphCell monitorCell, Object[] roots, ConnectionSet connectionSet) throws RemoteException {
        NamedData data = (NamedData)monitorCell.getUserObject();
        ProvisionMonitorAdmin admin = (ProvisionMonitorAdmin)data.getAdminObject();
        ProvisionMonitor.PeerInfo[] backups = admin.getBackupInfo();
        for (int i = 0; i < roots.length; ++i) {
            DefaultGraphCell peerCell = (DefaultGraphCell)roots[i];
            NamedData peerData = (NamedData)peerCell.getUserObject();
            ProvisionMonitor peerMonitor = (ProvisionMonitor)peerData.getData();
            for (int j = 0; j < backups.length; ++j) {
                if (!peerMonitor.equals(backups[j].getService())) continue;
                DefaultEdge edge = this.createMonitorEdge(monitorCell, peerCell, connectionSet);
                this.cellList.add(edge);
                edge = this.createMonitorEdge(peerCell, monitorCell, connectionSet);
                this.cellList.add(edge);
            }
        }
    }

    public class NamedData {
        private String name;
        private Object data;
        private ServiceItem item;
        private Object adminObject;
        private OperationalString operationalString;
        private Set<ServiceElement> servicesElementsSet;

        public NamedData(String name, Object data) throws RemoteException {
            this(name, data, null);
        }

        public NamedData(String name, Object data, OperationalString operationalString) throws RemoteException {
            this.name = name;
            this.data = data;
            this.operationalString = operationalString;
            if (operationalString != null) {
                ServiceElement[] serviceElementsArray = operationalString.getServices();
                this.servicesElementsSet = new HashSet<ServiceElement>(serviceElementsArray.length);
                for (ServiceElement serElement : serviceElementsArray) {
                    this.servicesElementsSet.add(serElement);
                }
            }
            if (data instanceof Administrable) {
                this.adminObject = ((Administrable)data).getAdmin();
            }
        }

        public boolean isSetHasServiceElement(ServiceElement serviceElement) {
            if (this.servicesElementsSet == null) {
                return false;
            }
            return this.servicesElementsSet.contains(serviceElement);
        }

        public OperationalString getOperationalString() {
            return this.operationalString;
        }

        public boolean equals(Object object) {
            return this.data.equals(object);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        void setServiceItem(ServiceItem item) {
            this.item = item;
        }

        ServiceItem getServiceItem() {
            return this.item;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getName() {
            return this.name;
        }

        String getDisplayName() {
            String displayName = this.name;
            if (displayName.startsWith("*")) {
                displayName = displayName.substring(1);
            }
            if (OpStringGraph.this.useShortNames) {
                displayName = displayName.length() > 4 ? displayName.substring(0, 3) + ".." : displayName;
            }
            return displayName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Object getAdminObject() {
            return this.adminObject;
        }
    }

    class LayoutSelector
    implements ActionListener {
        LayoutSelector() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            OpStringGraph.this.currentLayout = (String)cb.getSelectedItem();
            JFrame frame = (JFrame)SwingUtilities.getRoot((Component)OpStringGraph.this.graph);
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
            }
            this.doLayout(false);
            if (frame != null) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        void doLayout(boolean isPerformedWithinThread) {
            if (!isPerformedWithinThread) {
                AdminUIThreadPool.getThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        LayoutSelector.this.positionVertex(OpStringGraph.this.getLayoutType());
                    }
                });
            } else {
                this.positionVertex(OpStringGraph.this.getLayoutType());
            }
        }

        synchronized void positionVertex(int orientation) {
            Point2D p = new Point2D.Double(0.0, 0.0);
            Dimension d = OpStringGraph.this.displayControl.getDisplayableSize();
            switch (orientation) {
                case 1: {
                    p = new Point(d.width / 2, 0);
                    break;
                }
                case 5: {
                    p = new Point(d.width / 2, d.height);
                    break;
                }
                case 3: {
                    p = new Point(d.width, d.height / 2);
                    break;
                }
                case 7: {
                    p = new Point(0, d.height / 2);
                }
            }
            int w = 2;
            int h = 2;
            GraphConstants.setBounds((Map)OpStringGraph.this.graphCell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(p.getX(), p.getY(), w, h));
            OpStringGraph.this.layoutGraph(orientation);
        }
    }

    class TippableCell
    extends DefaultGraphCell {
        String toolTipText;

        TippableCell(Object obj) {
            super(obj);
        }

        TippableCell(Object obj, String toolTipText) {
            super(obj);
            this.toolTipText = toolTipText;
        }

        public String getToolTipText() {
            String toolTip = null;
            toolTip = ((NamedData)this.getUserObject()).getName().startsWith("*GS") ? this.toolTipText : (OpStringGraph.this.useShortNames ? this.toolTipText : null);
            return toolTip;
        }
    }

    static class GSGraph
    extends JGraph {
        GSGraph(GraphModel model) {
            super(model);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        }

        public String getToolTipText(MouseEvent event) {
            Object cell = this.getFirstCellForLocation(event.getX(), event.getY());
            if (cell instanceof TippableCell) {
                return ((TippableCell)((Object)cell)).getToolTipText();
            }
            return null;
        }
    }
}

