/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.jini.config.Configuration;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.event.BasicEventConsumer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.monitor.ProvisionFailureEvent;

public class ProvisionFailureEventTable
extends JPanel {
    JTable eventTable;
    FailureEventModel dataModel;
    ProvisionFailureConsumer pfConsumer;
    BasicEventConsumer eventConsumer;
    private JTabbedPane tabbedPane;
    private Component tabComponent;
    ImageIcon newItemIcon;
    Observatory observatory;
    JScrollPane scroller;
    private JFrame _parentFrame;

    public ProvisionFailureEventTable(JFrame parentFrame, Configuration config) throws Exception {
        this.setLayout(new BorderLayout());
        this._parentFrame = parentFrame;
        this.newItemIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/error.gif");
        this.eventTable = new JTable();
        this.eventTable.addMouseListener(new RowListener());
        this.eventTable.setBackground(Color.white);
        this.dataModel = new FailureEventModel();
        this.eventTable.setModel(this.dataModel);
        this.eventTable.setAutoResizeMode(3);
        TableColumnModel cm = this.eventTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(120);
        cm.getColumn(0).setMaxWidth(500);
        cm.getColumn(1).setPreferredWidth(100);
        cm.getColumn(1).setMaxWidth(500);
        cm.getColumn(2).setPreferredWidth(120);
        cm.getColumn(2).setMaxWidth(500);
        cm.getColumn(3).setPreferredWidth(150);
        cm.getColumn(3).setMaxWidth(500);
        this.scroller = new JScrollPane(this.eventTable);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.add((Component)this.scroller, "Center");
        JPanel buttons = new JPanel();
        JButton details = new JButton("Details");
        details.setToolTipText("Get details on the selected ProvisionFailureEvent");
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = ProvisionFailureEventTable.this.eventTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                ProvisionFailureEventTable.this.showDetails(ProvisionFailureEventTable.this.getEvent(row));
            }
        });
        JButton remove = new JButton("Delete");
        remove.setToolTipText("Delete the selected ProvisionFailureEvent");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = ProvisionFailureEventTable.this.eventTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                ProvisionFailureEventTable.this.removeEvent(row);
                int rowCount = ProvisionFailureEventTable.this.eventTable.getRowCount();
                if (rowCount == 0 && ProvisionFailureEventTable.this.tabComponent != null && ProvisionFailureEventTable.this.tabbedPane.indexOfComponent(ProvisionFailureEventTable.this.tabComponent) >= 0) {
                    ProvisionFailureEventTable.this.tabbedPane.setIconAt(ProvisionFailureEventTable.this.tabbedPane.indexOfComponent(ProvisionFailureEventTable.this.tabComponent), null);
                }
            }
        });
        JButton clear = new JButton("Clear All");
        clear.setToolTipText("Clear all ProvisionFailureEvent items");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int rows = ProvisionFailureEventTable.this.eventTable.getRowCount();
                if (rows == 0) {
                    return;
                }
                if (ProvisionFailureEventTable.this.tabComponent != null && ProvisionFailureEventTable.this.tabbedPane.indexOfComponent(ProvisionFailureEventTable.this.tabComponent) >= 0) {
                    ProvisionFailureEventTable.this.tabbedPane.setIconAt(ProvisionFailureEventTable.this.tabbedPane.indexOfComponent(ProvisionFailureEventTable.this.tabComponent), null);
                }
                ProvisionFailureEventTable.this.dataModel.tableData.clear();
                ProvisionFailureEventTable.this.dataModel.fireTableDataChanged();
            }
        });
        buttons.add(details);
        buttons.add(remove);
        buttons.add(clear);
        this.add((Component)buttons, "South");
        EventDescriptor eDesc = new EventDescriptor(ProvisionFailureEvent.class, new Long(-7832310585750966248L));
        this.pfConsumer = new ProvisionFailureConsumer();
        this.eventConsumer = new BasicEventConsumer(eDesc, (RemoteServiceEventListener)this.pfConsumer, null, config);
        this.handleEnterKeyEvents();
    }

    private void handleEnterKeyEvents() {
        KeyStroke stroke = KeyStroke.getKeyStroke("ENTER");
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int selRow = ProvisionFailureEventTable.this.eventTable.getSelectedRow();
                if (selRow >= 0) {
                    ProvisionFailureEventTable.this.showDetails(ProvisionFailureEventTable.this.getEvent(selRow));
                }
            }
        };
        InputMap inputMap = this.eventTable.getInputMap(0);
        inputMap.put(stroke, "ENTER");
        this.eventTable.getActionMap().put("ENTER", actionListener);
    }

    public void setTab(JTabbedPane tab, Component tabComponent) {
        this.tabbedPane = tab;
        this.tabComponent = tabComponent;
    }

    public synchronized void addObserver(Observer observer) {
        this.getObservatory().addObserver(observer);
    }

    public Observatory getObservatory() {
        if (this.observatory == null) {
            this.observatory = new Observatory();
        }
        return this.observatory;
    }

    public void addService(ServiceItem item) {
        this.eventConsumer.register(item);
    }

    public void removeService(ServiceID serviceID) {
        this.eventConsumer.deregister(serviceID);
    }

    public void addEvent(ProvisionFailureEvent event) {
        int old = this.dataModel.getRowCount();
        this.dataModel.addItem(event);
        this.dataModel.fireTableDataChanged();
        if (this.newItemIcon != null && this.tabComponent != null && this.tabbedPane.indexOfComponent(this.tabComponent) >= 0) {
            this.tabbedPane.setIconAt(this.tabbedPane.indexOfComponent(this.tabComponent), this.newItemIcon);
        }
        Rectangle lastCell = this.eventTable.getCellRect(this.eventTable.getRowCount(), 0, true);
        this.scroller.getViewport().scrollRectToVisible(lastCell);
        this.getObservatory().stateChange();
    }

    public void removeEvent(int row) {
        this.dataModel.removeItem(row);
    }

    public void terminate() {
        if (this.eventConsumer != null) {
            this.eventConsumer.terminate();
        }
    }

    public ProvisionFailureEvent getEvent(int row) {
        if (row == -1) {
            return null;
        }
        return (ProvisionFailureEvent)this.dataModel.getItem(row);
    }

    public int getNumEvents() {
        return this.dataModel.getRowCount();
    }

    public int getNumEvents(String opStringName) {
        return this.dataModel.getRowCount(opStringName);
    }

    void showDetails(ProvisionFailureEvent event) {
        ServiceElement sElem = event.getServiceElement();
        StringBuilder sb = new StringBuilder("<html><h3><font color=black>ProvisionFailureEvent Details</font></h3>");
        sb.append("<table BORDER=1 COLS=2>");
        sb.append("<tr><td><font color=black>Time</font></td>");
        sb.append("<td><font color=blue>" + event.getFailureTime() + "</font></td></tr>");
        sb.append("<tr><td><font color=black>Name</font></td>");
        sb.append("<td><font color=blue>" + sElem.getName() + "</font></td></tr>");
        sb.append("<tr><td><font color=black>Class</font></td>");
        String impl = "<not declared>";
        if (sElem.getComponentBundle() != null) {
            impl = sElem.getComponentBundle().getClassName();
        }
        sb.append("<td><font color=blue>" + impl + "</font></td></tr>");
        sb.append("<tr><td><font color=black>Reason</font></td>");
        sb.append("<td width=200><font color=blue>" + this.scrub(event.getReason()) + "</font></td></tr>");
        sb.append("<tr><td><font color=black>" + ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor") + "</font></td>");
        sb.append("<td><font color=blue>" + sElem.getOperationalStringName() + "</font></td></tr>");
        sb.append("<tr><td><font color=black>Exception</font></td>");
        String s = null;
        Throwable t = event.getThrowable();
        s = t == null ? "No Exception" : t.getClass().getName();
        sb.append("<td><font color=blue>" + s + "</font></td></tr>");
        sb.append("</table></html>");
        if (t == null) {
            JOptionPane.showMessageDialog(this._parentFrame, sb.toString(), "Provision Failure Details", 1);
        } else {
            int answer = JOptionPane.showOptionDialog(this._parentFrame, sb.toString(), "Provision Failure Exception", 0, 0, null, new Object[]{"Show Exception", "Close"}, null);
            if (answer == 0) {
                Throwable cause = t.getCause();
                if (cause != null) {
                    Throwable nested = cause.getCause();
                    UIHelper.showError(nested == null ? cause : nested, (Component)this._parentFrame);
                } else {
                    UIHelper.showError(t, (Component)this._parentFrame);
                }
            }
        }
    }

    String scrub(String input) {
        if (input == null) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(input, "\n");
        if (st.countTokens() == 0) {
            return input;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    class RowListener
    extends MouseAdapter {
        RowListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clickCount = e.getClickCount();
            if (ProvisionFailureEventTable.this.tabComponent != null && ProvisionFailureEventTable.this.tabbedPane.indexOfComponent(ProvisionFailureEventTable.this.tabComponent) >= 0) {
                ProvisionFailureEventTable.this.tabbedPane.setIconAt(ProvisionFailureEventTable.this.tabbedPane.indexOfComponent(ProvisionFailureEventTable.this.tabComponent), null);
            }
            if (clickCount == 2) {
                int row = ProvisionFailureEventTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                if (row == -1) {
                    return;
                }
                ProvisionFailureEventTable.this.showDetails(ProvisionFailureEventTable.this.getEvent(row));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        void maybeShowPopup(final MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem delete = new JMenuItem("Delete");
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int row = ProvisionFailureEventTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                        ProvisionFailureEventTable.this.removeEvent(row);
                    }
                });
                JMenuItem details = new JMenuItem("Details");
                details.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int row = ProvisionFailureEventTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                        ProvisionFailureEventTable.this.showDetails(ProvisionFailureEventTable.this.getEvent(row));
                    }
                });
                popup.add(delete);
                popup.addSeparator();
                popup.add(details);
                popup.pack();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class FailureEventModel
    extends AbstractTableModel {
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Time", "Name", ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor"), "Reason", "Exception"};

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                ProvisionFailureEvent event = (ProvisionFailureEvent)this.tableData.elementAt(index);
                ServiceElement sElem = event.getServiceElement();
                switch (columnIndex) {
                    case 0: {
                        return event.getFailureTime().toString();
                    }
                    case 1: {
                        return sElem.getName();
                    }
                    case 2: {
                        return sElem.getOperationalStringName();
                    }
                    case 3: {
                        return event.getReason();
                    }
                    case 4: {
                        String s = null;
                        Throwable t = event.getThrowable();
                        if (t == null) {
                            s = "No Exception";
                        } else {
                            if (t.getCause() != null) {
                                t = t.getCause();
                            }
                            s = t.getClass().getName();
                        }
                        return s;
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.removeElementAt(row);
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        public int getRowCount(String opstring) {
            int num = 0;
            ProvisionFailureEvent[] events = this.tableData.toArray(new ProvisionFailureEvent[this.tableData.size()]);
            for (int i = 0; i < events.length; ++i) {
                if (!events[i].getServiceElement().getOperationalStringName().equals(opstring)) continue;
                ++num;
            }
            return num;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }

    static class Observatory
    extends Observable {
        Observatory() {
        }

        void stateChange() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    class ProvisionFailureConsumer
    implements RemoteServiceEventListener {
        ProvisionFailureConsumer() {
        }

        public void notify(RemoteServiceEvent event) {
            try {
                ProvisionFailureEvent pfe = (ProvisionFailureEvent)event;
                ProvisionFailureEventTable.this.addEvent(pfe);
            }
            catch (Throwable t) {
                UIHelper.showError(t, "Notification of a ProvisionFailureEvent");
            }
        }
    }
}

