/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.grid.ProvisionFailureEventTable;
import com.gigaspaces.admin.ui.grid.SLAEventTable;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.UIExceptionTable;
import com.gigaspaces.admin.ui.grid.gsc.GSCPanel;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.grid.gsa.AgentIdAware;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.lrmi.stubs.LRMISpaceImpl;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.management.client.MBeanServerConnectionFactory;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.JSpaceAdminProxy;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.filters.FiltersInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.PrimaryBackupIndicationListener;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.lookup.entry.Name;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorAdmin;

public class Repository
implements AuthenticationListener {
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private static Map<ServiceID, ServiceItem> servicesMap = Collections.synchronizedMap(new HashMap());
    private static List<ServiceRegistrar> lusList = Collections.synchronizedList(new ArrayList());
    private static Repository instance = new Repository();
    private TreeWorker treeWorker;
    private ProvisionFailureEventTable provisionFailureTable;
    private SLAEventTable slaEventTable;
    private UIExceptionTable uiExceptionTable;
    private final LinkedList<ProvisionMonitorHolder> monitorList = new LinkedList();
    private GSCPanel gscPanel;
    private final Properties uiProps = new Properties();
    private final Map<ServiceID, JVMDetails> _jvmDetailsMap = new HashMap<ServiceID, JVMDetails>();
    private final Map<ServiceID, OSDetails> _osDetailsMap = new HashMap<ServiceID, OSDetails>();
    private final Map<String, List<ServiceItem>> _spacesMap = new HashMap<String, List<ServiceItem>>();
    private final Map<String, ServiceItem> _gsaMap = new HashMap<String, ServiceItem>(2);
    private final Map<Long, ServiceItem> _gscMap = new HashMap<Long, ServiceItem>();
    private final Map<String, Map<Integer, ServiceItem>> _gsaAgentsMap = new HashMap<String, Map<Integer, ServiceItem>>();
    private final Map<ServiceID, GSAAgentHolder> _gsaAgentsIDsMap = new HashMap<ServiceID, GSAAgentHolder>();
    private final Map<ServiceID, DefaultMutableTreeNode> _spacesNodesMap = new HashMap<ServiceID, DefaultMutableTreeNode>();
    public static final String NO_ZONE = "<No Zone>";
    private Map<String, List<ServiceItem>> _zoneServicesMap = new HashMap<String, List<ServiceItem>>();
    private Map<ServiceID, Set<String>> _servicesZonesMap = new HashMap<ServiceID, Set<String>>();
    private static final Map<IJSpaceContainerAdmin, ContainerConfig> containerAdminMap = new HashMap<IJSpaceContainerAdmin, ContainerConfig>();
    private static HashMap<String, ContainerConfig> containersMap = new HashMap(3);
    private static Map<IJSpaceContainerAdmin, MBeanServerConnection> _mBeanServerConnectionsMap = new HashMap<IJSpaceContainerAdmin, MBeanServerConnection>();
    private static final Map<ServiceID, IRemoteJSpaceAdmin> spaceAdminMap = new HashMap<ServiceID, IRemoteJSpaceAdmin>();
    private static Map<ServiceID, ServiceBeanConfig> puServiceBeanConfigMap = new HashMap<ServiceID, ServiceBeanConfig>();
    private static Map<ServiceID, ServiceElement> serviceElementsMap = new HashMap<ServiceID, ServiceElement>();
    private static Map<ServiceID, ServiceBeanInstance> serviceBeanInstancesMap = new HashMap<ServiceID, ServiceBeanInstance>();
    private static final Map<String, SpaceConfigProperties> _spaceConfigPropertiesMap = new HashMap<String, SpaceConfigProperties>(3);
    private static final Map<IRemoteJSpaceAdmin, SpaceConfig> _spaceConfigsMap = new HashMap<IRemoteJSpaceAdmin, SpaceConfig>();

    public ServiceItem[] getServiceItems() {
        return servicesMap.values().toArray(new ServiceItem[servicesMap.size()]);
    }

    public int getServiceCount() {
        return servicesMap.size();
    }

    public void setProperties(Properties props) {
        if (props != null) {
            this.uiProps.putAll((Map<?, ?>)props);
        }
    }

    public void setProperty(String key, String value) {
        if (key != null && value != null) {
            this.uiProps.put(key, value);
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.uiProps);
        return props;
    }

    public OperationalStringManager getOperationalStringManager(ServiceElement sElem) {
        if (this.treeWorker == null) {
            return null;
        }
        OperationalStringManager opMgr = null;
        DefaultMutableTreeNode oNode = this.treeWorker.getOpStringTreeNode(sElem.getOperationalStringName());
        if (oNode != null) {
            TreeWorker.OpStringHolder osh = (TreeWorker.OpStringHolder)oNode.getUserObject();
            osh.findPrimary();
            opMgr = osh.getPrimary();
        }
        return opMgr;
    }

    public TreeWorker.OpStringHolder getOperationalStringManager(String opStringName) {
        if (this.treeWorker == null) {
            return null;
        }
        TreeWorker.OpStringHolder osh = null;
        DefaultMutableTreeNode oNode = this.treeWorker.getOpStringTreeNode(opStringName);
        if (oNode != null) {
            osh = (TreeWorker.OpStringHolder)oNode.getUserObject();
        }
        return osh;
    }

    public ServiceItem getServiceItem(Uuid uuid) {
        return this.getServiceItem(new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()));
    }

    public ServiceItem getServiceItem(ServiceID serviceID) {
        return servicesMap.get(serviceID);
    }

    public int getNumSLAThresholdEvents(String opStringName) {
        if (this.slaEventTable == null) {
            return 0;
        }
        return this.slaEventTable.getNumEvents(opStringName);
    }

    public int getNumProvisionFailureEvents(String opStringName) {
        if (this.provisionFailureTable == null) {
            return 0;
        }
        return this.provisionFailureTable.getNumEvents(opStringName);
    }

    public static Repository getInstance() {
        return instance;
    }

    private Repository() {
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
    }

    void setTreeWorker(TreeWorker treeWorker) {
        this.treeWorker = treeWorker;
    }

    public TreeWorker getTreeWorker() {
        return this.treeWorker;
    }

    public void setSLAEventTable(SLAEventTable slaEventTable) {
        this.slaEventTable = slaEventTable;
    }

    public SLAEventTable getSLAEventTable() {
        return this.slaEventTable;
    }

    public void setProvisionFailureEventTable(ProvisionFailureEventTable provisionFailureTable) {
        this.provisionFailureTable = provisionFailureTable;
    }

    public ProvisionFailureEventTable getProvisionFailureEventTable() {
        return this.provisionFailureTable;
    }

    public void setUIExceptionTable(UIExceptionTable uiExceptionTable) {
        this.uiExceptionTable = uiExceptionTable;
    }

    public UIExceptionTable getUIExceptionTable() {
        return this.uiExceptionTable;
    }

    public void addLookup(ServiceRegistrar lookup) {
        if (this.haveLookup(lookup)) {
            return;
        }
        lusList.add(lookup);
    }

    public void removeLookup(ServiceRegistrar lookup) {
        lusList.remove(lookup);
        if (lusList.size() == 0) {
            servicesMap.clear();
        }
    }

    public ServiceRegistrar[] getLookups() {
        return lusList.toArray(new ServiceRegistrar[lusList.size()]);
    }

    boolean haveLookup(ServiceRegistrar reg) {
        boolean haveIt = false;
        ServiceRegistrar[] items = this.getLookups();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(reg)) continue;
            haveIt = true;
            break;
        }
        return haveIt;
    }

    public boolean addService(ServiceItem item) {
        if (this.haveService(item)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("> Repository: add service , before return:" + item.serviceID);
            }
            return false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("> Repository: add service:" + item.serviceID);
        }
        this.handleZones(item);
        this.addOsAndJvmInfoProvider(item);
        if (item.service instanceof GSA) {
            this.addGSAServiceItem(item);
        } else if (item.service instanceof GSC) {
            this.addGSCServiceItem(item);
        }
        this.addSpace(item);
        this.addGSAgent(item);
        servicesMap.put(item.serviceID, item);
        if (item.service instanceof ProvisionMonitor) {
            this.addProvisionMonitor(item);
        }
        return false;
    }

    public void addNonJiniManagedService(Object service, String name) {
        if (service instanceof ReferentUuid) {
            ServiceID spaceID = JSpaceUtilities.getServiceID((ReferentUuid)((ReferentUuid)service));
            Name nameAttr = new Name(name);
            ServiceItem serviceItem = new ServiceItem(spaceID, service, new Entry[]{nameAttr});
            this.addService(serviceItem);
            SecurityServicesRepository.getInstance().handleAddedSecuredService(serviceItem);
        }
    }

    private String[] handleZones(ServiceItem serviceItem) {
        String[] zonesArray;
        block9: {
            zonesArray = null;
            HashSet<String> zonesSet = new HashSet<String>();
            try {
                Object service = serviceItem.service;
                if (service instanceof IJSpace) {
                    service = ((IJSpace)service).getAdmin();
                } else if (service instanceof ServiceRegistrar) {
                    service = ((ServiceRegistrar)service).getRegistrar();
                }
                if (service instanceof GridZoneProvider) {
                    GridZoneProvider gridZoneProvider = (GridZoneProvider)service;
                    zonesArray = gridZoneProvider.getZones();
                    if (zonesArray == null) {
                        zonesArray = new String[]{NO_ZONE};
                    }
                    for (String zone : zonesArray) {
                        List<ServiceItem> serviceItemsList = this._zoneServicesMap.get(zone);
                        if (serviceItemsList == null) {
                            serviceItemsList = new ArrayList<ServiceItem>();
                            this._zoneServicesMap.put(zone, serviceItemsList);
                        }
                        zonesSet.add(zone);
                        serviceItemsList.add(serviceItem);
                    }
                    this._servicesZonesMap.put(serviceItem.serviceID, zonesSet);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return zonesArray;
    }

    public List<ServiceItem> getServicesItems(String zone) {
        return this._zoneServicesMap.get(zone) != null ? this._zoneServicesMap.get(zone) : new ArrayList(1);
    }

    public Set<String> getAllZones() {
        return this._zoneServicesMap.keySet();
    }

    public Set<String> getServiceZones(ServiceID serviceID) {
        return this._servicesZonesMap.get(serviceID);
    }

    public boolean isServiceAssociatedWithAnotherZones(ServiceItem serviceItem, Set<String> selectedZones) {
        Set<String> keysSet = this._zoneServicesMap.keySet();
        for (String zone : keysSet) {
            if (!selectedZones.contains(zone)) continue;
            List<ServiceItem> servicesList = this._zoneServicesMap.get(zone);
            for (ServiceItem servItem : servicesList) {
                if (!servItem.serviceID.equals((Object)serviceItem.serviceID)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeServiceFromZonesMap(ServiceItem removedServiceItem) {
        ServiceID removedServiceID = removedServiceItem.serviceID;
        Set<Map.Entry<String, List<ServiceItem>>> entriesSet = this._zoneServicesMap.entrySet();
        Iterator<Map.Entry<String, List<ServiceItem>>> iterator = entriesSet.iterator();
        ArrayList<String> removedZonesList = new ArrayList<String>(this._zoneServicesMap.size());
        while (iterator.hasNext()) {
            Map.Entry<String, List<ServiceItem>> mapEntry = iterator.next();
            List<ServiceItem> serviceItemsList = mapEntry.getValue();
            int listSize = serviceItemsList.size();
            for (int index = listSize - 1; index >= 0; --index) {
                if (!serviceItemsList.get((int)index).serviceID.equals((Object)removedServiceID)) continue;
                serviceItemsList.remove(index);
                if (!serviceItemsList.isEmpty()) continue;
                String zone = mapEntry.getKey();
                removedZonesList.add(zone);
            }
        }
        for (String removedZone : removedZonesList) {
            this._zoneServicesMap.remove(removedZone);
        }
        this._servicesZonesMap.remove(removedServiceItem.serviceID);
    }

    public void removeService(ServiceItem item) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("> Repository: remove service:" + item.serviceID);
        }
        ServiceID serviceID = item.serviceID;
        ServiceItem removedService = servicesMap.remove(serviceID);
        if (item.service instanceof ProvisionMonitor) {
            this.removeProvisionMonitor(item);
        } else if (item.service instanceof GSC) {
            this.removeGSC(item);
        }
        Repository.removeServiceBeanConfig(serviceID);
        Repository.removeServiceBeanInstance(serviceID);
        this.removeSpace(serviceID);
        this.removeSpace(item);
        this._jvmDetailsMap.remove(serviceID);
        this._osDetailsMap.remove(serviceID);
        this.removeGSA(item);
        this.removeGSAAgent(item);
        this.removeServiceFromZonesMap(item);
    }

    public ServiceItem getGSCServiceItem(long pid) {
        return this._gscMap.get(pid);
    }

    private void removeGSC(ServiceItem item) {
        JVMDetails jvmDetails = this.getJVMDetails(item, false);
        long pid = jvmDetails.getPid();
        this._gscMap.remove(pid);
    }

    boolean haveService(ServiceItem item) {
        return servicesMap.containsKey(item.serviceID);
    }

    public void setGSCPanel(GSCPanel gscPanel) {
        this.gscPanel = gscPanel;
    }

    public int getGSCCount() {
        if (this.gscPanel == null) {
            return 0;
        }
        return this.gscPanel.getGSCCount();
    }

    public void updateGSC(String hostAddress, ServiceID removedServiceID) {
        if (this.gscPanel != null) {
            this.gscPanel.update(hostAddress, removedServiceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployAdmin getNextDeployAdmin() {
        DeployAdmin deployAdmin = null;
        LinkedList<ProvisionMonitorHolder> linkedList = this.monitorList;
        synchronized (linkedList) {
            ProvisionMonitorHolder pmh = this.monitorList.removeFirst();
            deployAdmin = pmh.deployAdmin;
            if (this.monitorList.contains(pmh)) {
                this.monitorList.remove(pmh);
            }
            this.monitorList.addLast(pmh);
        }
        return deployAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProvisionMonitor(ServiceItem item) {
        LinkedList<ProvisionMonitorHolder> linkedList = this.monitorList;
        synchronized (linkedList) {
            ProvisionMonitorHolder pmh = new ProvisionMonitorHolder(item);
            if (this.monitorList.contains(pmh)) {
                this.monitorList.remove(pmh);
            }
            this.monitorList.add(pmh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvisionMonitor(ServiceItem item) {
        ProvisionMonitorHolder[] pmh = this.getProvisionMonitorHolders();
        for (int i = 0; i < pmh.length; ++i) {
            if (!pmh[i].item.service.equals(item.service)) continue;
            LinkedList<ProvisionMonitorHolder> linkedList = this.monitorList;
            synchronized (linkedList) {
                this.monitorList.remove(pmh[i]);
                break;
            }
        }
    }

    public int getMonitorCount() {
        return this.monitorList.size();
    }

    public int getManagersCount() {
        int managersCount = 0;
        for (ProvisionMonitorHolder provisionMonitorHolder : this.monitorList) {
            if (!provisionMonitorHolder.hasManagers()) continue;
            ++managersCount;
        }
        return managersCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisionMonitorHolder[] getProvisionMonitorHolders() {
        ProvisionMonitorHolder[] pmh = null;
        LinkedList<ProvisionMonitorHolder> linkedList = this.monitorList;
        synchronized (linkedList) {
            pmh = this.monitorList.toArray(new ProvisionMonitorHolder[this.monitorList.size()]);
        }
        return pmh;
    }

    public ProvisionMonitor getProvisionMonitor() {
        if (this.monitorList.size() > 0) {
            return this.monitorList.get(0).getProvisionMonitor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisionMonitorHolder getProvisionMonitorHolder(ProvisionMonitor provisionMonitor) {
        Object pmh = null;
        LinkedList<ProvisionMonitorHolder> linkedList = this.monitorList;
        synchronized (linkedList) {
            for (ProvisionMonitorHolder provisionMonitorHolder : this.monitorList) {
                if (!provisionMonitorHolder.getProvisionMonitor().equals(provisionMonitor)) continue;
                return provisionMonitorHolder;
            }
        }
        return null;
    }

    public void addSpaceNode(ServiceID serviceID, DefaultMutableTreeNode treeNode) {
        this._spacesNodesMap.put(serviceID, treeNode);
    }

    public void removeSpace(ServiceID serviceID) {
        this._spacesNodesMap.remove(serviceID);
    }

    public DefaultMutableTreeNode getSpaceNode(ServiceID serviceID) {
        return this._spacesNodesMap.get(serviceID);
    }

    public static ContainerConfig getContainerConfig(IJSpaceContainerAdmin containerAdmin) {
        return containerAdminMap.get(containerAdmin);
    }

    public static ContainerConfig addContainerToMap(IJSpaceContainerAdmin admin) throws RemoteException {
        String containerName;
        String containerHostName;
        String containerDisplayName;
        ContainerConfig config = containerAdminMap.get(admin);
        if (config == null) {
            config = admin.getConfig();
            containerAdminMap.put(admin, config);
        }
        if (!containersMap.containsKey(containerDisplayName = JSpaceUtilities.createContainerPresentName((String)(containerHostName = config.containerHostName), (String)(containerName = config.containerName)))) {
            containersMap.put(containerDisplayName, config);
        }
        return config;
    }

    public static void removeContainerConfigFromMap(IJSpaceContainerAdmin admin) {
        containerAdminMap.remove(admin);
    }

    public static MBeanServerConnection getMBeanServerConnection(IJSpaceContainerAdmin admin) throws RemoteException {
        MBeanServerConnection mbeanServerConnection;
        block3: {
            ContainerConfig containerConfig;
            mbeanServerConnection = null;
            if (admin != null && (mbeanServerConnection = _mBeanServerConnectionsMap.get(admin)) == null && (containerConfig = Repository.getContainerConfig(admin)) != null && containerConfig.isJMXEnabled()) {
                String jndiURL = containerConfig.jndiUrl;
                try {
                    mbeanServerConnection = MBeanServerConnectionFactory.createMBeanServerConnection((String)jndiURL);
                    _mBeanServerConnectionsMap.put(admin, mbeanServerConnection);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, "Failed to initilize MBeanServer connection with URL:" + jndiURL, e);
                }
            }
        }
        return mbeanServerConnection;
    }

    public static void removeMBeanServerConnectionFromMap(IJSpaceContainerAdmin admin) {
        _mBeanServerConnectionsMap.remove(admin);
    }

    public static IRemoteJSpaceAdmin addSpaceAdminObjectToMap(IJSpace space) throws RemoteException {
        ServiceID spaceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
        IRemoteJSpaceAdmin spaceAdmin = spaceAdminMap.get(spaceID);
        if (spaceAdmin == null) {
            spaceAdmin = (IRemoteJSpaceAdmin)space.getAdmin();
            spaceAdminMap.put(spaceID, spaceAdmin);
        }
        return spaceAdmin;
    }

    public static IRemoteJSpaceAdmin getSpaceAdmin(ServiceID spaceID) {
        return spaceAdminMap.get(spaceID);
    }

    public static IRemoteJSpaceAdmin removeSpaceAdminObjectFromMap(IJSpace space) {
        ServiceID spaceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
        IRemoteJSpaceAdmin removedSpaceAdminInstance = spaceAdminMap.remove(spaceID);
        Repository.removeSpaceConfigFromMap(removedSpaceAdminInstance);
        return removedSpaceAdminInstance;
    }

    public static void clearSpaceConfigProperties() {
        _spaceConfigPropertiesMap.clear();
    }

    public static SpaceConfigProperties getSpaceConfigProperties(String clusterName) {
        return _spaceConfigPropertiesMap.get(clusterName);
    }

    public static void addSpaceConfigProperties(SpaceConfigProperties spaceConfigProperties, String clusterName) {
        _spaceConfigPropertiesMap.put(clusterName, spaceConfigProperties);
    }

    public static void removeSpaceConfigProperties(String clusterName) {
        _spaceConfigPropertiesMap.remove(clusterName);
    }

    public static SpaceConfig addSpaceConfigToMap(IRemoteJSpaceAdmin spaceAdmin) throws RemoteException {
        SpaceConfig spaceConfig = _spaceConfigsMap.get(spaceAdmin);
        if (spaceConfig == null || spaceConfig.getCachePolicy().equals(String.valueOf(3)) && (spaceConfig.getBlobStoreDevices() == null || spaceConfig.getBlobStoreDevices().trim().length() == 0)) {
            if (spaceAdmin instanceof JSpaceAdminProxy) {
                spaceConfig = ((JSpaceAdminProxy)spaceAdmin).getConfig();
            }
            if (spaceConfig == null) {
                spaceConfig = spaceAdmin.getConfig();
            }
            if (!(spaceAdmin instanceof LRMISpaceImpl)) {
                String clusterName = Repository.handleSpaceConfigProperties(spaceConfig);
                if (clusterName != null) {
                    SpaceConfigProperties spaceConfigProperties = Repository.getSpaceConfigProperties(clusterName);
                    spaceConfigProperties.incrementSpacesCount();
                }
                _spaceConfigsMap.put(spaceAdmin, spaceConfig);
            }
        }
        return spaceConfig;
    }

    private static String handleSpaceConfigProperties(SpaceConfig spaceConfig) {
        SpaceClusterInfo clusterInfo = spaceConfig.getClusterInfo();
        if (!clusterInfo.isClustered()) {
            return null;
        }
        String clusterName = clusterInfo.getClusterName();
        SpaceConfigProperties cachedSpaceConfigProperties = Repository.getSpaceConfigProperties(clusterName);
        if (cachedSpaceConfigProperties != null) {
            ClusterPolicy cachedClusterPolicy = cachedSpaceConfigProperties.getClusterPolicy();
            JSpaceAttributes cachedDCacheProperties = cachedSpaceConfigProperties.getDCacheProperties();
            FiltersInfo[] cachedFiltersInfo = cachedSpaceConfigProperties.getFiltersInfo();
            spaceConfig.setClusterPolicy(cachedClusterPolicy);
            spaceConfig.setDCacheProperties(cachedDCacheProperties);
            spaceConfig.setFiltersInfo(cachedFiltersInfo);
        } else {
            SpaceConfigProperties spaceConfigProperties = new SpaceConfigProperties(spaceConfig.getClusterPolicy(), spaceConfig.getDCacheProperties(), spaceConfig.getFiltersInfo());
            Repository.addSpaceConfigProperties(spaceConfigProperties, clusterName);
        }
        return clusterName;
    }

    public static void removeSpaceConfigFromMap(IRemoteJSpaceAdmin spaceAdmin) {
        SpaceConfigProperties spaceConfigProperties;
        String clusterName;
        SpaceClusterInfo clusterInfo;
        SpaceConfig spaceConfig = _spaceConfigsMap.remove(spaceAdmin);
        if (spaceConfig != null && (clusterInfo = spaceConfig.getClusterInfo()).isClustered() && (clusterName = clusterInfo.getClusterName()) != null && (spaceConfigProperties = Repository.getSpaceConfigProperties(clusterName)).decrementSpacesCount() == 0) {
            Repository.removeSpaceConfigProperties(clusterName);
        }
    }

    public static void clearSpaceConfigs() {
        _spaceConfigsMap.clear();
        Repository.clearSpaceConfigProperties();
    }

    public static void addContainerToMap(ContainerConfig config, String containerDisplayName) {
        containersMap.put(containerDisplayName, config);
    }

    public static void removeContainerConfigFromMap(String containerDisplayName) {
        containersMap.remove(containerDisplayName);
    }

    public static void clearContainersMap() {
        containersMap.clear();
    }

    public static ContainerConfig getContainerConfig(String containerNodeName) {
        return containersMap.get(containerNodeName);
    }

    public static void addServiceBeanConfig(ServiceID serviceID, ServiceBeanConfig serviceBeanConfig) {
        puServiceBeanConfigMap.put(serviceID, serviceBeanConfig);
    }

    public static ServiceBeanConfig getServiceBeanConfig(ServiceID serviceID) {
        return puServiceBeanConfigMap.get(serviceID);
    }

    private static void removeServiceBeanConfig(ServiceID serviceID) {
        puServiceBeanConfigMap.remove(serviceID);
    }

    public static void addServiceElement(ServiceID serviceID, ServiceElement serviceElement) {
        serviceElementsMap.put(serviceID, serviceElement);
    }

    public static ServiceElement getServiceElement(ServiceID serviceID) {
        return serviceElementsMap.get(serviceID);
    }

    private static void removeServiceElement(ServiceID serviceID) {
        serviceElementsMap.remove(serviceID);
    }

    public static void addServiceBeanInstance(ServiceID serviceID, ServiceBeanInstance serviceElement) {
        serviceBeanInstancesMap.put(serviceID, serviceElement);
    }

    public static ServiceBeanInstance getServiceBeanInstance(ServiceID serviceID) {
        return serviceBeanInstancesMap.get(serviceID);
    }

    private static void removeServiceBeanInstance(ServiceID serviceID) {
        serviceBeanInstancesMap.remove(serviceID);
    }

    public void addGSAServiceItem(ServiceItem gsaServiceItem) {
        this._gsaMap.put(gsaServiceItem.serviceID.toString(), gsaServiceItem);
    }

    public void addGSCServiceItem(ServiceItem gscServiceItem) {
        JVMDetails jvmDetails = this.getJVMDetails(gscServiceItem, true);
        this._gscMap.put(jvmDetails.getPid(), gscServiceItem);
    }

    public ServiceItem getGSAServiceItem(String gsaServiceID) {
        return this._gsaMap.get(gsaServiceID);
    }

    public Collection<ServiceItem> getGSAServices() {
        return this._gsaMap.values();
    }

    public void removeGSAAgent(ServiceItem serviceItem) {
        this._gsaAgentsIDsMap.remove(serviceItem.serviceID);
        Object service = serviceItem.service;
        if (service instanceof ServiceRegistrar) {
            service = ((ServiceRegistrar)service).getRegistrar();
        }
        if (service instanceof AgentIdAware) {
            Collection<Map<Integer, ServiceItem>> values = this._gsaAgentsMap.values();
            block0: for (Map<Integer, ServiceItem> gsAgentsMap : values) {
                Set<Map.Entry<Integer, ServiceItem>> entrySet = gsAgentsMap.entrySet();
                for (Map.Entry<Integer, ServiceItem> mapEntry : entrySet) {
                    if (!serviceItem.serviceID.equals((Object)mapEntry.getValue().serviceID)) continue;
                    gsAgentsMap.remove(mapEntry.getKey());
                    continue block0;
                }
            }
        }
    }

    public void removeGSA(ServiceItem serviceItem) {
        if (serviceItem.service instanceof GSA) {
            this._gsaMap.remove(serviceItem.serviceID.toString());
            this._gsaAgentsMap.remove(serviceItem.serviceID.toString());
        }
    }

    private void addSpace(ServiceItem serviceItem) {
        if (serviceItem.service instanceof IJSpace) {
            String spaceName = JSpaceUtilities.retrieveName((Entry[])serviceItem.attributeSets);
            List<ServiceItem> spacesList = this._spacesMap.get(spaceName);
            if (spacesList == null) {
                spacesList = new ArrayList<ServiceItem>();
                this._spacesMap.put(spaceName, spacesList);
            }
            spacesList.add(serviceItem);
        }
    }

    private void removeSpace(ServiceItem removedServiceItem) {
        String spaceName = JSpaceUtilities.retrieveName((Entry[])removedServiceItem.attributeSets);
        List<ServiceItem> spacesList = this._spacesMap.get(spaceName);
        if (spacesList != null) {
            for (ServiceItem serviceItem : spacesList) {
                if (!serviceItem.serviceID.equals((Object)removedServiceItem.serviceID)) continue;
                spacesList.remove(serviceItem);
                break;
            }
        }
    }

    public IJSpace getPrimarySpace(String spaceName) {
        List<ServiceItem> spacesList = this._spacesMap.get(spaceName);
        IJSpace resultSpace = null;
        for (ServiceItem spaceService : spacesList) {
            ServiceID spaceId = spaceService.serviceID;
            SpaceMode spaceMode = PrimaryBackupIndicationListener.getInstance().getSpaceMode(spaceId);
            if (spaceMode == null || spaceMode.equals((Object)SpaceMode.BACKUP)) continue;
            resultSpace = (IJSpace)spaceService.service;
            break;
        }
        return resultSpace;
    }

    private void addGSAgent(ServiceItem serviceItem) {
        block8: {
            Object service = serviceItem.service;
            if (service instanceof ServiceRegistrar) {
                service = ((ServiceRegistrar)service).getRegistrar();
            }
            if (service instanceof AgentIdAware) {
                AgentIdAware agentIdAware = (AgentIdAware)service;
                try {
                    int agentId = agentIdAware.getAgentId();
                    if (agentId >= 0) {
                        String gsaServiceId = agentIdAware.getGSAServiceID();
                        this._gsaAgentsIDsMap.put(serviceItem.serviceID, new GSAAgentHolder(agentId, gsaServiceId));
                        String gsaServiceID = agentIdAware.getGSAServiceID();
                        Map<Integer, ServiceItem> agentsMap = this._gsaAgentsMap.get(gsaServiceID);
                        if (agentsMap == null) {
                            agentsMap = new HashMap<Integer, ServiceItem>();
                            this._gsaAgentsMap.put(gsaServiceID, agentsMap);
                        }
                        agentsMap.put(new Integer(agentId), serviceItem);
                    }
                }
                catch (ConnectException ce) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, ce.toString(), ce);
                    }
                }
                catch (Exception exc) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                    LOGGER.log(Level.SEVERE, exc.toString(), exc);
                }
            }
        }
    }

    public Map<Integer, ServiceItem> getGSAgents(ServiceID gsaServiceID) {
        return this._gsaAgentsMap.get(gsaServiceID.toString());
    }

    public int getGSACount() {
        return this._gsaAgentsMap.size();
    }

    public int getGSAgentID(ServiceID gsAgentServiceID) {
        GSAAgentHolder gsaAgentHolder = this._gsaAgentsIDsMap.get(gsAgentServiceID);
        return gsaAgentHolder == null ? -1 : gsaAgentHolder.getAgentId();
    }

    public GSA getGSAService(ServiceID gsAgentServiceID) {
        String gsaServiceIdStr;
        GSAAgentHolder gsaAgentHolder = this._gsaAgentsIDsMap.get(gsAgentServiceID);
        String string = gsaServiceIdStr = gsaAgentHolder == null ? null : gsaAgentHolder.getGSAServiceId();
        return gsaServiceIdStr == null ? null : (this.getGSAServiceItem(gsaServiceIdStr) == null ? null : (GSA)this.getGSAServiceItem((String)gsaServiceIdStr).service);
    }

    public void addOsAndJvmInfoProvider(ServiceItem serviceItem) {
        block18: {
            ServiceID serviceID;
            Object service;
            block17: {
                block16: {
                    service = serviceItem.service;
                    serviceID = serviceItem.serviceID;
                    if (service instanceof ServiceRegistrar) {
                        service = ((ServiceRegistrar)service).getRegistrar();
                    }
                    if (service instanceof IJSpace) {
                        try {
                            service = ((IJSpace)service).getAdmin();
                        }
                        catch (ConnectException ce) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, ce.toString(), ce);
                            }
                        }
                        catch (Exception exc) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block16;
                            LOGGER.log(Level.SEVERE, exc.toString(), exc);
                        }
                    }
                }
                if (service instanceof JVMInfoProvider) {
                    JVMInfoProvider jvmInfoProvider = (JVMInfoProvider)service;
                    try {
                        JVMDetails jvmDetails = jvmInfoProvider.getJVMDetails();
                        this._jvmDetailsMap.put(serviceID, jvmDetails);
                    }
                    catch (ConnectException ce) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, ce.toString(), ce);
                        }
                    }
                    catch (Exception exc) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block17;
                        LOGGER.log(Level.SEVERE, exc.toString(), exc);
                    }
                }
            }
            if (service instanceof OSInfoProvider) {
                OSInfoProvider osInfoProvider = (OSInfoProvider)service;
                try {
                    OSDetails osDetails = osInfoProvider.getOSDetails();
                    this._osDetailsMap.put(serviceID, osDetails);
                }
                catch (ConnectException ce) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, ce.toString(), ce);
                    }
                }
                catch (Exception exc) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block18;
                    LOGGER.log(Level.SEVERE, exc.toString(), exc);
                }
            }
        }
    }

    public JVMDetails getJVMDetails(ServiceItem serviceItem, boolean initIfNeeded) {
        JVMDetails jvmDetails = this._jvmDetailsMap.get(serviceItem.serviceID);
        if (jvmDetails == null && initIfNeeded) {
            this.addOsAndJvmInfoProvider(serviceItem);
            jvmDetails = this._jvmDetailsMap.get(serviceItem.serviceID);
        }
        return jvmDetails;
    }

    public JVMDetails getJVMDetails(ServiceID serviceID) {
        return this._jvmDetailsMap.get(serviceID);
    }

    public OSDetails getOSDetails(ServiceItem serviceItem, boolean initIfNeeded) {
        OSDetails osDetails = this._osDetailsMap.get(serviceItem.serviceID);
        if (osDetails == null && initIfNeeded) {
            this.addOsAndJvmInfoProvider(serviceItem);
            osDetails = this._osDetailsMap.get(serviceItem.serviceID);
        }
        return osDetails;
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
    }

    private static class SpaceConfigProperties {
        private ClusterPolicy _clusterPolicy;
        private JSpaceAttributes _dCacheProperties;
        private FiltersInfo[] _filtersInfo;
        private int _spacesCount = 0;

        public SpaceConfigProperties(ClusterPolicy clusterPolicy, JSpaceAttributes dCacheProperties, FiltersInfo[] filtersInfo) {
            this._clusterPolicy = clusterPolicy;
            this._dCacheProperties = dCacheProperties;
            this._filtersInfo = filtersInfo;
        }

        public void incrementSpacesCount() {
            ++this._spacesCount;
        }

        public int decrementSpacesCount() {
            --this._spacesCount;
            return this._spacesCount;
        }

        public ClusterPolicy getClusterPolicy() {
            return this._clusterPolicy;
        }

        public JSpaceAttributes getDCacheProperties() {
            return this._dCacheProperties;
        }

        public FiltersInfo[] getFiltersInfo() {
            return this._filtersInfo;
        }
    }

    public class ProvisionMonitorHolder {
        ServiceItem item;
        ProvisionMonitor monitor;
        ProvisionMonitorAdmin admin;
        DeployAdmin deployAdmin;
        Collection<XapManagerConfig> xapManagerConfigs = Collections.EMPTY_LIST;
        boolean isSecured = false;

        ProvisionMonitorHolder(ServiceItem item) {
            this.item = item;
            this.monitor = (ProvisionMonitor)item.service;
            try {
                this.admin = (ProvisionMonitorAdmin)this.monitor.getAdmin();
                this.deployAdmin = this.admin;
                this.isSecured = ((SecuredService)this.monitor).isServiceSecured();
                if (this.monitor instanceof GSM) {
                    GSM gsm = (GSM)this.monitor;
                    JVMDetails jvmDetails = gsm.getJVMDetails();
                    Map environmentVariables = jvmDetails.getEnvironmentVariables();
                    String managerServers = (String)environmentVariables.get("XAP_MANAGER_SERVERS");
                    this.xapManagerConfigs = XapManagerClusterInfo.parseServersEnvVar((String)managerServers);
                }
            }
            catch (Exception e) {
                UIHelper.showError((Throwable)e, "Getting remote GSM objects");
            }
        }

        public boolean isSecured() {
            return this.isSecured;
        }

        public boolean isManaging() {
            try {
                return this.monitor.isManaging();
            }
            catch (RemoteException e) {
                return false;
            }
        }

        public ServiceItem getServiceItem() {
            return this.item;
        }

        public boolean hasManagers() {
            return !this.xapManagerConfigs.isEmpty();
        }

        public Iterator<XapManagerConfig> getManagers() {
            return this.xapManagerConfigs.iterator();
        }

        public ProvisionMonitor getProvisionMonitor() {
            return this.monitor;
        }

        public DeployAdmin getDeployAdmin() {
            return this.deployAdmin;
        }

        public void reload() throws RemoteException {
            this.admin = (ProvisionMonitorAdmin)this.monitor.getAdmin();
            this.deployAdmin = this.admin;
        }

        private Repository getOuterType() {
            return Repository.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.item == null ? 0 : this.item.serviceID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProvisionMonitorHolder other = (ProvisionMonitorHolder)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.item == null ? other.item.serviceID != null : !this.item.serviceID.equals((Object)other.item.serviceID));
        }
    }

    public static class GSAAgentHolder {
        private int _agentId;
        private String _gsaServiceId;

        public GSAAgentHolder(int agentId, String gsaServiceId) {
            this._gsaServiceId = gsaServiceId;
            this._agentId = agentId;
        }

        public int getAgentId() {
            return this._agentId;
        }

        public String getGSAServiceId() {
            return this._gsaServiceId;
        }
    }
}

