/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.ui.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.jini.config.Configuration;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.SLA;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.event.BasicEventConsumer;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.qos.SLAThresholdEvent;
import org.jini.rio.watch.Calculable;

public class SLAEventTable
extends JPanel {
    private final JTable eventTable;
    private final SLAEventModel dataModel;
    private final SLAThresholdEventConsumer slaConsumer;
    private final BasicEventConsumer eventConsumer;
    JTabbedPane tabbedPane;
    Component tabComponent;
    private final ImageIcon newItemIcon;
    private final JScrollPane scroller;
    Observatory observatory;
    private JFrame _parentFrame;

    public SLAEventTable(JFrame parentFrame, Configuration config) throws Exception {
        this._parentFrame = parentFrame;
        this.setLayout(new BorderLayout());
        this.newItemIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/error.gif");
        this.eventTable = new JTable();
        this.eventTable.addMouseListener(new RowListener());
        this.dataModel = new SLAEventModel();
        this.eventTable.setModel(this.dataModel);
        this.eventTable.setAutoResizeMode(3);
        TableColumnModel cm = this.eventTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(120);
        cm.getColumn(0).setMaxWidth(200);
        cm.getColumn(1).setPreferredWidth(100);
        cm.getColumn(1).setMaxWidth(200);
        cm.getColumn(2).setPreferredWidth(120);
        cm.getColumn(2).setMaxWidth(200);
        cm.getColumn(3).setPreferredWidth(100);
        cm.getColumn(3).setMaxWidth(300);
        this.scroller = new JScrollPane(this.eventTable);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.add((Component)this.scroller, "Center");
        JPanel buttons = new JPanel();
        JButton details = new JButton("Details");
        details.setToolTipText("Get details on the selected SLAThresholdEvent");
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = SLAEventTable.this.eventTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                SLAEventTable.this.showDetails(SLAEventTable.this.getEvent(row));
            }
        });
        JButton remove = new JButton("Delete");
        remove.setToolTipText("Delete the selected SLAThresholdEvent");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = SLAEventTable.this.eventTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                SLAEventTable.this.removeEvent(row);
            }
        });
        JButton clear = new JButton("Clear All");
        clear.setToolTipText("Clear all SLAThresholdEvent items");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int rows = SLAEventTable.this.eventTable.getRowCount();
                if (rows == 0) {
                    return;
                }
                if (SLAEventTable.this.tabComponent != null && SLAEventTable.this.tabbedPane.indexOfComponent(SLAEventTable.this.tabComponent) >= 0) {
                    SLAEventTable.this.tabbedPane.setIconAt(SLAEventTable.this.tabbedPane.indexOfComponent(SLAEventTable.this.tabComponent), null);
                }
                ((SLAEventTable)SLAEventTable.this).dataModel.tableData.clear();
                SLAEventTable.this.dataModel.fireTableDataChanged();
            }
        });
        buttons.add(details);
        buttons.add(remove);
        buttons.add(clear);
        this.add((Component)buttons, "South");
        this.slaConsumer = new SLAThresholdEventConsumer();
        this.eventConsumer = new BasicEventConsumer(SLAThresholdEvent.getEventDescriptor(), (RemoteServiceEventListener)this.slaConsumer, null, config);
        this.handleEnterKeyEvents();
    }

    public synchronized void addObserver(Observer observer) {
        this.getObservatory().addObserver(observer);
    }

    public Observatory getObservatory() {
        if (this.observatory == null) {
            this.observatory = new Observatory();
        }
        return this.observatory;
    }

    public void setTab(JTabbedPane tabbedPane, Component tabComponent) {
        this.tabbedPane = tabbedPane;
        this.tabComponent = tabComponent;
    }

    public void removeEvent(int row) {
        this.dataModel.removeItem(row);
    }

    public SLAThresholdEvent getEvent(int row) {
        if (row == -1) {
            return null;
        }
        return (SLAThresholdEvent)this.dataModel.getItem(row);
    }

    public void addService(ServiceItem item) {
        this.eventConsumer.register(item);
    }

    public void removeService(ServiceID serviceID) {
        this.eventConsumer.deregister(serviceID);
    }

    public void terminate() {
        if (this.eventConsumer != null) {
            this.eventConsumer.terminate();
        }
    }

    public int getNumEvents() {
        return this.dataModel.getRowCount();
    }

    public int getNumEvents(String opStringName) {
        return this.dataModel.getRowCount(opStringName);
    }

    void showDetails(SLAThresholdEvent event) {
        ServiceElement sElem = event.getServiceElement();
        SLA sla = event.getSLA();
        Calculable calculable = event.getCalculable();
        String sb = "<html><h3><font color=black>SLAThresholdEvent Details</font></h3><table BORDER COLS=2><tr><td><font color=black>Identifier</font></td><td><font color=blue>" + sla.getIdentifier() + "</font></td></tr><tr><td><font color=black>Type</font></td><td><font color=blue>" + (event.getType() == 0 ? "BREACHED" : "CLEARED") + "</font></td></tr><tr><td><font color=black>Time</font></td><td><font color=blue>" + event.getTime() + "</font></td></tr><tr><td><font color=black>Service Name</font></td><td><font color=blue>" + sElem.getName() + "</font></td></tr><tr><td><font color=black>Service Class</font></td><td><font color=blue>" + this.getClassNames(sElem) + "</font></td></tr><tr><td><font color=black>Host Address</font></td><td><font color=blue>" + event.getHostAddress() + "</font></td></tr><tr><td><font color=black>Value</font></td><td><font color=blue>" + calculable.getValue() + "</font></td></tr><tr><td><font color=black>Low Threshold</font></td><td><font color=blue>" + sla.getCurrentLowThreshold() + "</font></td></tr><tr><td><font color=black>High Threshold</font></td><td><font color=blue>" + sla.getCurrentHighThreshold() + "</font></td></tr><tr><td><font color=black>SLA Policy Handler Class</font></td><td><font color=blue>" + event.getSLAPolicyHandlerDescription() + "</font></td></tr></table></html>";
        JOptionPane.showMessageDialog(this._parentFrame, sb, "SLA Threshold Event Details", 1);
    }

    private void handleEnterKeyEvents() {
        KeyStroke stroke = KeyStroke.getKeyStroke("ENTER");
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int selRow = SLAEventTable.this.eventTable.getSelectedRow();
                if (selRow >= 0) {
                    SLAEventTable.this.showDetails(SLAEventTable.this.getEvent(selRow));
                }
            }
        };
        InputMap inputMap = this.eventTable.getInputMap(0);
        inputMap.put(stroke, "ENTER");
        this.eventTable.getActionMap().put("ENTER", actionListener);
    }

    String getClassNames(ServiceElement sElem) {
        StringBuilder buffer = new StringBuilder();
        ClassBundle[] bundles = sElem.getExportBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(bundles[i].getClassName());
        }
        return buffer.toString();
    }

    String scrub(String input) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(input, "\n");
        if (st.countTokens() == 0) {
            return input;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    class RowListener
    extends MouseAdapter {
        RowListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clickCount = e.getClickCount();
            if (SLAEventTable.this.tabComponent != null && SLAEventTable.this.tabbedPane.indexOfComponent(SLAEventTable.this.tabComponent) >= 0) {
                SLAEventTable.this.tabbedPane.setIconAt(SLAEventTable.this.tabbedPane.indexOfComponent(SLAEventTable.this.tabComponent), null);
            }
            if (clickCount == 2) {
                int row = SLAEventTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                if (row == -1) {
                    return;
                }
                SLAEventTable.this.showDetails(SLAEventTable.this.getEvent(row));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        void maybeShowPopup(final MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem delete = new JMenuItem("Delete");
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int row = SLAEventTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                        SLAEventTable.this.removeEvent(row);
                    }
                });
                JMenuItem details = new JMenuItem("Details");
                details.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int row = SLAEventTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                        SLAEventTable.this.showDetails(SLAEventTable.this.getEvent(row));
                    }
                });
                popup.add(delete);
                popup.addSeparator();
                popup.add(details);
                popup.pack();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class SLAEventModel
    extends AbstractTableModel {
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Time", "Service Name", "Deployment Descriptor", "SLA ID", "Type", "Value", "Minimum", "Maximum"};

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                SLAThresholdEvent event = (SLAThresholdEvent)this.tableData.elementAt(index);
                ServiceElement sElem = event.getServiceElement();
                SLA sla = event.getSLA();
                Calculable calculable = event.getCalculable();
                switch (columnIndex) {
                    case 0: {
                        return event.getTime().toString();
                    }
                    case 1: {
                        String s = sElem.getName();
                        Long iId = sElem.getServiceBeanConfig().getInstanceID();
                        if (iId > 0L) {
                            s = s + " [" + iId + "]";
                        }
                        return s;
                    }
                    case 2: {
                        return sElem.getOperationalStringName();
                    }
                    case 3: {
                        return sla.getIdentifier();
                    }
                    case 4: {
                        return event.getType() == 0 ? "BREACHED" : "CLEARED";
                    }
                    case 5: {
                        return calculable.getValue();
                    }
                    case 6: {
                        return event.getThresholdValues().getCurrentLowThreshold();
                    }
                    case 7: {
                        return event.getThresholdValues().getCurrentHighThreshold();
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.add(rowNum, item);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.remove(row);
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.get(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        public int getRowCount(String opstring) {
            int num = 0;
            SLAThresholdEvent[] events = this.tableData.toArray(new SLAThresholdEvent[this.tableData.size()]);
            for (int i = 0; i < events.length; ++i) {
                if (!events[i].getServiceElement().getOperationalStringName().equals(opstring)) continue;
                ++num;
            }
            return num;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }

    class SLAThresholdEventConsumer
    implements RemoteServiceEventListener {
        SLAThresholdEventConsumer() {
        }

        public void notify(RemoteServiceEvent event) {
            try {
                SLAEventTable.this.dataModel.addItem(event);
                SLAEventTable.this.dataModel.fireTableDataChanged();
                if (SLAEventTable.this.newItemIcon != null && SLAEventTable.this.tabComponent != null && SLAEventTable.this.tabbedPane.indexOfComponent(SLAEventTable.this.tabComponent) >= 0) {
                    SLAEventTable.this.tabbedPane.setIconAt(SLAEventTable.this.tabbedPane.indexOfComponent(SLAEventTable.this.tabComponent), SLAEventTable.this.newItemIcon);
                }
                Rectangle lastCell = SLAEventTable.this.eventTable.getCellRect(SLAEventTable.this.eventTable.getRowCount(), 0, true);
                SLAEventTable.this.scroller.getViewport().scrollRectToVisible(lastCell);
                SLAEventTable.this.getObservatory().stateChange();
            }
            catch (Throwable t) {
                UIHelper.showError(t, "Notification of a SLAThresholdvent");
            }
        }
    }

    class Observatory
    extends Observable {
        Observatory() {
        }

        void stateChange() {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

