/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.dump.InternalDumpDownloadListener;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.tools.cluster.FileFilterExt;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jini.core.lookup.ServiceID;

public class ServicesDumpDialog
extends EscapeDialog
implements ActionListener,
InternalDumpDownloadListener {
    private JButton _executeButton;
    private JButton _closeButton;
    private static JFileChooser _fileChooser;
    protected JTextField _zipFilePathTextField = new JTextField();
    protected JTextField _causeTextField = new JTextField();
    private final int _componentHeight = 22;
    private JCheckBox _threadsDumpCheckBox;
    private JCheckBox _networkDumpCheckBox;
    private JCheckBox _heapDumpCheckBox;
    private JCheckBox _logsDumpCheckBox;
    private JCheckBox _onlyLiveServicesLogsDumpCheckBox;
    private JCheckBox _pusDumpCheckBox;
    private JProgressBar _progressBar = new JProgressBar();
    private JLabel _explLabel = new JLabel();
    private String _curServiceName = "";
    private AtomicInteger _fileSize;
    private AtomicInteger _generateGlobalCounter;
    private static final String SERVICES_ARE_NOT_AVAILABLE_MESSAGE = "Dump cannot be generated because the required services are not available.";
    private int _currentDownloadProgressValue = 0;
    private DumpProviderWrapper[] _dumpProviderWrappers;
    private final Dimension _labelSize = new Dimension(160, 22);
    private final Dimension _buttonSize = new Dimension(90, 22);
    private final Dimension _textFieldSize = new Dimension(500, 23);
    private static final Pattern causePattern;
    private ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private boolean _isMachineServicesDumpSelected;
    private static final Logger LOGGER;
    private Component _progressBarBox;

    public ServicesDumpDialog(JFrame parentFrame, boolean isMachineServicesDumpSelected, DumpProviderWrapper ... dumpProviderWrappers) {
        super(parentFrame, false);
        if (dumpProviderWrappers.length == 1) {
            this.setTitle("Generate " + dumpProviderWrappers[0].getDescr() + " service Dump");
        } else {
            this.setTitle("Generate Services Dump");
        }
        this._isMachineServicesDumpSelected = isMachineServicesDumpSelected;
        this._dumpProviderWrappers = dumpProviderWrappers;
        this.init();
        this.setLocationRelativeTo(parentFrame);
    }

    private void init() {
        Container contentPane = this.getContentPane();
        Box buttonsBox = this.createButtonsBox();
        Box centralBox = new Box(1);
        centralBox.add(Box.createVerticalStrut(3));
        centralBox.add(this.createZipFilePathBox());
        centralBox.add(Box.createVerticalStrut(5));
        centralBox.add(this.createCauseBox());
        centralBox.add(Box.createVerticalStrut(5));
        centralBox.add(this.createDumpOptionsBox());
        centralBox.add(Box.createVerticalStrut(15));
        this._progressBarBox = this.createProgressBarBox();
        centralBox.add(this._progressBarBox);
        this._progressBarBox.setVisible(false);
        centralBox.add(Box.createVerticalStrut(40));
        centralBox.add(new JSeparator());
        if (this.hasSecuredNotAuthenticatedService()) {
            String cbText = "";
            if (this._dumpProviderWrappers.length == 1) {
                boolean hasMonitorPUPermission = JSpaceUIUtils.hasPermittedPermission((SecuredService)this._dumpProviderWrappers[0].getDumpProvider(), this._dumpProviderWrappers[0].getServiceId(), (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, true);
                if (!hasMonitorPUPermission) {
                    this._pusDumpCheckBox.setSelected(false);
                    this._pusDumpCheckBox.setEnabled(false);
                }
                cbText = "<HTML>You do not have sufficient permissions to generate a processing unit dump for the selected service. ";
            } else {
                cbText = "<HTML>You do not have sufficient permissions to generate the requested service dumps for (some of) the selected service.<BR>";
            }
            cbText = cbText + "This operation requires the <FONT color=\"blue\">&lt;" + MonitorAuthority.MonitorPrivilege.MONITOR_JVM + "&gt;</FONT> / <FONT color=\"blue\">&lt;" + MonitorAuthority.MonitorPrivilege.MONITOR_PU + "&gt;</FONT> permission(s).</HTML>";
            JLabel securityWarningLabel = new JLabel(cbText, IconsRepository.getInstance().getIcon(100), 10);
            securityWarningLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 2, 3), BorderFactory.createTitledBorder("")));
            contentPane.add((Component)securityWarningLabel, "North");
        }
        contentPane.add((Component)centralBox, "Center");
        contentPane.add((Component)buttonsBox, "South");
        int width = 650;
        if (this.hasSecuredNotAuthenticatedService()) {
            this.setSize(650, 410);
        } else {
            this.setSize(650, 360);
        }
    }

    private boolean hasSecuredNotAuthenticatedService() {
        boolean hasSecuredNotAuthenticatedService = false;
        for (DumpProviderWrapper dumpProviderWrapper : this._dumpProviderWrappers) {
            if (!dumpProviderWrapper.isSecured()) continue;
            SecuredService securedService = (SecuredService)dumpProviderWrapper.getDumpProvider();
            ServiceID serviceId = dumpProviderWrapper.getServiceId();
            boolean hasMonitorJVMPermission = JSpaceUIUtils.hasPermittedPermission(securedService, serviceId, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, true);
            boolean hasMonitorPUPermission = JSpaceUIUtils.hasPermittedPermission(securedService, serviceId, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, true);
            if (hasMonitorJVMPermission && hasMonitorPUPermission) continue;
            hasSecuredNotAuthenticatedService = true;
            break;
        }
        return hasSecuredNotAuthenticatedService;
    }

    private Component createProgressBarBox() {
        Dimension labelSize = new Dimension(580, 20);
        Dimension progressBarSize = new Dimension(640, 20);
        this._explLabel.setPreferredSize(labelSize);
        this._explLabel.setMaximumSize(labelSize);
        this._explLabel.setMinimumSize(labelSize);
        this._progressBar.setPreferredSize(progressBarSize);
        this._progressBar.setMaximumSize(progressBarSize);
        this._progressBar.setMinimumSize(progressBarSize);
        Box vertBox = new Box(1);
        Box labelBox = new Box(0);
        labelBox.add(Box.createHorizontalStrut(3));
        labelBox.add(this._explLabel);
        labelBox.add(Box.createHorizontalGlue());
        Box progressBarBox = new Box(0);
        progressBarBox.add(Box.createHorizontalStrut(3));
        progressBarBox.add(this._progressBar);
        progressBarBox.add(Box.createHorizontalStrut(3));
        vertBox.add(Box.createHorizontalStrut(2));
        vertBox.add(labelBox);
        vertBox.add(Box.createHorizontalStrut(2));
        vertBox.add(progressBarBox);
        vertBox.add(Box.createHorizontalStrut(2));
        this.setProgressBarMinVal(0);
        return vertBox;
    }

    private Component createDumpOptionsBox() {
        Box logsDumpBox = new Box(0);
        Box onlyLiveServicesLogsBox = null;
        Box threadsDumpBox = new Box(0);
        Box networkDumpBox = new Box(0);
        Box pusDumpBox = new Box(0);
        Box heapDumpBox = new Box(0);
        this._threadsDumpCheckBox = new JCheckBox("JVM Thread Dump", true);
        this._networkDumpCheckBox = new JCheckBox("Network Dump", true);
        this._logsDumpCheckBox = new JCheckBox("Log Dump", true);
        this._pusDumpCheckBox = new JCheckBox("Processing Unit Dump", true);
        this._heapDumpCheckBox = new JCheckBox("JVM Heap Dump", false);
        JLabel heapDumpExplanationLabel = new JLabel("(Note that this operation consumes a lot of resources and may take a while to complete)");
        Font curFont = heapDumpExplanationLabel.getFont();
        heapDumpExplanationLabel.setFont(new Font(curFont.getName(), curFont.getStyle(), curFont.getSize() - 1));
        logsDumpBox.add(Box.createHorizontalStrut(3));
        logsDumpBox.add(this._logsDumpCheckBox);
        logsDumpBox.add(Box.createHorizontalGlue());
        if (this._isMachineServicesDumpSelected) {
            onlyLiveServicesLogsBox = new Box(0);
            this._onlyLiveServicesLogsDumpCheckBox = new JCheckBox("Only Live Services Log Dump", true);
            onlyLiveServicesLogsBox.add(Box.createHorizontalStrut(25));
            onlyLiveServicesLogsBox.add(this._onlyLiveServicesLogsDumpCheckBox);
            onlyLiveServicesLogsBox.add(Box.createHorizontalGlue());
        }
        threadsDumpBox.add(Box.createHorizontalStrut(3));
        threadsDumpBox.add(this._threadsDumpCheckBox);
        threadsDumpBox.add(Box.createHorizontalGlue());
        networkDumpBox.add(Box.createHorizontalStrut(3));
        networkDumpBox.add(this._networkDumpCheckBox);
        networkDumpBox.add(Box.createHorizontalGlue());
        pusDumpBox.add(Box.createHorizontalStrut(3));
        pusDumpBox.add(this._pusDumpCheckBox);
        pusDumpBox.add(Box.createHorizontalGlue());
        heapDumpBox.add(Box.createHorizontalStrut(3));
        heapDumpBox.add(this._heapDumpCheckBox);
        heapDumpBox.add(Box.createHorizontalStrut(3));
        heapDumpBox.add(heapDumpExplanationLabel);
        heapDumpBox.add(Box.createHorizontalGlue());
        this._logsDumpCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ServicesDumpDialog.this._onlyLiveServicesLogsDumpCheckBox != null) {
                    ServicesDumpDialog.this._onlyLiveServicesLogsDumpCheckBox.setEnabled(ServicesDumpDialog.this._logsDumpCheckBox.isSelected());
                }
            }
        });
        Box vertBox = new Box(1);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(threadsDumpBox);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(networkDumpBox);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(logsDumpBox);
        if (onlyLiveServicesLogsBox != null) {
            vertBox.add(Box.createVerticalStrut(3));
            vertBox.add(onlyLiveServicesLogsBox);
        }
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(pusDumpBox);
        vertBox.add(Box.createVerticalStrut(3));
        vertBox.add(heapDumpBox);
        vertBox.add(Box.createVerticalStrut(1));
        vertBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), BorderFactory.createTitledBorder("Select Dump Types")));
        return vertBox;
    }

    private Box createButtonsBox() {
        Box vertBox = new Box(1);
        Box horizontalBox = new Box(0);
        this._executeButton = new JButton("Generate");
        this._closeButton = new JButton("Close");
        this._executeButton.setMnemonic('G');
        this._closeButton.setMnemonic('C');
        this._executeButton.setPreferredSize(this._buttonSize);
        this._closeButton.setPreferredSize(this._buttonSize);
        this._executeButton.setMinimumSize(this._buttonSize);
        this._closeButton.setMinimumSize(this._buttonSize);
        this._executeButton.addActionListener(this);
        this._closeButton.addActionListener(this);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(this._executeButton);
        horizontalBox.add(Box.createHorizontalStrut(17));
        horizontalBox.add(this._closeButton);
        horizontalBox.add(Box.createHorizontalGlue());
        vertBox.add(Box.createVerticalStrut(10));
        vertBox.add(horizontalBox);
        vertBox.add(Box.createVerticalStrut(10));
        return vertBox;
    }

    protected Box createCauseBox() {
        JLabel explLabel = new JLabel("Cause for dump retrieval:");
        explLabel.setPreferredSize(this._labelSize);
        explLabel.setMaximumSize(this._labelSize);
        explLabel.setMinimumSize(this._labelSize);
        this._causeTextField.setPreferredSize(this._textFieldSize);
        this._causeTextField.setMaximumSize(this._textFieldSize);
        Box causeBox = new Box(0);
        causeBox.add(Box.createHorizontalStrut(3));
        causeBox.add(explLabel);
        causeBox.add(Box.createHorizontalStrut(3));
        causeBox.add(this._causeTextField);
        causeBox.add(Box.createHorizontalStrut(3));
        return causeBox;
    }

    protected Box createZipFilePathBox() {
        JLabel explLabel = new JLabel("Dump zip file location:");
        explLabel.setPreferredSize(this._labelSize);
        explLabel.setMaximumSize(this._labelSize);
        explLabel.setMinimumSize(this._labelSize);
        this._zipFilePathTextField.setPreferredSize(this._textFieldSize);
        this._zipFilePathTextField.setMaximumSize(this._textFieldSize);
        JButton browseButton = new JButton("...");
        Dimension browseButtonSize = new Dimension(22, 22);
        browseButton.setPreferredSize(browseButtonSize);
        browseButton.setMaximumSize(browseButtonSize);
        browseButton.setMinimumSize(browseButtonSize);
        Box zipFileBox = new Box(0);
        zipFileBox.add(Box.createHorizontalStrut(3));
        zipFileBox.add(explLabel);
        zipFileBox.add(Box.createHorizontalStrut(3));
        zipFileBox.add(this._zipFilePathTextField);
        zipFileBox.add(Box.createHorizontalStrut(2));
        zipFileBox.add(browseButton);
        zipFileBox.add(Box.createHorizontalStrut(3));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (_fileChooser == null) {
                    try {
                        ServicesDumpDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        _fileChooser = new JFileChooser(SystemInfo.singleton().getXapHome());
                        FileFilterExt zipFilter = new FileFilterExt("zip", "Zip file");
                        _fileChooser.addChoosableFileFilter(zipFilter);
                    }
                    finally {
                        ServicesDumpDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                int state = _fileChooser.showDialog(ServicesDumpDialog.this, "Select");
                File file = _fileChooser.getSelectedFile();
                if (file != null && state == 0) {
                    ServicesDumpDialog.this._zipFilePathTextField.setText(file.getPath());
                    ServicesDumpDialog.this._zipFilePathTextField.setToolTipText(file.getPath());
                }
            }
        });
        return zipFileBox;
    }

    private void processRetrievingDump() {
        final int dumpProvidersAmount = this._dumpProviderWrappers.length;
        if (dumpProvidersAmount == 0) {
            this._progressBarBox.setVisible(true);
            this.setProgressBarText(SERVICES_ARE_NOT_AVAILABLE_MESSAGE);
            return;
        }
        this._executeButton.setEnabled(false);
        this.resetProgressBar();
        this._progressBarBox.setVisible(true);
        this.setProgressBarValue(0);
        this.setProgressBarText("Generating dump...");
        this._generateGlobalCounter = new AtomicInteger(0);
        this._fileSize = new AtomicInteger(0);
        final String[] dumpOptions = this.getDumpOptions();
        final ArrayList failedDumpsList = new ArrayList();
        Thread processRetrieveDumpThread = new Thread(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                block10: {
                    String zipFilePath = ServicesDumpDialog.this._zipFilePathTextField.getText();
                    if (!zipFilePath.toLowerCase().endsWith(".zip")) {
                        zipFilePath = zipFilePath + ".zip";
                    }
                    File zipFile = new File(zipFilePath);
                    try {
                        void var9_14;
                        ServicesDumpDialog.this.setProgressBarMaxVal(dumpProvidersAmount);
                        final ArrayList dumpResultsList = new ArrayList(dumpProvidersAmount);
                        final ArrayList dumpProviderWrappersList = new ArrayList(dumpProvidersAmount);
                        final String cause = ServicesDumpDialog.this._causeTextField.getText();
                        ExecutorService threadPool = Executors.newFixedThreadPool(dumpProvidersAmount);
                        ArrayList futuresList = new ArrayList(dumpProvidersAmount);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Begining generating dump ...");
                        }
                        for (final DumpProviderWrapper dumpProviderWrapper : ServicesDumpDialog.this._dumpProviderWrappers) {
                            Runnable generateDumpThread = new Runnable(){

                                @Override
                                public void run() {
                                    block6: {
                                        InternalDumpProvider dumpProvider = dumpProviderWrapper.getDumpProvider();
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Begining generating dump from " + dumpProviderWrapper.getHostName() + " " + dumpProviderWrapper.getDescr() + "...");
                                        }
                                        try {
                                            InternalDumpResult dumpResult = dumpProvider.generateDump(cause, null, dumpOptions);
                                            if (LOGGER.isLoggable(Level.FINE)) {
                                                LOGGER.log(Level.FINE, "After generating dump from " + dumpProviderWrapper.getHostName() + " " + dumpProviderWrapper.getDescr() + "...");
                                            }
                                            int index = ServicesDumpDialog.this._generateGlobalCounter.incrementAndGet();
                                            ServicesDumpDialog.this.setProgressBarValue(index);
                                            dumpResultsList.add(dumpResult);
                                            dumpProviderWrappersList.add(dumpProviderWrapper);
                                            ServicesDumpDialog.this._fileSize.set(ServicesDumpDialog.this._fileSize.get() + (int)(dumpResult.downloadSize() / 1024L));
                                        }
                                        catch (AuthenticationException ae) {
                                            if (LOGGER.isLoggable(Level.WARNING)) {
                                                LOGGER.log(Level.WARNING, "Authentication fails for " + dumpProviderWrapper.getDescr() + "\n" + ae.toString(), ae);
                                            }
                                            failedDumpsList.add(dumpProviderWrapper);
                                        }
                                        catch (Exception re) {
                                            if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                                            LOGGER.log(Level.SEVERE, re.toString(), re);
                                        }
                                    }
                                }
                            };
                            futuresList.add(threadPool.submit(generateDumpThread));
                        }
                        for (Future future : futuresList) {
                            future.get();
                        }
                        int listSize = dumpProviderWrappersList.size();
                        int n = listSize - 1;
                        while (var9_14 >= 0) {
                            DumpProviderWrapper dumpProviderWrapper = (DumpProviderWrapper)dumpProviderWrappersList.get((int)var9_14);
                            if (dumpProviderWrapper.isLUS() && ServicesDumpDialog.this.hasFailedGSM(failedDumpsList, dumpProviderWrapper.getPid())) {
                                dumpResultsList.remove((int)var9_14);
                                dumpProviderWrappersList.remove((int)var9_14);
                            }
                            --var9_14;
                        }
                        listSize = dumpResultsList.size();
                        if (listSize == 0) {
                            ServicesDumpDialog.this.setProgressBarText(ServicesDumpDialog.SERVICES_ARE_NOT_AVAILABLE_MESSAGE);
                            ServicesDumpDialog.this.setProgressBarValue(dumpProvidersAmount);
                            return;
                        }
                        ServicesDumpDialog.this.setProgressBarText("Dump generation completed successfully");
                        ServicesDumpDialog.this.setProgressBarValue(dumpProvidersAmount);
                        Thread.sleep(1500L);
                        ServicesDumpDialog.this.setProgressBarText("");
                        ServicesDumpDialog.this.setProgressBarValue(0);
                        ServicesDumpDialog.this.setProgressBarMaxVal(ServicesDumpDialog.this._fileSize.get());
                        FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                        for (int index = 0; index < listSize; ++index) {
                            int localIndex = index;
                            InternalDumpResult dumpResult = (InternalDumpResult)dumpResultsList.get(index);
                            DumpProviderWrapper dumpProviderWrapper = (DumpProviderWrapper)dumpProviderWrappersList.get(localIndex);
                            DownloadThread downloadThread = new DownloadThread(dumpProviderWrapper, zipOutputStream, fileOutputStream, dumpResult, localIndex == listSize - 1);
                            ServicesDumpDialog.this._executorService.submit(downloadThread);
                        }
                    }
                    catch (Exception re) {
                        ServicesDumpDialog.this.setProgressBarText("Dump generation failed, please refer to the log for more details");
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                }
            }
        });
        processRetrieveDumpThread.start();
    }

    protected boolean hasFailedGSM(List<DumpProviderWrapper> failedDumpsList, long pid) {
        boolean found = false;
        for (DumpProviderWrapper providerWrapper : failedDumpsList) {
            if (!(providerWrapper.getDumpProvider() instanceof GSM) || providerWrapper.getPid() != pid) continue;
            found = true;
            break;
        }
        return found;
    }

    private void setProgressBarMaxVal(int maxVal) {
        this._progressBar.setMaximum(maxVal);
    }

    private void setProgressBarMinVal(int minVal) {
        this._progressBar.setMinimum(minVal);
    }

    private void setProgressBarText(String text) {
        this._explLabel.setText(text);
        this._explLabel.setToolTipText(text);
    }

    private void setProgressBarServiceName(String serviceName) {
        this._curServiceName = serviceName;
        this._explLabel.setText("Downloading dump of " + this._curServiceName);
    }

    private void setProgressBarFileName(String fileName) {
        this._explLabel.setText("Downloading dump from " + this._curServiceName + ", file: " + fileName);
    }

    private void setProgressBarValue(int curValue) {
        this._progressBar.setValue(curValue);
    }

    public void resetProgressBar() {
        this._currentDownloadProgressValue = 0;
    }

    private String[] getDumpOptions() {
        ArrayList<String> dumpOptionsList = new ArrayList<String>(5);
        dumpOptionsList.add("summary");
        if (this._threadsDumpCheckBox.isSelected()) {
            dumpOptionsList.add("thread");
        }
        if (this._networkDumpCheckBox.isSelected()) {
            dumpOptionsList.add("network");
        }
        if (this._logsDumpCheckBox.isSelected()) {
            dumpOptionsList.add("log");
        }
        if (this._onlyLiveServicesLogsDumpCheckBox != null && this._onlyLiveServicesLogsDumpCheckBox.isEnabled() && !this._onlyLiveServicesLogsDumpCheckBox.isSelected() && this._isMachineServicesDumpSelected) {
            dumpOptionsList.add("all-agents-logs");
        }
        if (this._pusDumpCheckBox.isSelected()) {
            dumpOptionsList.add("processingUnits");
        }
        if (this._heapDumpCheckBox.isSelected()) {
            dumpOptionsList.add("heap");
        }
        String[] dumpOptionsArray = new String[dumpOptionsList.size()];
        dumpOptionsList.toArray(dumpOptionsArray);
        return dumpOptionsArray;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._closeButton)) {
            this.setVisible(false);
        } else if (source.equals(this._executeButton) && this.isDataValid()) {
            this.processRetrievingDump();
        }
    }

    private boolean isDataValid() {
        String zipFilePath = this._zipFilePathTextField.getText();
        if (zipFilePath.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please provide a valid location for dump zip file.", "Genereate dump", 1);
            return false;
        }
        File zipFile = new File(zipFilePath);
        File parentDir = zipFile.getParentFile();
        boolean parentDirExists = false;
        String parentDirPath = zipFilePath;
        if (parentDir != null) {
            parentDirPath = parentDir.getPath();
            parentDirExists = parentDir.exists();
        }
        if (!parentDirExists) {
            JOptionPane.showMessageDialog(this, "The directory \"" + parentDirPath + "\" does not exist.\nPlease provide a valid location for dump zip file.", "Genereate dump", 1);
            return false;
        }
        String cause = this._causeTextField.getText();
        if (cause.length() > 0 && !causePattern.matcher(cause).matches()) {
            JOptionPane.showMessageDialog(this, "Dump cause can only contain alpha-numeric characters.", "Genereate dump", 1);
            return false;
        }
        return parentDirExists;
    }

    public void onDownload(long downloadedBytes, String name, String fileName) {
        this._currentDownloadProgressValue += (int)(downloadedBytes / 1024L);
        this.setProgressBarValue(this._currentDownloadProgressValue);
        this.setProgressBarFileName(fileName);
    }

    static {
        causePattern = Pattern.compile("[0-9A-Za-z]*");
        LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    }

    public static class DumpProviderWrapper {
        private InternalDumpProvider _dumpProvider;
        private ServiceID _serviceId;
        private String _descr;
        private String _hostName;
        private boolean _isSecured;
        private long _pid;
        private boolean _isLUS;

        public DumpProviderWrapper(InternalDumpProvider dumpProvider, ServiceID serviceId, boolean isSecured, String descr, String hostName, long pid, boolean isLUS) {
            this._dumpProvider = dumpProvider;
            this._serviceId = serviceId;
            this._descr = descr;
            this._hostName = hostName;
            this._isSecured = isSecured;
            this._pid = pid;
            this._isLUS = isLUS;
        }

        public InternalDumpProvider getDumpProvider() {
            return this._dumpProvider;
        }

        public boolean isLUS() {
            return this._isLUS;
        }

        public ServiceID getServiceId() {
            return this._serviceId;
        }

        public String getDescr() {
            return this._descr;
        }

        public String getHostName() {
            return this._hostName;
        }

        public boolean isSecured() {
            return this._isSecured;
        }

        public long getPid() {
            return this._pid;
        }
    }

    class DownloadThread
    implements Runnable {
        private DumpProviderWrapper _dumpProviderWrapper;
        private ZipOutputStream _zipOutputStream;
        private FileOutputStream _fileOutputStream;
        private InternalDumpResult _dumpResult;
        private boolean _isLastProvider;

        DownloadThread(DumpProviderWrapper dumpProviderWrapper, ZipOutputStream zipOutputStream, FileOutputStream fileOutputStream, InternalDumpResult dumpResult, boolean isLastProvider) {
            this._dumpProviderWrapper = dumpProviderWrapper;
            this._zipOutputStream = zipOutputStream;
            this._fileOutputStream = fileOutputStream;
            this._dumpResult = dumpResult;
            this._isLastProvider = isLastProvider;
        }

        @Override
        public void run() {
            try {
                String description = this._dumpProviderWrapper._descr;
                InternalDumpProvider dumpProvider = this._dumpProviderWrapper._dumpProvider;
                ServicesDumpDialog.this.setProgressBarServiceName(description);
                this._dumpResult.download(dumpProvider, this._zipOutputStream, (InternalDumpDownloadListener)ServicesDumpDialog.this);
            }
            catch (Exception re) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, re.toString(), re);
                }
            }
            finally {
                block14: {
                    if (this._isLastProvider) {
                        try {
                            ServicesDumpDialog.this.setProgressBarValue(ServicesDumpDialog.this._fileSize.get());
                            this._zipOutputStream.close();
                            this._fileOutputStream.close();
                            Thread.sleep(300L);
                            ServicesDumpDialog.this.setProgressBarText("Download completed successfully");
                            ServicesDumpDialog.this._executeButton.setEnabled(true);
                        }
                        catch (Exception re) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block14;
                            LOGGER.log(Level.SEVERE, re.toString(), re);
                        }
                    }
                }
            }
        }
    }
}

