/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.grid.DisplayControl;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.OpStringGraph;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeServiceNotificationListener;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.deploy.DeployUpdate;
import com.gigaspaces.admin.ui.grid.descriptor.JEEPUServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.SpaceServiceDescriptor;
import com.gigaspaces.admin.ui.grid.gsc.HostGSCsComponent;
import com.gigaspaces.admin.ui.grid.space.SpaceViewPanel;
import com.gigaspaces.admin.ui.grid.treenode.DeployedServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.EventContainersNode;
import com.gigaspaces.admin.ui.grid.treenode.JeePUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.RemoteServicesNode;
import com.gigaspaces.admin.ui.grid.treenode.userobject.EventContainersHolder;
import com.gigaspaces.admin.ui.grid.treenode.userobject.RemoteServicesHolder;
import com.gigaspaces.admin.ui.grid.views.EventContainersPanel;
import com.gigaspaces.admin.ui.grid.views.JEEConfigurationPanelsContainer;
import com.gigaspaces.admin.ui.grid.views.NoPermissionsView;
import com.gigaspaces.admin.ui.grid.views.PUConfigurationPanel;
import com.gigaspaces.admin.ui.grid.views.PUInstancePropertiesPanel;
import com.gigaspaces.admin.ui.grid.views.PUInstancesPanel;
import com.gigaspaces.admin.ui.grid.views.RemoteServicesPanel;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.cluster.view.ClusterPanel;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.cluster.view.ServiceManagerImpl;
import com.j_spaces.tools.spacebrowser.ClusterConnectionsPanel;
import com.j_spaces.tools.spacebrowser.ClusterSpaceRuntimePanel;
import com.j_spaces.tools.spacebrowser.ClusterTransactionsPanel;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.SpaceConnectionsPanel;
import com.j_spaces.tools.spacebrowser.SpaceRuntimePanel;
import com.j_spaces.tools.spacebrowser.SpaceTransactionsPanel;
import com.j_spaces.tools.spacebrowser.SpacesViewPanel;
import com.j_spaces.tools.spacebrowser.benchmark.BenchMarkPanel;
import com.j_spaces.tools.spacebrowser.benchmark.ClusterBenchMarkPanel;
import com.j_spaces.tools.spacebrowser.statistics.ClusterStatisticPanel;
import com.j_spaces.tools.spacebrowser.statistics.StatisticPanel;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.ui.MainFrame;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorEvent;
import org.openspaces.pu.container.servicegrid.PUServiceBean;

public class TreeServiceSelectionHandler
implements TreeServiceNotificationListener,
AuthenticationListener {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    JTree theTree;
    private DisplayControl displayControl;
    private BlankPanel blankPanel;
    OpStringGraph opStringGraph;
    private EditCluster currentCluster;
    private SpaceViewPanel spaceViewPanel;
    private SpacesViewPanel unmanagedSpacesViewPanel;
    private NoPermissionsView noPermissionsView;
    private NoPermissionsView noSpaceOperationsPermissionsView;
    private ClusterViewDlg _clusterViewDialog;
    private Map<String, ClusterStatisticPanel> statisticsPerCluster = new Hashtable<String, ClusterStatisticPanel>();
    private Map<String, BenchMarkPanel> benchmarkPanelsPerCluster = new Hashtable<String, BenchMarkPanel>();
    private Map<ServiceID, BenchMarkPanel> benchmarkPanelsPerSpace = new Hashtable<ServiceID, BenchMarkPanel>();
    private ClusterSpaceRuntimePanel clusterRuntimePanel;
    private ClusterTransactionsPanel clusterTransactionPanel;
    private ClusterConnectionsPanel clusterConnectionsPanel;
    private MainFrame clusterSQLPane;
    private MainFrame _iSQLPane;
    private SpaceTransactionsPanel spaceTransactionsPanel;
    private SpaceConnectionsPanel spaceConnectionsPanel;
    private SpaceRuntimePanel spaceRuntimePanel;
    private Map<Object, StatisticPanel> statisticsPerSpace = new Hashtable<Object, StatisticPanel>();
    private JPopupMenu _rootsPopupMenu;
    static final String BLANK = "BLANK";
    static final String OPSTRING_GRAPH = ResourceBundleHandler.getInstance().getResource("label.DeploymentDescriptorGraph");
    private static final String CONFIRM_MESSAGE_COMMON = "\nAre you sure you want to continue?";
    public static final String CONFIRM_MESSAGE_CLEAN_CLUSTER = "All space instances will be cleaned and all data currently in the space will be deleted.\nYou will not be able to undo this operation.\nAre you sure you want to continue?";
    private JButton undeploy;
    private JMenuItem undeployMenuItem;
    private String jmxServiceUrl;
    private MainUI _mainUI;
    private TreeWorker _treeWorker;
    private boolean isClusterViewInitialized = false;
    private EventContainersPanel eventContainersPanel;
    private RemoteServicesPanel remoteServicesPanel;
    private PUInstancesPanel puInstancesPanel;
    private PUConfigurationPanel puConfigurationPanel;
    private JEEConfigurationPanelsContainer jEEConfigurationPanelsContainer;
    private PUInstancePropertiesPanel puInstancePropertiesPanel;

    public TreeServiceSelectionHandler(MainUI mainUI, ClusterViewDlg clusterViewDialog, final TreeWorker treeWorker, SpacesViewPanel unmanagedSpacesViewPanel) {
        this._mainUI = mainUI;
        this._treeWorker = treeWorker;
        this._clusterViewDialog = clusterViewDialog;
        this.unmanagedSpacesViewPanel = unmanagedSpacesViewPanel;
        this.blankPanel = new BlankPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.opStringGraph = new OpStringGraph(this._mainUI);
        this.opStringGraph.setPreferredSize(new Dimension(90, 200));
        this.createSpaceViewPanel();
        this.noPermissionsView = new NoPermissionsView(MonitorAuthority.MonitorPrivilege.MONITOR_PU.toString());
        this.noSpaceOperationsPermissionsView = new NoPermissionsView("Space Operation");
        this.puInstancesPanel = new PUInstancesPanel(mainUI);
        this.puConfigurationPanel = new PUConfigurationPanel(this._mainUI);
        this.eventContainersPanel = new EventContainersPanel();
        this.remoteServicesPanel = new RemoteServicesPanel();
        this.jEEConfigurationPanelsContainer = new JEEConfigurationPanelsContainer(this._mainUI);
        this.puInstancePropertiesPanel = new PUInstancePropertiesPanel();
        TableChangeListener changeListener = new TableChangeListener();
        Repository.getInstance().getSLAEventTable().addObserver(changeListener);
        Repository.getInstance().getProvisionFailureEventTable().addObserver(changeListener);
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
        this._rootsPopupMenu = new JPopupMenu();
        JMenuItem collapseTreeMenuItem = new JMenuItem("Collapse Tree");
        collapseTreeMenuItem.setToolTipText("Collapse the entire tree");
        JMenuItem expandTreeMenuItem = new JMenuItem("Expand Tree");
        expandTreeMenuItem.setToolTipText("Expand the entire tree");
        JMenuItem expandPUsMenuItem = new JMenuItem("Expand Processing Units");
        expandPUsMenuItem.setToolTipText("Expand Processing Units");
        JMenuItem collapsePUsMenuItem = new JMenuItem("Collapse Processing Units");
        collapsePUsMenuItem.setToolTipText("Collapse Processing Units");
        JMenuItem expandPUInstancesMenuItem = new JMenuItem("Expand Processing Unit Instances");
        expandPUInstancesMenuItem.setToolTipText("Expand Processing Unit Instances");
        JMenuItem collapsePUInstancesMenuItem = new JMenuItem("Collapse Processing Unit Instances");
        collapsePUInstancesMenuItem.setToolTipText("Collapse Processing Unit Instances");
        this._rootsPopupMenu.add(collapseTreeMenuItem);
        this._rootsPopupMenu.add(expandTreeMenuItem);
        this._rootsPopupMenu.addSeparator();
        this._rootsPopupMenu.add(collapsePUsMenuItem);
        this._rootsPopupMenu.add(expandPUsMenuItem);
        this._rootsPopupMenu.addSeparator();
        this._rootsPopupMenu.add(collapsePUInstancesMenuItem);
        this._rootsPopupMenu.add(expandPUInstancesMenuItem);
        collapseTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeWorker.collapseTree();
            }
        });
        expandTreeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeWorker.expandTree();
            }
        });
        collapsePUsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeWorker.collapsePUs();
            }
        });
        expandPUsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeWorker.expandPUs();
            }
        });
        collapsePUInstancesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeWorker.collapsePUInstances();
            }
        });
        expandPUInstancesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeWorker.expandPUInstances();
            }
        });
    }

    private void createSpaceViewPanel() {
        this.spaceViewPanel = new SpaceViewPanel(this._mainUI, this._treeWorker);
    }

    private IJSpace getSpaceProxy(ClusterMemberInfo clusterMemberInfo) throws RemoteException, NoSuchNameException {
        String memberName = clusterMemberInfo.memberName;
        IJSpace spaceProxy = null;
        ServiceManagerImpl.ClusterMember clusterMember = this._clusterViewDialog.getServiceManager().getClusterMember(memberName);
        if (clusterMember != null) {
            spaceProxy = clusterMember.getClusteredProxy();
        }
        return spaceProxy;
    }

    @Override
    public void setTree(JTree theTree) {
        this.theTree = theTree;
        theTree.addMouseListener(new TreeMouseHandler());
    }

    @Override
    public void setToolBarButtons(JButton[] toolbarButtons) {
        for (JButton button : toolbarButtons) {
            String name = button.getAccessibleContext().getAccessibleName();
            if (!name.equals("undeploy")) continue;
            this.undeploy = button;
            this.undeploy.setEnabled(false);
            this.undeploy.addActionListener(new UndeployHandler());
        }
    }

    @Override
    public void setDisplayControl(DisplayControl displayControl) {
        this.displayControl = displayControl;
        this.opStringGraph.setDisplayControl(displayControl);
        displayControl.addDisplayComponent(this.blankPanel, BLANK);
        displayControl.addDisplayComponent(this.opStringGraph, OPSTRING_GRAPH);
        displayControl.addDisplayComponent(this.spaceViewPanel, "SpaceView");
        displayControl.addDisplayComponent(this.unmanagedSpacesViewPanel, "UnmanagedSpaces");
        displayControl.addDisplayComponent(this.puInstancesPanel, "PUInstances");
        displayControl.addDisplayComponent(this.puConfigurationPanel, "PUConfiguration");
        displayControl.addDisplayComponent(this.eventContainersPanel, "EventContaienrs");
        displayControl.addDisplayComponent(this.remoteServicesPanel, "RemoteServices");
        displayControl.addDisplayComponent(this.jEEConfigurationPanelsContainer, "JEEConfiguration");
        displayControl.addDisplayComponent(this.puInstancePropertiesPanel, "PUInstanceProperties");
        displayControl.addDisplayComponent(this.noPermissionsView, "ViewNoPermissions");
        displayControl.addDisplayComponent(this.noSpaceOperationsPermissionsView, "ViewNoSpaceOperationsPermissions");
        displayControl.display(this.blankPanel, BLANK);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.initViewForSelectedTreeNode(true);
    }

    private void initViewForSelectedTreeNode(boolean isNodeSelectionEvent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.theTree.getLastSelectedPathComponent();
        if (node == null) {
            node = TreeWorker.puRoot;
            this.theTree.setSelectionPath(new TreePath(TreeWorker.puRoot.getPath()));
        }
        final DefaultMutableTreeNode selTreeNode = node;
        Runnable initSelectionTask = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        TreeServiceSelectionHandler.this.initViewForSelectedTreeNode(selTreeNode, true);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        };
        if (isNodeSelectionEvent) {
            this._mainUI.getTreeSelectionsExecutor().submit(selTreeNode, initSelectionTask);
        } else {
            AdminUIThreadPool.getThreadPool().execute(initSelectionTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initViewForSelectedTreeNode(DefaultMutableTreeNode node, boolean isPerformedWithinThread) throws Exception {
        try {
            this._mainUI.setCursor(Cursor.getPredefinedCursor(3));
            Object uo = node.getUserObject();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            if (this.spaceViewPanel != null) {
                this.spaceViewPanel.setInvokeRefresh(node instanceof DeployedServiceNode || node instanceof TreeWorker.SpaceNode);
            }
            this.remoteServicesPanel.setInvokeRefresh(node instanceof RemoteServicesNode);
            this.eventContainersPanel.setInvokeRefresh(node instanceof EventContainersNode);
            this.puInstancesPanel.setInvokeRefresh(uo != null && uo.equals("Processing Unit Instances"));
            if (parentNode instanceof DeployedServiceNode) {
                if (this.spaceTransactionsPanel != null) {
                    this.spaceTransactionsPanel.setInvokeRefresh(uo.equals("Transactions"));
                }
                if (this.spaceConnectionsPanel != null) {
                    this.spaceConnectionsPanel.setInvokeRefresh(uo.equals("Connections"));
                }
                if (this.spaceRuntimePanel != null) {
                    this.spaceRuntimePanel.setInvokeRefresh(uo.equals("Data Types"));
                }
            }
            if (parentNode != null && parentNode.toString().equals("Operations")) {
                if (this.clusterConnectionsPanel != null) {
                    this.clusterConnectionsPanel.setInvokeRefresh(uo.equals("Connections"));
                }
                if (this.clusterRuntimePanel != null) {
                    this.clusterRuntimePanel.setInvokeRefresh(uo.equals("Data Types"));
                }
                if (this.clusterTransactionPanel != null) {
                    this.clusterTransactionPanel.setInvokeRefresh(uo.equals("Transactions"));
                }
            }
            DefaultMutableTreeNode granNode = null;
            Object parentObj = null;
            if (parentNode != null) {
                granNode = (DefaultMutableTreeNode)parentNode.getParent();
                parentObj = parentNode.getUserObject();
            }
            TreePath selPath = new TreePath(node.getPath());
            if (uo instanceof String && uo.equals("Processing Units")) {
                if (this.undeploy != null) {
                    this.undeploy.setEnabled(false);
                }
                if (this.undeployMenuItem != null) {
                    this.undeployMenuItem.setEnabled(false);
                }
                this.opStringGraph.display(isPerformedWithinThread);
                this.displayControl.display(this.opStringGraph, OPSTRING_GRAPH);
                this.currentCluster = null;
                return;
            }
            if (uo != null && uo.equals("Processing Unit Instances")) {
                TreeWorker.OpStringHolder opStringHolder = (TreeWorker.OpStringHolder)parentObj;
                this.puInstancesPanel.setPUInstancesDefinition(parentNode, opStringHolder);
                this.displayControl.display(this.puInstancesPanel, "PUInstances");
                return;
            }
            if (uo instanceof TreeWorker.OpStringHolder) {
                TreeWorker.OpStringHolder opStringHolder = (TreeWorker.OpStringHolder)uo;
                this.puConfigurationPanel.setPUConfiguration(opStringHolder);
                TreeWorker.OpStringHolder oh = (TreeWorker.OpStringHolder)uo;
                PUConfigurationPanel panel = this.puConfigurationPanel;
                String componentName = "PUConfiguration";
                if (this.hasProvisionPUPermission(oh) && !oh.isUndeploying()) {
                    if (this.undeploy != null) {
                        this.undeploy.setEnabled(true);
                    }
                    if (this.undeployMenuItem != null) {
                        this.undeployMenuItem.setEnabled(true);
                    }
                }
                this.displayControl.display(panel, componentName);
                this.currentCluster = null;
                return;
            }
            if (uo instanceof TreeWorker.ServiceElementHolder) {
                this.buttonsFalse();
                this.currentCluster = null;
                return;
            }
            if (uo instanceof ServiceRecord) {
                this.buttonsFalse();
                this.currentCluster = null;
                return;
            }
            if (uo instanceof TreeWorker.ServiceHolder) {
                this.buttonsFalse();
                if (this.handleSecuredServiceView(((TreeWorker.ServiceHolder)uo).getSecuredService(), ((TreeWorker.ServiceHolder)uo).getSecuredServiceID(), (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, ((TreeWorker.ServiceHolder)uo).isSecured())) {
                    this.displayControl.display(this.puInstancePropertiesPanel, "PUInstanceProperties");
                    EventContainersHolder eventContainersHolder = null;
                    RemoteServicesHolder remoteServicesHolder = null;
                    ArrayList<JEEPUServiceDescriptor> jeeServiceDescriptorList = new ArrayList<JEEPUServiceDescriptor>();
                    ArrayList<SpaceServiceDescriptor> remoteSpacesList = new ArrayList<SpaceServiceDescriptor>();
                    ArrayList<SpaceServiceDescriptor> embeddedSpacesList = new ArrayList<SpaceServiceDescriptor>();
                    int childrenNodesCount = node.getChildCount();
                    for (int index = 0; index < childrenNodesCount; ++index) {
                        DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)node.getChildAt(index);
                        Object userObject = childTreeNode.getUserObject();
                        if (userObject instanceof EventContainersHolder) {
                            eventContainersHolder = (EventContainersHolder)userObject;
                            continue;
                        }
                        if (userObject instanceof RemoteServicesHolder) {
                            remoteServicesHolder = (RemoteServicesHolder)userObject;
                            continue;
                        }
                        if (userObject instanceof JEEPUServiceDescriptor) {
                            jeeServiceDescriptorList.add((JEEPUServiceDescriptor)userObject);
                            continue;
                        }
                        if (!(childTreeNode instanceof DeployedServiceNode)) continue;
                        DeployedServiceNode spaceNode = (DeployedServiceNode)childTreeNode;
                        String type = spaceNode.getType();
                        if (type.equals("embedded")) {
                            embeddedSpacesList.add((SpaceServiceDescriptor)userObject);
                            continue;
                        }
                        if (!type.equals("remote")) continue;
                        remoteSpacesList.add((SpaceServiceDescriptor)userObject);
                    }
                    this.puInstancePropertiesPanel.setPUInstanceProperties(eventContainersHolder, remoteServicesHolder, jeeServiceDescriptorList, embeddedSpacesList, remoteSpacesList);
                }
                this.currentCluster = null;
                return;
            }
            if (node instanceof DeployedServiceNode) {
                this.buttonsFalse();
                String type = ((DeployedServiceNode)node).getType();
                if (type.equals("localcache") || type.equals("localview")) {
                    this.displayControl.display(this.blankPanel, BLANK);
                } else {
                    ServiceID serviceID = ((DeployedServiceNode)node).getServiceID();
                    IJSpace space = ((DeployedServiceNode)node).getSpaceProxy();
                    if (type.equals("remote")) {
                        serviceID = JSpaceUtilities.getSpaceServiceID((IJSpace)space);
                    }
                    this.spaceViewPanel.setSpace(space, serviceID, type, (IConnectionProvider)((Object)node));
                    if (this.handleSecuredServiceView((SecuredService)space, serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, space.isSecured())) {
                        this.displayControl.display(this.spaceViewPanel, "SpaceView");
                    }
                }
                this.currentCluster = null;
                return;
            }
            if (uo instanceof EditCluster) {
                EditCluster edCluster = (EditCluster)uo;
                this.showClusterPanel(edCluster, false, false, true);
                String clusterName = edCluster.getClusterName();
                this._clusterViewDialog.getClusterTree(clusterName).showHighLevelNode(node, null);
                this._clusterViewDialog.getServiceManager().awakeThread();
                return;
            }
            if (parentObj instanceof EditCluster) {
                if (node.toString().equals("Operations")) {
                    this.clearRightSplitPanel();
                    this.currentCluster = null;
                    return;
                }
                try {
                    EditCluster edCluster = (EditCluster)parentObj;
                    this.showClusterPanel(edCluster, false, false, true);
                    String clusterName = edCluster.getClusterName();
                    this._clusterViewDialog.getClusterTree(clusterName).performNodeAction(selPath);
                    this._clusterViewDialog.getServiceManager().awakeThread();
                    return;
                }
                catch (Exception exc) {
                    if (!LOGGER.isLoggable(Level.WARNING)) return;
                    LOGGER.log(Level.WARNING, exc.toString(), exc);
                }
                return;
            }
            if (granNode != null && granNode.getUserObject() instanceof EditCluster) {
                EditCluster edCluster = (EditCluster)granNode.getUserObject();
                if (parentNode.toString().equals("Operations")) {
                    ClusterMemberInfo[] clusterMemberInfo = edCluster.getClusterMembers();
                    this._clusterViewDialog.getServiceManager().setCurrentClusterMembers(clusterMemberInfo, false);
                    String clusterName = edCluster.getClusterName();
                    ServiceManagerImpl.ClusterMember[] aliveClusterMembers = this._clusterViewDialog.getServiceManager().getClusterMembers(clusterName, false);
                    if (aliveClusterMembers.length > 0) {
                        IJSpace space = aliveClusterMembers[0].getClusteredProxy();
                        ServiceID serviceID = aliveClusterMembers[0].getServiceID();
                        if (node.toString().equals("Data Types") || node.toString().equals("Transactions") || node.toString().equals("Connections") || node.toString().equals("Statistics")) {
                            if (this.handleSecuredServiceView((SecuredService)space, serviceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, space.isSecured())) {
                                if (node.toString().equals("Data Types")) {
                                    this.selectClusterRuntimePanel(edCluster);
                                } else if (node.toString().equals("Transactions")) {
                                    this.selectClusterTransactionsPanel(clusterName);
                                } else if (node.toString().equals("Connections")) {
                                    this.selectClusterConnectionsPanel(clusterName);
                                } else if (node.toString().equals("Statistics")) {
                                    ServiceManagerImpl.ClusterMember[] curClusterMembers = this._clusterViewDialog.getServiceManager().getClusterMembers(clusterName, false);
                                    if (curClusterMembers.length == 0) {
                                        JOptionPane.showMessageDialog(this._mainUI, "Unable to display Cluster Statistics since there are no any alive cluster member in cluster.", "Cluster Statistics", 2);
                                        return;
                                    }
                                    this.selectClusterStatisticsPanel(edCluster);
                                }
                            }
                        } else if ((node.toString().equals("Query") || node.toString().equals("Benchmark")) && this.handleSecuredServiceView((SecuredService)space, serviceID, (Privilege[])SpaceBrowser.SPACE_PRIVILIGIES, space.isSecured())) {
                            if (node.toString().equals("Query")) {
                                this.selectClusterSQLQueryPanel(clusterName, "SELECT * FROM SYSTABLES");
                            } else if (node.toString().equals("Benchmark")) {
                                this.selectClusterBenchmarkPanel(edCluster);
                            }
                        }
                    }
                    this.currentCluster = null;
                    return;
                }
                try {
                    if (this.currentCluster == null || this.currentCluster != edCluster) {
                        this.showClusterPanel(edCluster, true, false, true);
                    }
                    this._clusterViewDialog.getClusterTree(edCluster.getClusterName()).performNodeAction(selPath);
                    this._clusterViewDialog.getServiceManager().awakeThread();
                    return;
                }
                catch (Exception exc) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) return;
                    LOGGER.log(Level.SEVERE, exc.toString(), exc);
                }
                return;
            }
            if (parentNode instanceof DeployedServiceNode) {
                DeployedServiceNode spaceNode = (DeployedServiceNode)parentNode;
                IJSpace spaceProxy = spaceNode.getSpaceProxy();
                ServiceID spaceID = spaceNode.getServiceID();
                if (uo.equals("Data Types")) {
                    if (this.handleSecuredServiceView((SecuredService)spaceProxy, spaceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, spaceProxy.isSecured())) {
                        this.selectSpaceClassesPanel(spaceProxy, spaceID, spaceNode);
                    }
                } else if (uo.equals("Transactions")) {
                    if (this.handleSecuredServiceView((SecuredService)spaceProxy, spaceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, spaceProxy.isSecured())) {
                        this.selectSpaceTransactionPanel(spaceProxy);
                    }
                } else if (uo.equals("Query")) {
                    if (this.handleSecuredServiceView((SecuredService)spaceProxy, spaceID, (Privilege[])SpaceBrowser.SPACE_PRIVILIGIES, spaceProxy.isSecured())) {
                        this.selectSpaceSQLQueryPanel(spaceNode.getConnection(), spaceProxy.getName());
                    }
                } else if (uo.equals("Statistics")) {
                    if (this.handleSecuredServiceView((SecuredService)spaceProxy, spaceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, spaceProxy.isSecured())) {
                        this.selectSpaceStatisticsPanel(spaceProxy, spaceID, spaceNode.toString());
                    }
                } else if (uo.equals("Connections")) {
                    if (this.handleSecuredServiceView((SecuredService)spaceProxy, spaceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, spaceProxy.isSecured())) {
                        this.selectSpaceConnectionsPanel(spaceProxy);
                    }
                } else if (uo.equals("Benchmark") && this.handleSecuredServiceView((SecuredService)spaceProxy, spaceID, (Privilege[])SpaceBrowser.SPACE_PRIVILIGIES, spaceProxy.isSecured())) {
                    this.selectSpaceBenchmarkPanel(spaceProxy, spaceID);
                }
                this.currentCluster = null;
                return;
            } else if (parentNode instanceof TreeWorker.SpaceNode) {
                TreeWorker.SpaceNode spaceNode = (TreeWorker.SpaceNode)parentNode;
                IJSpace space = spaceNode.getSpace();
                ServiceID spaceID = spaceNode.getSpaceID();
                if (uo.equals("Data Types")) {
                    this.selectSpaceClassesPanel(space, spaceID, spaceNode);
                } else if (uo.equals("Transactions")) {
                    this.selectSpaceTransactionPanel(space);
                } else if (uo.equals("Query")) {
                    this.selectSpaceSQLQueryPanel(spaceNode.getConnection(), space.getName());
                } else if (uo.equals("Statistics")) {
                    this.selectSpaceStatisticsPanel(space, spaceID, spaceNode.toString());
                } else if (uo.equals("Connections")) {
                    this.selectSpaceConnectionsPanel(space);
                } else if (uo.equals("Benchmark")) {
                    this.selectSpaceBenchmarkPanel(space, spaceID);
                }
                this.currentCluster = null;
                return;
            } else if (node instanceof EventContainersNode) {
                Object puServiceBean;
                boolean isSecured;
                ServiceID securedServiceID;
                TreeWorker.ServiceHolder serviceHolder = (TreeWorker.ServiceHolder)parentObj;
                SecuredService securedService = serviceHolder.getSecuredService();
                if (!this.handleSecuredServiceView(securedService, securedServiceID = serviceHolder.getSecuredServiceID(), (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, isSecured = serviceHolder.isSecured()) || !((puServiceBean = serviceHolder.item.service) instanceof PUServiceBean)) return;
                this.eventContainersPanel.setEventContainersHolder((EventContainersHolder)uo, (PUServiceBean)puServiceBean);
                this.displayControl.display(this.eventContainersPanel, "EventContaienrs");
                return;
            } else if (node instanceof RemoteServicesNode) {
                Object puServiceBean;
                boolean isSecured;
                ServiceID securedServiceID;
                TreeWorker.ServiceHolder serviceHolder = (TreeWorker.ServiceHolder)parentObj;
                SecuredService securedService = serviceHolder.getSecuredService();
                if (!this.handleSecuredServiceView(securedService, securedServiceID = serviceHolder.getSecuredServiceID(), (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, isSecured = serviceHolder.isSecured()) || !((puServiceBean = serviceHolder.item.service) instanceof PUServiceBean)) return;
                this.remoteServicesPanel.setRemoteServicesHolder((RemoteServicesHolder)uo, (PUServiceBean)puServiceBean);
                this.displayControl.display(this.remoteServicesPanel, "RemoteServices");
                return;
            } else if (node instanceof JeePUServiceNode) {
                TreeWorker.ServiceHolder serviceHolder = (TreeWorker.ServiceHolder)parentObj;
                Object puServiceBean = serviceHolder.item.service;
                ServiceID serviceID = serviceHolder.item.serviceID;
                JEEPUServiceDescriptor jeeDescriptor = (JEEPUServiceDescriptor)uo;
                if (!(puServiceBean instanceof PUServiceBean)) return;
                this.jEEConfigurationPanelsContainer.setJEEConfiguration(jeeDescriptor, serviceID, (PUServiceBean)puServiceBean);
                this.displayControl.display(this.jEEConfigurationPanelsContainer, "JEEConfiguration");
                return;
            } else {
                this.buttonsFalse();
                this.displayControl.display(this.blankPanel, BLANK);
            }
            return;
        }
        finally {
            this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean handleSecuredServiceView(SecuredService securedService, ServiceID securedServiceId, Privilege permittedPrivilege, boolean isSecured) {
        if (!JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceId, permittedPrivilege, isSecured)) {
            this.displayControl.display(this.noPermissionsView, "ViewNoPermissions");
            return false;
        }
        return true;
    }

    private boolean handleSecuredServiceView(SecuredService securedService, ServiceID securedServiceId, Privilege[] permittedPrivilegesArray, boolean isSecured) {
        Privilege privilege;
        boolean isAtLeastOneSpaceOperationPermitted = false;
        Privilege[] privilegeArray = permittedPrivilegesArray;
        int n = privilegeArray.length;
        for (int i = 0; i < n && !(isAtLeastOneSpaceOperationPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceId, privilege = privilegeArray[i], isSecured)); ++i) {
        }
        if (!isAtLeastOneSpaceOperationPermitted) {
            this.displayControl.display(this.noSpaceOperationsPermissionsView, "ViewNoSpaceOperationsPermissions");
            return false;
        }
        return true;
    }

    public void stopStatisticsClusterComponent(String clusterName) {
        ClusterStatisticPanel clusterStatisticPanel = this.statisticsPerCluster.get(clusterName);
        if (clusterStatisticPanel != null) {
            clusterStatisticPanel.stopRefresh();
        }
    }

    private void selectClusterStatisticsPanel(EditCluster editCluster) {
        block3: {
            try {
                String clusterName = editCluster.getClusterName();
                ClusterStatisticPanel statistic = this.statisticsPerCluster.get(clusterName);
                if (statistic == null) {
                    statistic = new ClusterStatisticPanel(this._mainUI, this._clusterViewDialog.getServiceManager(), editCluster);
                    this.statisticsPerCluster.put(clusterName, statistic);
                    this.displayControl.addDisplayComponent(statistic, this.createClusterStatisticsPanelName(clusterName));
                }
                statistic.startRefresh();
                this._clusterViewDialog.getServiceManager().awakeThread();
                this.displayControl.display(statistic, this.createClusterStatisticsPanelName(clusterName));
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.toString(), e);
            }
        }
    }

    protected void selectClusterSQLQueryPanel(String clusterName, String query) {
        this.showClusterQueryPanel(query, clusterName);
    }

    public synchronized void showClusterQueryPanel(String query, String clusterName) {
        block3: {
            try {
                if (this.clusterSQLPane == null) {
                    this.clusterSQLPane = new MainFrame();
                    this.clusterSQLPane.getWorkBench().setQueryString(clusterName, "SELECT * FROM SYSTABLES");
                    this.displayControl.addDisplayComponent(this.clusterSQLPane.getPanel(), "ClusterQuery");
                }
                this.clusterSQLPane.getWorkBench().setMultiSpaceQuerySelected(true);
                this.clusterSQLPane.getWorkBench().setMultiSpaceQueryEnabled(false);
                this.initClusterQueryPanel(query, clusterName, "CLUSTER [" + clusterName + "]");
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void initClusterQueryPanel(String query, String clusterName, String spaceName) {
        this.clusterSQLPane.setClusterName(clusterName);
        this.displayControl.display(this.clusterSQLPane.getPanel(), "ClusterQuery");
        if (query.equals("SELECT * FROM SYSTABLES")) {
            this.clusterSQLPane.getWorkBench().setSpaceName(spaceName);
        } else {
            this.clusterSQLPane.getWorkBench().runQuery(spaceName, query + " WHERE rownum<5000");
        }
    }

    private void selectClusterConnectionsPanel(String clusterName) {
        if (this.clusterConnectionsPanel == null) {
            this.clusterConnectionsPanel = new ClusterConnectionsPanel(this._clusterViewDialog.getBrowser(), this._clusterViewDialog.getServiceManager());
            this.clusterConnectionsPanel.setInvokeRefresh(true);
            this.displayControl.addDisplayComponent(this.clusterConnectionsPanel, "ClusterConnections");
        }
        this.clusterConnectionsPanel.setCurrentClusterName(clusterName);
        this.displayControl.display(this.clusterConnectionsPanel, "ClusterConnections");
        this._clusterViewDialog.getServiceManager().awakeThread();
    }

    private void selectClusterTransactionsPanel(String clusterName) {
        if (this.clusterTransactionPanel == null) {
            this.clusterTransactionPanel = new ClusterTransactionsPanel(this._mainUI, this._clusterViewDialog.getServiceManager());
            this.clusterTransactionPanel.setInvokeRefresh(true);
            this.displayControl.addDisplayComponent(this.clusterTransactionPanel, "ClusterTransactions");
        }
        this.clusterTransactionPanel.setCurrentClusterName(clusterName);
        this.displayControl.display(this.clusterTransactionPanel, "ClusterTransactions");
    }

    private void selectClusterRuntimePanel(EditCluster editCluster) {
        if (this.clusterRuntimePanel == null) {
            this.clusterRuntimePanel = new ClusterSpaceRuntimePanel(this._mainUI, this._mainUI.getUIComponent(), this._clusterViewDialog.getBrowser(), true, this._clusterViewDialog.getServiceManager());
            this.clusterRuntimePanel.setInvokeRefresh(true);
            this.displayControl.addDisplayComponent(this.clusterRuntimePanel, "ClusterClasses");
        }
        this.clusterRuntimePanel.setCurrentClusterDefinition(editCluster);
        this.displayControl.display(this.clusterRuntimePanel, "ClusterClasses");
        this._clusterViewDialog.getServiceManager().awakeThread();
    }

    private void selectClusterBenchmarkPanel(EditCluster editCluster) {
        block3: {
            try {
                String clusterName = editCluster.getClusterName();
                BenchMarkPanel benchmarkPanel = this.benchmarkPanelsPerCluster.get(clusterName);
                if (benchmarkPanel == null) {
                    benchmarkPanel = new ClusterBenchMarkPanel((JFrame)this._mainUI, this._clusterViewDialog.getServiceManager(), clusterName);
                    this.benchmarkPanelsPerCluster.put(clusterName, benchmarkPanel);
                    this.displayControl.addDisplayComponent(benchmarkPanel, this.createClusterBenchmarkPanelName(clusterName));
                }
                this._clusterViewDialog.getServiceManager().awakeThread();
                this.displayControl.display(benchmarkPanel, this.createClusterBenchmarkPanelName(clusterName));
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public void selectSpaceOperationNode(ServiceID spaceID, String childNodeName) {
        DefaultMutableTreeNode spaceNode = Repository.getInstance().getSpaceNode(spaceID);
        if (spaceNode != null) {
            TreeNode childNode = JSpaceUIUtils.getChildTreeNode(spaceNode, childNodeName);
            Object[] pn = this._treeWorker.getTreeModel().getPathToRoot(childNode);
            TreePath selPath = new TreePath(pn);
            this.theTree.scrollPathToVisible(selPath);
            this.theTree.setSelectionPath(selPath);
        }
    }

    private void selectSpaceBenchmarkPanel(IJSpace spaceProxy, ServiceID spaceServiceID) {
        block3: {
            try {
                BenchMarkPanel benchmarkPanel = this.benchmarkPanelsPerSpace.get(spaceServiceID);
                if (benchmarkPanel == null) {
                    benchmarkPanel = new BenchMarkPanel(this._mainUI, false, spaceProxy);
                    this.benchmarkPanelsPerSpace.put(spaceServiceID, benchmarkPanel);
                    this.displayControl.addDisplayComponent(benchmarkPanel, this.createSpaceBenchmarkPanelName(spaceServiceID));
                }
                this.displayControl.display(benchmarkPanel, this.createSpaceBenchmarkPanelName(spaceServiceID));
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private void selectSpaceConnectionsPanel(IJSpace spaceProxy) {
        block3: {
            if (this.spaceConnectionsPanel == null) {
                this.spaceConnectionsPanel = new SpaceConnectionsPanel(SpaceBrowser.getInstance());
                this.spaceConnectionsPanel.setInvokeRefresh(true);
                this.displayControl.addDisplayComponent(this.spaceConnectionsPanel, "SingleSpaceConnections");
            }
            this.displayControl.display(this.spaceConnectionsPanel, "SingleSpaceConnections");
            try {
                IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
                MBeanServerConnection mBeanServerConnection = Repository.getMBeanServerConnection(containerAdmin);
                this.spaceConnectionsPanel.initPanel(mBeanServerConnection, spaceProxy);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void selectSpaceTransactionPanel(IJSpace spaceProxy) {
        if (this.spaceTransactionsPanel == null) {
            this.spaceTransactionsPanel = new SpaceTransactionsPanel(this._mainUI);
            this.spaceTransactionsPanel.setInvokeRefresh(true);
            this.displayControl.addDisplayComponent(this.spaceTransactionsPanel, "SingleSpaceTransactions");
        }
        this.displayControl.display(this.spaceTransactionsPanel, "SingleSpaceTransactions");
        this.spaceTransactionsPanel.setSpace(spaceProxy);
    }

    private void selectSpaceClassesPanel(IJSpace spaceProxy, ServiceID spaceID, IConnectionProvider connectionProvider) {
        IRemoteJSpaceAdmin spaceAdmin;
        block4: {
            spaceAdmin = null;
            if (this.spaceRuntimePanel == null) {
                this.spaceRuntimePanel = new SpaceRuntimePanel(this._mainUI, SpaceBrowser.getInstance(), true);
                this.spaceRuntimePanel.setInvokeRefresh(true);
                this.displayControl.addDisplayComponent(this.spaceRuntimePanel, "SingleSpaceClasses");
            }
            this.displayControl.display(this.spaceRuntimePanel, "SingleSpaceClasses");
            try {
                spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
            }
            catch (RemoteException re) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, re.toString(), re);
            }
        }
        if (spaceAdmin != null) {
            this.spaceRuntimePanel.setSpaceAdmin(spaceProxy, spaceAdmin, spaceID, connectionProvider);
        }
    }

    public void selectSpaceSQLQueryPanel(DatabaseConnection databaseConnection, String spaceName) {
        this.showSpaceQueryPanel("SELECT * FROM SYSTABLES", databaseConnection, spaceName);
    }

    public synchronized void showSpaceQueryPanel(String query, DatabaseConnection dbConnection, String spaceName) {
        block3: {
            try {
                if (this._iSQLPane == null) {
                    this._iSQLPane = new MainFrame();
                    this._iSQLPane.getWorkBench().setQueryString(spaceName, "SELECT * FROM SYSTABLES");
                    this.displayControl.addDisplayComponent(this._iSQLPane.getPanel(), "SingleSpaceQuery");
                }
                this._iSQLPane.getWorkBench().setMultiSpaceQueryEnabled(true);
                this._iSQLPane.setDBConnection(dbConnection);
                this._iSQLPane.getWorkBench().setMultiSpaceQuerySelected(this._iSQLPane.getWorkBench().isMultiSpaceQuerySelectedForRegularSpace());
                this.initQueryPanel(query, spaceName);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    private void initQueryPanel(String query, String spaceName) {
        this.displayControl.display(this._iSQLPane.getPanel(), "SingleSpaceQuery");
        if (query.equals("SELECT * FROM SYSTABLES")) {
            this._iSQLPane.getWorkBench().setSpaceName(spaceName);
        } else {
            this._iSQLPane.getWorkBench().runQuery(spaceName, query + " WHERE rownum<5000");
        }
    }

    private void clearRightSplitPanel() {
        this.displayControl.display(this.blankPanel, BLANK);
    }

    private String createSpaceBenchmarkPanelName(ServiceID spaceServiceID) {
        return "ClusterBenchmark_" + spaceServiceID;
    }

    private String createClusterBenchmarkPanelName(String clusterName) {
        return "ClusterBenchmark_" + clusterName;
    }

    private String createClusterStatisticsPanelName(String clusterName) {
        return "ClusterStatistics_" + clusterName;
    }

    private String createStatisticsPanelName(ServiceID serviceID) {
        return "SingleSpaceStatistics_" + serviceID;
    }

    void buttonsFalse() {
        if (this.undeploy != null) {
            this.undeploy.setEnabled(false);
        }
        if (this.undeployMenuItem != null) {
            this.undeployMenuItem.setEnabled(false);
        }
    }

    public void showClusterPanel(EditCluster editCluster, boolean isClusterMemberSelected, boolean isServiceManagerThreadPaused, boolean isAddOperationsNode) {
        this.currentCluster = editCluster;
        this._clusterViewDialog.setClusterView(editCluster, true, isClusterMemberSelected, isServiceManagerThreadPaused, isAddOperationsNode);
        if (!this.isClusterViewInitialized) {
            this.displayControl.addDisplayComponent(this._clusterViewDialog.getClusterPanel(), "ClusterGraph");
            this.isClusterViewInitialized = true;
        }
        this.displayControl.display(this._clusterViewDialog.getClusterPanel(), "ClusterGraph");
    }

    private void selectSpaceStatisticsPanel(IJSpace spaceProxy, ServiceID spaceID, String spaceName) {
        block3: {
            try {
                StatisticPanel statistic = this.statisticsPerSpace.get(spaceID);
                String statisticsPanelName = this.createStatisticsPanelName(spaceID);
                if (statistic == null) {
                    statistic = new StatisticPanel(this._mainUI);
                    statistic.setSpace(spaceProxy, spaceName);
                    this.statisticsPerSpace.put(spaceID, statistic);
                    this.displayControl.addDisplayComponent(statistic, statisticsPanelName);
                }
                this.displayControl.display(statistic, statisticsPanelName);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.toString(), e);
            }
        }
    }

    void setWaitCursor() {
        UIHelper.setWaitCursor(this.displayControl.getCurrentDisplay());
    }

    void setDefaultCursor() {
        UIHelper.setDefaultCursor(this.displayControl.getCurrentDisplay());
    }

    @Override
    public void serviceAdded(ServiceItem item) {
        JComponent currentComp;
        ClusterPanel clusterPanel;
        if (item.service instanceof ProvisionMonitor) {
            try {
                this.opStringGraph.addMonitor(item);
            }
            catch (Exception e) {
                UIHelper.showError((Throwable)e, "Adding a GSM to the graph");
            }
        } else if (item.service instanceof IJSpace && (clusterPanel = this._clusterViewDialog.getClusterPanelComponent()) != null) {
            clusterPanel.spaceAdded(item);
        }
        if ((currentComp = this.displayControl.getCurrentDisplay()) != null && currentComp instanceof OpStringGraph && (item.service instanceof ProvisionMonitor || item.service instanceof PUServiceBean)) {
            this.opStringGraph.display(true);
        }
    }

    @Override
    public void serviceRemoved(ServiceItem item) {
        if (item.service instanceof ProvisionMonitor) {
            this.opStringGraph.removeMonitor((ProvisionMonitor)item.service);
        } else if (item.service instanceof IJSpace) {
            ClusterPanel clusterPanel = this._clusterViewDialog.getClusterPanelComponent();
            clusterPanel.removeSpace(item.serviceID);
        }
        if (Repository.getInstance().getMonitorCount() == 0) {
            this.displayControl.display(this.blankPanel, BLANK);
        }
        this.jEEConfigurationPanelsContainer.clear(item.serviceID);
    }

    @Override
    public void serviceChanged(ServiceItem item) {
    }

    @Override
    public void notify(ProvisionMonitorEvent pme, String hostAddress) {
        try {
            int action = pme.getAction();
            JComponent currentComp = this.displayControl.getCurrentDisplay();
            switch (action) {
                case 7: {
                    this.opStringGraph.undeploy(pme.getOperationalString());
                    if (currentComp == null || !(currentComp instanceof OpStringGraph)) break;
                    this.setWaitCursor();
                    this.opStringGraph.display(false);
                    this.setDefaultCursor();
                }
            }
        }
        catch (Throwable t) {
            UIHelper.showError(t, "Processing a RemoteEvent from a GSM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOpStringTreeNodes(String name) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.theTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode node = this.findOpStringTreeNode(root, name);
        if (node != null) {
            DefaultTreeModel defaultTreeModel = treeModel;
            synchronized (defaultTreeModel) {
                treeModel.removeNodeFromParent(node);
                treeModel.nodeStructureChanged(root);
                if (root.getChildCount() == 0) {
                    this.undeploy.setEnabled(false);
                    this.undeployMenuItem.setEnabled(false);
                }
            }
        }
    }

    DefaultMutableTreeNode findOpStringTreeNode(DefaultMutableTreeNode node, String name) {
        DefaultMutableTreeNode opNode;
        block2: {
            DefaultMutableTreeNode n;
            TreeWorker.OpStringHolder ops;
            opNode = null;
            Object uo = node.getUserObject();
            if (uo instanceof TreeWorker.OpStringHolder && (ops = (TreeWorker.OpStringHolder)uo).getOpString(false).getName().equals(name)) {
                opNode = node;
            }
            if (opNode != null || node.getChildCount() < 0) break block2;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements() && (opNode = this.findOpStringTreeNode(n = (DefaultMutableTreeNode)e.nextElement(), name)) == null) {
            }
        }
        return opNode;
    }

    private void handleUndeploy(TreeWorker.OpStringHolder oh, AbstractButton ... undeployButtons) {
        if (!oh.isUndeploying() && this.doUndeploy(oh.getOpString(false), oh.deployAdmin)) {
            oh.setUndeploying(true);
            if (undeployButtons != null) {
                for (AbstractButton undeployButton : undeployButtons) {
                    if (undeployButton == null) continue;
                    undeployButton.setEnabled(false);
                }
            }
            this.undeploy.setEnabled(false);
            this.undeployMenuItem.setEnabled(false);
        }
    }

    boolean doUndeploy(final OperationalString opString, final DeployAdmin deployAdmin) {
        final String opStringName = opString.getName();
        int option = JOptionPane.showConfirmDialog(this._mainUI, "Undeploy the [" + opStringName + "] application ?", "Undeploy Confirmation", 0);
        if (option != 0) {
            return false;
        }
        if (deployAdmin != null) {
            final Timer taskTimer = new Timer(true);
            long now = System.currentTimeMillis();
            final WaitingToUndeployTask waitingToUndeployTask = new WaitingToUndeployTask(opString.getName());
            taskTimer.schedule((TimerTask)waitingToUndeployTask, new Date(now + 5000L));
            Runnable doUndeploy = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        deployAdmin.undeploy(opStringName);
                    }
                    catch (OperationalStringException e1) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, e1.toString(), e1);
                        }
                    }
                    catch (Exception e1) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, e1.toString(), e1);
                        }
                        waitingToUndeployTask.cancel();
                        int option = JOptionPane.showConfirmDialog(TreeServiceSelectionHandler.this._mainUI, "<html>Exception: <font color=red>" + e1.getClass().getName() + "</font><br> undeploying [<font color=blue>" + opStringName + "</font>] application,<br>force removal?</html>", "Undeploy Removal Confirmation", 0);
                        if (option != 0) {
                            return;
                        }
                        opString.setDeployed(0);
                        TreeServiceSelectionHandler.this.opStringGraph.undeploy(opString);
                        TreeServiceSelectionHandler.this.removeOpStringTreeNodes(opString.getName());
                        OperationalString[] nested = opString.getNestedOperationalStrings();
                        for (int i = 0; i < nested.length; ++i) {
                            TreeServiceSelectionHandler.this.removeOpStringTreeNodes(nested[i].getName());
                        }
                    }
                    finally {
                        taskTimer.cancel();
                        if (waitingToUndeployTask.dialog != null) {
                            waitingToUndeployTask.dialog.dispose();
                        }
                    }
                }
            };
            Thread t = new Thread(doUndeploy);
            t.start();
        } else if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Unknown DeployAdmin, unable to undeploy");
        }
        return true;
    }

    @Override
    public void setMenuItems(JMenuItem[] menuItems) {
        for (JMenuItem menuItem : menuItems) {
            String name = menuItem.getAccessibleContext().getAccessibleName();
            if (!name.equals("undeploy")) continue;
            this.undeployMenuItem = menuItem;
            this.undeployMenuItem.setEnabled(false);
            this.undeployMenuItem.addActionListener(new UndeployHandler());
        }
    }

    protected boolean hasProvisionPUPermission(TreeWorker.OpStringHolder oh) {
        if (oh.isSecured()) {
            ServiceID securedServiceID = oh.getSecuredServiceID();
            Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(securedServiceID);
            return authentication != null && authentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.PROVISION_PU);
        }
        return true;
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        DefaultMutableTreeNode parentParentTreeNode;
        DefaultMutableTreeNode parentTreeNode;
        DefaultMutableTreeNode selTreeNode;
        TreePath selTreePath = this.theTree.getSelectionPath();
        if (selTreePath != null && (selTreeNode = (DefaultMutableTreeNode)selTreePath.getLastPathComponent()) != null && (parentTreeNode = (DefaultMutableTreeNode)selTreeNode.getParent()) != null && (parentParentTreeNode = (DefaultMutableTreeNode)parentTreeNode.getParent()) != null) {
            Object userObj = selTreeNode.getUserObject();
            Object userParentObj = parentTreeNode.getUserObject();
            Object userParentParentObj = parentParentTreeNode.getUserObject();
            if (serviceItem.service instanceof IJSpace && userParentObj.equals("Operations") && userParentParentObj instanceof EditCluster || userParentObj instanceof SpaceServiceDescriptor && ((SpaceServiceDescriptor)userParentObj).getServiceID().equals((Object)serviceItem.serviceID) || userObj instanceof SpaceServiceDescriptor && ((SpaceServiceDescriptor)userObj).getServiceID().equals((Object)serviceItem.serviceID) || (serviceItem.service instanceof GSM || serviceItem.service instanceof GSC) && userObj instanceof TreeWorker.ServiceHolder && userParentObj.toString().equals("Processing Unit Instances") || serviceItem.service instanceof GSM && (userObj instanceof TreeWorker.OpStringHolder || selTreeNode instanceof EventContainersNode || selTreeNode instanceof RemoteServicesNode)) {
                this.initViewForSelectedTreeNode(false);
            }
        }
    }

    public void clearBenchmarks() {
        this.benchmarkPanelsPerCluster.clear();
        this.benchmarkPanelsPerSpace.clear();
    }

    class BlankPanel
    extends JPanel {
        BlankPanel() {
        }
    }

    class WaitingToUndeployTask
    extends TimerTask {
        String deployName;
        JDialog dialog;

        WaitingToUndeployTask(String deployName) {
            this.deployName = deployName;
        }

        @Override
        public void run() {
            JOptionPane pane = new JOptionPane("<html><font color=black>Undeploying the </font><font color=blue>" + this.deployName + "</font> <font color=black>deployment, <br>service termination in process ...</font></html>", 1);
            this.dialog = pane.createDialog(TreeServiceSelectionHandler.this._mainUI, "Undeployment In Progress");
            this.dialog.setModal(false);
            this.dialog.setVisible(true);
        }
    }

    class TableChangeListener
    implements Observer {
        TableChangeListener() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (TreeServiceSelectionHandler.this.displayControl == null) {
                return;
            }
            TreeServiceSelectionHandler.this.displayControl.refresh();
        }
    }

    class TreeMouseHandler
    extends MouseAdapter {
        TreeMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                DefaultMutableTreeNode selNode;
                TreePath path = TreeServiceSelectionHandler.this.theTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                Object selTreeComponent = path.getLastPathComponent();
                if (selTreeComponent instanceof DefaultMutableTreeNode && (selNode = (DefaultMutableTreeNode)selTreeComponent) instanceof JeePUServiceNode) {
                    String url = "http://" + selNode.toString();
                    JSpaceUIUtils.showInBrowser(TreeServiceSelectionHandler.this._mainUI, url, LOGGER);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            TreePath path = TreeServiceSelectionHandler.this.theTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Selected TreePath is NULL");
                }
                return;
            }
            Object selNode = path.getLastPathComponent();
            if (selNode instanceof DefaultMutableTreeNode) {
                TreeServiceSelectionHandler.this.theTree.setSelectionPath(path);
                Object uo = ((DefaultMutableTreeNode)selNode).getUserObject();
                this.doShowPopup(e, uo, (TreeNode)selNode);
            }
        }

        private void doShowPopup(MouseEvent e, Object uo, TreeNode selNode) {
            SpaceServiceDescriptor spaceServiceDescriptor;
            String type;
            JPopupMenu popup = null;
            if (selNode.toString().equals("Processing Units")) {
                TreeServiceSelectionHandler.this._rootsPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            if (uo instanceof TreeWorker.OpStringHolder) {
                final TreeWorker.OpStringHolder oh = (TreeWorker.OpStringHolder)uo;
                if (!oh.svcGridDeployment) {
                    final JMenuItem undeploy = new JMenuItem("Undeploy");
                    undeploy.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeServiceSelectionHandler.this.handleUndeploy(oh, new AbstractButton[]{undeploy});
                        }
                    });
                    if (!TreeServiceSelectionHandler.this.hasProvisionPUPermission(oh) || oh.isUndeploying()) {
                        undeploy.setEnabled(false);
                    }
                    JMenuItem update = new JMenuItem("Update");
                    URL loadedFrom = oh.getOpString(false).loadedFrom();
                    if (loadedFrom == null) {
                        update.setEnabled(false);
                    } else {
                        File f = null;
                        String jvmVersion = System.getProperty("java.version");
                        if (jvmVersion.indexOf("1.4") != -1) {
                            f = new File(loadedFrom.toExternalForm());
                        } else {
                            try {
                                f = new File(new URI(loadedFrom.toString()));
                                if (!f.exists()) {
                                    update.setEnabled(false);
                                }
                            }
                            catch (Exception e1) {
                                update.setEnabled(false);
                            }
                        }
                    }
                    update.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Component comp = SwingUtilities.getRoot(TreeServiceSelectionHandler.this.displayControl.getCurrentDisplay());
                            try {
                                DeployUpdate.exec(comp, TreeServiceSelectionHandler.this.displayControl.getLastPath(), oh.getOpString(false), oh.getPrimary());
                            }
                            catch (Exception e1) {
                                UIHelper.showError((Throwable)e1, "Updating Deployment");
                            }
                        }
                    });
                    if (popup == null) {
                        popup = new JPopupMenu();
                    }
                    popup.add(undeploy);
                    popup.add(update);
                }
            } else if (uo instanceof TreeWorker.ServiceHolder) {
                Object serviceObj;
                final TreeWorker.ServiceHolder sh = (TreeWorker.ServiceHolder)uo;
                TreeServiceSelectionHandler.this.jmxServiceUrl = sh.item == null ? null : JSpaceUtilities.getJMXConnectionUrl((ServiceItem)sh.item);
                try {
                    if (TreeServiceSelectionHandler.this.jmxServiceUrl == null) {
                        IJSpace spaceProxy;
                        IJSpaceContainerAdmin containerAdmin = null;
                        if (sh.instance != null) {
                            if (sh.instance.getService() instanceof IJSpace) {
                                spaceProxy = (IJSpace)sh.instance.getService();
                                containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
                            }
                        } else if (sh.item != null && sh.item.service instanceof IJSpace) {
                            spaceProxy = (IJSpace)sh.item.service;
                            containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
                        }
                        if (containerAdmin != null) {
                            ContainerConfig containerConfig = containerAdmin.getConfig();
                            TreeServiceSelectionHandler.this.jmxServiceUrl = JMXUtilities.createJMXUrl((String)containerConfig.jndiUrl);
                        }
                    }
                }
                catch (Exception exc) {
                    LOGGER.log(Level.WARNING, exc.toString(), exc);
                }
                final String descr = sh.getDescription() != null ? sh.getDescription() : "";
                TreeNode parentNode = selNode.getParent();
                if (parentNode != null && parentNode instanceof TreeWorker.PURootNode) {
                    Object userObject;
                    JMenuItem restartPUInstanceMenuItem;
                    block34: {
                        SecuredService securedServiceOwner = sh.getSecuredService();
                        if (popup == null) {
                            popup = new JPopupMenu();
                        }
                        restartPUInstanceMenuItem = new JMenuItem("Restart " + descr);
                        popup.add(restartPUInstanceMenuItem);
                        try {
                            if (securedServiceOwner != null && securedServiceOwner.isServiceSecured()) {
                                ServiceID securedServiceID = sh.getSecuredServiceID();
                                SecuredService securedService = sh.getSecuredService();
                                boolean isManagePUPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_PU, true);
                                boolean isMonitorPUPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, true);
                                restartPUInstanceMenuItem.setEnabled(isManagePUPermitted);
                            }
                        }
                        catch (Exception exc) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block34;
                            LOGGER.log(Level.SEVERE, exc.toString(), exc);
                        }
                    }
                    DefaultMutableTreeNode parentParentTreeNode = (DefaultMutableTreeNode)parentNode.getParent();
                    if (parentParentTreeNode != null && (userObject = parentParentTreeNode.getUserObject()) instanceof TreeWorker.OpStringHolder) {
                        restartPUInstanceMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                block3: {
                                    int returnValue = JOptionPane.showConfirmDialog(TreeServiceSelectionHandler.this._mainUI, "<HTML>Are you sure you want to restart <FONT COLOR=BLUE>" + descr + "</FONT> Processing Unit Instance?<HTML>", "Restart Processing Unit Instance", 0, 1);
                                    if (returnValue != 0) {
                                        return;
                                    }
                                    TreeWorker.OpStringHolder opStringHolder = (TreeWorker.OpStringHolder)userObject;
                                    String opStringName = opStringHolder.getOpString(false).getName();
                                    GSM gsm = (GSM)opStringHolder.monitor;
                                    ServiceID serviceToRelocate = sh.item.serviceID;
                                    ServiceID gscToRelocateTo = TreeServiceSelectionHandler.this._mainUI.getGscOwnerServiceID(serviceToRelocate);
                                    try {
                                        gsm.relocate(opStringName, serviceToRelocate, gscToRelocateTo, null);
                                    }
                                    catch (Exception exc) {
                                        if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                                        LOGGER.log(Level.SEVERE, exc.toString(), exc);
                                    }
                                }
                            }
                        });
                    }
                }
                if (sh != null && sh.item != null && selNode.getParent() != null && selNode.getParent().getParent() != null && selNode.getParent().getParent().getParent() != null && selNode.getParent().getParent().getParent().equals(TreeWorker.puRoot) && (serviceObj = sh.item.service) != null) {
                    if (popup == null) {
                        popup = new JPopupMenu();
                    }
                    HostGSCsComponent.addLaunchToSpacesMenuItems(popup, serviceObj, TreeServiceSelectionHandler.this._mainUI);
                }
            } else if (uo instanceof SpaceServiceDescriptor && (type = (spaceServiceDescriptor = (SpaceServiceDescriptor)uo).getType()).equals("embedded")) {
                if (popup == null) {
                    popup = new JPopupMenu();
                }
                String spaceContainerName = spaceServiceDescriptor.getSpaceContainerName();
                String spaceName = spaceServiceDescriptor.getSpaceName();
                ServiceID spaceID = spaceServiceDescriptor.getServiceID();
                HostGSCsComponent.addGoToSpaceMenuItem(spaceContainerName, spaceName, null, spaceID, TreeServiceSelectionHandler.this._mainUI, popup);
            }
            if (popup != null) {
                popup.pack();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class UndeployHandler
    implements ActionListener {
        UndeployHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent currentComp = TreeServiceSelectionHandler.this.displayControl.getCurrentDisplay();
            if (currentComp != null && currentComp instanceof PUConfigurationPanel) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreeServiceSelectionHandler.this.theTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object uo = node.getUserObject();
                if (uo instanceof TreeWorker.OpStringHolder) {
                    TreeWorker.OpStringHolder oh = (TreeWorker.OpStringHolder)uo;
                    TreeServiceSelectionHandler.this.handleUndeploy(oh, new AbstractButton[]{null});
                }
            }
        }
    }
}

