/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.grid.IConnectionProvider;
import com.gigaspaces.admin.ui.grid.OpStringGraph;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.TreeServiceSelectionHandler;
import com.gigaspaces.admin.ui.grid.gsc.HostGSCsComponent;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeCellRenderer;
import com.gigaspaces.admin.ui.grid.treenode.BasicPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.DeployedServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.EventContainersNode;
import com.gigaspaces.admin.ui.grid.treenode.GatewayPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.MemcachedNode;
import com.gigaspaces.admin.ui.grid.treenode.RemoteServicesNode;
import com.gigaspaces.admin.ui.util.DiscoveryUtil;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.grid.gsa.AgentIdAware;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.jdbc.driver.GDriver;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.EditCluster;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.statistics.ClusterStatisticPanel;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.isqlviewer.sql.DatabaseConnection;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanConfig;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ProvisionManager;
import org.jini.rio.entry.OperationalStringEntry;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;

public class TreeWorker {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    private JTree systemTree;
    private DefaultMutableTreeNode root;
    static final String PROCESSING_UNIT_ROOT_NAME = "Processing Units";
    public static final String PU_INSTANCES_ROOT = "Processing Unit Instances";
    static DefaultMutableTreeNode puRoot;
    private SortedTreeModel treeModel;
    private final MainUI _mainUI;
    private OpStringGraph _opStringGraph;
    private final Map<ServiceID, JTree> _clustTreeMap = new HashMap<ServiceID, JTree>(2);
    private final Map<ServiceID, DefaultMutableTreeNode> _opStrNodesMap = new HashMap<ServiceID, DefaultMutableTreeNode>(2);
    private final Map<String, ClusterStatisticPanel> statisticsPerUnmanagedCluster = new Hashtable<String, ClusterStatisticPanel>();
    private TreeServiceSelectionHandler _treeServiceNotificationListener;
    private final Map<String, Set<IJSpace>> _allClusteredSpaces = new Hashtable<String, Set<IJSpace>>();

    public TreeWorker(MainUI mainUI) {
        this._mainUI = mainUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JTree makeTree() {
        this.root = new DefaultMutableTreeNode("root");
        this.treeModel = new SortedTreeModel(this.root);
        this.systemTree = new ServicesTree(this.treeModel);
        this.systemTree.setRootVisible(false);
        this.systemTree.setShowsRootHandles(true);
        this.systemTree.setBackground(Color.white);
        this.systemTree.getSelectionModel().setSelectionMode(1);
        TreeRenderer renderer = new TreeRenderer();
        this.systemTree.setCellRenderer(renderer);
        puRoot = new DefaultMutableTreeNode(PROCESSING_UNIT_ROOT_NAME);
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            this.treeModel.insertNodeInto(puRoot, this.root, this.root.getChildCount());
            this.systemTree.makeVisible(new TreePath(puRoot.getPath()));
        }
        return this.systemTree;
    }

    public void setTreeServiceNotificationListener(TreeServiceSelectionHandler serviceNotificationListener) {
        this._treeServiceNotificationListener = serviceNotificationListener;
    }

    public TreeServiceSelectionHandler getTreeServiceNotificationListener() {
        return this._treeServiceNotificationListener;
    }

    void collapseTree() {
        for (int row = this.systemTree.getRowCount() - 1; row >= 0; --row) {
            this.systemTree.collapseRow(row);
        }
    }

    void expandTree() {
        for (int row = 0; row < this.systemTree.getRowCount(); ++row) {
            this.systemTree.expandRow(row);
        }
    }

    public void collapsePUs() {
        int childCount = puRoot.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            this.collapseTreePath(puRoot, childIndex);
        }
    }

    public void expandPUs() {
        int childCount = puRoot.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            this.expandTreePath(puRoot, childIndex);
        }
    }

    private void collapseTreePath(TreeNode parentNode, int childIndex) {
        TreeNode puNode = parentNode.getChildAt(childIndex);
        Object[] pn = this.treeModel.getPathToRoot(puNode);
        TreePath treePath = new TreePath(pn);
        LOGGER.finest("BEFORE COLLAPSE 2:" + treePath);
        this.systemTree.collapsePath(treePath);
    }

    private void expandTreePath(TreeNode parentNode, int childIndex) {
        TreeNode puNode = parentNode.getChildAt(childIndex);
        Object[] pn = this.treeModel.getPathToRoot(puNode);
        TreePath treePath = new TreePath(pn);
        this.systemTree.expandPath(treePath);
    }

    public void collapsePUInstances() {
        int childCount = puRoot.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            TreeNode puNode = puRoot.getChildAt(childIndex);
            TreeNode puInstancesRoot = puNode.getChildAt(0);
            int puInstancesCount = puInstancesRoot.getChildCount();
            for (int puInstanceNodeIndex = 0; puInstanceNodeIndex < puInstancesCount; ++puInstanceNodeIndex) {
                this.collapseTreePath(puInstancesRoot, puInstanceNodeIndex);
            }
        }
    }

    public void expandPUInstances() {
        int childCount = puRoot.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            TreeNode puNode = puRoot.getChildAt(childIndex);
            TreeNode puInstancesRoot = puNode.getChildAt(0);
            int puInstancesCount = puInstancesRoot.getChildCount();
            for (int puInstanceNodeIndex = 0; puInstanceNodeIndex < puInstancesCount; ++puInstanceNodeIndex) {
                this.expandTreePath(puInstancesRoot, puInstanceNodeIndex);
            }
        }
    }

    int getDeployedAppCount() {
        if (puRoot == null) {
            return 0;
        }
        return puRoot.getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDeploymentNames() {
        ArrayList<String> list = new ArrayList<String>();
        TreeWorker treeWorker = this;
        synchronized (treeWorker) {
            int children = puRoot.getChildCount();
            if (children > 0) {
                for (int i = 0; i < children; ++i) {
                    OperationalString opString;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)puRoot.getChildAt(i);
                    Object uo = node.getUserObject();
                    if (!(uo instanceof OpStringHolder) || (opString = ((OpStringHolder)uo).getOpString(false)) == null) continue;
                    list.add(opString.getName());
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public DefaultMutableTreeNode getOpStringTreeNode(String osName) {
        return this.getOpStringTreeNode(osName, puRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode getOpStringTreeNode(String osName, DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode treeNode;
        block6: {
            treeNode = null;
            TreeWorker treeWorker = this;
            synchronized (treeWorker) {
                block5: {
                    if (!(rootNode.getUserObject() instanceof OpStringHolder)) break block5;
                    Object uo = rootNode.getUserObject();
                    OperationalString opString = ((OpStringHolder)uo).getOpString(false);
                    if (opString == null || !osName.equals(opString.getName())) break block6;
                    treeNode = rootNode;
                    break block6;
                }
                int children = rootNode.getChildCount();
                if (children > 0) {
                    for (int i = 0; i < children; ++i) {
                        OperationalString opString;
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                        Object uo = node.getUserObject();
                        if (!(uo instanceof OpStringHolder) || (opString = ((OpStringHolder)uo).getOpString(false)) == null || !osName.equals(opString.getName())) continue;
                        treeNode = node;
                        break;
                    }
                }
            }
        }
        return treeNode;
    }

    boolean addService(ServiceItem item) {
        return this.addService(item, this.getOpStringName(item));
    }

    boolean addService(ServiceItem item, String opStringName) {
        return this.addService(item, opStringName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addClusterTree(JTree clusterTree, String clusterName, ServiceID spaceID, boolean isUnmanagedSpace) {
        if (!isUnmanagedSpace) {
            DefaultMutableTreeNode rootForCluster = this._opStrNodesMap.get(spaceID);
            SortedTreeModel sortedTreeModel = this.treeModel;
            synchronized (sortedTreeModel) {
                if (rootForCluster != null) {
                    DefaultTreeModel clusterTreeModel = (DefaultTreeModel)clusterTree.getModel();
                    DefaultMutableTreeNode clusterTreeNode = (DefaultMutableTreeNode)clusterTreeModel.getRoot();
                    if (!this.hasChildClusterNode(rootForCluster, clusterName)) {
                        this.treeModel.insertNodeInto(clusterTreeNode, rootForCluster, rootForCluster.getChildCount());
                    }
                }
                this._clustTreeMap.put(spaceID, clusterTree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean addService(ServiceItem item, String opStringName, ServiceBeanInstance serviceBeanInstance, ServiceElement serviceElement) {
        String[] serviceNames = DiscoveryUtil.getServiceNames(item);
        if (item.service instanceof ServiceRegistrar) {
            serviceNames = new String[]{"Lookup"};
        }
        if (opStringName == null) {
            return false;
        }
        final DefaultMutableTreeNode serviceElementNode = this.getServiceElementTreeNode(serviceNames, opStringName);
        if (serviceElementNode == null) {
            return false;
        }
        boolean added = false;
        if (this.findService(serviceElementNode, item) == null) {
            block12: {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "ADD SERVICE [" + this.flatten(serviceNames) + "] OPSTRING NAME [" + opStringName + "] ID=[" + item.serviceID + "]");
                }
                ServiceItem gsmServiceItem = null;
                Object service = item.service;
                if (service instanceof GSM) {
                    gsmServiceItem = item;
                }
                if (item.service instanceof AgentIdAware || item.service instanceof ServiceRegistrar && ((ServiceRegistrar)item.service).getRegistrar() instanceof AgentIdAware) {
                    return false;
                }
                try {
                    ServiceHolder serviceHolder = new ServiceHolder(item, serviceBeanInstance, gsmServiceItem == null ? null : (SecuredService)gsmServiceItem.service, gsmServiceItem == null ? null : gsmServiceItem.serviceID, serviceElement);
                    DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(serviceHolder);
                    SortedTreeModel sortedTreeModel = this.treeModel;
                    synchronized (sortedTreeModel) {
                        this.treeModel.insertNodeInto(serviceNode, serviceElementNode, serviceElementNode.getChildCount());
                        List<ServiceID> spacesIDsList = HostGSCsComponent.addDeployedServicesNodes(item, serviceNode, true);
                        DefaultMutableTreeNode opStringNode = (DefaultMutableTreeNode)serviceElementNode.getParent();
                        OpStringHolder opStringHolder = (OpStringHolder)opStringNode.getUserObject();
                        this.handleSpacesIDsList(spacesIDsList, opStringNode, opStringHolder.opString.getName());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TreePath treePath = new TreePath(serviceElementNode.getPath());
                                LOGGER.finest("BEFORE COLLAPSE 1:" + treePath);
                                TreeWorker.this.systemTree.collapsePath(treePath);
                                TreeWorker.this.systemTree.expandPath(treePath);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            added = true;
        }
        return added;
    }

    public static short getSpacePrimaryBackupIndication(TreeNode opStringNode, ServiceID puInstanceID) {
        if (opStringNode.getChildCount() > 0) {
            TreeNode puInstancesNode = opStringNode.getChildAt(0);
            int puInstancesCount = puInstancesNode.getChildCount();
            for (int childIndex = 0; childIndex < puInstancesCount; ++childIndex) {
                DefaultMutableTreeNode puInstanceNode = (DefaultMutableTreeNode)puInstancesNode.getChildAt(childIndex);
                ServiceHolder serviceHolder = (ServiceHolder)puInstanceNode.getUserObject();
                if (!serviceHolder.getServiceID().equals((Object)puInstanceID)) continue;
                return TreeWorker.getSpacePrimaryBackupIndication(puInstanceNode);
            }
        }
        return -1;
    }

    public static short getSpacePrimaryBackupIndication(TreeNode puInstanceNode) {
        int childCount = puInstanceNode.getChildCount();
        short returnedValue = -1;
        for (int index = 0; index < childCount; ++index) {
            TreeNode childTreeNode = puInstanceNode.getChildAt(index);
            if (!(childTreeNode instanceof DeployedServiceNode) || !((DeployedServiceNode)childTreeNode).getType().equals("embedded")) continue;
            ServiceID spaceServiceID = ((DeployedServiceNode)childTreeNode).getServiceID();
            returnedValue = SpaceBrowser.getInstance().getSpaceMode(spaceServiceID);
            break;
        }
        return returnedValue;
    }

    void removeService(ServiceBeanInstance instance, String opStringName) {
        this.removeService(new String[]{instance.getServiceBeanConfig().getName()}, opStringName, null, instance.getServiceBeanID());
    }

    void removeService(ServiceItem item) {
        String opStringName = this.getOpStringName(item);
        String[] serviceNames = DiscoveryUtil.getServiceNames(item);
        this._clustTreeMap.remove(item.serviceID);
        this._opStrNodesMap.remove(item.serviceID);
        if (opStringName == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, ResourceBundleHandler.getInstance().getResource("message.UnknownDeploymentDescriptorForService") + "=" + item.service.getClass().getName());
            }
            return;
        }
        Repository.getInstance().removeSpace(item.serviceID);
        this.removeService(serviceNames, opStringName, item.serviceID, null);
    }

    private void checkRemovingUnmanagedClusterNode(IJSpace removedSpace) {
        Set<Map.Entry<String, Set<IJSpace>>> allSpacesEntriesSet = this._allClusteredSpaces.entrySet();
        for (Map.Entry<String, Set<IJSpace>> mapEntry : allSpacesEntriesSet) {
            Set<IJSpace> set = mapEntry.getValue();
            if (!set.remove(removedSpace)) continue;
            if (set.size() != 0) break;
            String clusterName = mapEntry.getKey();
            this.stopClusterStatisticsPanel(clusterName);
            this.removeClusterNode(clusterName);
            break;
        }
    }

    private void stopClusterStatisticsPanel(String clusterName) {
        this._treeServiceNotificationListener.stopStatisticsClusterComponent(clusterName);
    }

    private void removeClusterNode(String clusterName) {
    }

    public void removePUInstances(List<ServiceID> removedPUInstanceIds, String operStringName) {
        for (ServiceID puInstanceServiceID : removedPUInstanceIds) {
            this.removeService(new String[]{operStringName}, operStringName, puInstanceServiceID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeService(String[] serviceNames, String opStringName, ServiceID serviceID, Uuid uuid) {
        DefaultMutableTreeNode sElemNode = this.getServiceElementTreeNode(serviceNames, opStringName);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "REMOVE SERVICE [" + this.flatten(serviceNames) + "] [" + opStringName + "] NODE=" + sElemNode + "serviceID=" + serviceID + "Thread id=" + Thread.currentThread().getId());
        }
        if (sElemNode == null) {
            return;
        }
        int children = sElemNode.getChildCount();
        if (children > 0) {
            ArrayList<DefaultMutableTreeNode> removals = new ArrayList<DefaultMutableTreeNode>();
            for (int i = 0; i < children; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)sElemNode.getChildAt(i);
                Object uo = node.getUserObject();
                if (!(uo instanceof ServiceHolder)) continue;
                ServiceHolder sh = (ServiceHolder)uo;
                ServiceElement serviceElement = sh.serviceElement;
                if (serviceElement != null) {
                    this._opStringGraph.removeServiceElements(new ServiceElement[]{serviceElement});
                }
                if (serviceID != null) {
                    if (sh.item == null || !sh.item.serviceID.equals((Object)serviceID)) continue;
                    removals.add(node);
                    continue;
                }
                if (uuid == null || sh.instance == null || !sh.instance.getServiceBeanID().equals((Object)uuid)) continue;
                removals.add(node);
            }
            if (removals.size() > 0) {
                for (DefaultMutableTreeNode node : removals) {
                    boolean nodeRemoved = false;
                    SortedTreeModel sortedTreeModel = this.treeModel;
                    synchronized (sortedTreeModel) {
                        MutableTreeNode parentOfParentNode;
                        TreeNode rootNode;
                        Object userObject = node.getUserObject();
                        DefaultMutableTreeNode parentNode = null;
                        if (userObject instanceof ServiceHolder && (rootNode = (parentOfParentNode = (MutableTreeNode)(parentNode = (DefaultMutableTreeNode)node.getParent()).getParent()).getParent()) != null && rootNode.equals(puRoot) && parentNode.getChildCount() < 2) {
                            if (parentOfParentNode.getChildCount() < 2 || parentOfParentNode.getChildCount() >= 2 && this.hasOnlyOnePUInstancesRoot((DefaultMutableTreeNode)parentOfParentNode)) {
                                this.treeModel.removeNodeFromParent(parentOfParentNode);
                                TreePath treePath = new TreePath(((DefaultMutableTreeNode)rootNode).getPath());
                                boolean isExpanded = this.systemTree.isExpanded(treePath);
                                if (isExpanded) {
                                    this.systemTree.expandPath(treePath);
                                }
                                nodeRemoved = true;
                            }
                            if (!nodeRemoved) {
                                this.treeModel.removeNodeFromParent(parentNode);
                                nodeRemoved = true;
                            }
                        }
                        if (!nodeRemoved && node.getParent() != null) {
                            this.treeModel.removeNodeFromParent(node);
                        }
                    }
                }
            }
        }
    }

    private boolean hasChildClusterNode(DefaultMutableTreeNode opStringNode, String clusterName) {
        boolean hasCluster = false;
        for (int index = opStringNode.getChildCount() - 1; index >= 0; --index) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)opStringNode.getChildAt(index);
            if (!(childNode.getUserObject() instanceof EditCluster) || !((EditCluster)childNode.getUserObject()).getClusterName().equals(clusterName)) continue;
            hasCluster = true;
            break;
        }
        return hasCluster;
    }

    private boolean hasOnlyOnePUInstancesRoot(DefaultMutableTreeNode opStringNode) {
        int count = 0;
        for (int index = opStringNode.getChildCount() - 1; index >= 0; --index) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)opStringNode.getChildAt(index);
            if (!(childNode instanceof PURootNode)) continue;
            ++count;
        }
        return count == 1;
    }

    private String flatten(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceHolder findService(DefaultMutableTreeNode sElemNode, ServiceItem item) {
        ServiceHolder sh = null;
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            if (sElemNode != null && item.serviceID != null) {
                int children = sElemNode.getChildCount();
                for (int i = 0; i < children; ++i) {
                    Uuid uuid;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)sElemNode.getChildAt(i);
                    Object uo = node.getUserObject();
                    if (!(uo instanceof ServiceHolder)) continue;
                    ServiceHolder s = (ServiceHolder)uo;
                    if (s.item != null && s.item.serviceID.equals((Object)item.serviceID)) {
                        sh = s;
                        break;
                    }
                    if (s.instance == null || !(uuid = UuidFactory.create((long)item.serviceID.getMostSignificantBits(), (long)item.serviceID.getLeastSignificantBits())).equals((Object)s.instance.getServiceBeanID())) continue;
                    s.item = item;
                    sh = s;
                    break;
                }
            }
        }
        return sh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceHolder findService(DefaultMutableTreeNode sElemNode, ServiceBeanInstance instance) {
        ServiceHolder sh = null;
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            if (sElemNode != null && instance != null) {
                int children = sElemNode.getChildCount();
                for (int i = 0; i < children; ++i) {
                    Uuid uuid;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)sElemNode.getChildAt(i);
                    Object uo = node.getUserObject();
                    if (!(uo instanceof ServiceHolder)) continue;
                    ServiceHolder s = (ServiceHolder)uo;
                    if (s.instance != null && s.instance.equals((Object)instance)) {
                        sh = s;
                        break;
                    }
                    if (s.item == null || !(uuid = UuidFactory.create((long)s.item.serviceID.getMostSignificantBits(), (long)s.item.serviceID.getLeastSignificantBits())).equals((Object)instance.getServiceBeanID())) continue;
                    s.instance = instance;
                    sh = s;
                    break;
                }
            }
        }
        return sh;
    }

    DefaultMutableTreeNode[] getServices(DefaultMutableTreeNode sElemNode) {
        ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
        if (sElemNode != null) {
            int children = sElemNode.getChildCount();
            for (int i = 0; i < children; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)sElemNode.getChildAt(i);
                Object uo = node.getUserObject();
                if (!(uo instanceof ServiceHolder)) continue;
                list.add(node);
            }
        }
        return list.toArray(new DefaultMutableTreeNode[list.size()]);
    }

    private String getOpStringName(ServiceItem item) {
        String opStringName = null;
        for (int i = 0; i < item.attributeSets.length; ++i) {
            if (!(item.attributeSets[i] instanceof OperationalStringEntry)) continue;
            opStringName = ((OperationalStringEntry)item.attributeSets[i]).name;
            break;
        }
        return opStringName;
    }

    void importOpStrings(ServiceItem item) {
        try {
            this.addService(item);
            ProvisionMonitor monitor = (ProvisionMonitor)item.service;
            Method getAdmin = monitor.getClass().getMethod("getAdmin", null);
            DeployAdmin deployAdmin = (DeployAdmin)getAdmin.invoke((Object)monitor, (Object[])null);
            Object[] opStringMgrs = deployAdmin.getOperationalStringManagers();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "~~~~~~ importOpStrings:" + item);
                LOGGER.log(Level.FINEST, "~~~~~~opStringMgrs=" + Arrays.toString(opStringMgrs));
            }
            OSDetails osDetails = Repository.getInstance().getOSDetails(item, true);
            String hostAddress = null;
            if (osDetails != null) {
                hostAddress = osDetails.getHostAddress();
            }
            if (opStringMgrs != null && opStringMgrs.length >= 0 && hostAddress != null) {
                this.addOpStrings(hostAddress, monitor, item.serviceID, deployAdmin, (OperationalStringManager[])opStringMgrs);
            }
        }
        catch (Exception e) {
            UIHelper.showError((Throwable)e, "Importing Deployment Descriptor from GSM");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOpStrings(String hostAddress, ProvisionMonitor monitor, ServiceID serviceID, DeployAdmin deployAdmin, OperationalStringManager[] opStringMgrs) {
        TreeWorker treeWorker = this;
        synchronized (treeWorker) {
            for (int i = 0; i < opStringMgrs.length; ++i) {
                try {
                    this.addOpString(hostAddress, monitor, serviceID, deployAdmin, opStringMgrs[i]);
                    if (this.systemTree.getSelectionPath() != null) continue;
                    this.systemTree.setSelectionPath(new TreePath(puRoot.getPath()));
                    continue;
                }
                catch (Exception e) {
                    UIHelper.showError((Throwable)e, "Adding Deployment Descriptor from GSM");
                }
            }
        }
    }

    public boolean isServicesDisplayed() {
        return puRoot.getChildCount() > 0;
    }

    private void addOpString(String hostAddress, ProvisionMonitor monitor, ServiceID serviceID, DeployAdmin deployAdmin, OperationalStringManager opStringMgr) throws OperationalStringException, RemoteException {
        OperationalString opString = opStringMgr.getOperationalString();
        this.addOpString(hostAddress, monitor, serviceID, deployAdmin, opStringMgr, opString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultMutableTreeNode addOpString(String hostAddress, ProvisionMonitor monitor, ServiceID serviceID, DeployAdmin deployAdmin, OperationalStringManager opStringMgr, OperationalString opString) throws OperationalStringException, RemoteException {
        String opsStringName = opString.getName();
        OperationalStringManager opStringManagerLocal = deployAdmin.getOperationalStringManager(opsStringName);
        boolean isManaging = opStringManagerLocal.isManaging();
        if (!isManaging) {
            return null;
        }
        DefaultMutableTreeNode opStringNode = this.getOpStringTreeNode(opsStringName);
        if (opStringNode != null) {
            return opStringNode;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "### ADD OPSTRING " + ResourceBundleHandler.getInstance().getResource("message.CreateNewDeploymentDescriptorNode") + " " + opString.getName());
        }
        opStringNode = new DefaultMutableTreeNode(new OpStringHolder(hostAddress, monitor, serviceID, deployAdmin, opStringMgr, opString));
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            this.treeModel.insertNodeInto(opStringNode, puRoot, puRoot.getChildCount());
            this.systemTree.makeVisible(new TreePath(opStringNode.getPath()));
            ServiceElement[] elems = opString.getServices();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "ELEMENTS COUNT=" + elems.length);
            }
            for (int i = 0; i < elems.length; ++i) {
                DefaultMutableTreeNode puInstancesRoot = this.addServiceElementNode(elems[i], opStringNode);
                Object[] instances = opStringMgr.getServiceBeanInstances(elems[i]);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Instances for " + elems[i] + " >>> INSTANCES:" + Arrays.toString(instances));
                }
                for (int j = 0; j < instances.length; ++j) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "BEFORE FIND SERVICE" + puInstancesRoot + " AND \n" + instances[j]);
                    }
                    if (this.findService(puInstancesRoot, (ServiceBeanInstance)instances[j]) != null) continue;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "ADD SERVICE [" + elems[i].getName() + "] OPSTRING NAME [" + opString.getName() + "]");
                    }
                    Uuid serviceUuid = instances[j].getServiceBeanID();
                    ServiceID servID = new ServiceID(serviceUuid.getMostSignificantBits(), serviceUuid.getLeastSignificantBits());
                    ServiceItem serviceItem = MainUI.lookupServiceItem(servID);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Service located=" + serviceItem + " for servID=" + servID);
                    }
                    if (serviceItem == null) continue;
                    ServiceHolder serviceHolder = null;
                    if (serviceItem.service instanceof AgentIdAware) continue;
                    serviceHolder = new ServiceHolder(serviceItem, (ServiceBeanInstance)instances[j], (SecuredService)monitor, serviceID, elems[i]);
                    DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(serviceHolder);
                    this.treeModel.insertNodeInto(serviceNode, puInstancesRoot);
                    try {
                        List<ServiceID> spacesIDsList = HostGSCsComponent.addDeployedServicesNodes(serviceItem, serviceNode, true);
                        this.handleSpacesIDsList(spacesIDsList, opStringNode, opsStringName);
                        this.systemTree.makeVisible(new TreePath(puInstancesRoot.getPath()));
                        continue;
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            OperationalString[] nested = opString.getNestedOperationalStrings();
            for (int j = 0; j < nested.length; ++j) {
                if (deployAdmin != null) {
                    this.addOpString(hostAddress, monitor, serviceID, deployAdmin, deployAdmin.getOperationalStringManager(nested[j].getName()));
                    continue;
                }
                this.addOpString(hostAddress, monitor, serviceID, null, null, nested[j]);
            }
        }
        return opStringNode;
    }

    private void handleSpacesIDsList(List<ServiceID> spacesIDsList, DefaultMutableTreeNode opStringNode, String opsStringName) {
        for (ServiceID spaceServiceID : spacesIDsList) {
            this._opStrNodesMap.put(spaceServiceID, opStringNode);
            if (!this._clustTreeMap.containsKey(spaceServiceID)) continue;
            this.addClusterTree(this._clustTreeMap.get(spaceServiceID), opsStringName, spaceServiceID, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOpString(OperationalString opString) {
        DefaultMutableTreeNode node = this.getOpStringTreeNode(opString.getName());
        if (node != null) {
            SortedTreeModel sortedTreeModel = this.treeModel;
            synchronized (sortedTreeModel) {
                this.treeModel.removeNodeFromParent(node);
                this.treeModel.nodeStructureChanged(puRoot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitor(ServiceItem item) {
        ArrayList<DefaultMutableTreeNode> removals = new ArrayList<DefaultMutableTreeNode>();
        if (puRoot.getChildCount() > 0) {
            for (int i = 0; i < puRoot.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)puRoot.getChildAt(i);
                Object uo = node.getUserObject();
                if (!(uo instanceof OpStringHolder)) continue;
                OpStringHolder osh = (OpStringHolder)uo;
                int count = osh.removeMonitor((ProvisionMonitor)item.service);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "monitor count for [" + osh.opString.getName() + "]=" + count);
                }
                if (count != 0) continue;
                removals.add(node);
            }
        }
        if (removals.size() == 0) {
            return;
        }
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            for (DefaultMutableTreeNode node : removals) {
                TreeNode parent = node.getParent();
                if (parent == null) continue;
                this.treeModel.removeNodeFromParent(node);
                this.treeModel.nodeStructureChanged(parent);
            }
        }
    }

    DefaultMutableTreeNode addServiceElementNode(ServiceElement sElem) {
        DefaultMutableTreeNode opStringNode = this.getOpStringTreeNode(sElem.getOperationalStringName());
        if (opStringNode == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, ResourceBundleHandler.getInstance().getResource("message.UnknownDeploymentDescriptor") + " " + sElem.getOperationalStringName());
            }
            return null;
        }
        DefaultMutableTreeNode puInstancesRootNode = this.getPURoot(opStringNode, sElem);
        return puInstancesRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized DefaultMutableTreeNode getPURoot(DefaultMutableTreeNode opStringNode, ServiceElement sElem) {
        PURootNode puRootNode = null;
        int childNodesCount = opStringNode.getChildCount();
        for (int index = 0; index < childNodesCount; ++index) {
            if (!(opStringNode.getChildAt(index) instanceof PURootNode)) continue;
            puRootNode = (PURootNode)opStringNode.getChildAt(index);
        }
        if (puRootNode == null) {
            puRootNode = new PURootNode(new ServiceElementHolder(sElem, (OpStringHolder)opStringNode.getUserObject()));
            SortedTreeModel sortedTreeModel = this.treeModel;
            synchronized (sortedTreeModel) {
                this.treeModel.insertNodeInto(puRootNode, opStringNode, 0);
            }
        }
        return puRootNode;
    }

    synchronized DefaultMutableTreeNode addServiceElementNode(ServiceElement sElem, DefaultMutableTreeNode opStringNode) {
        DefaultMutableTreeNode puInstancesRootNode = this.getPURoot(opStringNode, sElem);
        return puInstancesRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateOpString(OperationalString opString) {
        DefaultMutableTreeNode node = this.getOpStringTreeNode(opString.getName());
        if (node == null) {
            return;
        }
        ((OpStringHolder)node.getUserObject()).opString = opString;
        ServiceElement[] sElems = opString.getServices();
        for (int i = 0; i < sElems.length; ++i) {
            this.updateServiceElement(sElems[i]);
        }
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            this.treeModel.nodeChanged(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateServiceElement(ServiceElement sElem) {
        DefaultMutableTreeNode node = this.getServiceElementTreeNode(sElem);
        if (node == null) {
            return;
        }
        SortedTreeModel sortedTreeModel = this.treeModel;
        synchronized (sortedTreeModel) {
            DefaultMutableTreeNode opNode = this.getOpStringTreeNode(sElem.getOperationalStringName());
            if (opNode != null) {
                OpStringHolder osh = (OpStringHolder)opNode.getUserObject();
                osh.getOpString(false).removeService(sElem);
                osh.getOpString(false).addService(sElem);
                try {
                    ArrayList<DefaultMutableTreeNode> removals = new ArrayList<DefaultMutableTreeNode>();
                    ServiceBeanInstance[] instances = osh.getPrimary().getServiceBeanInstances(sElem);
                    DefaultMutableTreeNode[] shNodes = this.getServices(node);
                    for (int i = 0; i < shNodes.length; ++i) {
                        boolean found = false;
                        ServiceHolder sh = (ServiceHolder)shNodes[i].getUserObject();
                        for (int j = 0; j < instances.length; ++j) {
                            Uuid uuid;
                            if (sh.instance != null && sh.instance.getServiceBeanID().equals((Object)instances[j].getServiceBeanID())) {
                                found = true;
                                break;
                            }
                            if (sh.item == null || !(uuid = UuidFactory.create((long)sh.item.serviceID.getMostSignificantBits(), (long)sh.item.serviceID.getLeastSignificantBits())).equals((Object)instances[j].getServiceBeanID())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        removals.add(shNodes[i]);
                    }
                    if (removals.size() > 0) {
                        for (DefaultMutableTreeNode n : removals) {
                            this.treeModel.removeNodeFromParent(n);
                        }
                        this.treeModel.nodeStructureChanged(node);
                    }
                }
                catch (Exception e) {
                    UIHelper.showError((Throwable)e, "Updating ServiceElement");
                }
            }
            this.treeModel.nodeChanged(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceElement(ServiceElement sElem) {
        DefaultMutableTreeNode node = this.getServiceElementTreeNode(sElem);
        if (node != null) {
            SortedTreeModel sortedTreeModel = this.treeModel;
            synchronized (sortedTreeModel) {
                TreeNode parent = node.getParent();
                this.treeModel.removeNodeFromParent(node);
                this.treeModel.nodeStructureChanged(parent);
            }
        }
    }

    DefaultMutableTreeNode getServiceElementTreeNode(ServiceElement elem) {
        int children;
        DefaultMutableTreeNode treeNode = null;
        DefaultMutableTreeNode opNode = this.getOpStringTreeNode(elem.getOperationalStringName());
        if (opNode != null && (children = opNode.getChildCount()) > 0) {
            for (int i = 0; i < children; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)opNode.getChildAt(i);
                if (node instanceof PURootNode) {
                    return node;
                }
                Object uo = node.getUserObject();
                if (!(uo instanceof ServiceElementHolder)) continue;
                ServiceElement sElem = ((ServiceElementHolder)uo).sElem;
                if (!elem.getName().equals(sElem.getName())) continue;
                treeNode = node;
                break;
            }
        }
        return treeNode;
    }

    DefaultMutableTreeNode getServiceElementTreeNode(String[] serviceNames, String opStringName) {
        DefaultMutableTreeNode treeNode = null;
        for (int i = 0; i < serviceNames.length && (treeNode = this.getServiceElementTreeNode(serviceNames[i], opStringName)) == null; ++i) {
        }
        return treeNode;
    }

    DefaultMutableTreeNode getServiceElementTreeNode(String serviceName, String opStringName) {
        DefaultMutableTreeNode treeNode = null;
        DefaultMutableTreeNode opNode = this.getOpStringTreeNode(opStringName);
        if (opNode != null) {
            int children = opNode.getChildCount();
            if (children > 0) {
                for (int i = 0; i < children; ++i) {
                    ServiceElement sElem;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)opNode.getChildAt(i);
                    if (node instanceof PURootNode) {
                        return node;
                    }
                    Object uo = node.getUserObject();
                    if (!(uo instanceof ServiceElementHolder) || !serviceName.equals((sElem = ((ServiceElementHolder)uo).sElem).getName())) continue;
                    treeNode = node;
                    break;
                }
            }
        } else if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "### NO OPNODE FOR [" + serviceName + "] OPSTRING [" + opStringName + "]");
        }
        return treeNode;
    }

    void setManaging(ProvisionMonitor monitor, ServiceID monitorServiceID, String opStringName) throws RemoteException, OperationalStringException {
        DefaultMutableTreeNode node = this.getOpStringTreeNode(opStringName);
        if (node != null) {
            OpStringHolder osh = (OpStringHolder)node.getUserObject();
            osh.setPrimary(monitor, monitorServiceID, true);
        }
    }

    public static ImageIcon getSpaceIcon(ServiceID spaceServiceID, boolean isSecured) {
        short spaceMode = SpaceBrowser.getInstance().getSpaceMode(spaceServiceID);
        if (spaceMode < 0) {
            return null;
        }
        return JSpaceUIUtils.getSpaceIcon(spaceMode, isSecured, spaceServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClusterOperationNode(ServiceID spaceID, String operationName, String clusterName) {
        block10: {
            try {
                this._mainUI.setCursor(Cursor.getPredefinedCursor(3));
                TreeNode clusterNode = null;
                DefaultMutableTreeNode opStringNodeNode = this._opStrNodesMap.get(spaceID);
                if (opStringNodeNode != null) {
                    clusterNode = this.getClusterRoot(opStringNodeNode);
                }
                if (clusterNode == null) break block10;
                SortedTreeModel sortedTreeModel = this.treeModel;
                synchronized (sortedTreeModel) {
                    TreeNode operationsNode = JSpaceUIUtils.getChildTreeNode(clusterNode, "Operations");
                    if (operationsNode != null) {
                        TreeNode searchedOperationNode = JSpaceUIUtils.getChildTreeNode(operationsNode, operationName);
                        TreePath selPath = null;
                        if (searchedOperationNode != null) {
                            Object[] pn = this.treeModel.getPathToRoot(searchedOperationNode);
                            selPath = new TreePath(pn);
                            this.systemTree.scrollPathToVisible(selPath);
                            this.systemTree.setSelectionPath(selPath);
                        }
                        if (selPath != null && !this.systemTree.isExpanded(selPath)) {
                            this.systemTree.expandPath(selPath);
                        }
                    }
                }
            }
            finally {
                this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    private TreeNode getClusterRoot(DefaultMutableTreeNode opStringNodeNode) {
        int childNodesCount = opStringNodeNode.getChildCount();
        DefaultMutableTreeNode searchedNode = null;
        for (int index = 0; index < childNodesCount; ++index) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)opStringNodeNode.getChildAt(index);
            if (!(childNode.getUserObject() instanceof EditCluster)) continue;
            searchedNode = childNode;
            break;
        }
        return searchedNode;
    }

    public void setOpStringGraph(OpStringGraph opStringGraph) {
        this._opStringGraph = opStringGraph;
    }

    public void addUnmanagedSpace(IJSpace spaceProxy, ServiceID spaceID) {
        block4: {
            SpaceNode spaceNode = new SpaceNode(spaceProxy, spaceID);
            boolean isClusteredSpace = false;
            try {
                IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
                SpaceConfig spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                isClusteredSpace = spaceConfig.isClustered();
                if (isClusteredSpace) {
                    String clusterName = spaceConfig.getClusterInfo().getClusterName();
                    this.addSpaceToAllClusteredSpacesHashtable(spaceProxy, clusterName);
                }
            }
            catch (SpaceSecurityException spaceAdmin) {
            }
            catch (RemoteException re) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, re.toString(), re);
            }
        }
    }

    private void addSpaceToAllClusteredSpacesHashtable(IJSpace space, String clusterName) {
        Set<IJSpace> clusterdSpacesSet = this._allClusteredSpaces.get(clusterName);
        if (clusterdSpacesSet == null) {
            clusterdSpacesSet = new HashSet<IJSpace>();
            this._allClusteredSpaces.put(clusterName, clusterdSpacesSet);
        }
        clusterdSpacesSet.add(space);
    }

    public static List<ServiceHolder> getPUServiceHolders(TreeNode opStringNode) {
        ArrayList<ServiceHolder> resultList = new ArrayList<ServiceHolder>(1);
        if (opStringNode.getChildCount() > 0) {
            TreeNode puInstancesNode = opStringNode.getChildAt(0);
            int puInstancesCount = puInstancesNode.getChildCount();
            for (int childIndex = 0; childIndex < puInstancesCount; ++childIndex) {
                DefaultMutableTreeNode puIntanceNode = (DefaultMutableTreeNode)puInstancesNode.getChildAt(childIndex);
                if (!(puIntanceNode.getUserObject() instanceof ServiceHolder)) continue;
                ServiceHolder serviceHolder = (ServiceHolder)puIntanceNode.getUserObject();
                resultList.add(serviceHolder);
            }
        }
        return resultList;
    }

    public static boolean hasEmbeddedSpace(TreeNode opStringNode, ServiceID puInstanceID) {
        if (opStringNode.getChildCount() > 0) {
            TreeNode puInstancesNode = opStringNode.getChildAt(0);
            int puInstancesCount = puInstancesNode.getChildCount();
            for (int childIndex = 0; childIndex < puInstancesCount; ++childIndex) {
                DefaultMutableTreeNode puInstanceNode = (DefaultMutableTreeNode)puInstancesNode.getChildAt(childIndex);
                ServiceHolder serviceHolder = (ServiceHolder)puInstanceNode.getUserObject();
                if (!serviceHolder.getServiceID().equals((Object)puInstanceID)) continue;
                int childCount = puInstanceNode.getChildCount();
                for (int index = 0; index < childCount; ++index) {
                    TreeNode childNode = puInstanceNode.getChildAt(index);
                    if (!(childNode instanceof DeployedServiceNode) || !((DeployedServiceNode)childNode).getType().equals("embedded")) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static boolean hasGateway(TreeNode opStringNode, ServiceID puInstanceID) {
        if (opStringNode.getChildCount() > 0) {
            TreeNode puInstancesNode = opStringNode.getChildAt(0);
            int puInstancesCount = puInstancesNode.getChildCount();
            for (int childIndex = 0; childIndex < puInstancesCount; ++childIndex) {
                DefaultMutableTreeNode puInstanceNode = (DefaultMutableTreeNode)puInstancesNode.getChildAt(childIndex);
                ServiceHolder serviceHolder = (ServiceHolder)puInstanceNode.getUserObject();
                if (!serviceHolder.getServiceID().equals((Object)puInstanceID)) continue;
                int childCount = puInstanceNode.getChildCount();
                for (int index = 0; index < childCount; ++index) {
                    TreeNode childNode = puInstanceNode.getChildAt(index);
                    if (!(childNode instanceof GatewayPUServiceNode)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private class PUInstancesComparator
    implements Comparator {
        private PUInstancesComparator() {
        }

        public int compare(Object o1, Object o2) {
            ServiceHolder serviceHolder1 = (ServiceHolder)((DefaultMutableTreeNode)o1).getUserObject();
            ServiceHolder serviceHolder2 = (ServiceHolder)((DefaultMutableTreeNode)o2).getUserObject();
            String description1 = serviceHolder1.getDescription();
            String description2 = serviceHolder2.getDescription();
            return description1.compareToIgnoreCase(description2);
        }
    }

    private class SortedTreeModel
    extends DefaultTreeModel {
        private final Comparator comparator;

        public SortedTreeModel(TreeNode root) {
            super(root);
            this.comparator = new PUInstancesComparator();
        }

        public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent) {
            int index = this.findIndexFor(child, parent);
            super.insertNodeInto(child, parent, index);
        }

        private int findIndexFor(MutableTreeNode child, MutableTreeNode parent) {
            int cc = parent.getChildCount();
            if (cc == 0) {
                return 0;
            }
            if (cc == 1) {
                return this.comparator.compare(child, parent.getChildAt(0)) <= 0 ? 0 : 1;
            }
            return this.findIndexFor(child, parent, 0, cc - 1);
        }

        private int findIndexFor(MutableTreeNode child, MutableTreeNode parent, int i1, int i2) {
            if (i1 == i2) {
                return this.comparator.compare(child, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
            }
            int half = (i1 + i2) / 2;
            if (this.comparator.compare(child, parent.getChildAt(half)) <= 0) {
                return this.findIndexFor(child, parent, i1, half);
            }
            return this.findIndexFor(child, parent, half + 1, i2);
        }
    }

    public class ServicesTree
    extends JTree {
        public ServicesTree(TreeModel newModel) {
            super(newModel);
            this.setToolTipText("");
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (event != null) {
                DefaultMutableTreeNode treeNode;
                Object userObject;
                TreePath path;
                Object lastPath;
                Point p = event.getPoint();
                int selRow = this.getRowForLocation(p.x, p.y);
                TreeCellRenderer r = this.getCellRenderer();
                if (selRow != -1 && r != null && (lastPath = (path = this.getPathForRow(selRow)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)lastPath).getUserObject()) instanceof ServiceHolder) {
                    String name = ((ServiceHolder)userObject).item.serviceID.toString();
                    return name;
                }
            }
            return null;
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        private final ImageIcon appIcon;
        private final ImageIcon puIcon;
        private final ImageIcon puInstancesRootIcon;
        private final ImageIcon securedPUIcon;
        private final ImageIcon securedAuthenticatedPUIcon;
        private final ImageIcon clusterIcon;
        private final ImageIcon groupIcon;
        private final ImageIcon operationsIcon;
        private final ImageIcon spaceIcon;
        private final ImageIcon eventContainersIcon;
        private final ImageIcon remoteServicesIcon;
        private final ImageIcon classesIcon;
        private final ImageIcon transactionsIcon;
        private final ImageIcon sqlIcon;
        private final ImageIcon statisticsIcon;
        private final ImageIcon connectionsIcon;
        private final ImageIcon benchmarkIcon;
        private final ImageIcon clustersRootIcon;

        public TreeRenderer() {
            String path = "com/gigaspaces/admin/ui/images/";
            this.appIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/applications.gif");
            this.puIcon = IconsRepository.getInstance().getIcon(1);
            this.securedPUIcon = IconsRepository.getInstance().getIcon(3);
            this.securedAuthenticatedPUIcon = IconsRepository.getInstance().getIcon(4);
            this.puInstancesRootIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/pu_instances_root.png");
            this.eventContainersIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/event_containers.png");
            this.remoteServicesIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/remote_containers.png");
            this.clusterIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clustered_space.gif"));
            this.groupIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/cluster_groups.gif"));
            this.operationsIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/operations.gif"));
            this.classesIcon = new ImageIcon(this.getClass().getResource("/image/browser/classes.gif"));
            this.transactionsIcon = new ImageIcon(this.getClass().getResource("/image/browser/transaction.gif"));
            this.sqlIcon = new ImageIcon(this.getClass().getResource("/image/browser/query.gif"));
            this.statisticsIcon = new ImageIcon(this.getClass().getResource("/image/browser/statistics.gif"));
            this.connectionsIcon = new ImageIcon(this.getClass().getResource("/image/browser/space_connections.gif"));
            this.benchmarkIcon = new ImageIcon(this.getClass().getResource("/image/browser/benchmark.gif"));
            this.spaceIcon = IconsRepository.getInstance().getIcon(50);
            this.clustersRootIcon = new ImageIcon(this.getClass().getResource("/image/cluster-wizard/clustersRoot.gif"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jtree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(jtree, obj, sel, expanded, leaf, row, hasFocus);
            if (obj instanceof PURootNode) {
                this.setIcon(this.puInstancesRootIcon);
            } else if (obj instanceof SpaceNode) {
                SpaceNode spaceNode = (SpaceNode)obj;
                this.setIcon(TreeWorker.getSpaceIcon(spaceNode.getSpaceID(), spaceNode.isSecured()));
            } else if (obj instanceof EventContainersNode) {
                this.setIcon(this.eventContainersIcon);
            } else if (obj instanceof MemcachedNode) {
                this.setIcon(IconsRepository.getInstance().getIcon(19));
            } else if (obj instanceof RemoteServicesNode) {
                this.setIcon(this.remoteServicesIcon);
            } else if (obj instanceof DefaultMutableTreeNode) {
                final DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                Object uObj = node.getUserObject();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                if (uObj instanceof String) {
                    String name = (String)uObj;
                    if (name.equals(TreeWorker.PROCESSING_UNIT_ROOT_NAME)) {
                        this.setIcon(this.appIcon);
                    } else if (name.equals("Clusters")) {
                        this.setIcon(this.clustersRootIcon);
                    } else if (parentNode != null && parentNode.getUserObject() instanceof EditCluster) {
                        if (node.toString().equals("Operations")) {
                            this.setIcon(this.operationsIcon);
                        } else {
                            this.setIcon(this.groupIcon);
                        }
                    } else if (parentNode != null && "Data Types".equalsIgnoreCase(node.toString()) && (parentNode.toString().equals("Operations") || parentNode instanceof DeployedServiceNode || parentNode instanceof SpaceNode)) {
                        this.setIcon(this.classesIcon);
                    } else if (parentNode != null && "Transactions".equalsIgnoreCase(node.toString()) && (parentNode.toString().equals("Operations") || parentNode instanceof DeployedServiceNode || parentNode instanceof SpaceNode)) {
                        this.setIcon(this.transactionsIcon);
                    } else if (parentNode != null && "Query".equalsIgnoreCase(node.toString()) && (parentNode.toString().equals("Operations") || parentNode instanceof DeployedServiceNode || parentNode instanceof SpaceNode)) {
                        this.setIcon(this.sqlIcon);
                    } else if (parentNode != null && "Statistics".equalsIgnoreCase(node.toString()) && (parentNode.toString().equals("Operations") || parentNode instanceof DeployedServiceNode || parentNode instanceof SpaceNode)) {
                        this.setIcon(this.statisticsIcon);
                    } else if (parentNode != null && "Connections".equalsIgnoreCase(node.toString()) && (parentNode.toString().equals("Operations") || parentNode instanceof DeployedServiceNode || parentNode instanceof SpaceNode)) {
                        this.setIcon(this.connectionsIcon);
                    } else if (parentNode != null && "Benchmark".equalsIgnoreCase(node.toString()) && (parentNode.toString().equals("Operations") || parentNode instanceof DeployedServiceNode || parentNode instanceof SpaceNode)) {
                        this.setIcon(this.benchmarkIcon);
                    } else if (parentNode != null && parentNode.getParent() != null && ((DefaultMutableTreeNode)parentNode.getParent()).getUserObject() instanceof EditCluster) {
                        this.setIcon(this.spaceIcon);
                    }
                } else if (uObj instanceof ServiceHolder) {
                    Object parentParentUserObject;
                    DefaultMutableTreeNode parentParentNode;
                    ServiceHolder srh = (ServiceHolder)uObj;
                    Object rootNode = null;
                    if (parentNode != null && parentNode.getParent() != null) {
                        rootNode = parentNode.getParent().getParent();
                    }
                    if (rootNode != null && rootNode.equals(puRoot)) {
                        OpStringHolder opStringHolder;
                        String description = srh.getDescription();
                        if (!JSpaceUtilities.isEmpty((String)description)) {
                            this.setText(description);
                            if (srh.isDescriptionJustInitialized()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TreePath treePath = new TreePath(node.getPath());
                                        TreeWorker.this.systemTree.expandPath(treePath);
                                        LOGGER.finest("BEFORE COLLAPSE 3:" + treePath);
                                        TreeWorker.this.systemTree.collapsePath(treePath);
                                    }
                                });
                            }
                        } else if (parentNode != null && parentNode.getParent() != null && (opStringHolder = (OpStringHolder)((DefaultMutableTreeNode)parentNode.getParent()).getUserObject()) != null) {
                            this.setText(opStringHolder.opString.getName());
                        }
                    } else {
                        String name;
                        String string = name = srh.item == null ? srh.instance.getServiceBeanID().toString() : srh.item.serviceID.toString();
                        if (srh.item != null && srh.item.service instanceof GSA) {
                            this.setText(srh.getHostAddress());
                        } else {
                            this.setText(name);
                        }
                    }
                    if (parentNode != null && (parentParentNode = (DefaultMutableTreeNode)parentNode.getParent()) != null && (parentParentUserObject = parentParentNode.getUserObject()) instanceof OpStringHolder) {
                        short spaceMode = TreeWorker.getSpacePrimaryBackupIndication(parentParentNode, srh.item.serviceID);
                        this.setIcon(JSpaceUIUtils.getPUInstanceIcon(spaceMode, 1));
                    }
                } else if (uObj instanceof OpStringHolder) {
                    OperationalString opString = ((OpStringHolder)uObj).getOpString(false);
                    if (opString != null) {
                        this.setText(opString.getName());
                    }
                    if (this.puIcon != null) {
                        if (((OpStringHolder)uObj).isSecured()) {
                            ServiceID serviceID = ((OpStringHolder)uObj).getSecuredServiceID();
                            Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
                            if (authentication == null) {
                                this.setIcon(this.securedPUIcon);
                            } else {
                                this.setIcon(this.securedAuthenticatedPUIcon);
                            }
                        } else {
                            this.setIcon(this.puIcon);
                        }
                    }
                } else if (node instanceof BasicPUServiceNode) {
                    this.setIcon(ServiceTreeCellRenderer.getServiceIcon(node));
                } else if (uObj instanceof EditCluster) {
                    this.setIcon(this.clusterIcon);
                    this.setText(uObj.toString() + " [Space Cluster]");
                } else if (parentNode.getUserObject() instanceof EditCluster) {
                    if (node.toString().equals("Operations")) {
                        this.setIcon(this.operationsIcon);
                    } else {
                        this.setIcon(this.groupIcon);
                    }
                }
            }
            return this;
        }
    }

    public static class ServiceHolder
    extends SecurityHolder {
        ServiceItem item;
        ServiceBeanInstance instance;
        ServiceElement serviceElement;
        private final String hostName;
        private String description;
        private boolean _isDescriptionJustInitialized;
        private String[] _zones;

        ServiceHolder(ServiceItem item, ServiceBeanInstance instance, SecuredService gsmService, ServiceID gsmServiceID, ServiceElement serviceElement) {
            String host;
            block11: {
                Object service;
                block10: {
                    this._isDescriptionJustInitialized = false;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, ">> Instance=" + instance + "  ITEM=" + item + " " + JSpaceUtilities.getStackTrace((Throwable)new Exception("--DEBUG--")));
                    }
                    this.item = item;
                    this.instance = instance;
                    this.serviceElement = serviceElement;
                    if (serviceElement != null) {
                        Repository.addServiceElement(item.serviceID, serviceElement);
                    }
                    host = null;
                    service = item.service;
                    if (service instanceof ServiceRegistrar) {
                        ServiceRegistrar serviceRegistrar = (ServiceRegistrar)service;
                        service = serviceRegistrar.getRegistrar();
                    }
                    try {
                        host = service instanceof NIOInfoProvider ? JSpaceUtilities.retriveHostName((NIOInfoProvider)((NIOInfoProvider)service)) : null;
                    }
                    catch (RemoteException re) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                }
                if (service instanceof GridZoneProvider) {
                    try {
                        this._zones = ((GridZoneProvider)service).getZones();
                    }
                    catch (RemoteException re) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                }
            }
            String string = this.hostName = host == null ? null : host.toLowerCase();
            if (gsmService != null && gsmServiceID != null) {
                this.init(gsmServiceID, gsmService);
            } else {
                this.init(item.serviceID, item.service);
            }
        }

        public String getHostAddress() {
            return this.hostName;
        }

        public String[] getZones() {
            return this._zones;
        }

        public boolean equals(Object object) {
            if (object instanceof ServiceHolder) {
                ServiceHolder sHolder = (ServiceHolder)object;
                return sHolder.getServiceID().equals((Object)this.item.serviceID);
            }
            return false;
        }

        public String getDescription() {
            if (this.description != null) {
                this._isDescriptionJustInitialized = false;
                return this.description;
            }
            return this.attepmtToInitDecription();
        }

        public boolean isDescriptionJustInitialized() {
            return this._isDescriptionJustInitialized;
        }

        private String attepmtToInitDecription() {
            ServiceBeanConfig serviceBeanConfig = null;
            if (this.instance != null) {
                serviceBeanConfig = this.instance.getServiceBeanConfig();
            } else {
                ServiceID serviceID = this.item.serviceID;
                serviceBeanConfig = Repository.getServiceBeanConfig(serviceID);
            }
            if (this.serviceElement == null) {
                this.serviceElement = Repository.getServiceElement(this.item.serviceID);
            }
            if (this.serviceElement != null) {
                Long instanceID;
                String name = this.serviceElement.getName();
                if (serviceBeanConfig != null && (instanceID = serviceBeanConfig.getInstanceID()) != null) {
                    this.description = name = name + " [" + instanceID + "]";
                    this._isDescriptionJustInitialized = true;
                }
                return name;
            }
            return "";
        }

        public ServiceElement getServiceElement() {
            return this.serviceElement;
        }

        public ServiceBeanInstance getServiceBeanInstance() {
            return this.instance;
        }

        public ServiceID getServiceID() {
            return this.item.serviceID;
        }
    }

    static class SecurityHolder
    implements AuthenticationListener {
        private boolean isSecured = false;
        protected ServiceID serviceID;
        protected SecuredService securedService;

        SecurityHolder() {
        }

        protected void init(ServiceID serviceID, Object service) {
            block6: {
                this.serviceID = serviceID;
                if (service instanceof SecuredService) {
                    this.securedService = (SecuredService)service;
                    try {
                        this.isSecured = ((SecuredService)service).isServiceSecured();
                        if (this.isSecured) {
                            SecurityServicesRepository.getInstance().addAuthenticationListener(this);
                        }
                    }
                    catch (ConnectException re) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, re.toString(), re);
                        }
                    }
                    catch (RemoteException re) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                        LOGGER.log(Level.SEVERE, re.toString(), re);
                    }
                }
            }
        }

        public boolean isSecured() {
            return this.isSecured;
        }

        public ServiceID getSecuredServiceID() {
            return this.serviceID;
        }

        public SecuredService getSecuredService() {
            return this.securedService;
        }

        public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        }
    }

    public static class PURootNode
    extends DefaultMutableTreeNode {
        public PURootNode(ServiceElementHolder serviceElementHolder) {
            super(TreeWorker.PU_INSTANCES_ROOT);
        }
    }

    public static class SpaceNode
    extends DefaultMutableTreeNode
    implements IConnectionProvider {
        private final ServiceID spaceServiceID;
        private final IJSpace space;
        private final String spaceName;
        private final String spaceInstanceId;
        private boolean isSecured;
        private DatabaseConnection _dbConnect;

        public SpaceNode(IJSpace space, ServiceID serviceID) {
            this.space = space;
            this.spaceServiceID = serviceID;
            this.spaceName = space.getName();
            this.isSecured = space.isSecured();
            this.spaceInstanceId = JSpaceUIUtils.getSpaceInstanceID(space);
        }

        public ServiceID getSpaceID() {
            return this.spaceServiceID;
        }

        public IJSpace getSpace() {
            return this.space;
        }

        public boolean isSecured() {
            return this.isSecured;
        }

        @Override
        public String toString() {
            return this.spaceInstanceId.length() > 0 ? this.spaceName + " [" + this.spaceInstanceId + "]" : this.spaceName;
        }

        @Override
        public synchronized DatabaseConnection getConnection() {
            if (this._dbConnect == null) {
                try {
                    Properties props = JSpaceUIUtils.createSecuredContextProperties();
                    this._dbConnect = new DatabaseConnection((Driver)new GDriver(), props, this.space);
                    this._dbConnect.gsConnect();
                }
                catch (Exception ex) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Exception in method getConnection() of SpaceTreeNode class:" + JSpaceUtilities.LINE_SEPARATOR + ex.toString(), ex);
                    }
                    SpaceBrowser.showException(ex.toString(), ex);
                }
            }
            return this._dbConnect;
        }
    }

    class ServiceElementHolder {
        ServiceElement sElem;
        OpStringHolder parent;

        ServiceElementHolder(ServiceElement sElem, OpStringHolder parent) {
            this.sElem = sElem;
            this.parent = parent;
        }

        OperationalStringManager getPrimary() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getPrimary();
        }
    }

    public static class OpStringHolder
    extends SecurityHolder {
        String hostAddress;
        DeployAdmin deployAdmin;
        ProvisionMonitor monitor;
        OperationalStringManager opMgr;
        private OperationalString opString;
        boolean svcGridDeployment = false;
        private boolean _isUndeploying = false;

        OpStringHolder(String hostAddress, ProvisionMonitor monitor, ServiceID serviceID, DeployAdmin deployAdmin, OperationalStringManager opMgr, OperationalString opString) {
            this.init(serviceID, monitor);
            this.hostAddress = hostAddress;
            this.deployAdmin = deployAdmin;
            this.opMgr = opMgr;
            this.monitor = monitor;
            this.opString = opString;
        }

        int removeMonitor(ProvisionMonitor mon) {
            if (this.monitor.equals(mon)) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "FIND NEW PRIMARY");
                }
                this.opMgr = null;
                this.findPrimary();
            }
            return Repository.getInstance().getMonitorCount();
        }

        public OperationalString getOpString(boolean refresh) {
            block3: {
                if (refresh && this.opMgr != null) {
                    try {
                        this.opString = this.opMgr.getOperationalString();
                    }
                    catch (RemoteException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block3;
                        LOGGER.log(Level.FINE, this.getClass().getName() + ": [Exception: " + e.getClass().getName() + ": " + e.getMessage() + "] Getting Deployment Descriptor from remote manager");
                    }
                }
            }
            return this.opString;
        }

        void findPrimary() {
            try {
                if (this.opMgr != null && this.opMgr.isManaging()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Repository repo = Repository.getInstance();
            Repository.ProvisionMonitorHolder[] pmh = repo.getProvisionMonitorHolders();
            for (int i = 0; i < pmh.length; ++i) {
                try {
                    if (!this.setPrimary(pmh[i].getProvisionMonitor(), pmh[i].item.serviceID, false)) continue;
                    break;
                }
                catch (RemoteException e) {
                    repo.removeService(pmh[i].getServiceItem());
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void setUndeploying(boolean undeploying) {
            this._isUndeploying = undeploying;
        }

        public boolean isUndeploying() {
            return this._isUndeploying;
        }

        boolean setPrimary(ProvisionMonitor mon, ServiceID provisionMonitorServiceID, boolean isRefresh) throws RemoteException, OperationalStringException {
            boolean hasSet = false;
            DeployAdmin dAdmin = (DeployAdmin)mon.getAdmin();
            OperationalStringManager mgr = dAdmin.getOperationalStringManager(this.opString.getName());
            if (mgr.isManaging()) {
                this.opMgr = mgr;
                this.getOpString(isRefresh);
                hasSet = true;
                this.securedService = (SecuredService)mon;
                if (provisionMonitorServiceID == null) {
                    Repository.ProvisionMonitorHolder provisionMonitorHolder = Repository.getInstance().getProvisionMonitorHolder(mon);
                    if (provisionMonitorHolder != null) {
                        this.serviceID = provisionMonitorHolder.getServiceItem().serviceID;
                    }
                } else {
                    this.serviceID = provisionMonitorServiceID;
                }
                if (this.serviceID != null) {
                    ServiceItem serviceItem = Repository.getInstance().getServiceItem(this.serviceID);
                    if (serviceItem != null) {
                        this.monitor = (ProvisionMonitor)serviceItem.service;
                        this.deployAdmin = (DeployAdmin)this.monitor.getAdmin();
                    } else {
                        this.monitor = mon;
                        this.deployAdmin = dAdmin;
                    }
                }
            }
            return hasSet;
        }

        public ProvisionManager getPrimaryProvisioner() {
            return this.monitor;
        }

        public OperationalStringManager getPrimary() {
            this.findPrimary();
            return this.opMgr;
        }

        @Override
        public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
            block3: {
                if (this.serviceID.equals((Object)serviceItem.serviceID)) {
                    try {
                        this.reloadObjects();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINER)) break block3;
                        LOGGER.log(Level.FINER, e.toString(), e);
                    }
                }
            }
        }

        public void reloadObjects() throws RemoteException, OperationalStringException {
            this.deployAdmin = (DeployAdmin)this.monitor.getAdmin();
            this.opMgr = this.deployAdmin.getOperationalStringManager(this.opString.getName());
        }
    }
}

