/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.admin.ui.IServiceGridUIComponent;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.ResourceBundleHandler;
import com.gigaspaces.admin.ui.ServiceNotificationListener;
import com.gigaspaces.admin.ui.grid.DisplayControl;
import com.gigaspaces.admin.ui.grid.ProvisionFailureEventTable;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.SLAEventTable;
import com.gigaspaces.admin.ui.grid.TreeServiceNotificationListener;
import com.gigaspaces.admin.ui.grid.TreeServiceSelectionHandler;
import com.gigaspaces.admin.ui.grid.TreeWorker;
import com.gigaspaces.admin.ui.grid.UIExceptionTable;
import com.gigaspaces.admin.ui.grid.utils.DeploymentActionsManager;
import com.gigaspaces.admin.ui.tab.ClosableTabbedPane;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.tools.cluster.view.ClusterViewDlg;
import com.j_spaces.tools.spacebrowser.ISpacesView;
import com.j_spaces.tools.spacebrowser.SpacesViewPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import net.infonode.docking.View;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringException;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.event.BasicEventConsumer;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventProducer;
import org.jini.rio.event.RemoteServiceEvent;
import org.jini.rio.event.RemoteServiceEventListener;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.monitor.ProvisionMonitor;
import org.jini.rio.monitor.ProvisionMonitorEvent;
import org.jini.rio.opstring.OpStringLoader;

public class UI
extends JPanel
implements DisplayControl,
ServiceNotificationListener,
IServiceGridUIComponent {
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    CardLayout selector;
    String hostInfo;
    private TreeWorker treeWorker;
    JPanel detailPane;
    JComponent currentComp;
    boolean terminating;
    JSplitPane topLeftSplitPane;
    JButton update;
    ProvisionClientEventConsumer provisionClientEventConsumer;
    BasicEventConsumer clientEventConsumer;
    TreeServiceNotificationListener[] treeServiceNotificationListeners;
    JScrollPane scrollPane;
    static final String PROV_FAILURE_KEY = "Provision Failure Events";
    static final String UI_EXCEPTION_KEY = "UI Exception Table";
    static final String SLA_KEY = "SLA Threshold Events";
    private final JSplitPane verticalSplitPane;
    private final JLabel statusBar;
    private final String[] columnNames;
    private JTabbedPane tabbedPane;
    private SLAEventTable slaEventTable;
    private ProvisionFailureEventTable provisionFailureTable;
    private UIExceptionTable uiExceptionTable;
    private final ClusterViewDlg _clusterViewDlg;
    private final MainUI _mainUI;
    private TreeServiceSelectionHandler treeServiceSelectionHandler;
    private SpacesViewPanel _unmanagedSpacesView;

    public UI(MainUI mainUI, ClusterViewDlg clusterViewDlg, Configuration config) {
        ArrayList<String> spacesViewColumnNames;
        int dividerLoc;
        JTree systemTree;
        block20: {
            super(new BorderLayout(8, 8));
            this.terminating = false;
            this.statusBar = new JLabel();
            this.columnNames = new String[]{"Name", "Value"};
            this._mainUI = mainUI;
            this._clusterViewDlg = clusterViewDlg;
            clusterViewDlg.setUIComponent(this);
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            JPanel sPanel = new JPanel();
            sPanel.setLayout(new BoxLayout(sPanel, 1));
            sPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.selector = new CardLayout(8, 8);
            this.detailPane = new JPanel(this.selector);
            this.detailPane.setBorder(BorderFactory.createEtchedBorder());
            this.detailPane.setMinimumSize(new Dimension(150, 1));
            final Thread currentThread = Thread.currentThread();
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return currentThread.getContextClassLoader();
                }
            });
            try {
                String[] configParms = SystemConfig.getInstance().getConfigurationParms();
                OpStringLoader opLoader = new OpStringLoader(cl);
                String[] groups = SystemInfo.singleton().lookup().groupsArray();
                if (groups != null) {
                    opLoader.setDefaultGroups(groups);
                }
                if (configParms.length > 1) {
                    opLoader.setServiceOverride(configParms[1]);
                }
            }
            catch (Exception e) {
                UIHelper.showError((Throwable)e, "Loading service-grid.xml");
                System.exit(0);
            }
            this.treeWorker = new TreeWorker(mainUI);
            systemTree = this.treeWorker.makeTree();
            Repository.getInstance().setTreeWorker(this.treeWorker);
            JPanel treePane = new JPanel();
            treePane.setLayout(new BorderLayout());
            this.scrollPane = new JScrollPane(systemTree);
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            treePane.add((Component)this.scrollPane, "Center");
            treePane.setPreferredSize(new Dimension(180, Integer.MAX_VALUE));
            treePane.setBorder(BorderFactory.createEtchedBorder());
            this.provisionClientEventConsumer = new ProvisionClientEventConsumer();
            try {
                this.clientEventConsumer = new BasicEventConsumer(new EventDescriptor(ProvisionMonitorEvent.class, new Long(2764185076071141340L)), (RemoteServiceEventListener)this.provisionClientEventConsumer, config);
            }
            catch (Exception e) {
                UIHelper.showError((Throwable)e, "Creating BasicEventConsumer for ProvisionFailureEvent notifications");
            }
            View gridTreeView = new View("Service Grid Network", null, (Component)treePane);
            this.topLeftSplitPane = new JSplitPane(1, true, (Component)gridTreeView, this.detailPane);
            this.topLeftSplitPane.setBorder(BorderFactory.createEmptyBorder());
            dividerLoc = 325;
            Properties props = Repository.getInstance().getProperties();
            String val = props.getProperty("ui.topLeftSplitPane");
            if (val != null) {
                try {
                    dividerLoc = Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            spacesViewColumnNames = new ArrayList<String>(5);
            try {
                String spacesNetworkViewColumns = (String)props.get("SPACES_NETWORK_VIEW_COLUMNS");
                if (spacesNetworkViewColumns != null) {
                    StringTokenizer strTokenizer = new StringTokenizer(spacesNetworkViewColumns, ";", false);
                    while (strTokenizer.hasMoreTokens()) {
                        String columnName = strTokenizer.nextToken();
                        spacesViewColumnNames.add(columnName);
                    }
                    if (!((String)spacesViewColumnNames.get(0)).equals("\u00a0")) {
                        spacesViewColumnNames.add(0, "\u00a0");
                    }
                }
                if (spacesViewColumnNames.size() != 0) break block20;
                for (String columnName : ISpacesView.DEFAULT_COLUMN_NAMES) {
                    spacesViewColumnNames.add(columnName);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e.toString(), e);
                }
                if (spacesViewColumnNames.size() != 0) break block20;
                for (String columnName : ISpacesView.DEFAULT_COLUMN_NAMES) {
                    spacesViewColumnNames.add(columnName);
                }
            }
        }
        this.topLeftSplitPane.setDividerLocation(dividerLoc);
        this.createBottomPanel(config);
        this.verticalSplitPane = new JSplitPane(0, this.topLeftSplitPane, this.tabbedPane);
        this.verticalSplitPane.setDividerLocation(650);
        this.add((Component)this.verticalSplitPane, "Center");
        try {
            this._unmanagedSpacesView = new SpacesViewPanel(this._mainUI, true);
            this._unmanagedSpacesView.setColumnNames(spacesViewColumnNames);
            this.treeServiceSelectionHandler = new TreeServiceSelectionHandler(this._mainUI, clusterViewDlg, this.treeWorker, this._unmanagedSpacesView);
            this.treeWorker.setTreeServiceNotificationListener(this.treeServiceSelectionHandler);
            this.treeWorker.setOpStringGraph(this.treeServiceSelectionHandler.opStringGraph);
            this.treeServiceNotificationListeners = (TreeServiceNotificationListener[])config.getEntry("com.gigaspaces.admin.ui", "treeServiceNotificationListeners", TreeServiceNotificationListener[].class, (Object)new TreeServiceNotificationListener[]{this.treeServiceSelectionHandler});
            for (int i = 0; i < this.treeServiceNotificationListeners.length; ++i) {
                this.treeServiceNotificationListeners[i].setDisplayControl(this);
                this.treeServiceNotificationListeners[i].setTree(systemTree);
                this.treeServiceNotificationListeners[i].setToolBarButtons(this.getToolBarButtons());
                this.treeServiceNotificationListeners[i].setMenuItems(DeploymentActionsManager.getInstance(this._mainUI).getMenuItems());
                systemTree.addTreeSelectionListener(this.treeServiceNotificationListeners[i]);
            }
        }
        catch (ConfigurationException e) {
            UIHelper.showError((Throwable)e, "Processing configuration for treeServiceNotificationListeners");
        }
        DeploymentActionsManager.getInstance(this._mainUI).setTabbedPane(this.tabbedPane);
    }

    public void clearBenchmarks() {
        this.treeServiceSelectionHandler.clearBenchmarks();
    }

    private void createBottomPanel(Configuration config) {
        this.tabbedPane = new BottomClosableTabbedPane(3);
        this.tabbedPane.setOpaque(true);
        this.tabbedPane.setMinimumSize(new Dimension(1, 1));
        this.tabbedPane.setPreferredSize(new Dimension(1, 1));
        this.uiExceptionTable = new UIExceptionTable(this._mainUI);
        Repository.getInstance().setUIExceptionTable(this.uiExceptionTable);
        try {
            this.slaEventTable = new SLAEventTable(this._mainUI, config);
            this.tabbedPane.addTab(SLA_KEY, this.slaEventTable);
            this.slaEventTable.setTab(this.tabbedPane, this.slaEventTable);
        }
        catch (Exception e) {
            UIHelper.showError((Throwable)e, "Creating SLAEventTable component");
        }
        try {
            this.provisionFailureTable = new ProvisionFailureEventTable(this._mainUI, config);
            this.tabbedPane.addTab(PROV_FAILURE_KEY, this.provisionFailureTable);
            this.provisionFailureTable.setTab(this.tabbedPane, this.provisionFailureTable);
        }
        catch (Exception e) {
            UIHelper.showError((Throwable)e, "Creating ProvisionFailureEventTable component");
        }
        this.tabbedPane.addTab(UI_EXCEPTION_KEY, this.uiExceptionTable);
        this.uiExceptionTable.setTab(this.tabbedPane, this.uiExceptionTable);
        Repository.getInstance().setProvisionFailureEventTable(this.provisionFailureTable);
        Repository.getInstance().setSLAEventTable(this.slaEventTable);
    }

    public void setDeployDir(String deployDir) {
        DeploymentActionsManager.getInstance(this._mainUI).setLastDeployPath(deployDir);
    }

    public boolean isServicesDisplayed() {
        return this.treeWorker.isServicesDisplayed();
    }

    public void addClusterTree(JTree clusterTree, String clusterName, ServiceID spaceID, boolean isUnmanagedSpace) {
        this.treeWorker.addClusterTree(clusterTree, clusterName, spaceID, isUnmanagedSpace);
    }

    public void selectClusterOperationNode(ServiceID spaceID, String operationName, String clusterName) {
        this.treeWorker.selectClusterOperationNode(spaceID, operationName, clusterName);
    }

    @Override
    public Dimension getDisplayableSize() {
        return this.topLeftSplitPane.getRightComponent().getSize();
    }

    @Override
    public void refresh() {
    }

    @Override
    public void addDisplayComponent(JComponent component, String constraints) {
        this.detailPane.add(constraints, component);
        this.selector.addLayoutComponent(component, constraints);
    }

    @Override
    public void display(JComponent component, String constraints) {
        this.selector.show(this.detailPane, constraints);
        this.currentComp = component;
    }

    @Override
    public JComponent getCurrentDisplay() {
        return this.currentComp;
    }

    @Override
    public String getLastPath() {
        return DeploymentActionsManager.getInstance(this._mainUI).getLastDeployPath();
    }

    @Override
    public void serviceAdded(ServiceItem item) {
        block10: {
            if (this.terminating) {
                return;
            }
            if (item.service instanceof EventProducer) {
                this.slaEventTable.addService(item);
            }
            if (item.service instanceof ProvisionMonitor) {
                this.provisionFailureTable.addService(item);
            }
            for (int i = 0; i < this.treeServiceNotificationListeners.length; ++i) {
                this.treeServiceNotificationListeners[i].serviceAdded(item);
            }
            if (item.service instanceof ProvisionMonitor) {
                this.clientEventConsumer.register(item);
                this.treeWorker.importOpStrings(item);
            } else {
                this.treeWorker.addService(item);
            }
            if (item.service instanceof IJSpace) {
                IJSpace space = (IJSpace)item.service;
                try {
                    if (!space.isStartedWithinGSC()) {
                        this.addUnmanagedSpace(space, item.serviceID);
                    }
                }
                catch (RemoteException re) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                    LOGGER.log(Level.SEVERE, re.toString(), re);
                }
            }
        }
        this.refresh();
    }

    private void addUnmanagedSpace(IJSpace spaceProxy, ServiceID spaceID) {
        this.treeWorker.addUnmanagedSpace(spaceProxy, spaceID);
        this.addSpaceToUnmanagedSpacesView(spaceProxy, spaceID);
    }

    private void addSpaceToUnmanagedSpacesView(IJSpace spaceProxy, ServiceID spaceID) {
        block2: {
            IJSpaceContainerAdmin containerAdmin = (IJSpaceContainerAdmin)spaceProxy.getDirectProxy().getContainer();
            try {
                ContainerConfig containerConfig = Repository.addContainerToMap(containerAdmin);
                IRemoteJSpaceAdmin spaceAdmin = null;
                SpaceConfig spaceConfig = null;
                boolean isSecuredSpace = spaceProxy.isSecured();
                spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
                spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin);
                this._unmanagedSpacesView.addSpace(spaceProxy, spaceAdmin, spaceID, spaceConfig, containerConfig, isSecuredSpace);
            }
            catch (RemoteException re) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, re.toString(), re);
            }
        }
    }

    @Override
    public void serviceChanged(ServiceItem item) {
        if (this.terminating) {
            return;
        }
        this.treeWorker.addService(item);
        for (int i = 0; i < this.treeServiceNotificationListeners.length; ++i) {
            this.treeServiceNotificationListeners[i].serviceChanged(item);
        }
        this.refresh();
    }

    @Override
    public void serviceRemoved(final ServiceItem item) {
        if (this.terminating) {
            return;
        }
        Repository repo = Repository.getInstance();
        String hostAddress = null;
        OSDetails osDetails = repo.getOSDetails(item, false);
        if (osDetails != null) {
            hostAddress = osDetails.getHostAddress();
        }
        AdminUIThreadPool.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                if (item.service instanceof EventProducer) {
                    UI.this.slaEventTable.removeService(item.serviceID);
                }
                if (item.service instanceof ProvisionMonitor) {
                    UI.this.provisionFailureTable.removeService(item.serviceID);
                }
            }
        });
        if (hostAddress != null) {
            repo.updateGSC(hostAddress, item.serviceID);
        }
        for (int i = 0; i < this.treeServiceNotificationListeners.length; ++i) {
            this.treeServiceNotificationListeners[i].serviceRemoved(item);
        }
        this.treeWorker.removeService(item);
        if (item.service instanceof ProvisionMonitor) {
            this.treeWorker.removeMonitor(item);
        }
        if (item.service instanceof IJSpace) {
            this._unmanagedSpacesView.removeSpace(item.serviceID);
        }
        this.refresh();
    }

    private void terminate() {
        this.terminating = true;
        if (this.slaEventTable != null) {
            this.slaEventTable.terminate();
        }
        if (this.provisionFailureTable != null) {
            this.provisionFailureTable.terminate();
        }
        Repository.getInstance().setProperty("ui.topLeftSplitPane", Integer.toString(this.topLeftSplitPane.getDividerLocation()));
        if (this.clientEventConsumer != null) {
            this.clientEventConsumer.terminate();
        }
    }

    @Override
    public JLabel getStatusBar() {
        return this.statusBar;
    }

    @Override
    public String getComponentName() {
        return "Deployed Processing Units";
    }

    @Override
    public String getComponentToolTip() {
        return "Deployed Processing Units";
    }

    @Override
    public JMenu[] getMenus() {
        return DeploymentActionsManager.getInstance(this._mainUI).getMenusRuntimeView();
    }

    @Override
    public JButton[] getToolBarButtons() {
        return DeploymentActionsManager.getInstance(this._mainUI).getToolBarButtonsRuntimeView();
    }

    @Override
    public void closeServices() {
        this.terminate();
    }

    @Override
    public void resetInternalWindows() {
        this._clusterViewDlg.getGroupPanel().resetView();
    }

    public int getDividerLocation() {
        return this.verticalSplitPane.getDividerLocation();
    }

    public void setDividerLocation(int mainSplitPaneDivLoc) {
        this.verticalSplitPane.setDividerLocation(mainSplitPaneDivLoc);
    }

    public void selectClusterSQLQueryPanel(String clusterName, String query) {
        this.treeServiceSelectionHandler.selectClusterSQLQueryPanel(clusterName, query);
    }

    public void removePUInstances(List<ServiceID> removedPUInstanceIds, String operStringName) {
        this.treeWorker.removePUInstances(removedPUInstanceIds, operStringName);
    }

    public TreeWorker getTreeWorker() {
        return this.treeWorker;
    }

    class BottomClosableTabbedPane
    extends ClosableTabbedPane {
        BottomClosableTabbedPane(int firstClosableTabIndex) {
            super(firstClosableTabIndex);
        }

        @Override
        protected boolean isTabCanBeClosed(int tabIndex) {
            return false;
        }
    }

    class ProvisionClientEventConsumer
    implements RemoteServiceEventListener {
        ProvisionClientEventConsumer() {
        }

        /*
         * Unable to fully structure code
         */
        public void notify(RemoteServiceEvent event) {
            try {
                pme = (ProvisionMonitorEvent)event;
                opStringName = pme.getOperationalStringName();
                sElem = pme.getServiceElement();
                monitor = (ProvisionMonitor)event.getSource();
                deployAdmin = (DeployAdmin)monitor.getAdmin();
                hostAddress = ((NIOInfoProvider)monitor).getNIODetails().getHostAddress();
                for (i = 0; i < UI.this.treeServiceNotificationListeners.length; ++i) {
                    UI.this.treeServiceNotificationListeners[i].notify(pme, hostAddress);
                }
                action = pme.getAction();
                if (action == 7) {
                    this.undeploy(pme.getOperationalString(), deployAdmin);
                    return;
                }
                if (UI.LOGGER.isLoggable(Level.FINE)) {
                    UI.LOGGER.log(Level.FINE, "ACTION=" + action + ", opstring=" + opStringName);
                }
                switch (action) {
                    case 1: {
                        if (opStringName == null) break;
                        UI.access$200(UI.this).updateServiceElement(sElem);
                        if (!UI.LOGGER.isLoggable(Level.FINE)) break;
                        UI.LOGGER.log(Level.FINE, "Updated [" + sElem.getName() + "] in " + ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor") + " [" + opStringName + "]");
                        break;
                    }
                    case 4: {
                        UI.access$200(UI.this).addServiceElementNode(sElem);
                        break;
                    }
                    case 5: {
                        if (opStringName == null) break;
                        UI.access$200(UI.this).removeServiceElement(sElem);
                        break;
                    }
                    case 8: {
                        opString = pme.getOperationalString();
                        if (UI.LOGGER.isLoggable(Level.FINE)) {
                            UI.LOGGER.log(Level.FINE, ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor") + " [" + opString.getName() + "] updated");
                        }
                        UI.access$200(UI.this).updateOpString(opString);
                        break;
                    }
                    case 6: 
                    case 11: {
                        opStringMgr = deployAdmin.getOperationalStringManager(opStringName);
                        provisionMonitorHolder = Repository.getInstance().getProvisionMonitorHolder(monitor);
                        serviceID = null;
                        if (provisionMonitorHolder != null) {
                            serviceID = provisionMonitorHolder.getServiceItem().serviceID;
                        }
                        if (UI.LOGGER.isLoggable(Level.FINE)) {
                            UI.LOGGER.log(Level.FINE, "%%%%%% OPSTRING_DEPLOYED:" + serviceID);
                        }
                        try {
                            if (provisionMonitorHolder != null && ((SecuredService)monitor).isServiceSecured()) {
                                SecurityServicesRepository.getInstance().authenticateUsingExistngAuthentication(provisionMonitorHolder.getServiceItem(), false);
                                serviceItem = Repository.getInstance().getServiceItem(serviceID);
                                if (serviceItem != null) {
                                    monitor = (ProvisionMonitor)serviceItem.service;
                                }
                                deployAdmin = (DeployAdmin)monitor.getAdmin();
                                opStringMgr = deployAdmin.getOperationalStringManager(opStringName);
                            }
                        }
                        catch (RemoteException re) {
                            if (!UI.LOGGER.isLoggable(Level.FINEST)) ** GOTO lbl58
                            UI.LOGGER.log(Level.FINEST, "Caught " + re + " while trying to authenticate.", re);
                        }
lbl58:
                        // 3 sources

                        UI.access$200(UI.this).addOpStrings(hostAddress, monitor, serviceID, deployAdmin, new OperationalStringManager[]{opStringMgr});
                        if (UI.LOGGER.isLoggable(Level.FINE)) {
                            UI.LOGGER.log(Level.FINE, "Added " + ResourceBundleHandler.getInstance().getResource("terminology.DeploymentDescriptor") + " [" + opStringName + "]");
                        }
                        if (action != 11) break;
                        serviceBeanInstance = pme.getServiceBeanInstance();
                        id = serviceBeanInstance.getServiceBeanID();
                        servID = new ServiceID(id.getMostSignificantBits(), id.getLeastSignificantBits());
                        Repository.addServiceBeanInstance(servID, serviceBeanInstance);
                        Repository.addServiceElement(servID, sElem);
                        break;
                    }
                    case 13: {
                        servID = null;
                        serviceBeanInstance = pme.getServiceBeanInstance();
                        if (serviceBeanInstance != null) {
                            id = serviceBeanInstance.getServiceBeanID();
                            servID = new ServiceID(id.getMostSignificantBits(), id.getLeastSignificantBits());
                        }
                        UI.access$200(UI.this).setManaging(monitor, servID, opStringName);
                        break;
                    }
                    case 12: {
                        instance = pme.getServiceBeanInstance();
                        if (instance != null) {
                            UI.access$200(UI.this).removeService(instance, opStringName);
                            Repository.getInstance().updateGSC(instance.getHostAddress(), null);
                            break;
                        }
                        if (!UI.LOGGER.isLoggable(Level.FINE)) break;
                        UI.LOGGER.log(Level.FINE, "[" + sElem.getName() + "] SERVICE_FAILURE, unable to remove, instance is null");
                    }
                }
            }
            catch (Throwable t) {
                UIHelper.showError(t, "Processing GSM remote event");
            }
            UI.this.refresh();
        }

        void undeploy(OperationalString opString, DeployAdmin deployAdmin) {
            boolean undeploy = true;
            try {
                OperationalStringManager opMgr = deployAdmin.getOperationalStringManager(opString.getName());
                undeploy = opMgr.isManaging() && opString.getStatus() == 0;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (OperationalStringException e) {
                undeploy = true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, this.getClass().getName() + " : " + opString.getName() + " undeploy ? " + undeploy);
            }
            if (undeploy) {
                UI.this.treeWorker.removeOpString(opString);
            }
            OperationalString[] nested = opString.getNestedOperationalStrings();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, this.getClass().getName() + " : " + opString.getName() + " nested count=" + nested.length + ", status=" + opString.getStatus());
            }
            for (int i = 0; i < nested.length; ++i) {
                this.undeploy(nested[i], deployAdmin);
            }
        }
    }
}

