/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid;

import com.gigaspaces.admin.ui.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class UIExceptionTable
extends JPanel {
    JTable eventTable;
    ExceptionEventModel dataModel;
    JTabbedPane tabbedPane;
    Component tabComponent;
    ImageIcon newItemIcon;
    Observatory observatory;
    JScrollPane scroller;
    JFrame _parentFrame;

    public UIExceptionTable(JFrame parentFrame) {
        this.setLayout(new BorderLayout());
        this._parentFrame = parentFrame;
        this.newItemIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/error.gif");
        this.eventTable = new JTable();
        this.eventTable.addMouseListener(new RowListener());
        this.eventTable.setBackground(Color.white);
        this.dataModel = new ExceptionEventModel();
        this.eventTable.setModel(this.dataModel);
        this.eventTable.setAutoResizeMode(3);
        TableColumnModel cm = this.eventTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(120);
        cm.getColumn(0).setMaxWidth(300);
        cm.getColumn(1).setPreferredWidth(150);
        cm.getColumn(1).setMaxWidth(300);
        cm.getColumn(2).setPreferredWidth(200);
        cm.getColumn(2).setMaxWidth(500);
        this.scroller = new JScrollPane(this.eventTable);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.add((Component)this.scroller, "Center");
        JPanel buttons = new JPanel();
        JButton details = new JButton("Details");
        details.setToolTipText("Get details on the selected Exception");
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = UIExceptionTable.this.eventTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                UIExceptionTable.this.showDetails(UIExceptionTable.this.getEvent(row));
            }
        });
        JButton remove = new JButton("Delete");
        remove.setToolTipText("Delete the selected Exception");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int row = UIExceptionTable.this.eventTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                UIExceptionTable.this.removeEvent(row);
            }
        });
        JButton clear = new JButton("Clear All");
        clear.setToolTipText("Clear all Exception items");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int rows = UIExceptionTable.this.eventTable.getRowCount();
                if (rows == 0) {
                    return;
                }
                if (UIExceptionTable.this.tabComponent != null && UIExceptionTable.this.tabbedPane.indexOfComponent(UIExceptionTable.this.tabComponent) >= 0) {
                    UIExceptionTable.this.tabbedPane.setIconAt(UIExceptionTable.this.tabbedPane.indexOfComponent(UIExceptionTable.this.tabComponent), null);
                }
                UIExceptionTable.this.dataModel.tableData.clear();
                UIExceptionTable.this.dataModel.fireTableDataChanged();
            }
        });
        buttons.add(details);
        buttons.add(remove);
        buttons.add(clear);
        this.add((Component)buttons, "South");
        this.handleEnterKeyEvents();
    }

    public void setTab(JTabbedPane tab, Component tabComp) {
        this.tabbedPane = tab;
        this.tabComponent = tabComp;
    }

    public synchronized void addObserver(Observer observer) {
        this.getObservatory().addObserver(observer);
    }

    public Observatory getObservatory() {
        if (this.observatory == null) {
            this.observatory = new Observatory();
        }
        return this.observatory;
    }

    public void addException(Throwable t, String reason, Date when) {
        int old = this.dataModel.getRowCount();
        ExceptionEvent ee = new ExceptionEvent(t, when, reason);
        this.dataModel.addItem(ee);
        this.dataModel.fireTableDataChanged();
        if (this.newItemIcon != null && this.tabComponent != null && this.tabbedPane.indexOfComponent(this.tabComponent) >= 0) {
            this.tabbedPane.setIconAt(this.tabbedPane.indexOfComponent(this.tabComponent), this.newItemIcon);
        }
        Rectangle lastCell = this.eventTable.getCellRect(this.eventTable.getRowCount(), 0, true);
        this.scroller.getViewport().scrollRectToVisible(lastCell);
        this.getObservatory().stateChange();
    }

    public void removeEvent(int row) {
        this.dataModel.removeItem(row);
    }

    public ExceptionEvent getEvent(int row) {
        if (row == -1) {
            return null;
        }
        return (ExceptionEvent)this.dataModel.getItem(row);
    }

    public int getNumEvents() {
        return this.dataModel.getRowCount();
    }

    private void handleEnterKeyEvents() {
        KeyStroke stroke = KeyStroke.getKeyStroke("ENTER");
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int selRow = UIExceptionTable.this.eventTable.getSelectedRow();
                if (selRow >= 0) {
                    UIExceptionTable.this.showDetails(UIExceptionTable.this.getEvent(selRow));
                }
            }
        };
        InputMap inputMap = this.eventTable.getInputMap(0);
        inputMap.put(stroke, "ENTER");
        this.eventTable.getActionMap().put("ENTER", actionListener);
    }

    void showDetails(ExceptionEvent event) {
        Throwable t = event.getThrowable();
        Throwable cause = t.getCause();
        if (cause != null) {
            Throwable nested = cause.getCause();
            UIHelper.showError(nested == null ? cause : nested, (Component)this._parentFrame);
        } else {
            UIHelper.showError(t, (Component)this._parentFrame);
        }
    }

    String scrub(String input) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(input, "\n");
        if (st.countTokens() == 0) {
            return input;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    class RowListener
    extends MouseAdapter {
        RowListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clickCount = e.getClickCount();
            if (UIExceptionTable.this.tabComponent != null && UIExceptionTable.this.tabbedPane.indexOfComponent(UIExceptionTable.this.tabComponent) >= 0) {
                UIExceptionTable.this.tabbedPane.setIconAt(UIExceptionTable.this.tabbedPane.indexOfComponent(UIExceptionTable.this.tabComponent), null);
            }
            if (clickCount == 2) {
                int row = UIExceptionTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                if (row == -1) {
                    return;
                }
                UIExceptionTable.this.showDetails(UIExceptionTable.this.getEvent(row));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        void maybeShowPopup(final MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem delete = new JMenuItem("Delete");
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int row = UIExceptionTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                        UIExceptionTable.this.removeEvent(row);
                    }
                });
                JMenuItem details = new JMenuItem("Details");
                details.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int row = UIExceptionTable.this.eventTable.rowAtPoint(new Point(e.getX(), e.getY()));
                        UIExceptionTable.this.showDetails(UIExceptionTable.this.getEvent(row));
                    }
                });
                popup.add(delete);
                popup.addSeparator();
                popup.add(details);
                popup.pack();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ExceptionEventModel
    extends AbstractTableModel {
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Time", "Exception", "Description", "Message"};

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                ExceptionEvent event = (ExceptionEvent)this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return event.getWhen().toString();
                    }
                    case 1: {
                        return event.getThrowable().getClass().getName();
                    }
                    case 2: {
                        return event.getDescription();
                    }
                    case 3: {
                        return event.getThrowable().getLocalizedMessage();
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void addItem(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void removeItem(int row) {
            this.tableData.removeElementAt(row);
            this.fireTableDataChanged();
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }

    class Observatory
    extends Observable {
        Observatory() {
        }

        void stateChange() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    class ExceptionEvent {
        Throwable t;
        Date when;
        String description;

        ExceptionEvent(Throwable t, Date when, String description) {
            this.t = t;
            this.when = when;
            this.description = description;
        }

        Throwable getThrowable() {
            return this.t;
        }

        Date getWhen() {
            return this.when;
        }

        String getDescription() {
            return this.description;
        }
    }
}

