/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.j_spaces.tools.cluster.FileFilterExt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class AbstractAdvancedDeploymentPanel
extends Box {
    protected JTextField slaOverrideTextField = new JTextField();
    private final int componentHeight = 21;
    private final Dimension labelSize = new Dimension(129, 21);
    private static JFileChooser fileChooser;
    private Component _parentComponent;
    protected String _deployDir;

    public AbstractAdvancedDeploymentPanel(String deployDir) {
        super(1);
        this._deployDir = deployDir;
        this.initUI();
        this.setBorder(BorderFactory.createTitledBorder("Advanced Deployment Options"));
    }

    protected abstract void initUI();

    protected Box createSLAComponentsBox() {
        JLabel slaOverrideLabel = new JLabel("SLA override:");
        slaOverrideLabel.setPreferredSize(this.labelSize);
        slaOverrideLabel.setMaximumSize(this.labelSize);
        JButton browseButton = new JButton("...");
        browseButton.setPreferredSize(new Dimension(22, 21));
        browseButton.setMaximumSize(new Dimension(22, 21));
        browseButton.setMinimumSize(new Dimension(22, 21));
        Box slaOverrideBox = new Box(0);
        slaOverrideBox.add(Box.createHorizontalStrut(3));
        slaOverrideBox.add(slaOverrideLabel);
        slaOverrideBox.add(Box.createHorizontalStrut(7));
        slaOverrideBox.add(this.slaOverrideTextField);
        slaOverrideBox.add(Box.createHorizontalStrut(2));
        slaOverrideBox.add(browseButton);
        slaOverrideBox.add(Box.createHorizontalGlue());
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (fileChooser == null) {
                    if (AbstractAdvancedDeploymentPanel.this._parentComponent == null) {
                        AbstractAdvancedDeploymentPanel.this.initParentComponent();
                    }
                    try {
                        AbstractAdvancedDeploymentPanel.this._parentComponent.setCursor(Cursor.getPredefinedCursor(3));
                        fileChooser = new JFileChooser(AbstractAdvancedDeploymentPanel.this._deployDir);
                        FileFilterExt xmlFilter = new FileFilterExt("xml", "SLA config file");
                        fileChooser.setFileFilter(xmlFilter);
                    }
                    finally {
                        AbstractAdvancedDeploymentPanel.this._parentComponent.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                int state = fileChooser.showOpenDialog(AbstractAdvancedDeploymentPanel.this._parentComponent);
                File file = fileChooser.getSelectedFile();
                if (file != null && state == 0) {
                    AbstractAdvancedDeploymentPanel.this.slaOverrideTextField.setText(file.getPath());
                    AbstractAdvancedDeploymentPanel.this.slaOverrideTextField.setToolTipText(file.getPath());
                }
            }
        });
        return slaOverrideBox;
    }

    protected void initParentComponent() {
        this._parentComponent = SwingUtilities.getRoot(this);
    }

    public String getSLAConfigFilePath() {
        return this.slaOverrideTextField.getText();
    }

    public abstract void clear();
}

