/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.grid.deploy.BeanLevelTable;
import com.gigaspaces.admin.ui.grid.deploy.BeanLevelTableModel;
import com.gigaspaces.admin.ui.grid.deploy.utils.BeanLevelWrapper;
import com.gigaspaces.admin.ui.util.FilteredFileChooser;
import com.gigaspaces.grid.gsc.ui.PropertiesTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class BeanLevelPropertiesPanel
extends Box
implements ActionListener {
    private BeanLevelTable _beansLevelTable;
    private BeanLevelTableModel _beansLevelTableModel;
    private PropertiesTable _propertiesTable = new PropertiesTable(true, new Color(230, 230, 230));
    private JButton addPropertyButton;
    private JButton removeProperyButton;
    private JButton addBeanButton;
    private JButton removeBeanButton;
    private JButton loadProps;
    private Component _parentComponent;
    private String _deployDir;
    private FilteredFileChooser propertiesFileChooser;
    private final Dimension buttonSize = new Dimension(24, 22);
    private static final String COMPLETE_TABLE_DATA_MESSAGE = "Please complete filling all data in the table.";

    public BeanLevelPropertiesPanel(String deployDir) {
        super(0);
        this._deployDir = deployDir;
        this.init();
    }

    public List<BeanLevelWrapper> getWrappersList() {
        return this._beansLevelTableModel.getWrappersList();
    }

    private void init() {
        Box propertiesTableBox = this.createPropertiesTableBox();
        Box beansListBox = this.createBeansListBox();
        JSplitPane splitPane = new JSplitPane(1, beansListBox, propertiesTableBox);
        splitPane.setDividerLocation(140);
        this.add(splitPane);
        this.setBorder(BorderFactory.createTitledBorder("Bean Level Properties"));
    }

    private Box createBeansListBox() {
        Box buttonsBox = new Box(0);
        Box verticalBox = new Box(1);
        this._beansLevelTableModel = new BeanLevelTableModel();
        this._beansLevelTable = new BeanLevelTable(this._beansLevelTableModel, this._propertiesTable);
        this.addBeanWrapper(new BeanLevelWrapper("Context", true));
        this._beansLevelTable.setRowSelectionInterval(0, 0);
        JScrollPane listScrollPane = new JScrollPane(this._beansLevelTable);
        listScrollPane.setColumnHeader(null);
        listScrollPane.setPreferredSize(new Dimension(300, 400));
        this.addBeanButton = this.createAddRemoveButton("+");
        this.removeBeanButton = this.createAddRemoveButton("-");
        this.addBeanButton.addActionListener(this);
        this.removeBeanButton.addActionListener(this);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this.addBeanButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this.removeBeanButton);
        buttonsBox.add(Box.createHorizontalGlue());
        verticalBox.add(listScrollPane);
        verticalBox.add(Box.createVerticalStrut(3));
        verticalBox.add(buttonsBox);
        verticalBox.add(Box.createVerticalStrut(3));
        return verticalBox;
    }

    private Box createPropertiesTableBox() {
        Box buttonsBox = new Box(0);
        Box verticalBox = new Box(1);
        this.addPropertyButton = this.createAddRemoveButton("+");
        this.removeProperyButton = this.createAddRemoveButton("-");
        this.loadProps = new JButton("Load Properties ...");
        this.loadProps.addActionListener(this);
        this.addPropertyButton.addActionListener(this);
        this.removeProperyButton.addActionListener(this);
        this.loadProps.setToolTipText("Load Properties for the Space from a properties file");
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this.addPropertyButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this.removeProperyButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this.loadProps);
        buttonsBox.add(Box.createHorizontalGlue());
        verticalBox.add((Component)this._propertiesTable);
        verticalBox.add(Box.createVerticalStrut(3));
        verticalBox.add(buttonsBox);
        verticalBox.add(Box.createVerticalStrut(3));
        return verticalBox;
    }

    public void clear() {
        this._propertiesTable.clearTable();
        this._beansLevelTableModel.clear();
        this.addBeanWrapper(new BeanLevelWrapper("Context", true));
        this._beansLevelTable.setRowSelectionInterval(0, 0);
    }

    private JButton createAddRemoveButton(String text) {
        JButton button = new JButton(text);
        button.setPreferredSize(this.buttonSize);
        button.setMinimumSize(this.buttonSize);
        return button;
    }

    private void addBeanWrapper() {
        if (!this.isNewRowCanBeAdded()) {
            return;
        }
        String beanName = "<Bean Name ";
        List<String> allNamesList = this.getAllBeanNames();
        int count = 0;
        String tempBeanName = beanName;
        while (allNamesList.contains(tempBeanName + ">")) {
            tempBeanName = beanName;
            tempBeanName = tempBeanName + String.valueOf(++count);
        }
        tempBeanName = tempBeanName + ">";
        this.addBeanWrapper(tempBeanName);
    }

    private boolean isNewRowCanBeAdded() {
        int rowCount = this._beansLevelTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String val = this._beansLevelTable.getValueAt(i, 0).toString();
            if (val.trim().length() != 0) continue;
            if (this._parentComponent == null) {
                this.initParentComponent();
            }
            JOptionPane.showMessageDialog(this._parentComponent, COMPLETE_TABLE_DATA_MESSAGE, "Missing data", 1);
            return false;
        }
        return true;
    }

    private void addBeanWrapper(String name) {
        this._beansLevelTableModel.addWrapper(new BeanLevelWrapper(name, false));
    }

    private void addBeanWrapper(BeanLevelWrapper beanWrapper) {
        this._beansLevelTableModel.addWrapper(beanWrapper);
    }

    public List<String> getAllBeanNames() {
        List<BeanLevelWrapper> beanWrappersList = this._beansLevelTableModel.getWrappersList();
        ArrayList<String> beanNamesList = new ArrayList<String>(beanWrappersList.size());
        for (BeanLevelWrapper beanWrapper : beanWrappersList) {
            beanNamesList.add(beanWrapper.getBeanName());
        }
        return beanNamesList;
    }

    public void updateData() {
        this._beansLevelTable.updateData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loadProps) {
            File propsFile;
            if (this.propertiesFileChooser == null) {
                try {
                    if (this._parentComponent == null) {
                        this.initParentComponent();
                    }
                    this._parentComponent.setCursor(Cursor.getPredefinedCursor(3));
                    this.propertiesFileChooser = new FilteredFileChooser(this._parentComponent, new File(this._deployDir), "Select Properties file", "Load", ".properties");
                }
                finally {
                    this._parentComponent.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if ((propsFile = this.propertiesFileChooser.getFile()) == null) {
                return;
            }
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propsFile.getCanonicalPath()));
                this._propertiesTable.setProperties(properties);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        } else if (source == this.addBeanButton) {
            this.addBeanWrapper();
        } else if (source == this.removeBeanButton) {
            int selectedIndex;
            TableCellEditor tableCellEditor = this._beansLevelTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            if ((selectedIndex = this._beansLevelTable.getSelectedRow()) >= 0) {
                if (this._beansLevelTableModel.getWrapperAt(selectedIndex).isContext()) {
                    if (this._parentComponent == null) {
                        this.initParentComponent();
                    }
                    JOptionPane.showMessageDialog(this._parentComponent, "\"Context\" Bean Level cannot be removed.");
                    return;
                }
                this._beansLevelTableModel.removeWrapperAt(selectedIndex);
                this._propertiesTable.clearTable();
                int curListSize = this._beansLevelTableModel.getRowCount();
                if (curListSize > 0) {
                    if (selectedIndex < curListSize) {
                        this._beansLevelTable.setRowSelectionInterval(selectedIndex, selectedIndex);
                    } else if (curListSize > 0) {
                        this._beansLevelTable.setRowSelectionInterval(curListSize - 1, curListSize - 1);
                    }
                }
            }
        } else if (source == this.addPropertyButton) {
            this._propertiesTable.stopCellEditing();
            this._propertiesTable.addMapping("", "");
        } else if (source == this.removeProperyButton) {
            this._propertiesTable.stopCellEditing();
            this._propertiesTable.removeSelectedRow();
        }
    }

    private void initParentComponent() {
        this._parentComponent = SwingUtilities.getRoot(this);
    }
}

