/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.grid.deploy.BeanLevelTableModel;
import com.gigaspaces.admin.ui.grid.deploy.utils.BeanLevelWrapper;
import com.gigaspaces.grid.gsc.ui.PropertiesTable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;

class BeanLevelTable
extends JTable {
    private BeanLevelTableModel _tableModel;
    private PropertiesTable _propertiesTable;
    private int curSelRow = -1;

    public BeanLevelTable(BeanLevelTableModel tableModel, PropertiesTable propertiesTable) {
        super(tableModel);
        this._tableModel = tableModel;
        this._propertiesTable = propertiesTable;
        this.setSelectionMode(0);
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(1);
        this.setAutoscrolls(true);
    }

    @Override
    public void setRowSelectionInterval(int index0, int index1) {
        super.setRowSelectionInterval(index0, index1);
        this.curSelRow = index1;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this._propertiesTable != null) {
            this.updateData();
            BeanLevelWrapper selBeanWrapper = this._tableModel.getWrapperAt(this.getSelectedRow());
            if (selBeanWrapper != null) {
                this._propertiesTable.setProperties(selBeanWrapper.getProperties());
            }
            this.curSelRow = this.getSelectedRow();
        }
    }

    public void updateData() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this._propertiesTable.stopCellEditing();
        if (this.curSelRow >= 0) {
            Object cellValue = this.getValueAt(this.curSelRow, 0);
            if (cellValue == null) {
                return;
            }
            String newBeanLevelName = cellValue.toString();
            BeanLevelWrapper beanLevelWrapper = this._tableModel.getWrapperAt(this.curSelRow);
            beanLevelWrapper.setBeanName(newBeanLevelName);
            Properties props = this._propertiesTable.getProperties();
            Properties clonedProperties = (Properties)props.clone();
            Set<Object> keysSet = props.keySet();
            Iterator<Object> iterator = keysSet.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (key.trim().length() != 0) continue;
                clonedProperties.remove(key);
            }
            beanLevelWrapper.setProperties(clonedProperties);
        }
    }
}

