/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.grid.deploy.utils.BeanLevelWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

class BeanLevelTableModel
extends DefaultTableModel {
    private List<BeanLevelWrapper> _wrappersList = new ArrayList<BeanLevelWrapper>(3);

    public BeanLevelTableModel() {
        super(new String[]{""}, 0);
    }

    public void clear() {
        int listSize = this._wrappersList.size();
        if (listSize != 0) {
            this._wrappersList = new ArrayList<BeanLevelWrapper>(3);
            this.fireTableRowsDeleted(0, listSize - 1);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return !this._wrappersList.get(row).isContext();
    }

    public void setWrappersList(List<BeanLevelWrapper> wrappersList) {
        this._wrappersList = wrappersList;
        this.fireTableRowsInserted(0, this._wrappersList.size() - 1);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this._wrappersList.size()) {
            return this._wrappersList.get(row).getBeanName();
        }
        return null;
    }

    public void addWrapper(BeanLevelWrapper wrapper) {
        int count = this._wrappersList.size();
        this._wrappersList.add(wrapper);
        this.fireTableRowsInserted(count, count + 1);
    }

    public void removeWrapperAt(int rowIndex) {
        int size = this._wrappersList.size();
        this._wrappersList.remove(rowIndex);
        this.fireTableRowsDeleted(size - 1, size - 1);
    }

    public BeanLevelWrapper getWrapperAt(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this._wrappersList.size()) {
            return this._wrappersList.get(rowIndex);
        }
        return null;
    }

    public List<BeanLevelWrapper> getWrappersList() {
        return this._wrappersList;
    }

    public void setWrapperAt(BeanLevelWrapper wrapper, int row) {
        this._wrappersList.set(row, wrapper);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._wrappersList == null ? 0 : this._wrappersList.size();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this._wrappersList.get(row).setBeanName(aValue.toString());
        this.fireTableCellUpdated(row, column);
    }
}

