/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.deploy.GSMTable;
import com.gigaspaces.admin.ui.grid.deploy.utils.BeanLevelWrapper;
import com.gigaspaces.admin.ui.grid.deploy.utils.ClusterDefinitionComponent;
import com.gigaspaces.admin.ui.grid.deploy.utils.DeploymentHelper;
import com.gigaspaces.admin.ui.grid.deploy.utils.UserLoginDetailsBox;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.utils.UIValidationUtils;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.security.Authentication;
import com.j_spaces.core.exception.InvalidServiceNameException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.monitor.DeployAdmin;

public class DataGridDeploymentPanel
extends JPanel {
    private JTextField dataGridNameTextField = new JTextField();
    private JComboBox spaceSchemasCombo;
    private JCheckBox securedSpaceCB = new JCheckBox("Secured Space", false);
    protected UserLoginDetailsBox userLoginDetailsBox;
    private final int componentHeight = 24;
    private final Dimension labelSize = new Dimension(150, 24);
    private GSMTable gsmTable = new GSMTable();
    private ClusterDefinitionComponent clusterDefinitionComponent;
    private Component _parentComponent;
    private KeyListener _deployKeyListener;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public DataGridDeploymentPanel(KeyListener deployKeyListener) {
        this._deployKeyListener = deployKeyListener;
        this.initComponents();
    }

    public void updateData() {
    }

    public boolean validateEntries() {
        block9: {
            ServiceItem selServiceItem;
            Authentication selGsmAuthentication;
            boolean isSecuredService;
            if (this.dataGridNameTextField.getText().trim().length() == 0) {
                this.showWarning("A Data Grid Name must be provided");
                return false;
            }
            if (!this.clusterDefinitionComponent.validateEntries()) {
                return false;
            }
            String dataGridName = this.getDataGridName();
            try {
                ValidationUtils.checkServiceNameForValidation((String)dataGridName, (String)"Data Grid name");
            }
            catch (InvalidServiceNameException exc) {
                this.showWarning(exc.getMessage());
                return false;
            }
            if (this._parentComponent == null) {
                this.initParentComponent();
            }
            if ((isSecuredService = this.gsmTable.isSelectedItemSecured()) && !UIValidationUtils.validateCredentials(this._parentComponent, selGsmAuthentication = this.gsmTable.getAuthenticationOfSelectedGSM(), selServiceItem = this.gsmTable.getSelectedServiceItem(), this.gsmTable)) {
                return false;
            }
            try {
                if (this.getSelectedDeployAdmin().hasDeployed(dataGridName)) {
                    this.showWarning("<HTML>A Processing Unit named <FONT color=\"blue\"><B>" + dataGridName + "</B></FONT> is already deployed, please choose a different name.<HTML>");
                    return false;
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block9;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return true;
    }

    private void showWarning(String message) {
        if (this._parentComponent == null) {
            this.initParentComponent();
        }
        JOptionPane.showMessageDialog(this._parentComponent, message, "Data Grid Deployment", 2);
    }

    private void initParentComponent() {
        this._parentComponent = SwingUtilities.getRoot(this);
    }

    private void initComponents() {
        this.clusterDefinitionComponent = new ClusterDefinitionComponent("partitioned", this._deployKeyListener);
        this.setLayout(new BoxLayout(this, 1));
        JLabel dataGridNameTextLabel = new JLabel("Space name:");
        dataGridNameTextLabel.setPreferredSize(this.labelSize);
        dataGridNameTextLabel.setMaximumSize(this.labelSize);
        Box dataGridNameBox = new Box(0);
        dataGridNameBox.add(Box.createHorizontalStrut(3));
        dataGridNameBox.add(dataGridNameTextLabel);
        dataGridNameBox.add(this.dataGridNameTextField);
        dataGridNameBox.add(Box.createHorizontalGlue());
        this.dataGridNameTextField.addKeyListener(this._deployKeyListener);
        this.dataGridNameTextField.setPreferredSize(new Dimension(350, 24));
        this.dataGridNameTextField.setMaximumSize(new Dimension(350, 24));
        this.spaceSchemasCombo = new JComboBox<String>(DeploymentHelper.getAllSpaceSchemas());
        this.spaceSchemasCombo.setPreferredSize(new Dimension(350, 24));
        this.spaceSchemasCombo.setMaximumSize(new Dimension(350, 24));
        Box spaceSchemaBox = new Box(0);
        JLabel spaceSchemaLabel = new JLabel("Space Schema:");
        spaceSchemaLabel.setPreferredSize(this.labelSize);
        spaceSchemaLabel.setMaximumSize(this.labelSize);
        spaceSchemaBox.add(Box.createHorizontalStrut(3));
        spaceSchemaBox.add(spaceSchemaLabel);
        spaceSchemaBox.add(this.spaceSchemasCombo);
        spaceSchemaBox.add(Box.createHorizontalGlue());
        Box securedSpaceBox = new Box(0);
        securedSpaceBox.add(Box.createHorizontalStrut(3));
        securedSpaceBox.add(this.securedSpaceCB);
        securedSpaceBox.add(Box.createHorizontalGlue());
        this.userLoginDetailsBox = new UserLoginDetailsBox(this._deployKeyListener);
        this.userLoginDetailsBox.setEnabled(this.securedSpaceCB.isSelected());
        this.securedSpaceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataGridDeploymentPanel.this.userLoginDetailsBox.setEnabled(DataGridDeploymentPanel.this.securedSpaceCB.isSelected());
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.gsmTable);
        scrollPane.setPreferredSize(new Dimension(1000, 150));
        scrollPane.setMaximumSize(new Dimension(1000, 150));
        JLabel explLabel = new JLabel("Select a Grid Service Manager (GSM) for deployment:");
        Box explBox = new Box(0);
        explBox.add(explLabel);
        explBox.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(2));
        this.add(dataGridNameBox);
        this.add(Box.createVerticalStrut(5));
        this.add(spaceSchemaBox);
        this.add(Box.createVerticalStrut(5));
        this.add(securedSpaceBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.userLoginDetailsBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.clusterDefinitionComponent);
        this.add(Box.createVerticalStrut(10));
        this.add(explBox);
        this.add(Box.createVerticalStrut(2));
        this.add(scrollPane);
    }

    public String getDataGridName() {
        return this.dataGridNameTextField.getText();
    }

    public DeployAdmin getSelectedDeployAdmin() {
        return this.gsmTable.getSelectedDeployAdmin();
    }

    public GSM getSelectedGSM() {
        return (GSM)this.gsmTable.getSelectedServiceItem().service;
    }

    public ServiceItem getSelectedServiceItem() {
        return this.gsmTable.getSelectedServiceItem();
    }

    public String getSelectedGSMHostName() {
        GSMTable.Item item = this.gsmTable.getSelectedItem();
        return item.aInfo == null ? "Unknown" : item.aInfo.hostName;
    }

    public List<BeanLevelWrapper> getWrappersList(Properties spaceProperties) {
        BeanLevelWrapper contextBeanLevelWrapper = new BeanLevelWrapper("Context", true);
        Properties contextProperties = new Properties();
        contextProperties.setProperty("dataGridName", this.getDataGridName());
        contextBeanLevelWrapper.setProperties(contextProperties);
        BeanLevelWrapper spaceBeanLevelWrapper = new BeanLevelWrapper("space", false);
        if (spaceProperties == null) {
            spaceProperties = new Properties();
        }
        String spaceSchema = this.getSpaceSchema();
        spaceProperties.setProperty("gs.space.url.arg.schema", spaceSchema);
        spaceBeanLevelWrapper.setProperties(spaceProperties);
        ArrayList<BeanLevelWrapper> wrappersList = new ArrayList<BeanLevelWrapper>(2);
        wrappersList.add(contextBeanLevelWrapper);
        wrappersList.add(spaceBeanLevelWrapper);
        return wrappersList;
    }

    public void addGSMs() {
        this.gsmTable.clear();
        Repository.ProvisionMonitorHolder[] pmh = Repository.getInstance().getProvisionMonitorHolders();
        if (pmh.length > 0) {
            for (Repository.ProvisionMonitorHolder pmHolder : pmh) {
                ServiceItem serviceItem = pmHolder.getServiceItem();
                if (pmHolder.isManaging()) {
                    this.gsmTable.addItemFirst(serviceItem);
                    continue;
                }
                this.gsmTable.addItemLast(serviceItem);
            }
            this.gsmTable.setRowSelectionInterval(0, 0);
        }
    }

    public boolean isSpaceSecured() {
        return this.securedSpaceCB.isSelected();
    }

    private String getSpaceSchema() {
        return (String)this.spaceSchemasCombo.getSelectedItem();
    }

    public String getNumberOfClusterInstances() {
        return this.clusterDefinitionComponent.getNumberOfClusterInstances();
    }

    public String getNumberOfBackupClusterInstances() {
        return this.clusterDefinitionComponent.getNumberOfBackupClusterInstances();
    }

    public String getMaximumInstancesPerMachine() {
        return this.clusterDefinitionComponent.getMaximumInstancesPerMachine();
    }

    public String getMaximumInstancesPerVM() {
        return this.clusterDefinitionComponent.getMaximumInstancesPerVM();
    }

    public String getClusterSchemaName() {
        return this.clusterDefinitionComponent.getClusterSchemaName();
    }
}

