/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.DeploymentControl;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.deploy.AdvancedDataGridDeploymentPanel;
import com.gigaspaces.admin.ui.grid.deploy.AdvancedPUDeploymentPanel;
import com.gigaspaces.admin.ui.grid.deploy.DataGridDeploymentPanel;
import com.gigaspaces.admin.ui.grid.deploy.DeployProgressPanel;
import com.gigaspaces.admin.ui.grid.deploy.GSMTable;
import com.gigaspaces.admin.ui.grid.deploy.PUDeploymentPanel;
import com.gigaspaces.admin.ui.grid.deploy.utils.BeanLevelWrapper;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstances;
import com.gigaspaces.admin.ui.grid.utils.DeploymentActionsManager;
import com.gigaspaces.admin.ui.util.EscapeDialog;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.kernel.JSpaceUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Statement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.OperationalString;
import org.jini.rio.monitor.DeployAdmin;
import org.jini.rio.opstring.OpStringLoader;

public class DeployControl
extends JPanel
implements DeploymentControl {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");
    private static JDialog dialog;
    private final CardLayout panelDeck;
    private final JPanel deployPanel;
    private final JButton previous;
    private final JButton next;
    private final JButton finish;
    private final JButton cancel;
    private int currentPanelIndex = 0;
    private final String[] panels = new String[]{"DeploymentType", "OptionSelection", "GSMSelector", "DeploymentStatus"};
    private final DeploymentType deploymentType;
    private final OptionSelection optionSelection;
    private final GSMSelector gsmSelector;
    private final JPanel deploymentStatus;
    static String path;
    static boolean asAppl;
    DeployProgressPanel progressPanel;
    private static final String DEPLOY = "Deploy";
    private static final String DEPLOY_TOOLTIP = "Deploy with selected options";
    private static final String CLOSE_DIALOG_TOOLTIP = "Dismiss the dialog";
    public static final short DO_PU = 1;
    public static final short DO_EDG = 2;
    public static final String DO_SBA_LABEL = "SBA Application - Processing Unit";
    public static final String DO_SBA_TOOLTIP = "Deploy Application";
    public static final String DO_EDG_LABEL = "Enterprise Data Grid";
    public static final String DO_EDG_TOOLTIP = "Deploy In-Memory-Data-Grid";
    private final DeploymentActionsManager _deploymentActionsManager;

    public DeployControl(MainUI mainUI, String deployDir, DeploymentActionsManager deploymentActionsManager) {
        this._deploymentActionsManager = deploymentActionsManager;
        this.setLayout(new BorderLayout());
        if (deployDir != null) {
            path = deployDir;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Set Deployment Descriptor path to " + path);
        }
        JPanel base = new JPanel(new BorderLayout(8, 8));
        base.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        this.panelDeck = new CardLayout(8, 8);
        this.deployPanel = new JPanel(this.panelDeck);
        this.deployPanel.setBorder(BorderFactory.createEtchedBorder());
        this.deploymentType = new DeploymentType();
        this.optionSelection = new OptionSelection(mainUI, deployDir);
        this.gsmSelector = new GSMSelector();
        this.deploymentStatus = new JPanel(new BorderLayout());
        this.deployPanel.add(this.panels[0], this.deploymentType);
        this.deployPanel.add(this.panels[1], this.optionSelection);
        this.deployPanel.add(this.panels[2], this.gsmSelector);
        this.deployPanel.add(this.panels[3], this.deploymentStatus);
        this.deployPanel.add("Advanced_DataGrid_Panel", this.optionSelection.advancedDataGridDeploymentPanel);
        this.deployPanel.add("Advanced_PU_Panel", this.optionSelection.advancedPUDeploymentPanel);
        this.panelDeck.addLayoutComponent(this.deploymentType, this.panels[0]);
        this.panelDeck.addLayoutComponent(this.optionSelection, this.panels[1]);
        this.panelDeck.addLayoutComponent(this.gsmSelector, this.panels[2]);
        this.panelDeck.addLayoutComponent(this.deploymentStatus, this.panels[3]);
        JPanel buttons = new JPanel();
        this.previous = new JButton("< Previous");
        this.previous.setEnabled(false);
        this.previous.setToolTipText("Go back to the previous deployment options panel");
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DeployControl.this.currentPanelIndex--;
                DeployControl.this.panelDeck.show(DeployControl.this.deployPanel, DeployControl.this.panels[DeployControl.this.currentPanelIndex]);
                if (DeployControl.this.currentPanelIndex == 0) {
                    DeployControl.this.previous.setEnabled(false);
                }
                DeployControl.this.next.setEnabled(true);
                if ((DeployControl.this.deploymentType.isDeployProcessingUnit() || DeployControl.this.deploymentType.isDeployDataGrid()) && DeployControl.this.currentPanelIndex != 0) {
                    DeployControl.this.finish.setEnabled(true);
                    if (DeployControl.this.deploymentType.isDeployProcessingUnit()) {
                        ((DeployControl)DeployControl.this).optionSelection.advancedPUDeploymentPanel.clear();
                    } else if (DeployControl.this.deploymentType.isDeployDataGrid()) {
                        ((DeployControl)DeployControl.this).optionSelection.advancedDataGridDeploymentPanel.clear();
                    }
                } else {
                    DeployControl.this.finish.setEnabled(false);
                }
            }
        });
        this.next = new JButton("Next >");
        this.next.setToolTipText("Go to the next deployment options panel");
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DeployControl.this.performNext();
            }
        });
        this.finish = new JButton(DEPLOY);
        this.finish.setToolTipText(DEPLOY_TOOLTIP);
        this.finish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DeployControl.this.performDeployment();
            }
        });
        this.finish.setEnabled(false);
        this.cancel = new JButton("Cancel");
        this.cancel.setToolTipText("Cancel Deployment");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DeployControl.this.terminate();
            }
        });
        buttons.add(this.previous);
        buttons.add(this.next);
        buttons.add(this.finish);
        buttons.add(this.cancel);
        base.add((Component)this.deployPanel, "Center");
        base.add((Component)buttons, "South");
        this.add((Component)base, "Center");
    }

    private void performNext() {
        this.previous.setEnabled(true);
        if (this.currentPanelIndex == 0) {
            if (this.deploymentType.isDeployProcessingUnit()) {
                this.optionSelection.useProcessingUnitOption();
                this.optionSelection.puDeploymentPanel.addGSMs();
                this.next.setEnabled(true);
                this.finish.setEnabled(true);
            } else if (this.deploymentType.isDeployDataGrid()) {
                this.optionSelection.useDataGridOption();
                this.optionSelection.dataGridDeploymentPanel.addGSMs();
                this.next.setEnabled(true);
                this.finish.setEnabled(true);
            }
        } else if (this.currentPanelIndex == 1) {
            if (this.deploymentType.isDeployProcessingUnit()) {
                if (!this.optionSelection.puDeploymentPanel.validateEntries()) {
                    return;
                }
                this.finish.setEnabled(true);
            } else if (this.deploymentType.isDeployDataGrid()) {
                if (!this.optionSelection.dataGridDeploymentPanel.validateEntries()) {
                    return;
                }
                this.finish.setEnabled(true);
            }
        }
        this.nextPanel();
    }

    private void performDeployment() {
        if (this.deploymentType.isDeployProcessingUnit()) {
            this.performPUDeployment();
        } else if (this.deploymentType.isDeployDataGrid()) {
            this.performDataGridDeployment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPUDeployment() {
        if (this.optionSelection.puDeploymentPanel.validateEntries()) {
            String puName = null;
            try {
                String maxInstancesPerVM;
                String maxInstancesPerMachine;
                this.previous.setEnabled(false);
                this.finish.setEnabled(false);
                dialog.setCursor(Cursor.getPredefinedCursor(3));
                if (this.currentPanelIndex == 2) {
                    this.optionSelection.advancedPUDeploymentPanel.updateData();
                }
                List<BeanLevelWrapper> beanLevelWrapperslist = this.optionSelection.advancedPUDeploymentPanel.getWrappersList();
                List<String> beanLevelParametersList = this.createBeanLevelParametersList(beanLevelWrapperslist);
                List<ZoneInstances> zoneInstances = this.optionSelection.advancedPUDeploymentPanel.getZoneInstances();
                Set<String> selectedZones = this.optionSelection.advancedPUDeploymentPanel.getSelectedZones();
                List<Object> securityParametersList = null;
                if (this.optionSelection.puDeploymentPanel.isSpaceSecured()) {
                    String userName = this.optionSelection.puDeploymentPanel.userLoginDetailsBox.getUserName();
                    String password = this.optionSelection.puDeploymentPanel.userLoginDetailsBox.getPassword();
                    if (!JSpaceUtilities.isEmpty((String)userName, (boolean)true) && !JSpaceUtilities.isEmpty((String)password, (boolean)true)) {
                        securityParametersList = this.createSecurityParametersList(userName, password);
                    } else {
                        securityParametersList = new ArrayList<String>(2);
                        securityParametersList.add("-secured");
                        securityParametersList.add(Boolean.TRUE.toString());
                    }
                }
                puName = this.optionSelection.puDeploymentPanel.getProcessingUnitName();
                String overridePUName = this.optionSelection.puDeploymentPanel.getOverrideProcessingUnitName();
                String clusterSchemaName = this.optionSelection.puDeploymentPanel.getClusterSchemaName().trim();
                String primaryInstancesCount = this.optionSelection.puDeploymentPanel.getNumberOfClusterInstances();
                String backupInstancesCount = this.optionSelection.puDeploymentPanel.getNumberOfBackupClusterInstances();
                String slaConfigFilePath = this.optionSelection.advancedPUDeploymentPanel.getSLAConfigFilePath();
                boolean isSecuredSpace = this.optionSelection.puDeploymentPanel.isSpaceSecured();
                ArrayList<String> argsList = new ArrayList<String>(beanLevelParametersList);
                if (securityParametersList != null) {
                    argsList.addAll(securityParametersList);
                }
                if (!JSpaceUtilities.isEmpty((String)overridePUName)) {
                    argsList.add("-override-name");
                    argsList.add(overridePUName);
                }
                if (clusterSchemaName.length() > 0 || primaryInstancesCount.length() > 0 || backupInstancesCount.length() > 0) {
                    argsList.add("-cluster");
                    if (primaryInstancesCount.length() > 0) {
                        String totalMembers = primaryInstancesCount;
                        if (backupInstancesCount.length() > 0 && !backupInstancesCount.equals(String.valueOf(0))) {
                            totalMembers = totalMembers + "," + backupInstancesCount;
                        }
                        argsList.add("total_members=" + totalMembers);
                    }
                    argsList.add("schema=" + clusterSchemaName);
                }
                if ((maxInstancesPerMachine = this.optionSelection.puDeploymentPanel.getMaximumInstancesPerMachine()) != null) {
                    argsList.add("-max-instances-per-machine");
                    argsList.add(maxInstancesPerMachine);
                }
                if ((maxInstancesPerVM = this.optionSelection.puDeploymentPanel.getMaximumInstancesPerVM()) != null) {
                    argsList.add("-max-instances-per-vm");
                    argsList.add(maxInstancesPerVM);
                }
                if (slaConfigFilePath.length() > 0) {
                    argsList.add("-sla");
                    argsList.add(slaConfigFilePath);
                }
                argsList.addAll(this.getMaxInstancesPerZoneParametersArguments(zoneInstances));
                argsList.addAll(this.getSelectedZonesParametersArguments(selectedZones));
                argsList.add(puName);
                String[] argv = new String[argsList.size()];
                argsList.toArray(argv);
                DeployAdmin deployAdmin = this.optionSelection.puDeploymentPanel.getSelectedDeployAdmin();
                GSM gsm = this.optionSelection.puDeploymentPanel.getSelectedGSM();
                ServiceItem gsmServiceItem = this.optionSelection.puDeploymentPanel.getSelectedServiceItem();
                String hostName = this.optionSelection.puDeploymentPanel.getSelectedGSMHostName();
                this.deployPU(deployAdmin, gsm, argv, gsmServiceItem, hostName, zoneInstances, selectedZones);
                this.deploymentStatus.add((Component)this.progressPanel, "Center");
                this.cancel.setText("Close");
                this.cancel.setToolTipText(CLOSE_DIALOG_TOOLTIP);
                this.nextPanel();
                if (this.currentPanelIndex < this.panels.length - 1) {
                    this.nextPanel();
                }
            }
            catch (Throwable e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
                Throwable t = e;
                if (e.getCause() != null) {
                    t = e.getCause();
                }
                UIHelper.showError(t, (Component)dialog);
                this.previous.setEnabled(true);
                this.finish.setEnabled(true);
            }
            finally {
                dialog.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private void deployPU(final DeployAdmin deployAdmin, GSM gsm, String[] argv, ServiceItem gsmServiceItem, String hostName, List<ZoneInstances> zoneInstances, Set<String> selectedZones) throws Throwable {
        OperationalString opString;
        Class<?> deployerClass = Class.forName("org.openspaces.pu.container.servicegrid.deploy.Deploy");
        Object deployer = deployerClass.newInstance();
        Statement setGroups = new Statement(deployer, "setGroups", new Object[]{SystemInfo.singleton().lookup().groupsArray()});
        setGroups.execute();
        Statement setDeployAdmin = new Statement(deployer, "initializeDiscovery", new Object[]{gsm});
        setDeployAdmin.execute();
        Method method = deployerClass.getMethod("buildOperationalString", String[].class);
        try {
            opString = (OperationalString)method.invoke(deployer, new Object[]{argv});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        final OperationalString operationalString = opString;
        this.progressPanel = new DeployProgressPanel(operationalString, gsmServiceItem, hostName, zoneInstances, selectedZones);
        new Thread(){

            @Override
            public void run() {
                try {
                    Map errorMap = deployAdmin.deploy(operationalString, DeployControl.this.progressPanel.getServiceProvisionListener());
                    if (!errorMap.isEmpty()) {
                        UIHelper.showError(errorMap, "Deployment Errors", dialog);
                    }
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                    Throwable t = e;
                    if (e.getCause() != null) {
                        t = e.getCause();
                    }
                    UIHelper.showError(t, (Component)dialog);
                }
            }
        }.start();
    }

    public Set<String> getSelectedZonesParametersArguments(Set<String> selectedZones) {
        LinkedHashSet<String> args = new LinkedHashSet<String>();
        if (!selectedZones.isEmpty()) {
            args.add("-zones");
            args.addAll(selectedZones);
        }
        return args;
    }

    public List<String> getMaxInstancesPerZoneParametersArguments(List<ZoneInstances> zoneInstanceses) {
        ArrayList<String> args = new ArrayList<String>(2);
        String maxInstancesPerZone = this.getMaxInstancesPerZoneParameters(zoneInstanceses);
        if (maxInstancesPerZone.trim().length() > 0) {
            args.add("-max-instances-per-zone");
            args.add(maxInstancesPerZone.trim());
        }
        return args;
    }

    private String getMaxInstancesPerZoneParameters(List<ZoneInstances> zoneInstanceses) {
        StringBuilder resultBuilder = new StringBuilder();
        for (ZoneInstances zoneInstances : zoneInstanceses) {
            int maxInstancesNum = zoneInstances.getMaxInstancesNum();
            if (maxInstancesNum < 0) continue;
            resultBuilder.append(zoneInstances.getZone());
            resultBuilder.append("/");
            resultBuilder.append(maxInstancesNum);
            resultBuilder.append(",");
        }
        if (resultBuilder.length() > 0) {
            resultBuilder.deleteCharAt(resultBuilder.length() - 1);
        }
        return resultBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDataGridDeployment() {
        if (this.optionSelection.dataGridDeploymentPanel.validateEntries()) {
            String puName = "templates/datagrid";
            try {
                String dataGridName;
                String maxInstancesPerVM;
                String maxInstancesPerMachine;
                this.previous.setEnabled(false);
                this.finish.setEnabled(false);
                dialog.setCursor(Cursor.getPredefinedCursor(3));
                this.optionSelection.dataGridDeploymentPanel.updateData();
                String clusterSchemaName = this.optionSelection.dataGridDeploymentPanel.getClusterSchemaName().trim();
                String primaryInstancesCount = this.optionSelection.dataGridDeploymentPanel.getNumberOfClusterInstances();
                String backupInstancesCount = this.optionSelection.dataGridDeploymentPanel.getNumberOfBackupClusterInstances();
                String slaConfigFilePath = this.optionSelection.advancedDataGridDeploymentPanel.getSLAConfigFilePath();
                List<Object> securityParametersList = null;
                if (this.optionSelection.dataGridDeploymentPanel.isSpaceSecured()) {
                    String userName = this.optionSelection.dataGridDeploymentPanel.userLoginDetailsBox.getUserName();
                    String password = this.optionSelection.dataGridDeploymentPanel.userLoginDetailsBox.getPassword();
                    if (!JSpaceUtilities.isEmpty((String)userName, (boolean)true) && !JSpaceUtilities.isEmpty((String)password, (boolean)true)) {
                        securityParametersList = this.createSecurityParametersList(userName, password);
                    } else {
                        securityParametersList = new ArrayList<String>(2);
                        securityParametersList.add("-secured");
                        securityParametersList.add(Boolean.TRUE.toString());
                    }
                }
                Properties properties = this.optionSelection.advancedDataGridDeploymentPanel.getProperties();
                List<BeanLevelWrapper> beanLevelWrappersList = this.optionSelection.dataGridDeploymentPanel.getWrappersList(properties);
                List<String> beanLevelParametersList = this.createBeanLevelParametersList(beanLevelWrappersList);
                List<ZoneInstances> zoneInstances = this.optionSelection.advancedDataGridDeploymentPanel.getZoneInstances();
                Set<String> selectedZones = this.optionSelection.advancedDataGridDeploymentPanel.getSelectedZones();
                ArrayList<String> argsList = new ArrayList<String>(beanLevelParametersList);
                if (securityParametersList != null) {
                    argsList.addAll(securityParametersList);
                }
                if (clusterSchemaName.length() > 0 || primaryInstancesCount.length() > 0 || backupInstancesCount.length() > 0) {
                    argsList.add("-cluster");
                    if (primaryInstancesCount.length() > 0) {
                        String totalMembers = primaryInstancesCount;
                        if (backupInstancesCount.length() > 0 && !backupInstancesCount.equals(String.valueOf(0))) {
                            totalMembers = totalMembers + "," + backupInstancesCount;
                        }
                        argsList.add("total_members=" + totalMembers);
                    }
                    if (clusterSchemaName.length() > 0) {
                        argsList.add("schema=" + clusterSchemaName);
                    }
                }
                if ((maxInstancesPerMachine = this.optionSelection.dataGridDeploymentPanel.getMaximumInstancesPerMachine()) != null) {
                    argsList.add("-max-instances-per-machine");
                    argsList.add(maxInstancesPerMachine);
                }
                if ((maxInstancesPerVM = this.optionSelection.dataGridDeploymentPanel.getMaximumInstancesPerVM()) != null) {
                    argsList.add("-max-instances-per-vm");
                    argsList.add(maxInstancesPerVM);
                }
                if (slaConfigFilePath.length() > 0) {
                    argsList.add("-sla");
                    argsList.add(slaConfigFilePath);
                }
                if (!JSpaceUtilities.isEmpty((String)(dataGridName = this.optionSelection.dataGridDeploymentPanel.getDataGridName()))) {
                    argsList.add("-override-name");
                    argsList.add(dataGridName);
                }
                argsList.addAll(this.getMaxInstancesPerZoneParametersArguments(zoneInstances));
                argsList.addAll(this.getSelectedZonesParametersArguments(selectedZones));
                argsList.add("templates/datagrid");
                String[] argv = new String[argsList.size()];
                argsList.toArray(argv);
                DeployAdmin deployAdmin = this.optionSelection.dataGridDeploymentPanel.getSelectedDeployAdmin();
                GSM gsm = this.optionSelection.dataGridDeploymentPanel.getSelectedGSM();
                ServiceItem gsmServiceItem = this.optionSelection.dataGridDeploymentPanel.getSelectedServiceItem();
                String hostName = this.optionSelection.dataGridDeploymentPanel.getSelectedGSMHostName();
                this.deployPU(deployAdmin, gsm, argv, gsmServiceItem, hostName, zoneInstances, selectedZones);
                this.deploymentStatus.add((Component)this.progressPanel, "Center");
                this.cancel.setText("Close");
                this.cancel.setToolTipText(CLOSE_DIALOG_TOOLTIP);
                this.nextPanel();
                if (this.currentPanelIndex < this.panels.length - 1) {
                    this.nextPanel();
                }
            }
            catch (Throwable e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
                Throwable t = e;
                if (e.getCause() != null) {
                    t = e.getCause();
                }
                UIHelper.showError(t, (Component)dialog);
                this.previous.setEnabled(true);
                this.finish.setEnabled(true);
            }
            finally {
                dialog.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private List<String> createBeanLevelParametersList(List<BeanLevelWrapper> beanLevelWrapperslist) {
        ArrayList<String> parameters = new ArrayList<String>(10);
        for (BeanLevelWrapper levelWrapper : beanLevelWrapperslist) {
            String beanName = levelWrapper.getBeanName();
            Properties properties = levelWrapper.getProperties();
            if (properties.size() <= 0 || beanName.trim().length() <= 0) continue;
            parameters.add("-properties");
            if (!levelWrapper.isContext()) {
                parameters.add(beanName);
            }
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            int count = 0;
            StringBuilder stringBuilder = new StringBuilder(properties.size() * 4);
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> mapEntry = iterator.next();
                String key = (String)mapEntry.getKey();
                String value = (String)mapEntry.getValue();
                if (count == 0) {
                    stringBuilder.append("embed://");
                }
                ++count;
                stringBuilder.append(key);
                stringBuilder.append("=");
                stringBuilder.append(value);
                stringBuilder.append(";");
            }
            parameters.add(stringBuilder.toString());
        }
        return parameters;
    }

    private List<String> createSecurityParametersList(String userName, String password) {
        ArrayList<String> parameters = new ArrayList<String>(10);
        parameters.add("-properties");
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("embed://");
        stringBuilder.append("security.username").append('=');
        stringBuilder.append(userName);
        stringBuilder.append(";");
        stringBuilder.append("security.password").append('=');
        stringBuilder.append(password);
        stringBuilder.append(";");
        parameters.add(stringBuilder.toString());
        return parameters;
    }

    @Override
    public String getLastSelectedPath() {
        return path;
    }

    void nextPanel() {
        ++this.currentPanelIndex;
        if (this.currentPanelIndex == this.panels.length - 1 || this.currentPanelIndex == this.panels.length - 2) {
            this.next.setEnabled(false);
        }
        if (this.currentPanelIndex == 2 && this.deploymentType.isDeployProcessingUnit()) {
            this.panelDeck.show(this.deployPanel, "Advanced_PU_Panel");
        } else if (this.currentPanelIndex == 2 && this.deploymentType.isDeployDataGrid()) {
            this.panelDeck.show(this.deployPanel, "Advanced_DataGrid_Panel");
        } else {
            this.panelDeck.show(this.deployPanel, this.panels[this.currentPanelIndex]);
        }
    }

    public JDialog getDialog(JFrame frame, String title, boolean modal, int selectedDeploymentOption) {
        dialog = new EscapeDialog(frame, title, modal);
        dialog.getContentPane().add(this);
        int width = 590;
        int height = 525;
        dialog.pack();
        dialog.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int widthLoc = screenSize.width / 2 - width / 2;
        int heightLoc = screenSize.height / 2 - height / 2;
        dialog.setLocation(widthLoc, heightLoc);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeployControl.this.terminate();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                DeployControl.this.terminate();
            }
        });
        if (selectedDeploymentOption == 2) {
            this.deploymentType.dataGridDeploymentRadioButton.setSelected(true);
            this.performNext();
        } else if (selectedDeploymentOption == 1) {
            this.deploymentType.puDeploymentRadioButton.setSelected(true);
            this.performNext();
        }
        return dialog;
    }

    public JDialog getDialog() {
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationalString loadDeployment(String descriptor, String overrideLocation, String codeserver) throws Exception {
        OpStringLoader opStringLoader = new OpStringLoader(this.getClass().getClassLoader());
        String[] groups = SystemInfo.singleton().lookup().groupsArray();
        if (groups != null) {
            opStringLoader.setDefaultGroups(groups);
        }
        if (codeserver != null && codeserver.length() > 0) {
            opStringLoader.setCodebaseOverride(codeserver);
        }
        opStringLoader.setDefaultExportJars(new String[]{"gs-dl.jar"});
        if (overrideLocation != null && overrideLocation.length() > 0) {
            opStringLoader.setServiceOverride(overrideLocation);
        }
        OperationalString[] opStrings = null;
        try {
            dialog.setCursor(Cursor.getPredefinedCursor(3));
            if (descriptor == null) {
                ClassLoader cl = this.getClass().getClassLoader();
                URL cacheURL = cl.getResource("cache-deploy-desc.xml");
                opStrings = opStringLoader.parseOperationalString(cacheURL);
            } else {
                opStrings = opStringLoader.parseOperationalString(descriptor);
            }
        }
        finally {
            dialog.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (opStrings == null || opStrings.length == 0) {
            throw new IllegalArgumentException("Failed to deploy descriptor [" + descriptor + "] with override location [" + overrideLocation + "] and codeserver [" + codeserver + "], is your deployment descriptor correct?");
        }
        return opStrings[0];
    }

    @Override
    public void doDeploy(OperationalString opString, DeployAdmin deployAdmin) {
        try {
            deployAdmin.deploy(opString);
        }
        catch (Exception e) {
            UIHelper.showError((Throwable)e, "Deploying application");
        }
    }

    @Override
    public void unexport() {
        if (this.progressPanel != null) {
            this.progressPanel.ungetServiceProvisionListener();
            this.progressPanel = null;
        }
    }

    @Override
    public void terminate() {
        this.unexport();
        this._deploymentActionsManager.dialogDisposed();
        dialog.setVisible(false);
        if (asAppl) {
            System.exit(0);
        }
    }

    static {
        path = System.getProperty("user.dir", ".");
        asAppl = false;
    }

    private class GSMSelector
    extends JPanel {
        private final GSMTable gsmTable;

        private GSMSelector() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            JLabel l0 = new JLabel("Select a Grid Service Manager (GSM) for deployment");
            this.gsmTable = new GSMTable();
            JScrollPane sp = new JScrollPane(this.gsmTable);
            sp.setPreferredSize(new Dimension(Integer.MAX_VALUE, 100));
            sp.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
            this.add(l0);
            this.add(Box.createVerticalStrut(8));
            this.add(sp);
            this.add(Box.createVerticalGlue());
        }
    }

    private class OptionSelection
    extends JPanel {
        final PUDeploymentPanel puDeploymentPanel;
        final DataGridDeploymentPanel dataGridDeploymentPanel;
        final AdvancedDataGridDeploymentPanel advancedDataGridDeploymentPanel;
        final AdvancedPUDeploymentPanel advancedPUDeploymentPanel;
        private JPanel loadedComponent;
        static final String ADVANCED_DATA_GRID_DEPLOYMENT = "Advanced_DataGrid_Panel";
        static final String ADVANCED_PU_DEPLOYMENT = "Advanced_PU_Panel";

        private OptionSelection(MainUI mainUI, String deployDir) {
            this.setLayout(new BorderLayout());
            DeployKeyListener deployKeyListener = new DeployKeyListener();
            this.puDeploymentPanel = new PUDeploymentPanel(mainUI, DeployControl.this, deployKeyListener);
            this.dataGridDeploymentPanel = new DataGridDeploymentPanel(deployKeyListener);
            this.advancedDataGridDeploymentPanel = new AdvancedDataGridDeploymentPanel(deployDir);
            this.advancedPUDeploymentPanel = new AdvancedPUDeploymentPanel(deployDir);
        }

        void useProcessingUnitOption() {
            if (this.loadedComponent != null && !(this.loadedComponent instanceof PUDeploymentPanel)) {
                this.remove(this.loadedComponent);
            }
            this.add((Component)this.puDeploymentPanel, "Center");
            this.loadedComponent = this.puDeploymentPanel;
            this.invalidate();
            this.repaint();
        }

        void useDataGridOption() {
            if (this.loadedComponent != null && !(this.loadedComponent instanceof DataGridDeploymentPanel)) {
                this.remove(this.loadedComponent);
            }
            this.add((Component)this.dataGridDeploymentPanel, "Center");
            this.loadedComponent = this.dataGridDeploymentPanel;
            this.invalidate();
            this.repaint();
        }
    }

    public class DeployKeyListener
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                DeployControl.this.performDeployment();
            }
        }
    }

    private static class DeploymentType
    extends JPanel {
        private final JRadioButton puDeploymentRadioButton;
        private final JRadioButton dataGridDeploymentRadioButton;

        private DeploymentType() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            JLabel l1 = new JLabel("<html><font color=060132><u>Select the type of deployment</u></font></html>");
            this.puDeploymentRadioButton = new JRadioButton();
            this.puDeploymentRadioButton.setText(DeployControl.DO_SBA_LABEL);
            this.puDeploymentRadioButton.setToolTipText(DeployControl.DO_SBA_TOOLTIP);
            this.dataGridDeploymentRadioButton = new JRadioButton();
            this.dataGridDeploymentRadioButton.setText(DeployControl.DO_EDG_LABEL);
            this.dataGridDeploymentRadioButton.setToolTipText(DeployControl.DO_EDG_TOOLTIP);
            ButtonGroup group = new ButtonGroup();
            group.add(this.puDeploymentRadioButton);
            group.add(this.dataGridDeploymentRadioButton);
            this.puDeploymentRadioButton.setSelected(true);
            this.add(l1);
            this.add(Box.createVerticalStrut(14));
            this.add(this.puDeploymentRadioButton);
            this.add(Box.createVerticalStrut(8));
            this.add(this.dataGridDeploymentRadioButton);
            this.add(Box.createVerticalGlue());
        }

        boolean isDeployProcessingUnit() {
            return this.puDeploymentRadioButton.isSelected();
        }

        boolean isDeployDataGrid() {
            return this.dataGridDeploymentRadioButton.isSelected();
        }
    }
}

