/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstances;
import com.gigaspaces.admin.ui.jtreetable.DynamicTreeTableModel;
import com.gigaspaces.admin.ui.jtreetable.JTreeTable;
import com.gigaspaces.admin.ui.jtreetable.TreeTableModel;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.start.SystemConfig;
import com.j_spaces.kernel.JSpaceUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.lookup.ServiceItem;
import net.jini.export.Exporter;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;

public class DeployProgressPanel
extends JPanel
implements ServiceProvisionListener {
    private static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");
    public static final int FAILURE_COLUMN = 3;
    private JProgressBar totalProgress;
    private int totalPlanned;
    private int totalDeployed;
    private String opstringName;
    private Exporter exporter;
    private ServiceProvisionListener serviceProvisionListener;
    private DefaultMutableTreeNode root;
    private JTreeTable table;
    private DeployTreeTableModel treeTableModel;

    public static void packColumn(JTable table, int vColIndex, int margin, boolean isFixed) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
        if (isFixed) {
            col.setMinWidth(width);
            col.setMaxWidth(width);
        }
    }

    public DeployProgressPanel(OperationalString opstring, ServiceItem gsmServiceItem, String hostName, List<ZoneInstances> zoneInstances, Set<String> selectedZones) {
        String[] zones;
        long pid;
        block10: {
            this.opstringName = opstring.getName();
            this.initTreeTable(opstring);
            this.totalProgress = new JProgressBar(0, this.totalPlanned);
            this.totalProgress.setStringPainted(true);
            this.totalProgress.setString("0 of " + this.totalPlanned);
            JVMDetails jvmDetails = Repository.getInstance().getJVMDetails(gsmServiceItem, true);
            pid = 0L;
            if (jvmDetails != null) {
                pid = jvmDetails.getPid();
            }
            zones = null;
            try {
                zones = ((GridZoneProvider)gsmServiceItem.service).getZones();
            }
            catch (Exception exc) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block10;
                LOGGER.log(Level.SEVERE, exc.toString(), exc);
            }
        }
        String gsmDescr = JSpaceUtilities.createServiceName((String)"gsm", (int)-1, (long)pid, (String[])zones);
        this.setLayout(new BorderLayout(8, 8));
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setVerticalScrollBarPolicy(22);
        StringBuilder zonesInfoStrBuilder = new StringBuilder();
        if (!zoneInstances.isEmpty() || !selectedZones.isEmpty()) {
            StringBuilder usedMaxInstancesPerZoneStrBuilder = new StringBuilder();
            for (ZoneInstances zoneInstance : zoneInstances) {
                if (usedMaxInstancesPerZoneStrBuilder.length() > 0) {
                    usedMaxInstancesPerZoneStrBuilder.append(',');
                }
                int maxInstancesNum = zoneInstance.getMaxInstancesNum();
                String zone = zoneInstance.getZone();
                usedMaxInstancesPerZoneStrBuilder.append(zone);
                usedMaxInstancesPerZoneStrBuilder.append('/');
                usedMaxInstancesPerZoneStrBuilder.append(maxInstancesNum);
            }
            StringBuilder usedZonesStrBuilder = new StringBuilder();
            for (String zone : selectedZones) {
                if (usedZonesStrBuilder.length() > 0) {
                    usedZonesStrBuilder.append(',');
                }
                usedZonesStrBuilder.append(zone);
            }
            zonesInfoStrBuilder.append("<BR>zones:&nbsp&nbsp");
            if (usedZonesStrBuilder.length() > 0) {
                zonesInfoStrBuilder.append("<FONT color=green>");
                zonesInfoStrBuilder.append((CharSequence)usedZonesStrBuilder);
                zonesInfoStrBuilder.append("</FONT>&nbsp&nbsp&nbsp&nbsp");
            }
            if (usedMaxInstancesPerZoneStrBuilder.length() > 0) {
                zonesInfoStrBuilder.append("<FONT color=green>");
                zonesInfoStrBuilder.append((CharSequence)usedMaxInstancesPerZoneStrBuilder);
                zonesInfoStrBuilder.append("</FONT>");
            }
        }
        this.add((Component)new JLabel("<HTML>Deployment status for <B><FONT color=BLUE>" + opstring.getName() + "</FONT></B> using " + gsmDescr + " on host <FONT color=green>" + hostName + "</FONT>" + zonesInfoStrBuilder + "</HTML>"), "North");
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.totalProgress, "South");
    }

    public ServiceProvisionListener getServiceProvisionListener() throws ExportException, ConfigurationException {
        if (this.serviceProvisionListener == null) {
            this.export();
        }
        return this.serviceProvisionListener;
    }

    public void succeeded(final ServiceBeanInstance jsbInstance) throws RemoteException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String name = jsbInstance.getServiceBeanConfig().getName();
                for (int i = 0; i < DeployProgressPanel.this.root.getChildCount(); ++i) {
                    ServiceElementNode node = (ServiceElementNode)DeployProgressPanel.this.root.getChildAt(i);
                    if (!node.getName().equals(name)) continue;
                    int index = DeployProgressPanel.this.removeNextAvailable(node);
                    if (index != -1) {
                        node.insert(new InstanceNode(jsbInstance), index);
                    } else {
                        node.add(new InstanceNode(jsbInstance));
                    }
                    node.setSucceeded(node.getSucceeded() + 1);
                    DeployProgressPanel.this.totalDeployed++;
                    if (node.getPlanned() > 0) {
                        DeployProgressPanel.this.updateProgress();
                    }
                    DeployProgressPanel.this.treeTableModel.nodeStructureChanged(node);
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Not Found:" + name);
                }
            }
        });
    }

    void updateProgress() {
        this.totalProgress.setValue(this.totalDeployed);
        this.totalProgress.setString(this.totalDeployed + " of " + this.totalPlanned + " Deployed");
        if (this.isDone()) {
            this.totalProgress.setString("Successful Deployment");
        }
    }

    int removeNextAvailable(ServiceElementNode node) {
        TreeNode o;
        int j;
        int index = -1;
        for (j = 0; j < node.getChildCount(); ++j) {
            o = node.getChildAt(j);
            if (!(o instanceof InProcessNode)) continue;
            index = j;
            node.remove(index);
            this.treeTableModel.nodeStructureChanged(node);
            break;
        }
        if (index == -1) {
            for (j = 0; j < node.getChildCount(); ++j) {
                o = node.getChildAt(j);
                if (!(o instanceof FailureNode) || !((FailureNode)o).resubmitted()) continue;
                index = j;
                node.remove(index);
                node.setFailed(node.getFailed() - 1);
                this.treeTableModel.nodeStructureChanged(node);
                break;
            }
        }
        return index;
    }

    public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
        String name = sElem.getName();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            ServiceElementNode node = (ServiceElementNode)this.root.getChildAt(i);
            if (!node.getName().equals(name)) continue;
            node.setFailed(node.getFailed() + 1);
            this.treeTableModel.nodesChanged(this.root, new int[]{i});
            int index = this.removeNextAvailable(node);
            if (index != -1) {
                node.insert(new FailureNode(resubmitted), index);
            } else {
                node.add(new FailureNode(resubmitted));
            }
            this.treeTableModel.nodeStructureChanged(node);
            this.updateProgress();
            return;
        }
    }

    public void export() throws ConfigurationException, ExportException {
        Configuration config = SystemConfig.getInstance().getConfiguration();
        this.exporter = ExporterConfig.getExporter((Configuration)config, (String)"com.gigaspaces.admin", (String)"provisionListenerExporter");
        this.serviceProvisionListener = (ServiceProvisionListener)this.exporter.export((Remote)((Object)this));
    }

    private void initTreeTable(OperationalString opstring) {
        this.root = new DefaultMutableTreeNode(opstring.getName());
        this.totalPlanned = this.sumUpServices(opstring);
        this.treeTableModel = new DeployTreeTableModel(this.root);
        this.table = new ProgressTreeTable();
        this.table.getTree().setRootVisible(false);
        this.table.getTree().setShowsRootHandles(true);
        this.table.getTree().setCellRenderer(new TreeCellRenderer());
        ((DefaultTreeCellRenderer)this.table.getTree().getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.table.getTree().getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.table.getTree().getCellRenderer()).setClosedIcon(null);
        for (int row = 0; row < this.table.getTree().getRowCount(); ++row) {
            this.table.getTree().expandRow(row);
        }
        DeployProgressPanel.packColumn(this.table, 1, 6, true);
        DeployProgressPanel.packColumn(this.table, 2, 6, true);
        DeployProgressPanel.packColumn(this.table, 3, 6, true);
    }

    public boolean isDone() {
        return this.totalDeployed == this.totalPlanned;
    }

    public void showDialog() {
        JOptionPane.showOptionDialog(null, this.opstringName, "Deployment Progress", 1, -1, null, new Object[]{this}, null);
    }

    int sumUpServices(OperationalString deployment) {
        int summation = 0;
        ServiceElement[] elems = deployment.getServices();
        for (int i = 0; i < elems.length; ++i) {
            ServiceElement element = elems[i];
            summation += element.getPlanned();
            ServiceElementNode serviceElementNode = new ServiceElementNode(element);
            this.root.add(serviceElementNode);
            for (int j = 0; j < element.getPlanned(); ++j) {
                serviceElementNode.add(new InProcessNode());
            }
        }
        OperationalString[] nested = deployment.getNestedOperationalStrings();
        for (int i = 0; i < nested.length; ++i) {
            summation += this.sumUpServices(nested[i]);
        }
        return summation;
    }

    public void ungetServiceProvisionListener() {
        if (this.exporter != null) {
            this.exporter.unexport(true);
            this.serviceProvisionListener = null;
        }
    }

    private class ProgressTreeTable
    extends JTreeTable {
        public ProgressTreeTable() {
            super(DeployProgressPanel.this.treeTableModel);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component component = super.prepareRenderer(renderer, row, column);
            if (column == 3) {
                Number number;
                Object value = this.getValueAt(row, column);
                if (value instanceof Number && (number = (Number)value).intValue() > 0) {
                    component.setForeground(Color.red);
                }
            } else {
                component.setForeground(Color.black);
            }
            return component;
        }
    }

    public static class InstanceNode
    extends DefaultMutableTreeNode {
        private String name;

        public InstanceNode(ServiceBeanInstance instance) {
            super(instance);
            String hostAddress = ((ServiceBeanInstance)this.getUserObject()).getHostAddress();
            if (hostAddress == null) {
                hostAddress = "Unknown Host";
            }
            this.name = "Provisioned to " + hostAddress;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    public static class FailureNode
    extends DefaultMutableTreeNode {
        boolean resubmitted;

        public FailureNode(boolean resubmitted) {
            this.resubmitted = resubmitted;
        }

        public boolean resubmitted() {
            return this.resubmitted;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public String toString() {
            String s = this.resubmitted ? "Provision Failure: Resubmitted" : "Provision Failure: Uninstantiable";
            return s;
        }
    }

    public static class InProcessNode
    extends DefaultMutableTreeNode {
        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public String toString() {
            return "In process ...";
        }
    }

    public static class ServiceElementNode
    extends DefaultMutableTreeNode {
        int succeeded;
        int failed;
        int progress;

        public ServiceElementNode(ServiceElement serviceElement) {
            super(serviceElement);
        }

        boolean isExternal() {
            return this.getServiceElement().getProvisionType() == 0;
        }

        public int getSucceeded() {
            return this.succeeded;
        }

        public int getFailed() {
            return this.failed;
        }

        public void setSucceeded(int succeeded) {
            this.succeeded = succeeded;
        }

        public void setFailed(int failed) {
            this.failed = failed;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }

        public int getProgress() {
            return this.progress;
        }

        public String getName() {
            return this.getServiceElement().getName();
        }

        public int getPlanned() {
            return this.getServiceElement().getPlanned();
        }

        private ServiceElement getServiceElement() {
            return (ServiceElement)this.getUserObject();
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!sel) {
                if (value instanceof InstanceNode) {
                    component.setForeground(new Color(0, 145, 0));
                }
                if (value instanceof FailureNode) {
                    if (((FailureNode)value).resubmitted()) {
                        component.setForeground(new Color(202, 101, 0));
                    } else {
                        component.setForeground(Color.red);
                    }
                }
            }
            return component;
        }
    }

    private static class DeployTreeTableModel
    extends DynamicTreeTableModel {
        static final String[] columnNames = new String[]{"Service Name", "Planned", "Succeeded", "Failed"};
        private static final String[] methodNames = new String[]{"getName", "getPlanned", "getSucceeded", "getFailed"};
        private static final Class[] classes = new Class[]{TreeTableModel.class, String.class, Integer.class, Integer.class};

        public DeployTreeTableModel(TreeNode opStringNode) {
            super(opStringNode, columnNames, methodNames, null, classes);
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return false;
        }
    }
}

