/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.util.FilteredFileChooser;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.start.SystemInfo;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jini.rio.core.OperationalString;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.opstring.OpStringLoader;

public class DeployUpdate {
    public static void exec(Component comp, String path, OperationalString opstring, OperationalStringManager mgr) throws Exception {
        if (opstring == null) {
            throw new NullPointerException("deployment is null");
        }
        if (mgr == null) {
            throw new NullPointerException("mgr is null");
        }
        URL url = opstring.loadedFrom();
        boolean useLoadedFrom = false;
        File f = null;
        if (url != null) {
            try {
                String jvmVersion = System.getProperty("java.version");
                f = jvmVersion.indexOf("1.4") != -1 ? new File(url.toExternalForm()) : new File(new URI(url.toString()));
                if (f.exists()) {
                    int answer = JOptionPane.showConfirmDialog(null, "<html>Load the Deployment Descriptor from <br>[<font color=blue>" + f.getAbsolutePath() + "</font>]?</html>", "Update Deployment Descriptor", 1);
                    if (answer == 2) {
                        return;
                    }
                    if (answer == 0) {
                        useLoadedFrom = true;
                    }
                }
            }
            catch (URISyntaxException jvmVersion) {
                // empty catch block
            }
        }
        OpStringLoader opLoader = new OpStringLoader(DeployUpdate.class.getClassLoader());
        String[] groups = SystemInfo.singleton().lookup().groupsArray();
        if (groups != null) {
            opLoader.setDefaultGroups(groups);
        }
        opLoader.setDefaultExportJars(new String[]{"gs-dl.jar"});
        if (!useLoadedFrom) {
            FilteredFileChooser xmlChooser = new FilteredFileChooser(comp, new File(path), "Choose Deployment Descriptor", "OK", ".xml");
            f = xmlChooser.getFile();
        }
        if (f != null) {
            String name = opstring.getName();
            opstring = opLoader.parseOperationalString(f)[0];
            if (opstring.getName().equals(name)) {
                Map m = mgr.updateOperationalString(opstring);
                if (!m.isEmpty()) {
                    UIHelper.showError(m, "Updating Deployment Descriptor", comp);
                }
            } else {
                String message = "<html>The deployment descriptor chosen [<font color=blue>" + opstring.getName() + "</font>],<br>is a different name then the deployment descriptor<br>you are trying to update [<font color=green>" + name + "</font>].<br>Please select the correct deployment<br>descriptor document to update</html>";
                String title = "Deployment Descriptor Selection Error";
                JOptionPane.showMessageDialog(comp, message, title, 0);
            }
        }
    }
}

