/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.security.AuthenticationListener;
import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.entry.ApplianceInfo;
import org.jini.rio.monitor.DeployAdmin;

public class GSMTable
extends JTable
implements AuthenticationListener {
    private final MonitorTableModel dataModel = new MonitorTableModel();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public GSMTable() {
        this.setModel(this.dataModel);
        this.setAutoResizeMode(3);
        this.setSelectionMode(0);
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(80);
        cm.getColumn(1).setMaxWidth(80);
        cm.getColumn(0).setCellRenderer(new SecurityIndicationTableCellRenderer());
        SecurityServicesRepository.getInstance().addAuthenticationListener(this);
    }

    public void addItemLast(ServiceItem item) {
        this.dataModel.appendToTail(new Item(item));
    }

    public void addItemFirst(ServiceItem item) {
        this.dataModel.appendToHead(new Item(item));
    }

    public void clear() {
        this.dataModel.tableData.clear();
        this.dataModel.fireTableDataChanged();
    }

    @Override
    public int getSelectedRow() {
        int elements = this.dataModel.tableData.size();
        if (elements == 0) {
            return -1;
        }
        return super.getSelectedRow();
    }

    public void serviceAuthenticated(ServiceItem serviceItem, boolean isLoginSucceed, Authentication authentication, String failureMessage) {
        if (serviceItem.service instanceof GSM) {
            this.repaint();
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        int hitColumnIndex = this.columnAtPoint(p);
        int hitRowIndex = this.rowAtPoint(p);
        Object obj = this.getModel().getValueAt(hitRowIndex, hitColumnIndex);
        if (obj != null && !(obj instanceof Boolean)) {
            return obj.toString();
        }
        return null;
    }

    public Authentication getAuthenticationOfSelectedGSM() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        ServiceID selectedServiceID = ((Item)this.dataModel.getItem((int)selectedRow)).item.serviceID;
        return SecurityServicesRepository.getInstance().getSecurityAuthentication(selectedServiceID);
    }

    public DeployAdmin getSelectedDeployAdmin() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return ((Item)this.dataModel.getItem((int)selectedRow)).deployAdmin;
    }

    public Item getSelectedItem() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return (Item)this.dataModel.getItem(selectedRow);
    }

    public ServiceItem getSelectedServiceItem() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return ((Item)this.dataModel.getItem((int)selectedRow)).item;
    }

    public void reloadSelectedDeployAdmin() {
        this.dataModel.reloadAdminAt(this.getSelectedRow());
    }

    public boolean isSelectedItemSecured() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            return false;
        }
        return ((Item)this.dataModel.getItem((int)selectedRow)).isSecured;
    }

    public ServiceItem getServiceItem(int row) {
        return ((Item)this.dataModel.getItem((int)row)).item;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            Item item = (Item)this.dataModel.getItem(row);
            jc.setToolTipText("GSM: Deployments=" + item.deployments);
        }
        return c;
    }

    static class Item {
        ServiceItem item;
        ApplianceInfo aInfo;
        String groups;
        DeployAdmin deployAdmin;
        String deployments;
        boolean isSecured;
        private long _pid;

        Item(ServiceItem item) {
            block13: {
                JVMDetails jvmDetails;
                this.groups = "<?>";
                this.isSecured = false;
                this._pid = -1L;
                this.item = item;
                Object service = item.service;
                for (int i = 0; i < item.attributeSets.length; ++i) {
                    if (!(item.attributeSets[i] instanceof ApplianceInfo)) continue;
                    this.aInfo = (ApplianceInfo)item.attributeSets[i];
                    break;
                }
                if ((jvmDetails = Repository.getInstance().getJVMDetails(item, true)) != null) {
                    this._pid = jvmDetails.getPid();
                }
                try {
                    Object admin = ((Administrable)service).getAdmin();
                    this.isSecured = ((SecuredService)service).isServiceSecured();
                    this.deployAdmin = (DeployAdmin)admin;
                    OperationalStringManager[] mgrs = this.deployAdmin.getOperationalStringManagers();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < mgrs.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        if (mgrs[i].isManaging()) {
                            sb.append(mgrs[i].getOperationalString().getName() + "*");
                            continue;
                        }
                        sb.append(mgrs[i].getOperationalString().getName());
                    }
                    this.deployments = sb.toString();
                    JoinAdmin jAdmin = (JoinAdmin)admin;
                    String[] gps = jAdmin.getLookupGroups();
                    sb.delete(0, sb.length());
                    if (gps == null) {
                        this.groups = "ALL_GROUPS";
                    } else {
                        for (int i = 0; i < gps.length; ++i) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(gps[i]);
                        }
                        this.groups = sb.toString();
                    }
                    LookupLocator[] locs = jAdmin.getLookupLocators();
                    sb.delete(0, sb.length());
                    for (int i = 0; i < locs.length; ++i) {
                        if (i > 0) {
                            sb.append(" ");
                        }
                        sb.append(locs[i].getHost());
                    }
                }
                catch (RemoteException re) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block13;
                    _logger.log(Level.SEVERE, re.toString(), re);
                }
            }
        }

        public long getPid() {
            return this._pid;
        }
    }

    static class SecurityIndicationTableCellRenderer
    extends DefaultTableCellRenderer {
        private final ImageIcon securedGSMIcon = IconsRepository.getInstance().getIcon(10);
        private final ImageIcon securedAuthenticatedGSMIcon = IconsRepository.getInstance().getIcon(14);

        SecurityIndicationTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MonitorTableModel monitorTableModel = (MonitorTableModel)table.getModel();
            ImageIcon icon = null;
            Item item = (Item)monitorTableModel.getItem(row);
            if (item != null && item.isSecured) {
                ServiceID serviceID = item.item.serviceID;
                icon = JSpaceUIUtils.hasPermittedPermission((SecuredService)item.item.service, serviceID, (Privilege)GridAuthority.GridPrivilege.PROVISION_PU) ? this.securedAuthenticatedGSMIcon : this.securedGSMIcon;
            }
            this.setIcon(icon);
            return this;
        }
    }

    class MonitorTableModel
    extends AbstractTableModel {
        Vector tableData = new Vector();
        final String[] columnNames = new String[]{"Machine", "PID", "Groups"};

        public void reloadAdminAt(int index) {
            block2: {
                Item item = (Item)this.tableData.elementAt(index);
                try {
                    item.deployAdmin = (DeployAdmin)((Administrable)item.item.service).getAdmin();
                }
                catch (RemoteException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block2;
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        @Override
        public Object getValueAt(int index, int columnIndex) {
            try {
                Item item = (Item)this.tableData.elementAt(index);
                switch (columnIndex) {
                    case 0: {
                        return item.aInfo == null ? "Unknown" : item.aInfo.hostName;
                    }
                    case 1: {
                        return item.getPid() < 0L ? "n/a" : String.valueOf(item.getPid());
                    }
                    case 2: {
                        return item.groups;
                    }
                }
                return null;
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
                return null;
            }
        }

        public void appendToTail(Object item) {
            int rowNum = this.tableData.size();
            this.tableData.insertElementAt(item, rowNum);
            this.fireTableRowsInserted(rowNum, rowNum);
        }

        public void appendToHead(Item item) {
            this.tableData.insertElementAt(item, 0);
            this.fireTableRowsInserted(0, this.tableData.size());
        }

        public Object getItem(int row) {
            return this.tableData.elementAt(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void setValueAt(Object item, int rowNum) {
            this.tableData.setElementAt(item, rowNum);
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }
}

