/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.deploy.DeployControl;
import com.gigaspaces.admin.ui.grid.deploy.GSMTable;
import com.gigaspaces.admin.ui.grid.deploy.utils.ClusterDefinitionComponent;
import com.gigaspaces.admin.ui.grid.deploy.utils.UserLoginDetailsBox;
import com.gigaspaces.admin.ui.grid.utils.DeploymentActionsManager;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.utils.UIValidationUtils;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.security.Authentication;
import com.j_spaces.core.exception.InvalidServiceNameException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.cluster.FileFilterExt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import net.jini.core.lookup.ServiceItem;
import org.jini.rio.monitor.DeployAdmin;

public class PUDeploymentPanel
extends JPanel {
    private JComboBox puNameComboBox = new JComboBox();
    private JTextField overridePUNameTextField = new JTextField();
    private final int componentHeight = 24;
    private final Dimension labelSize = new Dimension(206, 24);
    private GSMTable gsmTable = new GSMTable();
    private JCheckBox securedSpaceCB = new JCheckBox("Secured Space", false);
    protected UserLoginDetailsBox userLoginDetailsBox;
    private JDialog _parentComponent;
    private DeployControl _deployControl;
    private ClusterDefinitionComponent clusterDefinitionComponent;
    private KeyListener _deployKeyListener;
    private JButton browseButton = new JButton("...");
    private final FileFilterExt jarFilesFilter = new FileFilterExt(new String[]{"jar", "war", "zip"});
    private JFileChooser jarFileChooser;
    private MainUI _mainUI;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");

    public PUDeploymentPanel(MainUI mainUI, DeployControl deployControl, KeyListener deployKeyListener) {
        this._deployControl = deployControl;
        this._deployKeyListener = deployKeyListener;
        this._mainUI = mainUI;
        this.initComponents();
    }

    public boolean validateEntries() {
        block14: {
            ServiceItem selServiceItem;
            Authentication selGsmAuthentication;
            boolean isSecuredService;
            if (this.puNameComboBox.getSelectedItem() == null || this.puNameComboBox.getSelectedItem().toString().trim().length() == 0) {
                this.showWarning("A Processing Unit Name must be provided");
                return false;
            }
            if (!this.clusterDefinitionComponent.validateEntries()) {
                return false;
            }
            String overridePUName = this.getOverrideProcessingUnitName();
            String puName = this.getProcessingUnitName();
            if (JSpaceUtilities.isEmpty((String)overridePUName, (boolean)true)) {
                if (!new File(puName).exists()) {
                    try {
                        ValidationUtils.checkServiceNameForValidation((String)puName, (String)"Processing Unit name");
                    }
                    catch (InvalidServiceNameException exc) {
                        this.showWarning(exc.getMessage());
                        return false;
                    }
                }
            } else {
                try {
                    ValidationUtils.checkServiceNameForValidation((String)overridePUName, (String)"Override Processing Unit name");
                }
                catch (InvalidServiceNameException exc) {
                    this.showWarning(exc.getMessage());
                    return false;
                }
            }
            if (this._parentComponent == null) {
                this.initParentComponent();
            }
            if ((isSecuredService = this.gsmTable.isSelectedItemSecured()) && !UIValidationUtils.validateCredentials(this._parentComponent, selGsmAuthentication = this.gsmTable.getAuthenticationOfSelectedGSM(), selServiceItem = this.gsmTable.getSelectedServiceItem(), this.gsmTable)) {
                return false;
            }
            String actualPUName = JSpaceUtilities.isEmpty((String)overridePUName, (boolean)true) ? puName : overridePUName;
            try {
                if (this.getSelectedDeployAdmin().hasDeployed(actualPUName)) {
                    this.showWarning("<HTML>A Processing Unit named <FONT color=\"blue\"><B>" + actualPUName + "</B></FONT> is already deployed, please choose a different name.<HTML>");
                    return false;
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block14;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        return true;
    }

    private void showWarning(String message) {
        if (this._parentComponent == null) {
            this.initParentComponent();
        }
        JOptionPane.showMessageDialog(this._parentComponent, message, "Processing Unit Application", 2);
    }

    private void initParentComponent() {
        this._parentComponent = (JDialog)SwingUtilities.getRoot(this);
    }

    private void initComponents() {
        this.clusterDefinitionComponent = new ClusterDefinitionComponent(this._deployKeyListener);
        this.setLayout(new BoxLayout(this, 1));
        JLabel puNameTextLabel = new JLabel("Processing Unit:");
        this.puNameComboBox.getEditor().getEditorComponent().addKeyListener(this._deployKeyListener);
        this.overridePUNameTextField.addKeyListener(this._deployKeyListener);
        puNameTextLabel.setPreferredSize(this.labelSize);
        puNameTextLabel.setMaximumSize(this.labelSize);
        puNameTextLabel.setMinimumSize(this.labelSize);
        this.puNameComboBox.setPreferredSize(new Dimension(278, 24));
        this.puNameComboBox.setMaximumSize(new Dimension(278, 24));
        this.overridePUNameTextField.setPreferredSize(new Dimension(310, 24));
        this.overridePUNameTextField.setMaximumSize(new Dimension(310, 24));
        this.browseButton.setPreferredSize(new Dimension(30, 24));
        this.browseButton.setMaximumSize(new Dimension(30, 24));
        this.browseButton.setToolTipText("Select Processing Unit jar file");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PUDeploymentPanel.this.selectPUJarFile();
            }
        });
        Box puNameBox = new Box(0);
        puNameBox.add(Box.createHorizontalStrut(3));
        puNameBox.add(puNameTextLabel);
        puNameBox.add(this.puNameComboBox);
        puNameBox.add(Box.createHorizontalStrut(2));
        puNameBox.add(this.browseButton);
        puNameBox.add(Box.createHorizontalGlue());
        JLabel overridePUNameTextLabel = new JLabel("Override Processing Unit name:");
        overridePUNameTextLabel.setPreferredSize(this.labelSize);
        overridePUNameTextLabel.setMaximumSize(this.labelSize);
        overridePUNameTextLabel.setMinimumSize(this.labelSize);
        Box overridePUNameBox = new Box(0);
        overridePUNameBox.add(Box.createHorizontalStrut(3));
        overridePUNameBox.add(overridePUNameTextLabel);
        overridePUNameBox.add(this.overridePUNameTextField);
        overridePUNameBox.add(Box.createHorizontalGlue());
        this.puNameComboBox.setEditable(true);
        Box securedSpaceBox = new Box(0);
        securedSpaceBox.add(Box.createHorizontalStrut(3));
        securedSpaceBox.add(this.securedSpaceCB);
        securedSpaceBox.add(Box.createHorizontalGlue());
        this.userLoginDetailsBox = new UserLoginDetailsBox(this._deployKeyListener);
        this.userLoginDetailsBox.setEnabled(this.securedSpaceCB.isSelected());
        this.securedSpaceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PUDeploymentPanel.this.userLoginDetailsBox.setEnabled(PUDeploymentPanel.this.securedSpaceCB.isSelected());
            }
        });
        this.gsmTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeployAdmin deployAdmin = PUDeploymentPanel.this.gsmTable.getSelectedDeployAdmin();
                PUDeploymentPanel.this.updatePUList(deployAdmin);
            }
        });
        this.puNameComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                DeployAdmin deployAdmin = PUDeploymentPanel.this.gsmTable.getSelectedDeployAdmin();
                PUDeploymentPanel.this.updatePUList(deployAdmin);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.gsmTable);
        scrollPane.setPreferredSize(new Dimension(1000, 150));
        scrollPane.setMaximumSize(new Dimension(1000, 150));
        JLabel explLabel = new JLabel("Select a Grid Service Manager (GSM) for deployment:");
        Box explBox = new Box(0);
        explBox.add(explLabel);
        explBox.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(2));
        this.add(puNameBox);
        this.add(Box.createVerticalStrut(4));
        this.add(overridePUNameBox);
        this.add(Box.createVerticalStrut(4));
        this.add(securedSpaceBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.userLoginDetailsBox);
        this.add(Box.createVerticalStrut(5));
        this.add(this.clusterDefinitionComponent);
        this.add(Box.createVerticalStrut(10));
        this.add(explBox);
        this.add(Box.createVerticalStrut(2));
        this.add(scrollPane);
    }

    private void selectPUJarFile() {
        File selectedJarFile;
        int selectedOption;
        if (this.jarFileChooser == null) {
            try {
                if (this._parentComponent == null) {
                    this.initParentComponent();
                }
                this._parentComponent.setCursor(Cursor.getPredefinedCursor(3));
                this.jarFileChooser = new JFileChooser(DeploymentActionsManager.getInstance(this._mainUI).getLastDeployPath());
                this.jarFileChooser.setAccessory(new FileChooserAddition(this.jarFileChooser, false));
                this.jarFileChooser.addChoosableFileFilter(this.jarFilesFilter);
                this.jarFileChooser.setFileSelectionMode(0);
                this.jarFileChooser.setPreferredSize(new Dimension(650, 340));
            }
            finally {
                this._parentComponent.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if ((selectedOption = this.jarFileChooser.showDialog(this._parentComponent, "Select")) == 0 && (selectedJarFile = this.jarFileChooser.getSelectedFile()) != null) {
            String path = selectedJarFile.getAbsolutePath();
            DeploymentActionsManager.getInstance(this._mainUI).setLastDeployPath(path);
            this.puNameComboBox.setSelectedItem(selectedJarFile.getPath());
        }
    }

    public String getProcessingUnitName() {
        return this.puNameComboBox.getSelectedItem() == null ? "" : this.puNameComboBox.getSelectedItem().toString();
    }

    public String getOverrideProcessingUnitName() {
        return this.overridePUNameTextField.getText();
    }

    public DeployAdmin getSelectedDeployAdmin() {
        return this.gsmTable.getSelectedDeployAdmin();
    }

    public GSM getSelectedGSM() {
        return (GSM)this.gsmTable.getSelectedServiceItem().service;
    }

    public ServiceItem getSelectedServiceItem() {
        return this.gsmTable.getSelectedServiceItem();
    }

    public String getSelectedGSMHostName() {
        GSMTable.Item item = this.gsmTable.getSelectedItem();
        return item.aInfo == null ? "Unknown" : item.aInfo.hostName;
    }

    public void addGSMs() {
        this.gsmTable.clear();
        Repository.ProvisionMonitorHolder[] pmh = Repository.getInstance().getProvisionMonitorHolders();
        if (pmh.length > 0) {
            for (Repository.ProvisionMonitorHolder pmHolder : pmh) {
                ServiceItem serviceItem = pmHolder.getServiceItem();
                if (pmHolder.isManaging()) {
                    this.gsmTable.addItemFirst(serviceItem);
                    continue;
                }
                this.gsmTable.addItemLast(serviceItem);
            }
            this.gsmTable.setRowSelectionInterval(0, 0);
        }
    }

    public boolean isSpaceSecured() {
        return this.securedSpaceCB.isSelected();
    }

    public String getNumberOfClusterInstances() {
        return this.clusterDefinitionComponent.getNumberOfClusterInstances();
    }

    public String getNumberOfBackupClusterInstances() {
        return this.clusterDefinitionComponent.getNumberOfBackupClusterInstances();
    }

    public String getClusterSchemaName() {
        return this.clusterDefinitionComponent.getClusterSchemaName();
    }

    public String getMaximumInstancesPerMachine() {
        return this.clusterDefinitionComponent.getMaximumInstancesPerMachine();
    }

    public String getMaximumInstancesPerVM() {
        return this.clusterDefinitionComponent.getMaximumInstancesPerVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePUList(DeployAdmin deployAdmin) {
        if (deployAdmin == null) {
            return;
        }
        JDialog parentDialog = this._deployControl.getDialog();
        try {
            String line;
            parentDialog.setCursor(Cursor.getPredefinedCursor(3));
            String selectedPUName = ((JTextComponent)this.puNameComboBox.getEditor().getEditorComponent()).getText();
            boolean addFirstComboItem = true;
            if (!JSpaceUtilities.isEmpty((String)selectedPUName, (boolean)true)) {
                int itemsCount = this.puNameComboBox.getItemCount();
                for (int index = 0; index < itemsCount; ++index) {
                    if (!this.puNameComboBox.getItemAt(index).equals(selectedPUName)) continue;
                    addFirstComboItem = false;
                    break;
                }
            } else {
                addFirstComboItem = false;
            }
            this.puNameComboBox.removeAllItems();
            URL listPU = new URL(new URL(deployAdmin.getDeployURL()), "list-pu");
            BufferedReader reader = new BufferedReader(new InputStreamReader(listPU.openStream()));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                String puName = tokenizer.nextToken();
                this.puNameComboBox.addItem(puName);
            }
            if (!JSpaceUtilities.isEmpty((String)selectedPUName, (boolean)true)) {
                this.puNameComboBox.setSelectedItem(selectedPUName);
            }
            if (addFirstComboItem) {
                ((JTextComponent)this.puNameComboBox.getEditor().getEditorComponent()).setText(selectedPUName);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        finally {
            parentDialog.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public class FileChooserAddition
    extends JPanel {
        private JCheckBox checkBox;

        public FileChooserAddition(final JFileChooser fileChooser, boolean selectDirectoryOnly) {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox("<HTML>Select<BR>directory only</HTML>", selectDirectoryOnly);
            this.checkBox.setMnemonic('d');
            JPanel checkBoxPanel = new JPanel();
            checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
            checkBoxPanel.add(Box.createHorizontalStrut(5));
            checkBoxPanel.add(this.checkBox);
            Dimension dim = new Dimension(100, 40);
            checkBoxPanel.setPreferredSize(dim);
            checkBoxPanel.setMaximumSize(dim);
            this.add((Component)checkBoxPanel, "South");
            this.checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        fileChooser.setFileSelectionMode(1);
                        PUDeploymentPanel.this.jarFileChooser.removeChoosableFileFilter(PUDeploymentPanel.this.jarFilesFilter);
                    } else {
                        fileChooser.setFileSelectionMode(0);
                        PUDeploymentPanel.this.jarFileChooser.addChoosableFileFilter(PUDeploymentPanel.this.jarFilesFilter);
                    }
                }
            });
        }

        public void setCheckBoxEnabled(boolean enable) {
            this.checkBox.setEnabled(enable);
        }
    }
}

