/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy;

import com.gigaspaces.admin.ui.util.FilteredFileChooser;
import com.gigaspaces.grid.gsc.ui.PropertiesTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class PropertiesPanel
extends Box
implements ActionListener {
    private PropertiesTable propertiesTable = new PropertiesTable(true, new Color(230, 230, 230));
    private FilteredFileChooser propertiesFileChooser;
    private JButton _addPropertyButton;
    private JButton _removeProperyButton;
    private JButton _loadProps;
    private Component _parentComponent;
    private String _deployDir;
    private final Dimension buttonSize = new Dimension(24, 22);

    public PropertiesPanel(String deployDir) {
        super(1);
        this._deployDir = deployDir;
        Box buttonsBox = new Box(0);
        this._addPropertyButton = this.createAddRemoveButton("+");
        this._removeProperyButton = this.createAddRemoveButton("-");
        this._loadProps = new JButton("Load Properties ...");
        this._loadProps.addActionListener(this);
        this._addPropertyButton.addActionListener(this);
        this._removeProperyButton.addActionListener(this);
        this._loadProps.setToolTipText("Load Properties for the Space from a properties file");
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._addPropertyButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._removeProperyButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._loadProps);
        buttonsBox.add(Box.createHorizontalGlue());
        this.add((Component)this.propertiesTable);
        this.add(Box.createVerticalStrut(2));
        this.add(buttonsBox);
        this.setBorder(BorderFactory.createTitledBorder("Properties"));
    }

    private JButton createAddRemoveButton(String text) {
        JButton button = new JButton(text);
        button.setPreferredSize(this.buttonSize);
        button.setMinimumSize(this.buttonSize);
        return button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._loadProps) {
            File propsFile;
            if (this.propertiesFileChooser == null) {
                try {
                    if (this._parentComponent == null) {
                        this.initParentComponent();
                    }
                    this._parentComponent.setCursor(Cursor.getPredefinedCursor(3));
                    File deployDir = null;
                    if (this._deployDir != null) {
                        deployDir = new File(this._deployDir);
                    }
                    this.propertiesFileChooser = new FilteredFileChooser(this._parentComponent, deployDir, "Select Properties file", "Load", ".properties");
                }
                finally {
                    this._parentComponent.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if ((propsFile = this.propertiesFileChooser.getFile()) == null) {
                return;
            }
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propsFile.getCanonicalPath()));
                this.propertiesTable.setProperties(properties);
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        } else if (source == this._addPropertyButton) {
            this.propertiesTable.stopCellEditing();
            this.propertiesTable.addMapping("", "");
        } else if (source == this._removeProperyButton) {
            this.propertiesTable.stopCellEditing();
            this.propertiesTable.removeSelectedRow();
        }
    }

    private void initParentComponent() {
        this._parentComponent = SwingUtilities.getRoot(this);
    }

    public Properties getProperties() {
        return this.propertiesTable.getProperties();
    }

    public void clear() {
        this.propertiesTable.clearTable();
    }
}

