/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy.utils;

import com.gigaspaces.admin.ui.grid.deploy.utils.DeploymentHelper;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class ClusterDefinitionComponent
extends Box
implements ItemListener {
    private JTextField numInstancesTextField = new WholeNumberField(true, 1);
    private JTextField numBackupsTextField = new WholeNumberField(true, 0);
    private JComboBox clusterSchemasCombo;
    private final int componentHeight = 24;
    private final Dimension labelSize = new Dimension(150, 24);
    private JLabel clusterExplLabel1 = new JLabel("Cluster schema file:");
    private JLabel clusterExplLabel2 = new JLabel();
    private JTextField numInstancesPerVMTextField = new WholeNumberField(true, 1);
    private JTextField numInstancesPerMachineTextField = new WholeNumberField(true, 1);
    private final String _maxInstancesPerVMToolTip = "<HTML>When deploying a backup topology, the number of instances of the same partition<BR>that will be deployed on the same VM (value of 1 means that primary and<BR>backup for the same partition will not run on the same VM). When deploying<BR> a topology without backups, the number of instances (out of the total<BR>number of instances) that will be deployed on the same VM.</HTML>";
    private final String _maxInstancesPerMachineToolTip = "<HTML>When deploying a backup topology, the number of instances of the same<BR>partition that will be deployed on the same machine (regardless of the number<BR>of VMs running on the machine)  (value of 1 means that primary and backup for<BR>the same partition will not run on the same machine). When deploying a topology<BR>without backups, the number of instances (out of the total number of instances)<BR>that will be deployed on the same machine.</HTML>";
    private Component _parentComponent;
    private KeyListener _deployKeyListener;

    public ClusterDefinitionComponent(KeyListener deployKeyListener) {
        this(null, deployKeyListener);
    }

    public ClusterDefinitionComponent(String defaultSelectedClusterSchema, KeyListener deployKeyListener) {
        super(1);
        this._deployKeyListener = deployKeyListener;
        this.init(defaultSelectedClusterSchema);
    }

    private void init(String defaultSelectedClusterSchema) {
        this.numInstancesTextField.addKeyListener(this._deployKeyListener);
        this.numBackupsTextField.addKeyListener(this._deployKeyListener);
        this.numInstancesPerMachineTextField.addKeyListener(this._deployKeyListener);
        this.numInstancesPerVMTextField.addKeyListener(this._deployKeyListener);
        Dimension numTextFieldSize = new Dimension(32, 24);
        JLabel numInstancesLabel = new JLabel("Number of Instances:");
        this.numInstancesTextField.setPreferredSize(numTextFieldSize);
        this.numInstancesTextField.setMaximumSize(numTextFieldSize);
        numInstancesLabel.setPreferredSize(this.labelSize);
        numInstancesLabel.setMaximumSize(this.labelSize);
        numInstancesLabel.setMinimumSize(this.labelSize);
        JLabel numBackupsLabel = new JLabel("Backups:");
        this.numBackupsTextField.setPreferredSize(numTextFieldSize);
        this.numBackupsTextField.setMaximumSize(numTextFieldSize);
        Box numInstancesBox = new Box(0);
        numInstancesBox.add(Box.createHorizontalStrut(3));
        numInstancesBox.add(numInstancesLabel);
        numInstancesBox.add(this.numInstancesTextField);
        numInstancesBox.add(Box.createHorizontalStrut(22));
        numInstancesBox.add(numBackupsLabel);
        numInstancesBox.add(Box.createHorizontalStrut(24));
        numInstancesBox.add(this.numBackupsTextField);
        numInstancesBox.add(Box.createHorizontalGlue());
        this.numBackupsTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateExplanationLabelText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateExplanationLabelText();
            }

            private void updateExplanationLabelText() {
                if (ClusterDefinitionComponent.this.clusterSchemasCombo.getSelectedItem().equals("partitioned") && ClusterDefinitionComponent.this.numInstancesPerVMTextField.getText().trim().length() == 0) {
                    ClusterDefinitionComponent.this.numInstancesPerVMTextField.setText(String.valueOf(1));
                }
            }
        });
        JLabel clusterSchemasLabel = new JLabel("Cluster schema:");
        clusterSchemasLabel.setPreferredSize(this.labelSize);
        clusterSchemasLabel.setMaximumSize(this.labelSize);
        clusterSchemasLabel.setMinimumSize(this.labelSize);
        this.clusterSchemasCombo = new JComboBox<String>(DeploymentHelper.getAllClusterSchemas());
        this.clusterSchemasCombo.setPreferredSize(new Dimension(346, 24));
        this.clusterSchemasCombo.setMaximumSize(new Dimension(10, 24));
        Component comboBoxEditor = this.clusterSchemasCombo.getEditor().getEditorComponent();
        if (comboBoxEditor instanceof JTextComponent) {
            final JTextComponent comboBoxEditorTextField = (JTextComponent)comboBoxEditor;
            comboBoxEditorTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateExplanationLabelText();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateExplanationLabelText();
                }

                private void updateExplanationLabelText() {
                    String enteredClusterShemaName = comboBoxEditorTextField.getText();
                    if (enteredClusterShemaName.length() > 0) {
                        ClusterDefinitionComponent.this.clusterExplLabel1.setVisible(true);
                        ClusterDefinitionComponent.this.clusterExplLabel2.setVisible(true);
                        ClusterDefinitionComponent.this.clusterExplLabel2.setText(enteredClusterShemaName + "-cluster-schema.xsl");
                    } else {
                        ClusterDefinitionComponent.this.clusterExplLabel1.setVisible(false);
                        ClusterDefinitionComponent.this.clusterExplLabel2.setVisible(false);
                    }
                }
            });
        }
        Box clusterSchemasBox = new Box(0);
        clusterSchemasBox.add(Box.createHorizontalStrut(3));
        clusterSchemasBox.add(clusterSchemasLabel);
        clusterSchemasBox.add(this.clusterSchemasCombo);
        clusterSchemasBox.add(Box.createHorizontalGlue());
        this.clusterSchemasCombo.addItemListener(this);
        this.clusterExplLabel1.setPreferredSize(this.labelSize);
        this.clusterExplLabel1.setMaximumSize(this.labelSize);
        this.clusterExplLabel1.setMinimumSize(this.labelSize);
        Box explanationBox = new Box(0);
        explanationBox.add(Box.createHorizontalStrut(3));
        explanationBox.add(this.clusterExplLabel1);
        explanationBox.add(this.clusterExplLabel2);
        explanationBox.add(Box.createHorizontalGlue());
        this.clusterExplLabel2.setForeground(Color.BLUE);
        this.clusterExplLabel1.setVisible(false);
        this.clusterExplLabel2.setVisible(false);
        this.numBackupsTextField.setEditable(false);
        if (defaultSelectedClusterSchema != null) {
            this.clusterSchemasCombo.setSelectedItem(defaultSelectedClusterSchema);
        }
        JLabel maxInstancesPerVMLabel = new JLabel("Per VM:");
        JLabel maxInstancesPerMachineLabel = new JLabel("Per Machine:");
        Dimension labelSize2 = new Dimension(this.labelSize);
        labelSize2.width -= 5;
        maxInstancesPerVMLabel.setPreferredSize(labelSize2);
        maxInstancesPerVMLabel.setMaximumSize(labelSize2);
        maxInstancesPerVMLabel.setMinimumSize(labelSize2);
        this.numInstancesPerVMTextField.setToolTipText("<HTML>When deploying a backup topology, the number of instances of the same partition<BR>that will be deployed on the same VM (value of 1 means that primary and<BR>backup for the same partition will not run on the same VM). When deploying<BR> a topology without backups, the number of instances (out of the total<BR>number of instances) that will be deployed on the same VM.</HTML>");
        maxInstancesPerVMLabel.setToolTipText("<HTML>When deploying a backup topology, the number of instances of the same partition<BR>that will be deployed on the same VM (value of 1 means that primary and<BR>backup for the same partition will not run on the same VM). When deploying<BR> a topology without backups, the number of instances (out of the total<BR>number of instances) that will be deployed on the same VM.</HTML>");
        this.numInstancesPerMachineTextField.setToolTipText("<HTML>When deploying a backup topology, the number of instances of the same<BR>partition that will be deployed on the same machine (regardless of the number<BR>of VMs running on the machine)  (value of 1 means that primary and backup for<BR>the same partition will not run on the same machine). When deploying a topology<BR>without backups, the number of instances (out of the total number of instances)<BR>that will be deployed on the same machine.</HTML>");
        maxInstancesPerMachineLabel.setToolTipText("<HTML>When deploying a backup topology, the number of instances of the same<BR>partition that will be deployed on the same machine (regardless of the number<BR>of VMs running on the machine)  (value of 1 means that primary and backup for<BR>the same partition will not run on the same machine). When deploying a topology<BR>without backups, the number of instances (out of the total number of instances)<BR>that will be deployed on the same machine.</HTML>");
        this.numInstancesPerVMTextField.setPreferredSize(numTextFieldSize);
        this.numInstancesPerVMTextField.setMaximumSize(numTextFieldSize);
        this.numInstancesPerMachineTextField.setPreferredSize(numTextFieldSize);
        this.numInstancesPerMachineTextField.setMaximumSize(numTextFieldSize);
        Box maxInstancesBox = new Box(0);
        maxInstancesBox.add(Box.createHorizontalStrut(3));
        maxInstancesBox.add(maxInstancesPerVMLabel);
        maxInstancesBox.add(this.numInstancesPerVMTextField);
        maxInstancesBox.add(Box.createHorizontalStrut(22));
        maxInstancesBox.add(maxInstancesPerMachineLabel);
        maxInstancesBox.add(Box.createHorizontalStrut(5));
        maxInstancesBox.add(this.numInstancesPerMachineTextField);
        maxInstancesBox.add(Box.createHorizontalGlue());
        maxInstancesBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Maximum Instances"), BorderFactory.createEmptyBorder(0, 0, 3, 0)));
        this.add(Box.createVerticalStrut(3));
        this.add(clusterSchemasBox);
        this.add(Box.createVerticalStrut(4));
        this.add(numInstancesBox);
        this.add(Box.createVerticalStrut(3));
        this.add(explanationBox);
        this.add(Box.createVerticalStrut(4));
        this.add(maxInstancesBox);
        this.add(Box.createVerticalStrut(1));
        this.setBorder(BorderFactory.createTitledBorder("Cluster Info"));
    }

    public boolean validateEntries() {
        String numOfInstancesStr = this.numInstancesTextField.getText();
        int numInstancesTextLength = numOfInstancesStr.length();
        String clusterSchemaName = this.getClusterSchemaName();
        if (!JSpaceUtilities.isEmpty((String)clusterSchemaName, (boolean)true)) {
            if (numInstancesTextLength == 0) {
                this.showWarning("When providing cluster schema number of instances/backups must be provided as well.");
                return false;
            }
            if (Integer.parseInt(numOfInstancesStr) < 2 && this.numBackupsTextField.getText().trim().length() == 0) {
                this.showWarning("When providing cluster schema without backup members number of instances must be greater than 1.");
                return false;
            }
        }
        int backupsAmount = 0;
        if (this.getNumberOfBackupClusterInstances().trim().length() > 0) {
            backupsAmount = Integer.parseInt(this.getNumberOfBackupClusterInstances());
        }
        if (numInstancesTextLength == 0 && backupsAmount > 0) {
            this.showWarning("When providing number of backups, number of instances must be provided as well.");
            return false;
        }
        return true;
    }

    private void showWarning(String message) {
        if (this._parentComponent == null) {
            this.initParentComponent();
        }
        JOptionPane.showMessageDialog(this._parentComponent, message, "Processing Unit Application Deployment Error", 2);
    }

    private void initParentComponent() {
        this._parentComponent = SwingUtilities.getRoot(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.clusterSchemasCombo && e.getStateChange() == 1) {
            boolean isNoneItemSelected;
            Object selItem = e.getItem();
            this.clusterSchemasCombo.setEditable(!DeploymentHelper.ALL_CLUSTER_SCHEMAS_SET.contains(selItem));
            this.setBackupOptionEnabled(selItem.equals("partitioned") || !DeploymentHelper.ALL_CLUSTER_SCHEMAS_SET.contains(selItem));
            if (!selItem.equals("partitioned") || !DeploymentHelper.ALL_CLUSTER_SCHEMAS_SET.contains(selItem)) {
                this.numBackupsTextField.setText("");
            }
            this.clusterExplLabel1.setVisible(!(isNoneItemSelected = selItem.equals("<None>")));
            this.clusterExplLabel2.setVisible(!isNoneItemSelected);
            if (!isNoneItemSelected) {
                this.clusterExplLabel2.setText(selItem + "-cluster-schema.xsl");
            } else {
                this.clusterExplLabel2.setText("");
            }
        }
    }

    public String getClusterSchemaName() {
        String selectedClusterSchema = (String)this.clusterSchemasCombo.getSelectedItem();
        if (selectedClusterSchema.equals("<None>")) {
            selectedClusterSchema = "";
        }
        return selectedClusterSchema;
    }

    public String getNumberOfClusterInstances() {
        return this.numInstancesTextField.getText();
    }

    private void setBackupOptionEnabled(boolean enabled) {
        this.numBackupsTextField.setEditable(enabled);
    }

    public String getNumberOfBackupClusterInstances() {
        if (this.numBackupsTextField.isEditable()) {
            return this.numBackupsTextField.getText();
        }
        return "";
    }

    public String getMaximumInstancesPerVM() {
        if (this.numInstancesPerVMTextField.getText().trim().length() == 0) {
            return null;
        }
        return this.numInstancesPerVMTextField.getText();
    }

    public String getMaximumInstancesPerMachine() {
        if (this.numInstancesPerMachineTextField.getText().trim().length() == 0) {
            return null;
        }
        return this.numInstancesPerMachineTextField.getText();
    }
}

