/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy.zone;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstances;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstancesTableModel;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZonesActionsMediator;
import com.gigaspaces.admin.ui.grid.deploy.zone.events.ZoneSelectionChangedEvent;
import com.gigaspaces.admin.ui.grid.deploy.zone.events.ZoneSelectionChangedListener;
import com.j_spaces.tools.spacebrowser.WholeNumberField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ZoneInstancesPanel
extends Box
implements ActionListener,
ZoneSelectionChangedListener {
    private JTable _zonesInstancesTable;
    private ZoneInstancesTableModel _zonesInstancesTableModel;
    private JButton _addZoneButton;
    private JButton _deleteZoneButton;
    private final Dimension buttonSize = new Dimension(24, 24);
    private static final int MAX_INSTANCES_PER_ZONE = 1000;
    private JComboBox _zonesComboBox;

    public ZoneInstancesPanel(ZonesActionsMediator zonesActionsMediator) {
        super(1);
        this.init();
        this.setBorder(BorderFactory.createTitledBorder("Max. instances(partitions) number"));
        zonesActionsMediator.addZoneSelectionChangeListener(this);
    }

    private void init() {
        this._zonesInstancesTableModel = new ZoneInstancesTableModel();
        this._zonesInstancesTable = new JTable(this._zonesInstancesTableModel);
        this.setTableProperties(this._zonesInstancesTable);
        this._zonesInstancesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ZoneInstancesPanel.this.handleDeleteButtonState();
            }
        });
        this._zonesInstancesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ZoneInstancesPanel.this.deleteSelectedRows();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._zonesInstancesTable);
        this._addZoneButton = this.createAddRemoveButton("+", "Add zone");
        this._deleteZoneButton = this.createAddRemoveButton("-", "Remove selected zone");
        this._addZoneButton.addActionListener(this);
        this._deleteZoneButton.addActionListener(this);
        this._deleteZoneButton.setEnabled(false);
        this._addZoneButton.setEnabled(false);
        Box buttonsBox = new Box(0);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._addZoneButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        buttonsBox.add(this._deleteZoneButton);
        buttonsBox.add(Box.createHorizontalGlue());
        this.add(scrollPane);
        this.add(Box.createVerticalStrut(1));
        this.add(buttonsBox);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._addZoneButton)) {
            if (this.stopCellEditing()) {
                String firstZone = (String)this._zonesComboBox.getModel().getElementAt(0);
                int defaultMaxInstancesPerZone = 1;
                ZoneInstances zoneInstances = new ZoneInstances(firstZone, defaultMaxInstancesPerZone);
                this._zonesInstancesTableModel.addZoneInstances(zoneInstances);
            }
        } else if (source.equals(this._deleteZoneButton)) {
            this.deleteSelectedRows();
        }
    }

    public List<ZoneInstances> getZoneInstances() {
        this.stopCellEditing();
        return this._zonesInstancesTableModel.getZoneInstances();
    }

    private void deleteSelectedRows() {
        if (!this.stopCellEditing()) {
            return;
        }
        int[] selRows = this._zonesInstancesTable.getSelectedRows();
        if (selRows.length > 0) {
            this._zonesInstancesTableModel.removeZoneInstanceAt(selRows);
            if (this._zonesInstancesTable.getRowCount() > 0) {
                int minRow = selRows[0];
                int selRow = minRow == 0 ? 0 : minRow - 1;
                this._zonesInstancesTable.setRowSelectionInterval(selRow, selRow);
            }
        }
    }

    private boolean stopCellEditing() {
        JTextField textEditor;
        String minInstancesNum;
        int editingColumn = this._zonesInstancesTable.getEditingColumn();
        TableCellEditor cellEditor = this._zonesInstancesTable.getCellEditor();
        if (editingColumn == 1 && cellEditor != null && !this.isZoneInstanceInfoValid(minInstancesNum = (textEditor = (JTextField)((DefaultCellEditor)cellEditor).getComponent()).getText())) {
            return false;
        }
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return true;
    }

    private boolean isZoneInstanceInfoValid(String instancesNum) {
        return true;
    }

    private void handleDeleteButtonState() {
        this._deleteZoneButton.setEnabled(this._zonesInstancesTable.getSelectedRows().length > 0);
    }

    private JButton createAddRemoveButton(String text, String tooltip) {
        JButton button = new JButton(text);
        button.setPreferredSize(this.buttonSize);
        button.setMinimumSize(this.buttonSize);
        button.setToolTipText(tooltip);
        return button;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 3);
        TableColumnModel tableColumnModel = table.getColumnModel();
        int columnWidth = 60;
        TableColumn zonesColumn = tableColumnModel.getColumn(0);
        TableColumn instancesNumberColumn = tableColumnModel.getColumn(1);
        instancesNumberColumn.setCellEditor(new DefaultCellEditor(new WholeNumberField(true, 0, 1000)));
        Set<String> zones = this.getAvailableZones();
        this._zonesComboBox = new JComboBox<String>(zones.toArray(new String[zones.size()]));
        zonesColumn.setCellEditor(new DefaultCellEditor(this._zonesComboBox));
        this._zonesComboBox.setRenderer(new BasicComboBoxRenderer());
        instancesNumberColumn.setPreferredWidth(60);
        instancesNumberColumn.setMaxWidth(60);
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private Set<String> getAvailableZones() {
        Set<String> allZones = Repository.getInstance().getAllZones();
        allZones.remove("<No Zone>");
        return allZones;
    }

    private void addZone(String zone) {
        ((DefaultComboBoxModel)this._zonesComboBox.getModel()).insertElementAt(zone, 0);
        this.setAddZoneButtonsEnabled(true);
    }

    private void removeZone(String zone) {
        ((DefaultComboBoxModel)this._zonesComboBox.getModel()).removeElement(zone);
        this._zonesInstancesTableModel.removeZone(zone);
        this.setAddZoneButtonsEnabled(this._zonesComboBox.getModel().getSize() > 0);
    }

    public void setDisplayedZones(Set<String> zones) {
        this.stopCellEditing();
        ((DefaultComboBoxModel)this._zonesComboBox.getModel()).removeAllElements();
        for (String zone : zones) {
            ((DefaultComboBoxModel)this._zonesComboBox.getModel()).addElement(zone);
        }
        this._zonesInstancesTableModel.setDisplayedZones(zones);
        this._addZoneButton.setEnabled(!zones.isEmpty());
    }

    public void displayAllZonesForSelection() {
        this.stopCellEditing();
        ((DefaultComboBoxModel)this._zonesComboBox.getModel()).removeAllElements();
        Set<String> zones = this.getAvailableZones();
        for (String zone : zones) {
            ((DefaultComboBoxModel)this._zonesComboBox.getModel()).addElement(zone);
        }
        this.setAddZoneButtonsEnabled(!zones.isEmpty());
    }

    private void setAddZoneButtonsEnabled(boolean enabled) {
        this._addZoneButton.setEnabled(enabled);
    }

    @Override
    public void zoneSelectionChanged(ZoneSelectionChangedEvent zoneSelectionChangedEvent) {
        boolean isSelected = zoneSelectionChangedEvent.isSelected();
        String zone = zoneSelectionChangedEvent.getZone();
        if (isSelected) {
            this.addZone(zone);
        } else {
            this.removeZone(zone);
        }
    }
}

