/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy.zone;

import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstances;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;

public class ZoneInstancesTableModel
extends DefaultTableModel {
    private final String CN_ZONES = "Zone";
    private final String CN_INSTANCES_NUMBER = "Amount";
    public static final int CI_ZONES = 0;
    public static final int CI_INSTANCES_NUMBER = 1;
    protected String[] columnNames;
    private final List<ZoneInstances> _curZoneInstancesList = new ArrayList<ZoneInstances>();

    public ZoneInstancesTableModel() {
        this.initColumnNames();
    }

    public void addZoneInstances(ZoneInstances zoneInstances) {
        this._curZoneInstancesList.add(zoneInstances);
        int newListSize = this._curZoneInstancesList.size();
        this.fireTableRowsInserted(newListSize - 1, newListSize - 1);
    }

    protected void initColumnNames() {
        this.columnNames = new String[2];
        this.columnNames[0] = "Zone";
        this.columnNames[1] = "Amount";
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row >= this._curZoneInstancesList.size()) {
            return;
        }
        ZoneInstances zoneInstances = this._curZoneInstancesList.get(row);
        switch (column) {
            case 0: {
                String zone = (String)aValue;
                zoneInstances.setZone(zone);
                break;
            }
            case 1: {
                String str = aValue.toString();
                if (str.length() <= 0) break;
                int maxInstancesNum = Integer.parseInt(str);
                zoneInstances.setMaxInstancesNum(maxInstancesNum);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ZoneInstances zoneInstances;
        if (row >= 0 && row < this._curZoneInstancesList.size() && (zoneInstances = this._curZoneInstancesList.get(row)) != null) {
            return this.getCellValue(zoneInstances, column);
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._curZoneInstancesList == null ? 0 : this._curZoneInstancesList.size();
    }

    private Object getCellValue(ZoneInstances zoneInstances, int column) {
        switch (column) {
            case 0: {
                return zoneInstances.getZone();
            }
            case 1: {
                return zoneInstances.getMaxInstancesNum();
            }
        }
        return "";
    }

    public List<ZoneInstances> getZoneInstances() {
        return this._curZoneInstancesList;
    }

    public void removeZoneInstanceAt(int ... rows) {
        for (int index = rows.length - 1; index >= 0; --index) {
            this._curZoneInstancesList.remove(rows[index]);
        }
        this.fireTableDataChanged();
    }

    public void clear() {
        int curRowCount = this._curZoneInstancesList.size();
        if (curRowCount > 0) {
            this.fireTableRowsDeleted(0, curRowCount - 1);
        }
        this._curZoneInstancesList.clear();
    }

    public void removeZone(String zone) {
        int listSize = this._curZoneInstancesList.size();
        for (int index = listSize - 1; index >= 0; --index) {
            ZoneInstances zoneInstances = this._curZoneInstancesList.get(index);
            String zoneName = zoneInstances.getZone();
            if (!zone.equals(zoneName)) continue;
            this._curZoneInstancesList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void setDisplayedZones(Set<String> zonesSet) {
        int listSize = this._curZoneInstancesList.size();
        for (int index = listSize - 1; index >= 0; --index) {
            ZoneInstances zoneInstances = this._curZoneInstancesList.get(index);
            String zoneName = zoneInstances.getZone();
            if (zonesSet.contains(zoneName)) continue;
            this._curZoneInstancesList.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

