/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy.zone;

import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstances;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneInstancesPanel;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZonesActionsMediator;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZonesSelectionPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ZonesDefinitionPanel
extends Box
implements ActionListener {
    private ZonesSelectionPanel _zonesSelectionPanel;
    private ZoneInstancesPanel _zoneInstancesPanel;
    private JRadioButton _specificZoneRB;
    private JRadioButton _anyZoneRB;

    public ZonesDefinitionPanel() {
        super(0);
        this.init();
    }

    private void init() {
        ZonesActionsMediator zonesActionsMediator = new ZonesActionsMediator();
        this._zonesSelectionPanel = new ZonesSelectionPanel(zonesActionsMediator);
        this._zoneInstancesPanel = new ZoneInstancesPanel(zonesActionsMediator);
        this.initRadioButtons();
        Box specificZoneRbBox = new Box(0);
        specificZoneRbBox.add(Box.createHorizontalStrut(4));
        specificZoneRbBox.add(this._specificZoneRB);
        specificZoneRbBox.add(Box.createHorizontalGlue());
        Box anyZoneRbBox = new Box(0);
        anyZoneRbBox.add(Box.createHorizontalStrut(4));
        anyZoneRbBox.add(this._anyZoneRB);
        anyZoneRbBox.add(Box.createHorizontalGlue());
        Box zonesSelectionBox = new Box(0);
        zonesSelectionBox.add(Box.createHorizontalStrut(18));
        zonesSelectionBox.add(this._zonesSelectionPanel);
        zonesSelectionBox.add(Box.createHorizontalStrut(3));
        Box zonesBox = new Box(1);
        zonesBox.add(specificZoneRbBox);
        zonesBox.add(Box.createVerticalStrut(3));
        zonesBox.add(zonesSelectionBox);
        zonesBox.add(Box.createVerticalStrut(3));
        zonesBox.add(anyZoneRbBox);
        Box maxInstancesPerZoneBox = new Box(1);
        maxInstancesPerZoneBox.add(this._zoneInstancesPanel);
        this.add(zonesBox);
        this.add(maxInstancesPerZoneBox);
        this._zoneInstancesPanel.setDisplayedZones(Collections.EMPTY_SET);
    }

    private void initRadioButtons() {
        this._specificZoneRB = new JRadioButton("Select zone", true);
        this._anyZoneRB = new JRadioButton("Any zone", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._specificZoneRB);
        buttonGroup.add(this._anyZoneRB);
        this._specificZoneRB.addActionListener(this);
        this._anyZoneRB.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this._specificZoneRB)) {
            this._zonesSelectionPanel.setAllSelectionsEnabled(true);
            Set<String> selectedZones = this._zonesSelectionPanel.getSelectedZones();
            this._zoneInstancesPanel.setDisplayedZones(selectedZones);
        } else if (source.equals(this._anyZoneRB)) {
            this._zonesSelectionPanel.setAllSelectionsEnabled(false);
            this._zoneInstancesPanel.displayAllZonesForSelection();
        }
    }

    public List<ZoneInstances> getZoneInstances() {
        return this._zoneInstancesPanel.getZoneInstances();
    }

    public Set<String> getSelectedZones() {
        return this._zonesSelectionPanel.getSelectedZones();
    }
}

