/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy.zone;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneSelection;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZonesActionsMediator;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZonesSelectionTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ZonesSelectionPanel
extends Box {
    private JTable _zonesSelectionTable;
    private ZonesSelectionTableModel _zonesSelectionTableModel;
    private final Dimension buttonSize = new Dimension(24, 24);
    private Color defaultTableBackground;
    private Color defaultTableHeaderBackground;
    private Color defaultTableForeground;
    private Color defaultTableHeaderForeground;
    private final ZonesActionsMediator _zonesActionsMediator;

    public ZonesSelectionPanel(ZonesActionsMediator zonesActionsMediator) {
        super(1);
        this._zonesActionsMediator = zonesActionsMediator;
        this.init();
    }

    private void init() {
        this._zonesSelectionTableModel = new ZonesSelectionTableModel(this._zonesActionsMediator);
        this._zonesSelectionTable = new JTable(this._zonesSelectionTableModel);
        this.setTableProperties(this._zonesSelectionTable);
        this._zonesSelectionTableModel.setZones(this.getAvailableZones());
        JScrollPane scrollPane = new JScrollPane(this._zonesSelectionTable);
        this.add(scrollPane);
    }

    public Set<String> getSelectedZones() {
        if (!this.isEnabled()) {
            return Collections.EMPTY_SET;
        }
        this.stopCellEditing();
        List<ZoneSelection> zonesSelections = this._zonesSelectionTableModel.getZonesSelections();
        HashSet<String> retValue = new HashSet<String>();
        for (ZoneSelection zoneSelection : zonesSelections) {
            if (!zoneSelection.isSelected()) continue;
            retValue.add(zoneSelection.getZone());
        }
        return retValue;
    }

    private boolean stopCellEditing() {
        TableCellEditor cellEditor = this._zonesSelectionTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return true;
    }

    private void setTableProperties(JTable table) {
        JTableHeader header = table.getTableHeader();
        header.setReorderingAllowed(false);
        this.defaultTableBackground = table.getBackground();
        this.defaultTableHeaderBackground = header.getBackground();
        this.defaultTableForeground = table.getForeground();
        this.defaultTableHeaderForeground = header.getForeground();
        table.setRowHeight(table.getRowHeight() + 3);
        TableColumnModel tableColumnModel = table.getColumnModel();
        int columnWidth = 45;
        TableColumn selectColumn = tableColumnModel.getColumn(0);
        TableColumn zoneColumn = tableColumnModel.getColumn(1);
        selectColumn.setPreferredWidth(45);
        selectColumn.setMaxWidth(45);
        table.setAutoCreateColumnsFromModel(false);
        table.setAutoResizeMode(1);
        table.setAutoscrolls(true);
    }

    private Set<String> getAvailableZones() {
        Set<String> allZones = Repository.getInstance().getAllZones();
        allZones.remove("<No Zone>");
        return allZones;
    }

    public void setAllSelectionsEnabled(boolean enabled) {
        this.setEnabled(enabled);
        this._zonesSelectionTable.setEnabled(enabled);
        JComponent transparentBlockingPanel = new JComponent(){};
        transparentBlockingPanel.setOpaque(true);
        this.add(transparentBlockingPanel);
        this._zonesSelectionTable.clearSelection();
        if (enabled) {
            this._zonesSelectionTable.setForeground(this.defaultTableForeground);
            this._zonesSelectionTable.getTableHeader().setForeground(this.defaultTableHeaderForeground);
        } else {
            this._zonesSelectionTable.setForeground(SystemColor.lightGray);
            this._zonesSelectionTable.getTableHeader().setForeground(SystemColor.lightGray);
        }
    }
}

