/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.deploy.zone;

import com.gigaspaces.admin.ui.grid.deploy.zone.ZoneSelection;
import com.gigaspaces.admin.ui.grid.deploy.zone.ZonesActionsMediator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;

public class ZonesSelectionTableModel
extends DefaultTableModel {
    private final String CN_SELECT = "Select";
    private final String CN_ZONE = "Zone";
    public static final int CI_SELECT = 0;
    public static final int CI_ZONE = 1;
    protected String[] columnNames;
    private final ZonesActionsMediator _zonesActionsMediator;
    private final List<ZoneSelection> _curZonesSelectionList = new ArrayList<ZoneSelection>();

    public ZonesSelectionTableModel(ZonesActionsMediator zonesActionsMediator) {
        this._zonesActionsMediator = zonesActionsMediator;
        this.initColumnNames();
    }

    protected void initColumnNames() {
        this.columnNames = new String[2];
        this.columnNames[0] = "Select";
        this.columnNames[1] = "Zone";
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row >= this._curZonesSelectionList.size()) {
            return;
        }
        switch (column) {
            case 0: {
                ZoneSelection zoneSelection = this._curZonesSelectionList.get(row);
                Boolean selected = (Boolean)aValue;
                zoneSelection.setSelected(selected);
                this._zonesActionsMediator.fireZoneSelectionChanged(this, zoneSelection.getZone(), selected);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean editable;
        switch (column) {
            case 0: {
                editable = true;
                break;
            }
            default: {
                editable = false;
            }
        }
        return editable;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ZoneSelection zoneSelection;
        if (row >= 0 && row < this._curZonesSelectionList.size() && (zoneSelection = this._curZonesSelectionList.get(row)) != null) {
            return this.getCellValue(zoneSelection, column);
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int columnIndex) {
        Object obj = this.getValueAt(0, columnIndex);
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._curZonesSelectionList == null ? 0 : this._curZonesSelectionList.size();
    }

    private Object getCellValue(ZoneSelection zoneSelection, int column) {
        switch (column) {
            case 0: {
                return zoneSelection.isSelected();
            }
            case 1: {
                return zoneSelection.getZone();
            }
        }
        return "";
    }

    public List<ZoneSelection> getZonesSelections() {
        return this._curZonesSelectionList;
    }

    public void clear() {
        int curRowCount = this._curZonesSelectionList.size();
        if (curRowCount > 0) {
            this.fireTableRowsDeleted(0, curRowCount - 1);
        }
        this._curZonesSelectionList.clear();
    }

    public void setZones(Set<String> zones) {
        for (String zone : zones) {
            this._curZonesSelectionList.add(new ZoneSelection(zone));
        }
        this.fireTableRowsInserted(0, zones.size() - 1);
    }
}

