/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.IServiceGridUIComponent;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.GSCPanel;
import com.gigaspaces.admin.ui.grid.utils.DeploymentActionsManager;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jini.config.Configuration;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class GSCMonitorPanel
extends JPanel
implements IServiceGridUIComponent,
ChangeListener {
    private GSCPanel gscPanel;
    private MainUI mainUI;
    private JSlider resizingSlider;
    private static final int MIN_SIZE = 10;
    private static final int MAX_SIZE = 70;
    private static int CUR_SIZE = 26;

    public GSCMonitorPanel(MainUI mainUI, Configuration config) {
        this.mainUI = mainUI;
        this.setLayout(new BorderLayout());
        this.gscPanel = new GSCPanel(mainUI, config);
        Repository.getInstance().setGSCPanel(this.gscPanel);
        this.createSlider();
        Box sliderBox = new Box(0);
        sliderBox.add(Box.createHorizontalStrut(3));
        sliderBox.add(new JLabel(IconsRepository.getInstance().getIcon(203)));
        sliderBox.add(Box.createHorizontalStrut(3));
        sliderBox.add(this.resizingSlider);
        sliderBox.add(Box.createHorizontalStrut(3));
        sliderBox.add(new JLabel(IconsRepository.getInstance().getIcon(202)));
        this.add((Component)sliderBox, "North");
        this.add((Component)this.gscPanel, "Center");
    }

    private void createSlider() {
        this.resizingSlider = new JSlider(0, 10, 70, CUR_SIZE);
        this.resizingSlider.setToolTipText("Resize hosts");
        this.resizingSlider.addChangeListener(this);
        this.resizingSlider.setMajorTickSpacing(10);
        this.resizingSlider.setMinorTickSpacing(2);
        this.resizingSlider.setPaintTicks(true);
        Dimension sliderSize = new Dimension(300, 30);
        this.resizingSlider.setPreferredSize(sliderSize);
        this.resizingSlider.setMaximumSize(sliderSize);
        this.resizingSlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() > 0) {
                    GSCMonitorPanel.this.resizingSlider.setValue(GSCMonitorPanel.this.resizingSlider.getValue() + 1);
                } else {
                    GSCMonitorPanel.this.resizingSlider.setValue(GSCMonitorPanel.this.resizingSlider.getValue() - 1);
                }
            }
        });
    }

    public void addService(ServiceItem serviceItem) {
        this.gscPanel.addService(serviceItem);
    }

    public void update(ServiceID removedServiceID) {
        this.gscPanel.update(removedServiceID);
    }

    public void change(ServiceItem serviceItem) {
        this.gscPanel.change(serviceItem);
    }

    public void remove(ServiceItem serviceItem) {
        this.gscPanel.remove(serviceItem);
    }

    public List<ServiceItem> getGSCItemsList() {
        return this.gscPanel.getGSCItemsList();
    }

    public GSCPanel getGSCPanel() {
        return this.gscPanel;
    }

    @Override
    public void closeServices() {
    }

    @Override
    public String getComponentName() {
        return "Monitoring";
    }

    @Override
    public String getComponentToolTip() {
        return "Monitoring";
    }

    @Override
    public JMenu[] getMenus() {
        return DeploymentActionsManager.getInstance(this.mainUI).getMenusMonitoringView();
    }

    @Override
    public JLabel getStatusBar() {
        return this.mainUI.getUIComponent().getStatusBar();
    }

    @Override
    public JButton[] getToolBarButtons() {
        return DeploymentActionsManager.getInstance(this.mainUI).getToolBarButtonsMonitoringView();
    }

    @Override
    public void resetInternalWindows() {
    }

    public static int getCurrentHostViewSize() {
        return 10 * CUR_SIZE;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int size;
            CUR_SIZE = size = source.getValue();
            Dimension newSize = new Dimension(10 * size, 10 * size);
            this.gscPanel.resizeHostComponents(newSize);
        }
    }
}

