/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.HostGSCsComponent;
import com.gigaspaces.admin.ui.grid.gsc.ServiceRelocationHelper;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.os.OSDetails;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.jini.config.Configuration;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;

public class GSCPanel
extends JPanel {
    private JPanel _miniGSCsPanel;
    private JPanel _detailsPanel;
    private JScrollPane _detailsScrollPane;
    private ServiceRelocationHelper serviceRelocator;
    private MainUI parentFrame;
    private JScrollPane _miniGSCsScrollPane;
    private Map<String, HostDisplayDetails> _hostsDisplayComponentsMap = new HashMap<String, HostDisplayDetails>();
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public GSCPanel(MainUI parentFrame, Configuration config) {
        super(new BorderLayout(8, 8));
        this.parentFrame = parentFrame;
        this.serviceRelocator = new ServiceRelocationHelper(parentFrame, config);
        this._miniGSCsPanel = new JPanel();
        this._miniGSCsPanel.setLayout(new FlowLayout(0, 10, 10));
        this._miniGSCsScrollPane = new JScrollPane(this._miniGSCsPanel);
        Dimension scrollPanelSize = new Dimension(1000, 200);
        this._miniGSCsScrollPane.setPreferredSize(scrollPanelSize);
        this._miniGSCsScrollPane.setMaximumSize(scrollPanelSize);
        this._miniGSCsScrollPane.setBorder(null);
        Box westTopBox = new Box(0);
        westTopBox.add(Box.createHorizontalStrut(3));
        westTopBox.add(this._miniGSCsScrollPane);
        this._detailsPanel = new JPanel();
        this._detailsPanel.setLayout(new FlowLayout(0, 10, 10));
        this._detailsScrollPane = new JScrollPane(this._detailsPanel);
        this._detailsPanel.setMinimumSize(new Dimension(250, 250));
        this._detailsPanel.setPreferredSize(new Dimension(700, 5000));
        this._detailsPanel.setMaximumSize(new Dimension(700, 5200));
        this._detailsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        Dimension boxSize = new Dimension(1000, 68);
        westTopBox.setPreferredSize(boxSize);
        westTopBox.setMaximumSize(boxSize);
        westTopBox.setMinimumSize(new Dimension(100, 68));
        this.add((Component)this._detailsScrollPane, "Center");
        this.add((Component)westTopBox, "South");
    }

    public ServiceRelocationHelper getServiceRelocator() {
        return this.serviceRelocator;
    }

    public String getGscOwnerName(ServiceID puInstanceID) {
        String gscName = "";
        for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
            HostGSCsComponent hostGSCsComponent = hostDisplayDetails.getHostGSCsComponent();
            String name = hostGSCsComponent.getGscOwnerName(puInstanceID);
            if (name == null) continue;
            gscName = name;
            break;
        }
        return gscName;
    }

    public ServiceID getGscOwnerServiceD(ServiceID puInstanceID) {
        ServiceID gscServiceID = null;
        for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
            HostGSCsComponent hostGSCsComponent = hostDisplayDetails.getHostGSCsComponent();
            ServiceID serviceID = hostGSCsComponent.getGscOwnerServiceID(puInstanceID);
            if (serviceID == null) continue;
            gscServiceID = serviceID;
            break;
        }
        return gscServiceID;
    }

    void refresh() {
        this._miniGSCsPanel.revalidate();
        this._miniGSCsPanel.repaint();
        this._detailsPanel.revalidate();
        this._detailsPanel.repaint();
        ArrayList<HostDisplayDetails> hostsList = new ArrayList<HostDisplayDetails>(this._hostsDisplayComponentsMap.values());
        for (HostDisplayDetails hostDisplayDetails : hostsList) {
            HostGSCsComponent hostGSCsComponent = hostDisplayDetails.getHostGSCsComponent();
            hostGSCsComponent.revalidate();
            hostGSCsComponent.repaint();
        }
        this.invalidate();
        this.getParent().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addService(ServiceItem item) {
        OSDetails osDetails = Repository.getInstance().getOSDetails(item, true);
        if (osDetails != null) {
            String hostName = osDetails.getHostName();
            String hostAddress = osDetails.getHostAddress();
            HostDisplayDetails hostDisplayDetails = this._hostsDisplayComponentsMap.get(hostAddress);
            if (hostDisplayDetails == null) {
                HostGSCsComponent hostGSCComponent = new HostGSCsComponent(this.parentFrame, this, osDetails);
                JPanel gscMiniPanel = this.createMiniCyberPanel(hostGSCComponent, hostName, hostAddress);
                hostDisplayDetails = new HostDisplayDetails(gscMiniPanel, hostGSCComponent);
                this.addGSCToUI(hostDisplayDetails);
                Map<String, HostDisplayDetails> map = this._hostsDisplayComponentsMap;
                synchronized (map) {
                    this._hostsDisplayComponentsMap.put(hostAddress, hostDisplayDetails);
                }
            }
            hostDisplayDetails.getHostGSCsComponent().addService(item);
            this.refresh();
        }
    }

    public synchronized void addGSCToUI(HostDisplayDetails hostDisplayDetails) {
        HostGSCsComponent hostComponent = hostDisplayDetails.getHostGSCsComponent();
        JPanel gscMiniPanel = hostDisplayDetails.getGscMiniPanel();
        this._miniGSCsPanel.add(gscMiniPanel);
        if (!(hostComponent.getParent() != null && hostComponent.getParent().equals(this._detailsPanel) || hostComponent.isManuallyRemovedFromPanel())) {
            hostComponent.reloadServices();
            this._detailsPanel.add(hostComponent);
        }
    }

    private JPanel createMiniCyberPanel(HostGSCsComponent hostComponent, String hostName, String hostIP) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ImageIcon serverIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/pc_on_network.gif");
        JLabel imageLabel = new JLabel(serverIcon);
        imageLabel.setPreferredSize(new Dimension(22, 22));
        imageLabel.setMaximumSize(new Dimension(22, 22));
        imageLabel.setAlignmentX(0.5f);
        imageLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        imageLabel.addMouseListener(new GSCSelector(hostComponent, imageLabel));
        imageLabel.setToolTipText(hostIP);
        panel.add(imageLabel);
        JLabel label = new JLabel(hostName);
        label.setAlignmentX(0.5f);
        panel.add(label);
        return panel;
    }

    public int getGSCCount() {
        int count = 0;
        for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
            count += hostDisplayDetails.getHostGSCsComponent().getGSCCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceItem> getGSCItemsList() {
        ArrayList<ServiceItem> gscList = new ArrayList<ServiceItem>();
        Map<String, HostDisplayDetails> map = this._hostsDisplayComponentsMap;
        synchronized (map) {
            for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
                gscList.addAll(hostDisplayDetails.getHostGSCsComponent().getGSCItemsList());
            }
        }
        return gscList;
    }

    public void change(ServiceItem item) {
    }

    public void update(String hostAddress, ServiceID removedServiceID) {
        HostDisplayDetails hostDisplayDetails = this._hostsDisplayComponentsMap.get(hostAddress);
        if (hostDisplayDetails != null) {
            this.remove(removedServiceID);
        }
        this.refresh();
    }

    public void update(ServiceID removedServiceID) {
        if (removedServiceID != null) {
            this.remove(removedServiceID);
        } else {
            for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
                if (hostDisplayDetails == null) continue;
                hostDisplayDetails.getHostGSCsComponent().reloadServices();
            }
        }
        this.refresh();
    }

    public void remove(ServiceItem item) {
        this.remove(item.serviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ServiceID serviceID) {
        Map<String, HostDisplayDetails> map = this._hostsDisplayComponentsMap;
        synchronized (map) {
            for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
                String hostAddress;
                HostGSCsComponent hostGSCsComponent = hostDisplayDetails.getHostGSCsComponent();
                if (!hostGSCsComponent.removeService(serviceID)) continue;
                if (hostGSCsComponent.getServicesCount() != 0 || (hostDisplayDetails = this._hostsDisplayComponentsMap.remove(hostAddress = hostGSCsComponent.getHostAddress())) == null) break;
                this._miniGSCsPanel.remove(hostDisplayDetails.getGscMiniPanel());
                this._detailsPanel.remove(hostDisplayDetails.getHostGSCsComponent());
                this.refresh();
                break;
            }
        }
    }

    public int getGSCsInUseCount() {
        int inUse = 0;
        for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
            HostGSCsComponent hostGSCSComponent = hostDisplayDetails.getHostGSCsComponent();
            inUse += hostGSCSComponent.getGSCsInUseCount();
        }
        return inUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHostComponents(Dimension newSize) {
        Map<String, HostDisplayDetails> map = this._hostsDisplayComponentsMap;
        synchronized (map) {
            for (HostDisplayDetails hostDisplayDetails : this._hostsDisplayComponentsMap.values()) {
                HostGSCsComponent hostGSCsComponent = hostDisplayDetails.getHostGSCsComponent();
                hostGSCsComponent.resize(newSize);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static class HostDisplayDetails {
        private JPanel gscMiniPanel;
        private HostGSCsComponent hostGSCsComponent;

        HostDisplayDetails(JPanel gscMiniPanel, HostGSCsComponent hostComponent) {
            this.gscMiniPanel = gscMiniPanel;
            this.hostGSCsComponent = hostComponent;
        }

        public JPanel getGscMiniPanel() {
            return this.gscMiniPanel;
        }

        public HostGSCsComponent getHostGSCsComponent() {
            return this.hostGSCsComponent;
        }
    }

    class GSCSelector
    extends MouseAdapter {
        HostGSCsComponent _hostComponent;
        JComponent component;
        boolean selected = true;
        String hostName;

        GSCSelector(HostGSCsComponent hostComponent, JComponent component) {
            this._hostComponent = hostComponent;
            this.component = component;
            this.hostName = this._hostComponent.getHostName();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                GSCPanel.this.parentFrame.setCursor(Cursor.getPredefinedCursor(3));
                if (this.selected) {
                    this.component.setBorder(BorderFactory.createRaisedBevelBorder());
                    GSCPanel.this._detailsPanel.remove(this._hostComponent);
                    this._hostComponent.setManuallyRemovedFromPanel(true);
                    this.selected = false;
                } else {
                    this.component.setBorder(BorderFactory.createLoweredBevelBorder());
                    this._hostComponent.reloadServices();
                    GSCPanel.this._detailsPanel.add(this._hostComponent);
                    this._hostComponent.setManuallyRemovedFromPanel(false);
                    this.selected = true;
                }
                GSCPanel.this.refresh();
            }
            finally {
                GSCPanel.this.parentFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

