/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.ServicesDumpDialog;
import com.gigaspaces.admin.ui.grid.descriptor.AsyncPollingEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.DotNetPUServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.EventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.GatewayDelegatorServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.GatewayServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.GatewaySinkServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.JEEPUServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.MemcachedDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.NotifyEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.PUServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.PollingEventContainerDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.RemotingServiceDescriptor;
import com.gigaspaces.admin.ui.grid.descriptor.SpaceServiceDescriptor;
import com.gigaspaces.admin.ui.grid.gsc.GSCMonitorPanel;
import com.gigaspaces.admin.ui.grid.gsc.GSCPanel;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTable;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTableModel;
import com.gigaspaces.admin.ui.grid.treenode.DeployedServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.DotNetPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.EventContainersNode;
import com.gigaspaces.admin.ui.grid.treenode.GatewayPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.JeePUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.MemcachedNode;
import com.gigaspaces.admin.ui.grid.treenode.RemoteServicesNode;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.MonitorAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.utils.JConsoleUIUtils;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.id.Uuid;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.provision.ServiceRecord;
import org.openspaces.core.gateway.GatewayDelegatorServiceDetails;
import org.openspaces.core.gateway.GatewaySinkServiceDetails;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.events.asyncpolling.AsyncPollingEventContainerServiceDetails;
import org.openspaces.events.notify.NotifyEventContainerServiceDetails;
import org.openspaces.events.polling.PollingEventContainerServiceDetails;
import org.openspaces.interop.DotnetContainerServiceDetails;
import org.openspaces.memcached.MemcachedServiceDetails;
import org.openspaces.pu.container.jee.JeeServiceDetails;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.pu.service.PlainServiceDetails;
import org.openspaces.remoting.RemotingServiceDetails;

public class HostGSCsComponent
extends JPanel {
    private final ServiceTreeTable _serviceTreeTable;
    private ServiceTreeTableModel _serviceTreeTableModel;
    private MainUI _mainUI;
    private GSCPanel _gscPanel;
    private JPanel infoPanel;
    private OSDetails _osDetails;
    private boolean isManuallyRemovedFromPanel;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");
    private static final int LEFT_MARGIN = 2;
    private static final int LINE_HEIGHT = 16;
    private static final Color backgroundColor = new Color(230, 230, 230);
    private static final Color startColor = Color.white;
    private static final Color endColor = new Color(220, 220, 220);
    private JScrollPane _serviceTreeScrollPane;
    private Dimension _curSize;

    public HostGSCsComponent(MainUI mainUI, GSCPanel gscPanel, OSDetails osDetails) {
        this.setLayout(new BorderLayout());
        this._mainUI = mainUI;
        this._gscPanel = gscPanel;
        this._osDetails = osDetails;
        this._serviceTreeTableModel = new ServiceTreeTableModel(this, mainUI);
        this._serviceTreeTable = new ServiceTreeTable(this, this._serviceTreeTableModel);
        this._serviceTreeScrollPane = new JScrollPane(this._serviceTreeTable);
        this._serviceTreeScrollPane.getViewport().setBackground(Color.WHITE);
        this.infoPanel = new JPanel(){

            @Override
            public Color getBackground() {
                return backgroundColor;
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                HostGSCsComponent.this.drawInfo(g);
            }
        };
        this.infoPanel.setPreferredSize(new Dimension(120, 38));
        this.infoPanel.setDoubleBuffered(true);
        this.add((Component)this.infoPanel, "North");
        this.add((Component)this._serviceTreeScrollPane, "Center");
        GSCMouseHandler ma = new GSCMouseHandler();
        this.addMouseListener(ma);
        this._serviceTreeTable.addMouseListener(ma);
        int curSize = GSCMonitorPanel.getCurrentHostViewSize();
        this._curSize = new Dimension(curSize, curSize);
        this.setPreferredSize(this._curSize);
        this._serviceTreeTable.resizeColumnWidth(curSize - 5);
        this.revalidate();
        this.repaint();
    }

    public Dimension getCurSize() {
        return this._curSize;
    }

    @Override
    public void resize(Dimension newSize) {
        this._curSize = newSize;
        this.setPreferredSize(newSize);
        this._serviceTreeTable.updateTreeTableColumnWidth(newSize.width - 3);
        this.revalidate();
        this.repaint();
    }

    public ServiceTreeTable getServiceTreeTable() {
        return this._serviceTreeTable;
    }

    public String getHostAddress() {
        return this._osDetails.getHostAddress();
    }

    public String getHostName() {
        return this._osDetails.getHostName();
    }

    public GSCPanel getGSCPanel() {
        return this._gscPanel;
    }

    public List<ServiceItem> getGSCItemsList() {
        return this._serviceTreeTableModel.getGSCItemsList();
    }

    public int getServicesCount() {
        return this._serviceTreeTableModel.getServicesCount();
    }

    public int getGSCCount() {
        return this._serviceTreeTableModel.getGSCCount();
    }

    public MainUI getParentFrame() {
        return this._mainUI;
    }

    public boolean removeService(ServiceID removedServiceID) {
        return this._serviceTreeTable.removeService(removedServiceID);
    }

    public static void addLaunchToSpacesMenuItems(JPopupMenu popup, Object serviceObj, MainUI mainUI) {
        try {
            if (serviceObj instanceof PUServiceBean) {
                SpaceURL[] spacesUrls = HostGSCsComponent.getServices(serviceObj);
                if (spacesUrls.length > 0) {
                    for (int i = 0; i < spacesUrls.length; ++i) {
                        SpaceURL spaceURL = spacesUrls[i];
                        String containerName = spaceURL.getContainerName();
                        String spaceName = spaceURL.getSpaceName();
                        String hostName = spaceURL.getProperty("machineHostname");
                        HostGSCsComponent.addGoToSpaceMenuItem(containerName, spaceName, hostName, null, mainUI, popup);
                    }
                }
            } else {
                JMenuItem notDeployedMenuItem = new JMenuItem("Service was not deployed using a Processing Unit");
                popup.addSeparator();
                popup.add(notDeployedMenuItem);
            }
        }
        catch (Exception exc) {
            _logger.log(Level.SEVERE, exc.toString(), exc);
        }
    }

    public static void addGoToSpaceMenuItem(final String containerName, final String spaceName, final String hostName, final ServiceID spaceID, final MainUI mainUI, JPopupMenu popup) {
        JMenuItem spaceMenuItem = new JMenuItem("Go to space <" + JSpaceUtilities.createFullSpaceName((String)containerName, (String)spaceName) + ">");
        spaceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (spaceID != null) {
                    mainUI.selectSpaceNode(spaceID);
                } else {
                    mainUI.selectSpaceNode(hostName, containerName, spaceName);
                }
            }
        });
        popup.add(spaceMenuItem);
    }

    public boolean isManuallyRemovedFromPanel() {
        return this.isManuallyRemovedFromPanel;
    }

    public void setManuallyRemovedFromPanel(boolean isManuallyRemovedFromPanel) {
        this.isManuallyRemovedFromPanel = isManuallyRemovedFromPanel;
    }

    public static void navigateToSpace(Object serviceObj, MainUI mainUI) {
        try {
            if (serviceObj instanceof PUServiceBean) {
                SpaceURL[] spacesUrls = HostGSCsComponent.getServices(serviceObj);
                if (spacesUrls.length == 0) {
                    JOptionPane.showMessageDialog(mainUI, "Unable to navigate to space.\nThere are no deployed spaces.", "Navigation", 1);
                } else {
                    SpaceURL spaceURL = spacesUrls[0];
                    String containerName = spaceURL.getContainerName();
                    String spaceName = spaceURL.getSpaceName();
                    String hostName = spaceURL.getProperty("machineHostname");
                    mainUI.selectSpaceNode(hostName, containerName, spaceName);
                }
            } else {
                JOptionPane.showMessageDialog(mainUI, "Unable to navigate to space.\nService was not deployed using a Processing Unit.", "Navigation", 1);
            }
        }
        catch (Exception exc) {
            _logger.log(Level.SEVERE, exc.toString(), exc);
        }
    }

    public static SpaceURL[] getServices(Object serviceObj) throws RemoteException {
        SpaceURL[] spacesUrls = null;
        if (serviceObj instanceof PUServiceBean) {
            spacesUrls = ((PUServiceBean)serviceObj).listSpacesURLs();
        }
        return spacesUrls;
    }

    private void openServicesDumpDialog(ServiceItem serviceItem, boolean isSecured, String descr, String hostName, long pid) {
        ServicesDumpDialog.DumpProviderWrapper dumpProviderWrapper;
        ServicesDumpDialog.DumpProviderWrapper[] dumpProviderWrappresArray = new ServicesDumpDialog.DumpProviderWrapper[1];
        Object service = serviceItem.service;
        if (service instanceof ServiceRegistrar) {
            service = ((ServiceRegistrar)serviceItem.service).getRegistrar();
        }
        InternalDumpProvider dumpProvider = (InternalDumpProvider)service;
        dumpProviderWrappresArray[0] = dumpProviderWrapper = new ServicesDumpDialog.DumpProviderWrapper(dumpProvider, serviceItem.serviceID, isSecured, descr, hostName, pid, serviceItem.service instanceof ServiceRegistrar);
        ServicesDumpDialog dumpDialog = new ServicesDumpDialog((JFrame)this._mainUI, false, dumpProviderWrappresArray);
        dumpDialog.setVisible(true);
    }

    private void restartPUInstance(ServiceRecord rec, ServiceTreeTableModel.GSCHolder gscHolder, String puInstanceName) {
        block5: {
            int returnValue = JOptionPane.showConfirmDialog(this._mainUI, "<HTML>Are you sure you want to restart <FONT COLOR=BLUE>" + puInstanceName + "</FONT> Processing Unit Instance?<HTML>", "Restart Processing Unit Instance", 0, 1);
            if (returnValue != 0) {
                return;
            }
            ServiceElement sElem = rec.getServiceElement();
            OperationalStringManager opMgr = Repository.getInstance().getOperationalStringManager(sElem);
            try {
                Uuid gscUuid = gscHolder.cybernode.getInstantiatorUuid();
                ServiceBeanInstance instance = null;
                ServiceBeanInstance[] instances = opMgr.getServiceBeanInstances(sElem);
                for (int i = 0; i < instances.length; ++i) {
                    if (!instances[i].getServiceBeanID().equals((Object)rec.getServiceID())) continue;
                    instance = instances[i];
                    break;
                }
                if (instance != null) {
                    opMgr.relocate(instance, null, gscUuid);
                }
            }
            catch (Exception exc) {
                if (!_logger.isLoggable(Level.SEVERE)) break block5;
                _logger.log(Level.SEVERE, exc.toString(), exc);
            }
        }
    }

    public synchronized void reloadServices() {
        this._serviceTreeTable.reloadServices();
    }

    public String getGscOwnerName(ServiceID puInstanceServiceID) {
        return this._serviceTreeTableModel.getGscOwnerName(puInstanceServiceID);
    }

    public ServiceID getGscOwnerServiceID(ServiceID puInstanceServiceID) {
        return this._serviceTreeTableModel.getGscOwnerServiceID(puInstanceServiceID);
    }

    private void openBrowser() {
        String url = this._serviceTreeTable.getSelectedURL();
        if (url != null) {
            JSpaceUIUtils.showInBrowser(this._mainUI, url, _logger);
        }
    }

    public int getGSCsInUseCount() {
        return this._serviceTreeTableModel.getGSCsInUseCount();
    }

    public static List<ServiceID> addDeployedServicesNodes(ServiceItem serviceItem, DefaultMutableTreeNode puNode, boolean isMainTree) throws Exception {
        PUServiceDescriptor[] servicesDescriptors = HostGSCsComponent.getSpaceServicesDetails(serviceItem.service);
        ArrayList<ServiceID> spacesServiceIDsList = new ArrayList<ServiceID>(2);
        EventContainersNode eventContainersTreeNode = null;
        RemoteServicesNode remoteServicesTreeNode = null;
        if (servicesDescriptors != null) {
            for (PUServiceDescriptor serviceDescriptor : servicesDescriptors) {
                DefaultMutableTreeNode deployedServiceNode = null;
                if (serviceDescriptor instanceof SpaceServiceDescriptor) {
                    deployedServiceNode = new DeployedServiceNode((SpaceServiceDescriptor)serviceDescriptor);
                    if (serviceDescriptor.getType().equals("embedded")) {
                        spacesServiceIDsList.add(((SpaceServiceDescriptor)serviceDescriptor).getServiceID());
                    }
                    if (isMainTree && !serviceDescriptor.getType().equals("localcache") && !serviceDescriptor.getType().equals("localview")) {
                        SpaceServiceDescriptor spaceDescriptor = (SpaceServiceDescriptor)serviceDescriptor;
                        HostGSCsComponent.addChildNodesToSpace(spaceDescriptor.getServiceID(), spaceDescriptor.iSClustered(), deployedServiceNode);
                    }
                } else if (serviceDescriptor instanceof JEEPUServiceDescriptor) {
                    deployedServiceNode = new JeePUServiceNode((JEEPUServiceDescriptor)serviceDescriptor);
                } else if (serviceDescriptor instanceof GatewayServiceDescriptor) {
                    deployedServiceNode = new GatewayPUServiceNode((GatewayServiceDescriptor)serviceDescriptor);
                } else if (serviceDescriptor instanceof DotNetPUServiceDescriptor) {
                    deployedServiceNode = new DotNetPUServiceNode((DotNetPUServiceDescriptor)serviceDescriptor);
                } else if (serviceDescriptor instanceof MemcachedDescriptor) {
                    deployedServiceNode = new MemcachedNode((MemcachedDescriptor)serviceDescriptor);
                } else if (serviceDescriptor instanceof EventContainerDescriptor) {
                    if (eventContainersTreeNode == null) {
                        eventContainersTreeNode = new EventContainersNode();
                    }
                    eventContainersTreeNode.addDescriptor((EventContainerDescriptor)serviceDescriptor);
                } else if (serviceDescriptor instanceof RemotingServiceDescriptor && remoteServicesTreeNode == null) {
                    remoteServicesTreeNode = new RemoteServicesNode((RemotingServiceDescriptor)serviceDescriptor);
                }
                if (deployedServiceNode == null) continue;
                puNode.add(deployedServiceNode);
            }
            if (eventContainersTreeNode != null) {
                puNode.add(eventContainersTreeNode);
            }
            if (remoteServicesTreeNode != null) {
                puNode.add(remoteServicesTreeNode);
            }
        }
        return spacesServiceIDsList;
    }

    public static void addChildNodesToSpace(ServiceID spaceServiceID, boolean isClusteredSpace, DefaultMutableTreeNode deployedSpaceNode) {
        if (deployedSpaceNode.getUserObject() instanceof SpaceServiceDescriptor && !((SpaceServiceDescriptor)deployedSpaceNode.getUserObject()).getType().equals("remote")) {
            Repository.getInstance().addSpaceNode(spaceServiceID, deployedSpaceNode);
        }
        DefaultMutableTreeNode statisticsLeaf = new DefaultMutableTreeNode("Statistics");
        DefaultMutableTreeNode queryLeaf = new DefaultMutableTreeNode("Query");
        boolean isMirrorEnabled = false;
        if (!isClusteredSpace) {
            block10: {
                ServiceItem spaceServiceItem = MainUI.lookupServiceItem(spaceServiceID);
                if (spaceServiceItem != null) {
                    IJSpace spaceProxy = (IJSpace)spaceServiceItem.service;
                    try {
                        SpaceConfig spaceConfig;
                        IRemoteJSpaceAdmin spaceAdmin = Repository.addSpaceAdminObjectToMap(spaceProxy);
                        if (spaceAdmin != null && (spaceConfig = Repository.addSpaceConfigToMap(spaceAdmin)) != null) {
                            isMirrorEnabled = spaceConfig.isMirrorServiceEnabled();
                        }
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block10;
                        _logger.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            if (!isMirrorEnabled) {
                DefaultMutableTreeNode classesLeaf = new DefaultMutableTreeNode("Data Types");
                DefaultMutableTreeNode transactionsLeaf = new DefaultMutableTreeNode("Transactions");
                deployedSpaceNode.add(classesLeaf);
                deployedSpaceNode.add(transactionsLeaf);
            }
        }
        if (!isMirrorEnabled) {
            deployedSpaceNode.add(queryLeaf);
            deployedSpaceNode.add(statisticsLeaf);
        }
        if (!isClusteredSpace) {
            DefaultMutableTreeNode connectionsLeaf = new DefaultMutableTreeNode("Connections");
            deployedSpaceNode.add(connectionsLeaf);
            if (!isMirrorEnabled) {
                DefaultMutableTreeNode benchmarkLeaf = new DefaultMutableTreeNode("Benchmark");
                deployedSpaceNode.add(benchmarkLeaf);
            }
        }
    }

    public static PUServiceDescriptor[] getSpaceServicesDetails(Object serviceObj) throws Exception {
        PUServiceDescriptor[] serviceDescriptorsResult = null;
        if (serviceObj instanceof PUServiceBean) {
            PUServiceBean puServiceBean = (PUServiceBean)serviceObj;
            Object[] serviceDetailsArray = null;
            try {
                serviceDetailsArray = puServiceBean.listServiceDetails();
                serviceDescriptorsResult = new PUServiceDescriptor[serviceDetailsArray.length];
            }
            catch (Exception exc) {
                if (exc.getCause() != null && exc.getCause() instanceof ConnectException) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, exc.toString(), exc);
                    }
                    return null;
                }
                throw exc;
            }
            for (int index = 0; index < serviceDetailsArray.length; ++index) {
                PlainServiceDetails serviceDetails = (PlainServiceDetails)serviceDetailsArray[index];
                String serviceType = serviceDetails.getServiceType();
                if (serviceType.equals("space")) {
                    serviceDescriptorsResult[index] = new SpaceServiceDescriptor((SpaceServiceDetails)serviceDetails);
                    continue;
                }
                if (serviceType.equals("jee-container")) {
                    serviceDescriptorsResult[index] = new JEEPUServiceDescriptor((JeeServiceDetails)serviceDetails);
                    continue;
                }
                if (serviceType.equals("gateway")) {
                    String subType = serviceDetails.getServiceSubType();
                    if (subType.equals("gateway-delegator")) {
                        serviceDescriptorsResult[index] = new GatewayDelegatorServiceDescriptor((GatewayDelegatorServiceDetails)serviceDetails);
                        continue;
                    }
                    if (!subType.equals("gateway-sink")) continue;
                    serviceDescriptorsResult[index] = new GatewaySinkServiceDescriptor((GatewaySinkServiceDetails)serviceDetails);
                    continue;
                }
                if (serviceType.equals("dotnet")) {
                    serviceDescriptorsResult[index] = new DotNetPUServiceDescriptor((DotnetContainerServiceDetails)serviceDetails);
                    continue;
                }
                if (serviceType.equals("event-container")) {
                    String serviceSubType = serviceDetails.getServiceSubType();
                    if (serviceSubType.equals("async-polling")) {
                        serviceDescriptorsResult[index] = new AsyncPollingEventContainerDescriptor((AsyncPollingEventContainerServiceDetails)serviceDetails);
                        continue;
                    }
                    if (serviceSubType.equals("notify")) {
                        serviceDescriptorsResult[index] = new NotifyEventContainerDescriptor((NotifyEventContainerServiceDetails)serviceDetails);
                        continue;
                    }
                    if (!serviceSubType.equals("polling")) continue;
                    serviceDescriptorsResult[index] = new PollingEventContainerDescriptor((PollingEventContainerServiceDetails)serviceDetails);
                    continue;
                }
                serviceDescriptorsResult[index] = serviceType.equals("remoting") ? new RemotingServiceDescriptor((RemotingServiceDetails)serviceDetails) : (serviceType.equals("memcached") ? new MemcachedDescriptor((MemcachedServiceDetails)serviceDetails) : new PUServiceDescriptor(serviceDetails));
            }
        }
        return serviceDescriptorsResult;
    }

    public void addService(ServiceItem serviceItem) {
        this._serviceTreeTableModel.addService(serviceItem);
        this._serviceTreeTable.updateTreeTableColumnWidth();
        this._serviceTreeTable.revalidate();
        this._serviceTreeScrollPane.revalidate();
        this._serviceTreeTable.repaint();
        this._serviceTreeScrollPane.repaint();
    }

    void drawInfo(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.infoPanel.getSize();
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, startColor, dim.width, dim.height, endColor);
        g2.setPaint(gradient);
        g2.fillRect(0, 0, dim.width, dim.height);
        Font defaultFont = g.getFont();
        FontMetrics fontMetrics = g.getFontMetrics(defaultFont);
        int baseLine = fontMetrics.getHeight() - 1;
        g2.setColor(Color.BLACK);
        g2.setFont(defaultFont);
        String hostName = this._osDetails.getHostName() == null ? "" : this._osDetails.getHostName();
        String hostAddress = this._osDetails.getHostAddress() == null ? "" : this._osDetails.getHostAddress();
        String osProps = this._osDetails.getName() + " " + this._osDetails.getVersion() + ", " + this._osDetails.getArch();
        g2.drawString(hostName + "@" + hostAddress, 2, baseLine);
        g2.drawString(osProps, 2, baseLine + 16);
    }

    class GSCMouseHandler
    extends MouseAdapter {
        GSCMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int clickCount = e.getClickCount();
            boolean serviceAction = e.getComponent() instanceof ServiceTreeTable;
            if (clickCount == 2 && SwingUtilities.isLeftMouseButton(e)) {
                if (serviceAction) {
                    if (HostGSCsComponent.this._serviceTreeTable.isSpaceSelected()) {
                        ServiceItem item;
                        ServiceRecord rec = HostGSCsComponent.this._serviceTreeTable.getSelectedServiceRecord();
                        ServiceID serviceID = null;
                        if (rec != null) {
                            Uuid uuid = rec.getServiceID();
                            serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                        }
                        if ((item = Repository.getInstance().getServiceItem(serviceID)) != null) {
                            HostGSCsComponent.navigateToSpace(item.service, HostGSCsComponent.this._mainUI);
                        }
                    } else if (HostGSCsComponent.this._serviceTreeTable.isJ2eePUSelected()) {
                        HostGSCsComponent.this.openBrowser();
                    }
                }
            } else {
                Point mousePoint = e.getPoint();
                HostGSCsComponent.this._serviceTreeTable.selectRow(mousePoint);
                this.maybeShowPopup(e, serviceAction);
            }
        }

        void maybeShowPopup(MouseEvent e, boolean serviceAction) {
            if (!SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            JPopupMenu popup = null;
            if (serviceAction) {
                final ServiceRecord rec = HostGSCsComponent.this._serviceTreeTable.getServiceRecordAt(e.getPoint());
                Object selectedUserObject = HostGSCsComponent.this._serviceTreeTable.getSelectedUserObject(e.getPoint());
                if (selectedUserObject instanceof ServiceTreeTableModel.ServiceUserObject) {
                    final ServiceTreeTableModel.ServiceUserObject serviceUserObject = (ServiceTreeTableModel.ServiceUserObject)selectedUserObject;
                    final ServiceItem serviceItem = serviceUserObject.getServiceItem();
                    popup = new JPopupMenu();
                    JMenuItem dumpMenuItem = new JMenuItem("Generate dump...");
                    if (!(serviceItem.service instanceof ServiceRegistrar)) {
                        String jmxServiceUrl = JSpaceUtilities.getJMXConnectionUrl((ServiceItem)serviceItem);
                        boolean isRemoteJmxPortDefined = JSpaceUtilities.isJMXRemotePortDefined((ServiceItem)serviceItem);
                        JMenuItem jConsoleMenuItem = new JMenuItem("Launch JConsole...");
                        JConsoleUIUtils.manageJConsoleMenuItem(HostGSCsComponent.this._mainUI, jConsoleMenuItem, jmxServiceUrl, !isRemoteJmxPortDefined, _logger, true, true, HostGSCsComponent.this._mainUI);
                        JMenuItem jVisualVmMenuItem = new JMenuItem("VisualVM...");
                        JConsoleUIUtils.manageJVisualVmMenuItem(HostGSCsComponent.this._mainUI, jVisualVmMenuItem, jmxServiceUrl, _logger, true, true, HostGSCsComponent.this._mainUI, false);
                        popup.add(jConsoleMenuItem);
                        popup.add(jVisualVmMenuItem);
                        popup.add(dumpMenuItem);
                        if (!serviceUserObject.isSecured()) {
                            if (jmxServiceUrl != null) {
                                jConsoleMenuItem.setEnabled(true);
                                jVisualVmMenuItem.setEnabled(true);
                            }
                        } else {
                            SecuredService securedService = (SecuredService)serviceItem.service;
                            ServiceID securedServiceID = serviceItem.serviceID;
                            boolean isMonitorJVMPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, true);
                            boolean isManageGridPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_GRID, true);
                            if (jmxServiceUrl != null) {
                                jConsoleMenuItem.setEnabled(isMonitorJVMPermitted);
                                jVisualVmMenuItem.setEnabled(isMonitorJVMPermitted);
                            }
                            dumpMenuItem.setEnabled(isMonitorJVMPermitted);
                        }
                    }
                    dumpMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostGSCsComponent.this.openServicesDumpDialog(serviceItem, serviceUserObject.isSecured(), serviceUserObject.toString(), HostGSCsComponent.this._osDetails.getHostName(), serviceUserObject.getPid());
                        }
                    });
                } else if (selectedUserObject instanceof ServiceTreeTableModel.GSCHolder) {
                    final ServiceTreeTableModel.GSCHolder gscHolder = (ServiceTreeTableModel.GSCHolder)selectedUserObject;
                    JMenuItem jConsoleMenuItem = gscHolder.getJConsoleMenuItem();
                    JMenuItem jVisualVmMenuItem = gscHolder.getJVisualVmMenuItem();
                    popup = new JPopupMenu();
                    popup.add(jConsoleMenuItem);
                    popup.add(jVisualVmMenuItem);
                    JMenuItem dumpMenuItem = new JMenuItem("Generate dump...");
                    if (!gscHolder.isSecuredService()) {
                        jConsoleMenuItem.setEnabled(true);
                        jVisualVmMenuItem.setEnabled(true);
                    } else {
                        SecuredService securedService = (SecuredService)gscHolder.getServiceItem().service;
                        ServiceID securedServiceID = gscHolder.getServiceItem().serviceID;
                        boolean isMonitorJVMPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_JVM, true);
                        boolean isManageGridPermitted = JSpaceUIUtils.hasPermittedPermission(securedService, securedServiceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_GRID, true);
                        jConsoleMenuItem.setEnabled(isMonitorJVMPermitted);
                        jVisualVmMenuItem.setEnabled(isMonitorJVMPermitted);
                        dumpMenuItem.setEnabled(isMonitorJVMPermitted);
                    }
                    dumpMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostGSCsComponent.this.openServicesDumpDialog(gscHolder.getServiceItem(), gscHolder.isSecuredService(), gscHolder.getPresentationName(false), gscHolder.hostName, Repository.getInstance().getJVMDetails(gscHolder.getServiceItem(), true).getPid());
                        }
                    });
                    popup.add(dumpMenuItem);
                }
                ServiceID serviceID = null;
                if (rec != null) {
                    Uuid uuid = rec.getServiceID();
                    serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                    ServiceItem item = Repository.getInstance().getServiceItem(serviceID);
                    if (item != null) {
                        Object serviceObj = item.service;
                        popup = new JPopupMenu();
                        if (HostGSCsComponent.this._serviceTreeTable.isPUSelected()) {
                            DefaultMutableTreeNode selTreeNode = HostGSCsComponent.this._serviceTreeTable.getSelectedTreeNode(e.getPoint());
                            final ServiceTreeTableModel.GSCHolder gscHolder = (ServiceTreeTableModel.GSCHolder)((DefaultMutableTreeNode)selTreeNode.getParent()).getUserObject();
                            JMenuItem restartPUInstanceMenuItem = new JMenuItem("Restart " + rec.getPresentationName());
                            if (gscHolder.isSecuredService()) {
                                ServiceID gscServiceID = gscHolder.item.serviceID;
                                SecuredService gsc = (SecuredService)gscHolder.item.service;
                                boolean iMonitorPUPermitted = JSpaceUIUtils.hasPermittedPermission(gsc, gscServiceID, (Privilege)MonitorAuthority.MonitorPrivilege.MONITOR_PU, true);
                                boolean isManagePUPermitted = JSpaceUIUtils.hasPermittedPermission(gsc, gscServiceID, (Privilege)GridAuthority.GridPrivilege.MANAGE_PU, true);
                                restartPUInstanceMenuItem.setEnabled(isManagePUPermitted);
                            }
                            restartPUInstanceMenuItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    HostGSCsComponent.this.restartPUInstance(rec, gscHolder, rec.getPresentationName());
                                }
                            });
                            popup.add(restartPUInstanceMenuItem);
                        } else {
                            HostGSCsComponent.addLaunchToSpacesMenuItems(popup, serviceObj, HostGSCsComponent.this._mainUI);
                        }
                    }
                } else if (HostGSCsComponent.this._serviceTreeTable.isJ2eePUSelected()) {
                    popup = new JPopupMenu();
                    JMenuItem openBrowserMenuItem = new JMenuItem("Open within browser");
                    openBrowserMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HostGSCsComponent.this.openBrowser();
                        }
                    });
                    popup.add(openBrowserMenuItem);
                }
            } else {
                popup = new JPopupMenu();
                JMenuItem refresh = new JMenuItem("Refresh");
                refresh.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            HostGSCsComponent.this._mainUI.setCursor(Cursor.getPredefinedCursor(3));
                            HostGSCsComponent.this.reloadServices();
                        }
                        finally {
                            HostGSCsComponent.this._mainUI.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                });
                popup.add(refresh);
            }
            if (popup != null) {
                popup.pack();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

