/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.gsc.ServiceRelocationHelper;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTransferHandler;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTable;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTableModel;
import com.gigaspaces.internal.utils.SecurityUtils;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.core.provision.ServiceRecord;

public class PanelDropTarget
implements DropTargetListener {
    boolean acceptableType;
    DataFlavor targetFlavor;
    MainUI _mainUI;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui");
    private ServiceTreeTable _serServiceTreeTable;
    private ServiceRelocationHelper _serviceRelocation;

    public PanelDropTarget(MainUI mainUI, ServiceTreeTable serviceTreeTable, ServiceRelocationHelper serviceRelocationHelper) {
        this._mainUI = mainUI;
        this._serviceRelocation = serviceRelocationHelper;
        this._serServiceTreeTable = serviceTreeTable;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.checkTransferType(dtde);
        this.acceptOrRejectDrag(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        block3: {
            this.checkTransferType(dtde);
            Transferable transferable = dtde.getTransferable();
            try {
                if (!this.isTargetValid(transferable, dtde.getLocation())) {
                    dtde.rejectDrag();
                    return;
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.acceptOrRejectDrag(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.acceptOrRejectDrag(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if ((dtde.getDropAction() & 3) != 0) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable transferable = dtde.getTransferable();
            try {
                boolean success = this.dropComponent(transferable, dtde.getLocation());
                dtde.dropComplete(success);
            }
            catch (Exception e) {
                e.printStackTrace();
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
        }
    }

    boolean acceptOrRejectDrag(DropTargetDragEvent dtde) {
        int dropAction = dtde.getDropAction();
        int sourceActions = dtde.getSourceActions();
        boolean acceptedDrag = false;
        if (!this.acceptableType || (sourceActions & 3) == 0) {
            dtde.rejectDrag();
        } else if ((dropAction & 3) == 0) {
            dtde.acceptDrag(1);
            acceptedDrag = true;
        } else {
            dtde.acceptDrag(dropAction);
            acceptedDrag = true;
        }
        return acceptedDrag;
    }

    void checkTransferType(DropTargetDragEvent dtde) {
        this.acceptableType = false;
        DataFlavor[] fl = dtde.getCurrentDataFlavors();
        for (int i = 0; i < fl.length; ++i) {
            Class<?> dataClass = fl[i].getRepresentationClass();
            if (!ServiceRecord.class.isAssignableFrom(dataClass)) continue;
            this.targetFlavor = fl[i];
            this.acceptableType = true;
            break;
        }
    }

    private boolean isTargetValid(Transferable transferable, Point targetLocationPoint) throws IOException, UnsupportedFlavorException {
        Object o = transferable.getTransferData(this.targetFlavor);
        if (o instanceof ServiceTransferHandler.ServiceTransferData) {
            TreePath path = this._serServiceTreeTable.getTree().getPathForLocation(targetLocationPoint.x, targetLocationPoint.y);
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return false;
            }
            ServiceTreeTable.GSCNode gscNode = this.getGSCNodeInTreeHirerchy(node);
            return gscNode != null;
        }
        return false;
    }

    boolean dropComponent(Transferable transferable, Point targetLocationPoint) throws IOException, UnsupportedFlavorException {
        Object o = transferable.getTransferData(this.targetFlavor);
        if (o instanceof ServiceTransferHandler.ServiceTransferData) {
            ServiceTransferHandler.ServiceTransferData serviceTransferData = (ServiceTransferHandler.ServiceTransferData)o;
            ServiceRecord record = serviceTransferData.getServiceRecord();
            String sourceGSCPresentationName = serviceTransferData.getSourceGSCName();
            TreePath path = this._serServiceTreeTable.getTree().getPathForLocation(targetLocationPoint.x, targetLocationPoint.y);
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return false;
            }
            ServiceTreeTable.GSCNode gscNode = this.getGSCNodeInTreeHirerchy(node);
            if (gscNode == null) {
                return false;
            }
            ServiceTreeTableModel.GSCHolder gscHolder = (ServiceTreeTableModel.GSCHolder)gscNode.getUserObject();
            if (gscHolder.getServiceRecord(record.getServiceID()) == null) {
                int returnValue;
                if (gscHolder.isSecuredService()) {
                    int returnedValue;
                    ServiceID serviceID = gscHolder.getServiceItem().serviceID;
                    Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
                    if (authentication == null && !SecurityServicesRepository.getInstance().isUserLoggedIn()) {
                        returnedValue = JOptionPane.showConfirmDialog(this._mainUI, "<HTML>You do not have sufficient permissions to relocate the processing unit instance <font color=blue>" + record.getPresentationName() + "</font> to secured GSC.<BR>" + ValidationUtils.MSG_UNABLE_TO_RELOCATE_SUFFIX + " " + "Do you wish to login?" + "</HTML>", "Service Relocation", 0, 2);
                        if (returnedValue == 0) {
                            if (SecurityUtils.login((Component)this._mainUI, gscHolder.getServiceItem())) {
                                authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
                            }
                            if (authentication == null) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                    }
                    if (authentication == null && SecurityServicesRepository.getInstance().isUserLoggedIn() || !authentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.MANAGE_PU)) {
                        returnedValue = JOptionPane.showConfirmDialog(this._mainUI, "<HTML>You do not have sufficient permissions to relocate the processing unit instance <font color=blue>" + record.getPresentationName() + "</font> to secured GSC.<BR>" + ValidationUtils.MSG_UNABLE_TO_RELOCATE_SUFFIX + " " + "Do you wish to login as a different user?" + "</HTML>", "Service Relocation", 0, 2);
                        if (returnedValue == 0) {
                            this._mainUI.logout();
                            SecurityUtils.login((Component)this._mainUI, false);
                        }
                        return false;
                    }
                }
                if ((returnValue = JOptionPane.showConfirmDialog(this._mainUI, "<HTML>Are you sure you want to relocate <B><font color=blue>" + record.getPresentationName() + "</B></font><BR> from <font color=blue>" + sourceGSCPresentationName + "</font> on host <font color=green>" + record.getHostName() + "</font> to <font color=blue>" + gscHolder.getPresentationName(false) + "</font> on host <font color=green>" + gscHolder.hostName + "</font>?</HTML>", "Service Relocation Confirmation", 0, 1)) == 0) {
                    return this._serviceRelocation.relocate(this._mainUI, record, sourceGSCPresentationName, gscHolder);
                }
            }
        }
        return false;
    }

    private ServiceTreeTable.GSCNode getGSCNodeInTreeHirerchy(DefaultMutableTreeNode node) {
        while (node != null && !(node instanceof ServiceTreeTable.GSCNode)) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return (ServiceTreeTable.GSCNode)node;
    }
}

