/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTableModel;
import com.gigaspaces.admin.ui.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.lookup.ServiceID;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.OperationalStringManager;
import org.jini.rio.core.ServiceBeanInstance;
import org.jini.rio.core.ServiceElement;
import org.jini.rio.core.ServiceProvisionListener;
import org.jini.rio.core.provision.ServiceRecord;
import org.jini.rio.cybernode.Cybernode;

public class ServiceRelocationHelper
implements ServiceProvisionListener {
    Exporter exporter;
    ServiceProvisionListener proxy;
    private JDialog dialog;
    boolean relocated;
    ImageIcon relocationIcon;
    private JFrame _parentFrame;
    static final Logger LOGGER = Logger.getLogger("com.gigaspaces.admin.ui");

    public ServiceRelocationHelper(JFrame parentFrame, Configuration config) {
        block5: {
            block4: {
                config = config == null ? EmptyConfiguration.INSTANCE : config;
                this._parentFrame = parentFrame;
                try {
                    this.exporter = ExporterConfig.getExporter((Configuration)config, (String)"com.gigaspaces.admin.ui", (String)"serviceProvisionListenerExporter");
                }
                catch (ConfigurationException e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            try {
                this.proxy = (ServiceProvisionListener)this.exporter.export((Remote)((Object)this));
            }
            catch (ExportException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.relocationIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/relocate.gif");
    }

    boolean doRelocate(ServiceRecord record, ServiceTreeTableModel.GSCHolder target) {
        block8: {
            ServiceElement sElem = record.getServiceElement();
            OperationalStringManager opMgr = Repository.getInstance().getOperationalStringManager(sElem);
            if (opMgr == null) {
                JOptionPane.showMessageDialog(this.dialog, "<HTML>Relocation of service <B><font color=blue>" + record.getPresentationName() + "</font></B> failed, unknown GSM</HTML>", "Service Relocation Failure", 0);
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                this.relocated = false;
            } else {
                this.relocated = false;
                try {
                    ServiceBeanInstance instance = null;
                    ServiceBeanInstance[] instances = opMgr.getServiceBeanInstances(sElem);
                    for (int i = 0; i < instances.length; ++i) {
                        if (!instances[i].getServiceBeanID().equals((Object)record.getServiceID())) continue;
                        instance = instances[i];
                        break;
                    }
                    if (instance == null && opMgr == null) {
                        JOptionPane.showMessageDialog(this.dialog, "<HTML>Relocation of service <B><font color=blue>" + record.getPresentationName() + "</font></B> failed, unknown instance</HTML>", "Service Relocation Failure", 0);
                        this.relocated = false;
                        if (this.dialog != null) {
                            this.dialog.dispose();
                        }
                        return false;
                    }
                    Cybernode cybernode = target.cybernode;
                    Uuid uuid = cybernode.getInstantiatorUuid();
                    opMgr.relocate(instance, this.proxy, uuid);
                    this.relocated = true;
                }
                catch (Exception e) {
                    UIHelper.showError((Throwable)e, "Relocating service to another GSC");
                    if (this.dialog == null) break block8;
                    this.dialog.dispose();
                }
            }
        }
        return this.relocated;
    }

    public void succeeded(ServiceBeanInstance instance) throws RemoteException {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public void failed(ServiceElement sElem, boolean resubmitted) throws RemoteException {
        JOptionPane.showMessageDialog(this.dialog, "<HTML>Relocation of service <B><font color=blue>" + sElem.getName() + "</font></B> failed</HTML>", "Service Relocation Failure", 0);
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    boolean relocate(JFrame parentFrame, final ServiceRecord record, String sourceGSCPresentationName, final ServiceTreeTableModel.GSCHolder targetGSCHolder) {
        this.dialog = new JDialog(parentFrame, "Service Relocation", true);
        JPanel relocatePanel = new JPanel(new BorderLayout(8, 8));
        relocatePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        String from = record.getServiceElement().getName();
        String fromHostName = record.getHostName();
        String to = targetGSCHolder.getPresentationName(false);
        String toHostName = targetGSCHolder.hostName;
        String text = "<html>Relocating service <B><font color=blue>" + from + "</font></B><br>From compute resource <font color=blue>" + sourceGSCPresentationName + "</font> on host <font color=green>" + fromHostName + "</font><br>to compute resource <font color=blue>" + to + "</font> on host <font color=green>" + toHostName + "</font></html>";
        JLabel label = new JLabel(text);
        JProgressBar progressBar = new JProgressBar(0);
        progressBar.setIndeterminate(true);
        labelPanel.add(label);
        labelPanel.add(Box.createVerticalStrut(12));
        labelPanel.add(progressBar);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension d = ServiceRelocationHelper.this.dialog.getSize();
                ServiceRelocationHelper.this.dialog.dispose();
            }
        });
        JPanel bPanel = new JPanel();
        bPanel.add(close);
        JLabel imageLabel = new JLabel(this.relocationIcon);
        relocatePanel.add((Component)labelPanel, "Center");
        relocatePanel.add((Component)imageLabel, "West");
        this.dialog.getContentPane().add(relocatePanel);
        int width = 470;
        int height = 165;
        this.dialog.pack();
        this.dialog.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int widthLoc = screenSize.width / 2 - width / 2;
        int heightLoc = screenSize.height / 2 - height / 2;
        this.dialog.setLocation(widthLoc, heightLoc);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceRelocationHelper.this.relocated = ServiceRelocationHelper.this.doRelocate(record, targetGSCHolder);
            }
        });
        t.start();
        this.dialog.setVisible(true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ServiceID serviceID = new ServiceID(record.getServiceID().getMostSignificantBits(), record.getServiceID().getLeastSignificantBits());
        String fromHostAddress = record.getHostAddress();
        Repository.getInstance().updateGSC(fromHostAddress, serviceID);
        String targetHostAddress = targetGSCHolder.hostAddress;
        Repository.getInstance().updateGSC(targetHostAddress, null);
        this.dialog = null;
        return this.relocated;
    }
}

