/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.MainUI;
import com.gigaspaces.admin.ui.grid.gsc.ServiceRelocationHelper;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTable;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTableModel;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.internal.utils.SecurityUtils;
import com.gigaspaces.internal.utils.ValidationUtils;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecuredService;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;
import org.jini.rio.core.provision.ServiceRecord;

public class ServiceTransferHandler
extends TransferHandler {
    DataFlavor localServiceRecordFlavor;
    DataFlavor serialServiceRecordFlavor;
    String localTransferType = "application/x-java-jvm-local-objectref;class=org.jini.rio.core.provision.ServiceRecord";
    JComponent source = null;
    private static ServiceTransferHandler instance;
    private MainUI _mainUI;
    private ServiceRelocationHelper _serviceRelocationHelper;

    private ServiceTransferHandler(ServiceRelocationHelper serviceRelocationHelper, MainUI mainUI) {
        this._serviceRelocationHelper = serviceRelocationHelper;
        this._mainUI = mainUI;
        try {
            this.localServiceRecordFlavor = new DataFlavor(this.localTransferType);
        }
        catch (ClassNotFoundException e) {
            UIHelper.showError((Throwable)e, "ServiceTransferHandler: unable to create data flavor");
        }
        this.serialServiceRecordFlavor = new DataFlavor(ServiceRecord.class, "ServiceRecord");
    }

    public static synchronized ServiceTransferHandler getInstance(ServiceRelocationHelper serviceRelocationHelper, MainUI mainUI) {
        if (instance == null) {
            instance = new ServiceTransferHandler(serviceRelocationHelper, mainUI);
        }
        return instance;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 || action == 1) {
            try {
                ServiceTransferData serviceTransferData = (ServiceTransferData)data.getTransferData(this.localServiceRecordFlavor);
                Uuid serviceID = serviceTransferData.getServiceRecord().getServiceID();
                ServiceID serviceRecordID = new ServiceID(serviceID.getMostSignificantBits(), serviceID.getLeastSignificantBits());
                if (this.source instanceof ServiceTreeTable) {
                    ((ServiceTreeTable)this.source).removeService(serviceRecordID);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean hasLocalServiceRecordFlavor(DataFlavor[] flavors) {
        if (this.localServiceRecordFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.localServiceRecordFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerialServiceRecordFlavor(DataFlavor[] flavors) {
        if (this.serialServiceRecordFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.serialServiceRecordFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.hasLocalServiceRecordFlavor(flavors)) {
            return true;
        }
        return this.hasSerialServiceRecordFlavor(flavors);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        ServiceRecord record = null;
        this.source = c;
        ServiceTreeTableModel.GSCHolder selectedGSCHolder = null;
        if (this.source instanceof ServiceTreeTable) {
            record = ((ServiceTreeTable)this.source).getSelectedServiceRecord();
            selectedGSCHolder = ((ServiceTreeTable)this.source).getSelectedGSCHolder();
        }
        if (selectedGSCHolder != null && selectedGSCHolder.isSecuredService()) {
            ServiceID serviceID = selectedGSCHolder.getServiceItem().serviceID;
            Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
            if (authentication == null && !SecurityServicesRepository.getInstance().isUserLoggedIn()) {
                SecuredService securedService = (SecuredService)selectedGSCHolder.cybernode;
                int returnedValue = JOptionPane.showConfirmDialog(selectedGSCHolder.getHostGSCsComponent().getParentFrame(), "<HTML>You do not have sufficient permissions to relocate the processing unit instance <font color=blue>" + record.getPresentationName() + "</font> from secured GSC.<BR>" + ValidationUtils.MSG_UNABLE_TO_RELOCATE_SUFFIX + " " + "Do you wish to login?" + "</HTML>", "Service Relocation", 0, 2);
                if (returnedValue == 0) {
                    if (SecurityUtils.login((Component)selectedGSCHolder.getHostGSCsComponent().getParentFrame(), selectedGSCHolder.getServiceItem())) {
                        authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
                    }
                    if (authentication == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (authentication == null && SecurityServicesRepository.getInstance().isUserLoggedIn() || !authentication.getGrantedAuthorities().isGranted((Privilege)GridAuthority.GridPrivilege.MANAGE_PU)) {
                int returnedValue = JOptionPane.showConfirmDialog(selectedGSCHolder.getHostGSCsComponent().getParentFrame(), "<HTML>You do not have sufficient permissions to relocate the processing unit instance <font color=blue>" + record.getPresentationName() + "</font> from secured GSC.<BR>" + ValidationUtils.MSG_UNABLE_TO_RELOCATE_SUFFIX + " " + "Do you wish to login as a different user?" + "</HTML>", "Service Relocation", 0, 2);
                if (returnedValue == 0) {
                    this._mainUI.logout();
                    SecurityUtils.login((Component)this._mainUI, false);
                }
                return null;
            }
        }
        if (record == null) {
            return null;
        }
        ServiceRecordTransferable serviceRecordTransferable = new ServiceRecordTransferable(new ServiceTransferData(record, selectedGSCHolder.getPresentationName(false)));
        return serviceRecordTransferable;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    public class ServiceRecordTransferable
    implements Transferable {
        private ServiceTransferData serviceTransferData;

        public ServiceRecordTransferable(ServiceTransferData serviceTransferData) {
            this.serviceTransferData = serviceTransferData;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.serviceTransferData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ServiceTransferHandler.this.localServiceRecordFlavor, ServiceTransferHandler.this.serialServiceRecordFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (ServiceTransferHandler.this.localServiceRecordFlavor.equals(flavor)) {
                return true;
            }
            return ServiceTransferHandler.this.serialServiceRecordFlavor.equals(flavor);
        }
    }

    public static class ServiceTransferData
    implements Serializable {
        private ServiceRecord record;
        private String sourceGSCName;

        public ServiceTransferData(ServiceRecord record, String sourceGSCName) {
            this.record = record;
            this.sourceGSCName = sourceGSCName;
        }

        public String getSourceGSCName() {
            return this.sourceGSCName;
        }

        public ServiceRecord getServiceRecord() {
            return this.record;
        }
    }
}

