/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.ui.grid.gsc;

import com.gigaspaces.admin.security.SecurityServicesRepository;
import com.gigaspaces.admin.ui.grid.Repository;
import com.gigaspaces.admin.ui.grid.gsc.GSCMonitorPanel;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTable;
import com.gigaspaces.admin.ui.grid.gsc.ServiceTreeTableModel;
import com.gigaspaces.admin.ui.grid.treenode.DeployedServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.DotNetPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.EventContainersNode;
import com.gigaspaces.admin.ui.grid.treenode.GatewayPUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.JeePUServiceNode;
import com.gigaspaces.admin.ui.grid.treenode.MemcachedNode;
import com.gigaspaces.admin.ui.grid.treenode.RemoteServicesNode;
import com.gigaspaces.admin.ui.util.UIHelper;
import com.gigaspaces.grid.esm.ESM;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.security.Authentication;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import com.j_spaces.tools.spacebrowser.utils.IconsRepository;
import com.j_spaces.tools.spacebrowser.utils.JSpaceUIUtils;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;

public class ServiceTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ServiceTreeTableModel _serviceTreeTableModel;
    private static ImageIcon _jettyIcon;
    private static ImageIcon _gatewayIcon;
    private static ImageIcon _localViewIcon;
    private static ImageIcon _localCacheIcon;
    private static ImageIcon _remoteSpaceIcon;
    private static ImageIcon _dotNetInteropIcon;
    private static ImageIcon _dotNetPureIcon;
    private static ImageIcon _securedGSCIcon;
    private static ImageIcon _securedAuthenticatedGSCIcon;
    private static ImageIcon _eventContainersIcon;
    private static ImageIcon _remoteServicesIcon;
    private static ImageIcon _gscIcon;

    public ServiceTreeCellRenderer(ServiceTreeTableModel serviceTreeTableModel) {
        this._serviceTreeTableModel = serviceTreeTableModel;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreePath treePath = tree.getPathForRow(row);
        if (treePath != null) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object treeNode = treePath.getLastPathComponent();
            int width = GSCMonitorPanel.getCurrentHostViewSize();
            Dimension dim = new Dimension(width, 20);
            this.setPreferredSize(dim);
            ImageIcon serviceIcon = ServiceTreeCellRenderer.getServiceIcon(treeNode);
            if (serviceIcon != null) {
                this.setIcon(serviceIcon);
            } else if (treeNode instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)treeNode).getUserObject() instanceof ServiceTreeTableModel.ServiceUserObject) {
                ServiceTreeTableModel.ServiceUserObject serviceUserObject = (ServiceTreeTableModel.ServiceUserObject)((DefaultMutableTreeNode)treeNode).getUserObject();
                this.setIcon(this.getServiceIcon(serviceUserObject));
            }
        }
        return this;
    }

    public static ImageIcon getServiceIcon(Object treeNode) {
        if (treeNode instanceof DeployedServiceNode) {
            DeployedServiceNode deployedServiceNode = (DeployedServiceNode)treeNode;
            ServiceID serviceID = deployedServiceNode.getServiceID();
            short spaceMode = SpaceBrowser.getInstance().getSpaceMode(serviceID);
            String type = deployedServiceNode.getType();
            if (type.equals("embedded")) {
                boolean isSecured = false;
                if (deployedServiceNode.getSpaceProxy() != null) {
                    isSecured = deployedServiceNode.getSpaceProxy().isSecured();
                }
                return JSpaceUIUtils.getSpaceIcon(spaceMode, isSecured, serviceID);
            }
            if (type.equals("localcache")) {
                return _localCacheIcon;
            }
            if (type.equals("localview")) {
                return _localViewIcon;
            }
            if (type.equals("remote")) {
                return _remoteSpaceIcon;
            }
        } else if (treeNode instanceof JeePUServiceNode) {
            JeePUServiceNode j2eePUServiceNode = (JeePUServiceNode)treeNode;
            if (j2eePUServiceNode.isJetty()) {
                return _jettyIcon;
            }
        } else {
            if (treeNode instanceof GatewayPUServiceNode) {
                return _gatewayIcon;
            }
            if (treeNode instanceof DotNetPUServiceNode) {
                DotNetPUServiceNode dotNetPUServiceNode = (DotNetPUServiceNode)treeNode;
                String type = dotNetPUServiceNode.getType();
                if (type.equals("interop")) {
                    return _dotNetInteropIcon;
                }
                if (type.equals("pure")) {
                    return _dotNetPureIcon;
                }
            } else {
                if (treeNode instanceof ServiceTreeTable.PUNode) {
                    short spaceMode = ServiceTreeCellRenderer.getSpaceMode((ServiceTreeTable.PUNode)treeNode);
                    return JSpaceUIUtils.getPUInstanceIcon(spaceMode, 1);
                }
                if (treeNode instanceof ServiceTreeTable.GSCNode) {
                    ServiceTreeTableModel.GSCHolder gscHolder = (ServiceTreeTableModel.GSCHolder)((ServiceTreeTable.GSCNode)treeNode).getUserObject();
                    if (gscHolder.isSecuredService()) {
                        Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(gscHolder.getServiceItem().serviceID);
                        if (authentication == null) {
                            return _securedGSCIcon;
                        }
                        return _securedAuthenticatedGSCIcon;
                    }
                    return _gscIcon;
                }
                if (treeNode instanceof EventContainersNode) {
                    return _eventContainersIcon;
                }
                if (treeNode instanceof MemcachedNode) {
                    return IconsRepository.getInstance().getIcon(19);
                }
                if (treeNode instanceof RemoteServicesNode) {
                    return _remoteServicesIcon;
                }
            }
        }
        return null;
    }

    private ImageIcon getServiceIcon(ServiceTreeTableModel.ServiceUserObject serviceUserObject) {
        ServiceItem serviceItem = serviceUserObject.getServiceItem();
        if (serviceUserObject.isSecured()) {
            ServiceID serviceID = serviceItem.serviceID;
            Authentication authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(serviceID);
            return this.getSecuredServiceIcon(serviceUserObject, authentication);
        }
        if (serviceItem.service instanceof GSA) {
            return IconsRepository.getInstance().getIcon(7);
        }
        if (serviceItem.service instanceof GSM) {
            return IconsRepository.getInstance().getIcon(5);
        }
        if (serviceItem.service instanceof ESM) {
            return IconsRepository.getInstance().getIcon(9);
        }
        if (serviceItem.service instanceof ServiceRegistrar) {
            return IconsRepository.getInstance().getIcon(8);
        }
        return null;
    }

    private ImageIcon getSecuredServiceIcon(ServiceTreeTableModel.ServiceUserObject serviceUserObject, Authentication authentication) {
        Object service = serviceUserObject.getServiceItem().service;
        if (service instanceof GSA) {
            if (authentication == null) {
                return IconsRepository.getInstance().getIcon(12);
            }
            return IconsRepository.getInstance().getIcon(16);
        }
        if (service instanceof GSM) {
            if (authentication == null) {
                return IconsRepository.getInstance().getIcon(10);
            }
            return IconsRepository.getInstance().getIcon(14);
        }
        if (service instanceof ESM) {
            if (authentication == null) {
                return IconsRepository.getInstance().getIcon(31);
            }
            return IconsRepository.getInstance().getIcon(232);
        }
        if (service instanceof ServiceRegistrar) {
            String gsaOwnerID = serviceUserObject.getGSAOwnerServiceID();
            ServiceItem gsaOwnerServiceItem = Repository.getInstance().getGSAServiceItem(gsaOwnerID);
            if (gsaOwnerServiceItem == null || this._serviceTreeTableModel.getServiceUserObject(gsaOwnerServiceItem.serviceID) == null || !this._serviceTreeTableModel.getServiceUserObject(gsaOwnerServiceItem.serviceID).isSecured()) {
                return IconsRepository.getInstance().getIcon(8);
            }
            authentication = SecurityServicesRepository.getInstance().getSecurityAuthentication(gsaOwnerServiceItem.serviceID);
            if (authentication == null) {
                return IconsRepository.getInstance().getIcon(13);
            }
            return IconsRepository.getInstance().getIcon(17);
        }
        return null;
    }

    private static short getSpaceMode(ServiceTreeTable.PUNode puNode) {
        int childCount = puNode.getChildCount();
        short spaceMode = -1;
        for (int index = 0; index < childCount; ++index) {
            TreeNode childNode = puNode.getChildAt(index);
            if (!(childNode instanceof DeployedServiceNode)) continue;
            DeployedServiceNode deployedServiceNode = (DeployedServiceNode)childNode;
            if (deployedServiceNode.getType().equals("remote")) {
                spaceMode = 1;
                break;
            }
            ServiceID serviceID = deployedServiceNode.getServiceID();
            spaceMode = SpaceBrowser.getInstance().getSpaceMode(serviceID);
            break;
        }
        return spaceMode;
    }

    static {
        String path = "com/gigaspaces/admin/ui/images/";
        _jettyIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/jetty.gif");
        _gatewayIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/wan.png");
        _localCacheIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/local_cache.gif");
        _localViewIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/local_view.gif");
        _remoteSpaceIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/proxy_space.gif");
        _dotNetInteropIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/dot_net_mixed.gif");
        _dotNetPureIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/dot_net.gif");
        _eventContainersIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/event_containers.png");
        _remoteServicesIcon = UIHelper.getImageIcon("com/gigaspaces/admin/ui/images/remote_containers.png");
        _securedGSCIcon = IconsRepository.getInstance().getIcon(11);
        _securedAuthenticatedGSCIcon = IconsRepository.getInstance().getIcon(15);
        _gscIcon = IconsRepository.getInstance().getIcon(6);
    }
}

